# 帳票設計書 7-XMLサイトマップ

## 概要

本ドキュメントは、QuickerSiteのサイト全体のURL一覧をXMLサイトマップ形式で出力する帳票機能について記述する。検索エンジン（Google、Bingなど）へのサイトインデックス登録用に使用されるsitemaps.org準拠のXMLファイルを生成する機能である。

### 本帳票の処理概要

本帳票は、Webサイト内のすべての公開ページ、リストアイテム、フォーラム投稿のURLを、sitemaps.org仕様に準拠したXML形式で出力し、検索エンジンのクローラーがサイト構造を効率的に把握できるようにする機能を提供する。

**業務上の目的・背景**：検索エンジン最適化（SEO）において、XMLサイトマップは重要な役割を果たす。サイトマップを提供することで、検索エンジンのクローラーがサイト内のすべてのページを発見しやすくなり、インデックス登録の効率と精度が向上する。これにより、検索結果での露出が改善され、サイトへのオーガニックトラフィックの増加が期待できる。

**帳票の利用シーン**：Google Search ConsoleやBing Webmaster Toolsにサイトマップを登録する場合、検索エンジンのクローラーに新規ページを通知する場合、サイト構造の全体像を把握する場合、SEO監査の一環としてURL一覧を取得する場合などに利用される。

**主要な出力内容**：
1. URLセット（urlset）要素
2. 各ページのURL（loc）要素
3. リストアイテムのURL
4. フォーラム投稿のURL

**帳票の出力タイミング**：サイトマップURLにアクセスした際にリアルタイムで生成される。

**帳票の利用者**：検索エンジンクローラー、サイト管理者、SEO担当者

## 帳票種別

フィード出力（XML形式 / XMLサイトマップ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | XMLサイトマップ | sitemap.asp | 直接アクセス |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | XML（sitemaps.org準拠） |
| MIMEタイプ | text/html（デフォルト） |
| 文字コード | UTF-8 |
| ファイル名 | - （直接出力） |
| 出力方法 | HTTPレスポンス |
| スキーマ | http://www.sitemaps.org/schemas/sitemap/0.9 |

## 帳票レイアウト

### レイアウト概要

sitemaps.org仕様に準拠したXML構造で出力する。

```xml
<?xml version="1.0" encoding="UTF-8"?>
<urlset
xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">
<url>
<loc>https://example.com/page1</loc>
</url>
<url>
<loc>https://example.com/page2</loc>
</url>
...
</urlset>
```

### URL要素

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | loc | ページURL | 生成ロジック | URL |

### URL生成パターン

| No | 種別 | URL形式 | 条件 |
|----|------|--------|------|
| 1 | 通常ページ | customer.sQSUrl/default.asp?iId={暗号化ID} | 標準ページ |
| 2 | ユーザーフレンドリーURL | customer.sQSUrl/{sUserFriendlyURL} | bUserFriendlyURL=true かつ sUserFriendlyURL設定あり |
| 3 | リストアイテム | customer.sQSUrl/default.asp?iId={親ID}&item={アイテムID} | iListPageIDが設定されている場合 |
| 4 | フォーラム投稿 | customer.sQSUrl/default.asp?iId={ページID}&iPostID={投稿ID} | iThemeIDが設定されている場合 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 検索機能結果 | cls_searchの検索結果に含まれるページ | Yes |
| bOnline | オンラインステータス（検索機能で判定） | Yes |
| 外部URL除外 | includeURL=false | Yes |
| リストアイテム含む | includeListItems=true | Yes |
| パスワード保護除外 | includePasswordProtected=false | Yes |

### ソート順

ソート順は指定されていない（検索結果の順序）

### 改ページ条件

改ページなし（全データを1ファイルに出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| tblPage | ページ情報 | cls_search経由 |
| tblPost | フォーラム投稿 | iThemeID = ページのiThemeID |
| tblTheme | フォーラムテーマ | iId = ページのiThemeID |

### テーブル別参照項目詳細

#### tblPage（cls_search経由）

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| iId | loc URL生成 | 検索結果 | ページ識別子 |
| sUserFriendlyURL | loc URL生成 | bUserFriendlyURL=true | ユーザーフレンドリーURL |
| iListPageID | リストアイテム判定 | - | 親ページID |
| iThemeID | フォーラム判定 | - | テーマID |

#### tblPost

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| iId | loc URL生成 | iThemeID, iPostID=null | 投稿識別子 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 通常ページURL | customer.sQSUrl & "/default.asp?iId=" & encrypt(pageKey) | - | 標準URL |
| ユーザーフレンドリーURL | customer.sQSUrl & "/" & sUserFriendlyURL | - | 設定時のみ |
| リストアイテムURL | customer.sQSUrl & "/default.asp?iId=" & encrypt(iListPageID) & "&item=" & encrypt(pageKey) | - | リストの場合 |
| フォーラム投稿URL | customer.sQSUrl & "/default.asp?iId=" & encrypt(pageKey) & "&iPostID=" & encrypt(postId) | - | フォーラムの場合 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[サイトマップリクエスト] --> B[XML宣言出力]
    B --> C[urlset開始タグ出力]
    C --> D[cls_search初期化]
    D --> E[検索実行]
    E --> F[結果ループ開始]
    F --> G{フォーラムページ?}
    G -->|Yes| H[フォーラム投稿取得]
    H --> I[投稿URLをurl要素として出力]
    I --> J[次のページへ]
    G -->|No| K{リストアイテム?}
    K -->|Yes| L[リストアイテムURLを出力]
    K -->|No| M{ユーザーフレンドリーURL?}
    M -->|Yes| N[ユーザーフレンドリーURLを出力]
    M -->|No| O[標準URLを出力]
    L --> J
    N --> J
    O --> J
    J --> P{全ページ処理完了?}
    P -->|No| G
    P -->|Yes| Q[urlset終了タグ出力]
    Q --> R[出力完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ページなし | 検索結果が0件 | （空のurlset） | ページを公開状態にする |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 〜50,000件（sitemaps.org上限） |
| 目標出力時間 | 5秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- ページIDは暗号化（encrypt）されてURLに含まれる
- イントラネットページは検索結果から除外（cls_searchの設定）
- パスワード保護ページは除外
- 削除済みページ、非公開ページは除外
- XML特殊文字（&, <, >）は適切にエスケープ

## 備考

- sitemaps.org仕様に準拠
- XMLサイトマップの最大URL数は50,000件（仕様上の制限）
- XMLサイトマップの最大ファイルサイズは50MB（仕様上の制限）
- Google Search ConsoleやBing Webmaster Toolsで登録可能
- 検証ツール（xml-sitemaps.com等）でバリデーション可能
- cls_searchクラスを再利用して全ページを取得
- &はXMLエンティティ（&amp;）としてエスケープ

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、検索クラスの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | search.asp | `asp/includes/search.asp` | cls_searchクラスの構造、resultsメソッドを確認 |

**読解のコツ**: cls_searchクラスはサイト内検索機能を提供するが、サイトマップではこの機能を「全ページ取得」として再利用している。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sitemap.asp | `sitemap.asp` | サイトマップ生成の全体フローを把握 |

**主要処理フロー**:
1. **行8-14**: XML宣言とurlset開始タグ出力
2. **行16-23**: cls_search初期化と設定
3. **行26-54**: ページループ処理
4. **行29-38**: フォーラム投稿の処理（iThemeIDチェック）
5. **行42-52**: URL生成（リストアイテム、ユーザーフレンドリーURL、標準URL）
6. **行55**: urlset終了タグ出力

#### Step 3: 検索処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | search.asp | `asp/includes/search.asp` | cls_searchクラスの詳細実装 |

**主要処理フロー**:
- **行31-104**: results関数 - ページ検索SQL生成と実行
- **行18-19**: includeURL, includeListItems設定
- **行20**: allowEmptyString設定（全件取得用）

### プログラム呼び出し階層図

```
sitemap.asp
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ cls_search
    │      ├─ includeURL=false
    │      ├─ allowEmptyString=true
    │      ├─ includeListItems=true
    │      └─ results()
    │             └─ db.execute("select iId from tblPage...")
    │
    ├─ フォーラム投稿処理
    │      └─ db.execute("select iId from tblPost...")
    │
    └─ XML生成
           ├─ XML宣言
           ├─ urlset開始
           ├─ url/loc要素（ループ）
           └─ urlset終了
```

### データフロー図

```
[入力]                       [処理]                         [出力]

リクエスト               sitemap.asp                   XML Sitemap
    │                        │                              │
    ▼                        ▼                              ▼
begin.asp ──────────▶  cls_search ──────────────▶    <?xml?>
    │                        │                        <urlset>
    ▼                        ▼                          │
tblPage ─────────────▶  results() ──────────────▶    <url>
    │                        │                        <loc>URL</loc>
    ▼                        ▼                        </url>
tblPost ─────────────▶  フォーラム処理 ────────▶      ...
    │                        │                        </urlset>
    ▼                        ▼
customer.sQSUrl ─────▶  URL生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sitemap.asp | `sitemap.asp` | ソース | エントリーポイント、メイン処理 |
| search.asp | `asp/includes/search.asp` | ソース | 検索クラス（cls_search） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
