# 帳票設計書 8-メールページ送信

## 概要

本ドキュメントは、QuickerSiteのページコンテンツをHTML形式のメールとして送信する機能について記述する。サイト訪問者が気に入ったページの内容を指定したメールアドレスに送信できる機能であり、CAPTCHA認証によるセキュリティ対策が施されている。

### 本帳票の処理概要

本帳票は、WebサイトのページコンテンツをHTML形式のメールとして指定されたメールアドレスに送信する機能を提供する。ユーザーが他者とコンテンツを共有したり、自分宛にページ内容を保存したりする際に利用できる。

**業務上の目的・背景**：Webサイトのコンテンツを友人や同僚と共有したい、後で読むために自分宛に送信したいというニーズは一般的である。「友達に教える」「ページを送信」機能として広く利用されている。この機能により、サイトのコンテンツ拡散とユーザーエンゲージメントの向上が期待できる。

**帳票の利用シーン**：サイト訪問者が記事やニュースを友人に共有する場合、製品情報を社内の同僚に送信する場合、自分宛にページ内容を保存する場合、イベント情報を複数の人に通知する場合などに利用される。

**主要な出力内容**：
1. ページタイトル（件名として使用）
2. ページ本文（HTML形式のメール本文）
3. CSSスタイル（メール表示用）
4. サイトURL情報

**帳票の出力タイミング**：ユーザーがメールアドレスとCAPTCHAを入力し、「送信」ボタンをクリックした際にメールが送信される。

**帳票の利用者**：サイト訪問者（一般ユーザー）

## 帳票種別

メール配信（HTML形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | メールページ送信フォーム | mailPage.asp?iId={暗号化ページID} | 「送信」ボタンクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTMLメール |
| 文字コード | QS_CHARSET（設定による） |
| 出力方法 | メール送信（cls_mail_messageクラス） |
| 認証 | CAPTCHA認証必須 |

### メール固有設定

| 項目 | 内容 |
|-----|------|
| 送信者 | customer.webmasterEmail / customer.siteName |
| 件名 | {ページタイトル} on {サイトURL} |
| 本文形式 | HTML |
| 添付ファイル | なし |

## 帳票レイアウト

### レイアウト概要

HTML形式のメールとして、ページタイトルと本文を整形して送信する。

```html
<html>
<head>
  <title>ページタイトル</title>
  <style>CSS定義</style>
</head>
<body class="main">
  <table style="..." align="left" width="555">
    <tr>
      <td>
        <b>ページタイトル</b>
        <hr />
        ページ本文（コンテンツ）
      </td>
    </tr>
  </table>
</body>
</html>
```

### メール構成

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 件名 | ページタイトル + サイトURL | pageTitle, customer.sUrl | テキスト |
| 2 | タイトル | ページタイトル | pageTitle | 太字 |
| 3 | 本文 | ページコンテンツ | pageBody | HTML |
| 4 | スタイル | CSSスタイル | css()関数 | CSS |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ページID | 送信対象のページID（iId） | Yes |
| メールアドレス | 送信先メールアドレス | Yes |
| CAPTCHA | セキュリティコード（4文字） | Yes |
| アプリケーションでない | sApplicationが空であること | Yes |

### 入力検証

| 項目 | 検証内容 | エラーメッセージ |
|------|---------|----------------|
| CAPTCHA | セッション値との一致（大小文字無視） | err_captcha |
| メールアドレス | メールアドレス形式チェック | err_email |

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| tblPage | ページ基本情報 | iId = リクエストのiId |
| tblCustomer | 顧客情報（サイト名、URL等） | iId = 現在の顧客ID |

### テーブル別参照項目詳細

#### tblPage

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| sTitle | ページタイトル | iId指定 | 件名・本文タイトル |
| sValue | ページ本文 | iId指定 | pageBody経由 |
| sApplication | アプリケーション判定 | iId指定 | 空でない場合は処理終了 |

#### tblCustomer

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| sUrl | 件名のサイトURL | 現在の顧客 | "{タイトル} on {URL}" |
| webmasterEmail | 送信者メール | 現在の顧客 | From設定 |
| siteName | 送信者名 | 現在の顧客 | FromName設定 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 件名 | selectedPage.replaceBlocks(pageTitle & " " & l("on") & " " & customer.sUrl) | - | コンテンツブロック置換 |
| 本文 | selectedPage.replaceBlocks(mailbody) | - | コンテンツブロック置換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ページアクセス] --> B{sApplication判定}
    B -->|空でない| C[Response.End]
    B -->|空| D[フォーム表示]
    D --> E[ユーザー入力]
    E --> F[送信ボタンクリック]
    F --> G[CSRF検証]
    G --> H{CAPTCHA検証}
    H -->|不一致| I[エラー表示：err_captcha]
    H -->|一致| J{メールアドレス検証}
    J -->|不正| K[エラー表示：err_email]
    J -->|正常| L[メール本文生成]
    L --> M[cls_mail_message.send]
    M --> N[送信完了画面表示]
    N --> O[閉じるボタン表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| CAPTCHA不一致 | セキュリティコードが一致しない | err_captcha | 正しいコードを入力 |
| メールアドレス不正 | メールアドレス形式が不正 | err_email | 正しい形式で入力 |
| アプリケーションページ | sApplicationが空でない | （処理終了） | 通常ページから実行 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1メール/リクエスト |
| 目標出力時間 | 3秒以内 |
| 同時出力数上限 | メールサーバー設定依存 |

## セキュリティ考慮事項

- CAPTCHA認証によるボット対策を実施
- CSRFトークン検証（checkCSRF関数）を実施
- ページIDは暗号化（encrypt/decrypt）されて受け渡し
- メールアドレス形式チェック（CheckEmailSyntax関数）を実施
- セッションにCAPTCHA値を保存（総当たり攻撃対策）
- アプリケーションページは送信対象外
- 入力値はセッションに保存（リトライ時の利便性）

## 備考

- HTML形式のメールとして送信
- printReplies=trueにより、コメント/返信も含めた内容が送信される
- pagetoemail=trueにより、メール用の処理が有効化される
- replaceBlocks関数でコンテンツブロックが実際の内容に置換される
- css()関数でスタイルシートがメール内に埋め込まれる
- 送信完了後は「閉じる」ボタンのみが表示される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、メール送信クラスの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mail_message.asp | `asp/includes/mail_message.asp` | cls_mail_messageクラスの構造、sendメソッドを確認 |

**読解のコツ**: cls_mail_messageクラスは複数のメールコンポーネント（CDO.Message、Persits.MailSender等）に対応。使用するコンポーネントはC_MAILCOMPONENT設定で決定される。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mailPage.asp | `mailPage.asp` | メール送信フォームと処理の全体フローを把握 |

**主要処理フロー**:
1. **行1-3**: begin.asp、printReplies=true、pagetoemail=true設定
2. **行3**: process.aspインクルード（ページデータ取得）
3. **行14-15**: sApplicationチェック
4. **行17-50**: フォーム送信処理
5. **行19**: CSRF検証（checkCSRF関数）
6. **行22-24**: CAPTCHA検証
7. **行25-27**: メールアドレス検証
8. **行29-48**: メール本文生成とsend処理
9. **行51**: 送信完了/フォーム表示の分岐

#### Step 3: メール送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mail_message.asp | `asp/includes/mail_message.asp` | cls_mail_messageクラスの詳細実装 |

**主要処理フロー**:
- **行14-174**: send関数 - メール送信処理
- **行53-75**: Persits.MailSender使用時の処理
- **行76-113**: CDO.Message使用時の処理
- **行114-127**: CDONTS.NewMail使用時の処理
- **行128-151**: JMail.Message使用時の処理

### プログラム呼び出し階層図

```
mailPage.asp
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ process.asp（ページ処理）
    │      ├─ selectedPage（cls_page）
    │      │      └─ replaceBlocks()
    │      ├─ pageTitle（変数）
    │      └─ pageBody（変数）
    │
    ├─ CAPTCHA検証
    │      └─ session("CAPTCHA")
    │
    ├─ CSRF検証
    │      └─ checkCSRF()
    │
    └─ cls_mail_message
           ├─ receiver（送信先）
           ├─ subject（件名）
           ├─ body（本文）
           └─ send()
                  └─ メールコンポーネント
                         ├─ CDO.Message
                         ├─ Persits.MailSender
                         ├─ CDONTS.NewMail
                         └─ JMail.Message
```

### データフロー図

```
[入力]                       [処理]                         [出力]

リクエスト               mailPage.asp                   HTMLメール
(iId, sEmail) ─────▶  CAPTCHA検証 ──────────▶       送信先へ
                              │
session("CAPTCHA") ─▶        │
                              ▼
tblPage ──────────────▶  メール本文生成
                              │
                              ▼
                   cls_mail_message.send
                              │
                              ▼
                   メールサーバー（SMTP）
                              │
                              ▼
                   送信完了画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mailPage.asp | `mailPage.asp` | ソース | エントリーポイント、フォーム・送信処理 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス（cls_mail_message） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| process.asp | `asp/process.asp` | ソース | ページデータ取得・処理 |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
