---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-フォーム送信Excelエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **想定データ件数**：根拠なし（運用実績なし）
  2. **目標出力時間**：根拠なし（パフォーマンス要件未定義）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_formExcel.asp` 行1-67
- E-02: `asp/includes/excelFile.asp` 行1-55
- E-03: `asp/includes/form.asp` 行1-888（cls_formクラス定義）
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行2

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォーム送信データをExcel形式でエクスポートする機能 | E-01 行63-65, E-04 | ○ |
| C-02 | 管理者権限（bFormExport）によるアクセス制御 | E-01 行4 | ○ |
| C-03 | cls_formクラスを使用してフォーム情報取得 | E-01 行6, E-03 | ○ |
| C-04 | cls_excelFileクラスを使用してExcel出力 | E-01 行63-65, E-02 | ○ |
| C-05 | ファイル名形式がIEExport_{ランダム}.xls | E-02 行7-8, 行19 | ○ |
| C-06 | 出力カラム：ID, 日時, カタログ, アイテム, フィールド値 | E-01 行16-26, 32-57 | ○ |
| C-07 | カタログ連携がある場合のみカタログ/アイテム列を表示 | E-01 行9-14, 17-20, 34-37 | ○ |
| C-08 | sb_ff_commentタイプはエクスポート対象外 | E-01 行22-23, 39 | ○ |
| C-09 | チェックボックス値はconvertCheckedYesNo関数で変換 | E-01 行43 | ○ |
| C-10 | ファイル/画像はURLリンクとして出力 | E-01 行44-49 | ○ |
| C-11 | 旧エクスポートファイルの自動削除機能 | E-02 行39-53（deleteOthers） | ○ |
| C-12 | HTMLテーブル形式でXLSファイル生成 | E-02 行19-26 | ○ |
| C-13 | ブラウザリダイレクトによるダウンロード | E-01 行65, E-02 行36-38 | ○ |
| C-14 | 文字コードはISO-8859-1変換 | E-02 行16（convertTo_iso_8859_1） | ○ |
| C-15 | フォームフィールドのループ処理でデータ取得 | E-01 行21-25, 38-55 | ○ |
| C-16 | submissionsはcls_formのプロパティとして定義 | E-03 行824-838 | ○ |
| C-17 | fieldsはcls_formのプロパティとして定義 | E-03 行233-249 | ○ |
| C-18 | sanitize関数でXSS対策 | E-01 行43, 51 | ○ |
| C-19 | formatTimeStamp関数で日時フォーマット | E-01 行33 | ○ |
| C-20 | ランダムパスワードでファイル名生成 | E-02 行8（GeneratePassWord） | ○ |
| C-21 | tblFormSubmissionからデータ取得 | E-03 行828-836 | ○ |
| C-22 | tblFormFieldValueからフィールド値取得 | E-03（valuesメソッド参照） | ○ |
| C-23 | linkUrls関数でURLをリンク化 | E-01 行47 | ○ |
| C-24 | 想定データ件数〜10,000件 | **根拠なし** | △ |
| C-25 | 目標出力時間10秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（想定データ件数、出力時間）についてはコード内に明示的な定義がない
  - 候補：運用マニュアル / 要件定義書 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能実装の大部分はソースコードで確認可能
- 1: 中リスク - パフォーマンス要件は推定値であり、大量データ時の動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] bs_formExcel.aspのセキュリティチェック処理（行4）が適切か確認
- [ ] 大量データ（10,000件以上）でのエクスポート動作を検証
- [ ] ファイル削除処理（deleteOthers）の影響範囲を確認
- [ ] 文字コード変換（ISO-8859-1）による文字化けリスクを検証
