---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：2-ゲストブックExcelエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **想定データ件数**：根拠なし（運用実績なし）
  2. **目標出力時間**：根拠なし（パフォーマンス要件未定義）
  3. **tblGuestBookItemのカラム構造**：コードから推測のみ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_gbExcel.asp` 行1-26
- E-02: `asp/includes/excelFile.asp` 行1-55
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行3

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ゲストブック投稿データをExcel形式でエクスポートする機能 | E-01 行21-25, E-03 | ○ |
| C-02 | 管理画面セキュリティ（bs_security.asp）によるアクセス制御 | E-01 行4 | ○ |
| C-03 | cls_excelFileクラスを使用してExcel出力 | E-01 行21-24, E-02 | ○ |
| C-04 | ファイル名形式がIEExport_{ランダム}.xls | E-02 行7-8, 行19 | ○ |
| C-05 | tblGuestBookItemテーブルからSELECT *で全データ取得 | E-01 行5 | ○ |
| C-06 | iGuestbookIDでフィルタリング | E-01 行5 | ○ |
| C-07 | iId昇順でソート | E-01 行5 "order by iId asc" | ○ |
| C-08 | ゲストブックIDはdecrypt関数で復号 | E-01 行5 "decrypt(request.querystring("iGBID"))" | ○ |
| C-09 | rs(0)〜rs(5)の6カラムを出力 | E-01 行10-15 | ○ |
| C-10 | whileループでレコードセット処理 | E-01 行8-18 | ○ |
| C-11 | HTMLテーブル形式でXLSファイル生成 | E-02 行19-26 | ○ |
| C-12 | ブラウザリダイレクトによるダウンロード | E-01 行24, E-02 行36-38 | ○ |
| C-13 | 旧エクスポートファイルの自動削除機能 | E-02 行39-53（deleteOthers） | ○ |
| C-14 | ヘッダー行が出力されない | E-01（headerなし） | ○ |
| C-15 | データサニタイズ処理がない | E-01（sanitize関数未使用） | ○ |
| C-16 | convertGetal関数でID変換 | E-01 行5 "convertGetal(decrypt(...))" | ○ |
| C-17 | 想定データ件数〜5,000件 | **根拠なし** | △ |
| C-18 | 目標出力時間5秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（想定データ件数、出力時間）についてはコード内に明示的な定義がない
  - 候補：運用マニュアル / 要件定義書 / パフォーマンステスト結果
- tblGuestBookItemテーブルの正確なカラム定義（スキーマ情報）
  - 候補：データベース設計書 / SQLスキーマファイル

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - データサニタイズ処理がないため、悪意のある投稿内容がそのまま出力される可能性
- 1: 中リスク - ヘッダー行がないため、出力データの意味が分かりにくい
- 0: 低リスク - シンプルな実装で理解しやすい

## 6) レビュアーチェックリスト（最小）
- [ ] bs_gbExcel.aspのセキュリティチェック処理（行4）が適切か確認
- [ ] tblGuestBookItemの全カラム（rs(0)〜rs(5)）の内容を確認
- [ ] 大量データでのエクスポート動作を検証
- [ ] 特殊文字やHTMLタグを含む投稿の出力結果を確認
