---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：3-連絡先Excelエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **想定データ件数**：根拠なし（運用実績なし）
  2. **目標出力時間**：根拠なし（パフォーマンス要件未定義）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_contactHome.asp` 行1-31
- E-02: `asp/includes/contactSearch.asp` 行1-327
- E-03: `asp/includes/excelFile.asp` 行1-55
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行4

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 連絡先検索結果をExcel形式でエクスポートする機能 | E-02 行219-225, E-04 | ○ |
| C-02 | 管理者権限（bIntranetContacts）によるアクセス制御 | E-01 行4 | ○ |
| C-03 | cls_contactSearchクラスを使用して検索・エクスポート | E-01 行9-10, E-02 | ○ |
| C-04 | cls_excelFileクラスを使用してExcel出力 | E-02 行221-223 | ○ |
| C-05 | ファイル名形式がIEExport_{ランダム}.xls | E-03 行7-8, 行19 | ○ |
| C-06 | mode判定でl("excel")の場合にExcel出力 | E-02 行219 "case l("excel")" | ○ |
| C-07 | ダウンロードリンクを画面に表示 | E-02 行223 "excelfile.downloadLink" | ○ |
| C-08 | ヘッダー行にカスタムフィールド名を出力 | E-02 行146-156 | ○ |
| C-09 | iId, nickname, E-mail, last login列を出力 | E-02 行153-155 | ○ |
| C-10 | getRequestValues関数で検索条件取得 | E-02 行37-53 | ○ |
| C-11 | メールアドレスで部分一致検索 | E-02 行72-74 | ○ |
| C-12 | ニックネームで部分一致検索 | E-02 行75-77 | ○ |
| C-13 | ステータスでフィルタリング | E-02 行78-80 | ○ |
| C-14 | 日付範囲での検索 | E-02 行96-119 | ○ |
| C-15 | iContactID降順、iRang昇順でソート | E-02 行121 | ○ |
| C-16 | convertCheckedYesNo関数でチェックボックス変換 | E-02 行184 | ○ |
| C-17 | convertDateToPicker関数で日付変換 | E-02 行186 | ○ |
| C-18 | removeHTML関数でリッチテキスト処理 | E-02 行182 | ○ |
| C-19 | sanitize関数でXSS対策 | E-02 行180, 181 | ○ |
| C-20 | URLフィールドはリンク形式で出力 | E-02 行187-190 | ○ |
| C-21 | Eメールフィールドはmailtoリンクで出力 | E-02 行191-194 | ○ |
| C-22 | hasManyContactsの場合ページサイズ100件 | E-02 行24-28 | ○ |
| C-23 | tblContact, tblContactField, tblContactValuesからデータ取得 | E-02 行65-70 | ○ |
| C-24 | 暗号化されたフィールドIDを使用 | E-02 行40-48 "encrypt(sfId)" | ○ |
| C-25 | ステータス別の色分け表示（cs_silent等） | E-02 行228-239 | ○ |
| C-26 | 旧エクスポートファイルの自動削除機能 | E-03 行39-53（deleteOthers） | ○ |
| C-27 | 想定データ件数〜10,000件 | **根拠なし** | △ |
| C-28 | 目標出力時間10秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（想定データ件数、出力時間）についてはコード内に明示的な定義がない
  - 候補：運用マニュアル / 要件定義書 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能実装の大部分はソースコードで確認可能
- 1: 中リスク - 大量ユーザー（10,000件以上）でのエクスポート動作確認が必要
- 0: 低リスク - 適切なアクセス制御が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] bs_contactHome.aspのセキュリティチェック処理（行4）が適切か確認
- [ ] 大量データ（10,000件以上）でのエクスポート動作を検証
- [ ] 各フィールドタイプ（テキスト、日付、チェックボックス等）の出力形式を確認
- [ ] メールアドレスやニックネームの検索条件が適切に動作するか確認
