---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：5-印刷用ページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標出力時間**：根拠なし（パフォーマンス要件未定義）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `printPage.asp` 行1-15
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行6

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページコンテンツを印刷用に整形して出力する機能 | E-01 行10-11, E-02 | ○ |
| C-02 | window.print()で自動印刷ダイアログ表示 | E-01 行10 "onload=...window.print();" | ○ |
| C-03 | printReplies変数をtrueに設定 | E-01 行1 "printReplies=true" | ○ |
| C-04 | begin.aspとprocess.aspをインクルード | E-01 行1 | ○ |
| C-05 | selectedPage.showTitleでタイトル取得 | E-01 行4 | ○ |
| C-06 | sApplicationが空でない場合Response.End | E-01 行8 | ○ |
| C-07 | タイトルを太字（<b>タグ）で出力 | E-01 行11 "<b>..." | ○ |
| C-08 | 水平線（<hr />）でタイトルと本文を区切り | E-01 行11 "<hr />" | ○ |
| C-09 | treatConstants関数で定数置換 | E-01 行11 "treatConstants(...,true)" | ○ |
| C-10 | replaceBlocks関数でコンテンツブロック置換 | E-01 行11 "selectedPage.replaceBlocks(pageTitle)" | ○ |
| C-11 | QS_CHARSETで文字コード指定 | E-01 行5 "charset=<%=QS_CHARSET%>" | ○ |
| C-12 | qs_{tdir}.cssスタイルシート読み込み | E-01 行6 | ○ |
| C-13 | sorttable.js読み込み | E-01 行7 | ○ |
| C-14 | window.focus()でウィンドウにフォーカス | E-01 行10 "window.focus();" | ○ |
| C-15 | tdirで方向（LTR/RTL）を指定 | E-01 行2 "dir=<%=tdir%>" | ○ |
| C-16 | XHTML 1.0 Transitional準拠 | E-01 行1-2 DOCTYPE宣言 | ○ |
| C-17 | cleanUPASP関数で終了処理 | E-01 行14 "cleanUPASP" | ○ |
| C-18 | 目標出力時間1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（出力時間）についてはコード内に明示的な定義がない
  - 候補：運用マニュアル / 要件定義書 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな実装で理解しやすい
- 0: 低リスク - 適切なXSS対策（treatConstants関数）が実装されている
- 0: 低リスク - アプリケーションページは印刷対象外として適切に制御

## 6) レビュアーチェックリスト（最小）
- [ ] sApplicationチェック（行8）が適切に動作するか確認
- [ ] treatConstantsとreplaceBlocksの置換処理が正しく動作するか確認
- [ ] 各種ブラウザでwindow.print()が正常に動作するか確認
- [ ] 印刷プレビューでレイアウトが崩れないか確認
