---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：6-RSSフィード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **目標出力時間**：根拠なし（パフォーマンス要件未定義）
  2. **同時出力数上限**：根拠なし（明示的な制限なし）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `rss.asp` 行1-235
- E-02: `asp/includes/rss_writer.asp` 行1-290
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行7

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RSS 2.0形式でXML出力する機能 | E-01 行7, E-02 行73 | ○ |
| C-02 | kwRSS_writerクラスを使用 | E-01 行7, E-02 行12-159 | ○ |
| C-03 | Content-Typeをapplication/xmlに設定 | E-01 行4 | ○ |
| C-04 | メインRSS（ページID未指定時）の処理 | E-01 行9-59 | ○ |
| C-05 | ページ固有RSS（ページID指定時）の処理 | E-01 行61-231 | ○ |
| C-06 | bEnableMainRSSでメインRSS有効/無効判定 | E-01 行11 | ○ |
| C-07 | アプリケーションキャッシュの使用 | E-01 行13, 51, 84, 217 | ○ |
| C-08 | イントラネット認証チェック | E-01 行63-79 | ○ |
| C-09 | No Accessメッセージ出力 | E-01 行70-71 | ○ |
| C-10 | 最大300件まで取得（メインRSS） | E-01 行25 "RSScounter<300" | ○ |
| C-11 | ChannelTitle, ChannelURL, ChannelDesc設定 | E-01 行16-19, 86-89 | ○ |
| C-12 | updatedTS降順でソート | E-01 行23 "order by updatedTS desc" | ○ |
| C-13 | bOnline, bDeleted, bContainerPageで出力判定 | E-01 行30 | ○ |
| C-14 | パスワード保護ページは除外 | E-01 行30 "isLeeg(rssPage.sPw)" | ○ |
| C-15 | 外部URLページは除外 | E-01 行30 "isLeeg(rssPage.sExternalURL)" | ○ |
| C-16 | Format_RFC822_DateAndTimeで日時変換 | E-01 行36, 120, 160, 201 | ○ |
| C-17 | リストアイテム処理（bPushRSS） | E-01 行91-130 | ○ |
| C-18 | フォーラム投稿処理 | E-01 行133-173 | ○ |
| C-19 | カタログアイテム処理 | E-01 行175-213 | ○ |
| C-20 | enclosure要素で画像配信 | E-01 行116-118, E-02 行58-60 | ○ |
| C-21 | comments要素でコメントリンク | E-01 行165, E-02 行63-64 | ○ |
| C-22 | ユーザーフレンドリーURL対応 | E-01 行97-101 | ○ |
| C-23 | prepareForExport関数で整形 | E-01 行114, 155-158, 197 | ○ |
| C-24 | CDATAでXMLインジェクション対策 | E-02 行277-287（CheckString関数） | ○ |
| C-25 | SetTitle, SetLink, SetDesc等のメソッド | E-02 行34-64 | ○ |
| C-26 | AddNew関数で新規アイテム追加 | E-02 行66-68 | ○ |
| C-27 | GetRSS関数でXML生成 | E-02 行70-157 | ○ |
| C-28 | aspXMLクラスでXML構築 | E-02 行182-289 | ○ |
| C-29 | treatConstants関数で定数置換 | E-01 行51, 224 | ○ |
| C-30 | selectedPage.addHitRSSでアクセスカウント | E-01 行226 | ○ |
| C-31 | 目標出力時間2秒以内 | **根拠なし** | △ |
| C-32 | 同時出力数上限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（出力時間、同時接続数）についてはコード内に明示的な定義がない
  - 候補：運用マニュアル / 要件定義書 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RSS 2.0仕様に準拠した実装
- 0: 低リスク - 適切なアクセス制御（イントラネット認証）
- 1: 中リスク - キャッシュ無効化のタイミングが不明確（1=1条件でキャッシュが常に再生成される可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] bEnableMainRSS設定が適切に動作するか確認
- [ ] イントラネット認証チェック（行63-79）が適切か確認
- [ ] キャッシュの有効期限・無効化条件を確認
- [ ] 各種コンテンツタイプ（リスト、フォーラム、カタログ）のRSS出力を検証
- [ ] RSS 2.0バリデーションツールでの検証
