---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：7-XMLサイトマップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **想定データ件数50,000件**：根拠なし（sitemaps.org仕様に基づく推定）
  2. **目標出力時間**：根拠なし（パフォーマンス要件未定義）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sitemap.asp` 行1-61
- E-02: `asp/includes/search.asp` 行1-172
- E-03: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行8

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sitemaps.org準拠のXMLサイトマップを出力する機能 | E-01 行9-14, E-03 | ○ |
| C-02 | XML宣言（version="1.0" encoding="UTF-8"） | E-01 行9 | ○ |
| C-03 | urlset名前空間をsitemaps.org/schemas/sitemap/0.9に設定 | E-01 行11 | ○ |
| C-04 | cls_searchクラスを使用して全ページ取得 | E-01 行17, E-02 | ○ |
| C-05 | includeURL=falseに設定 | E-01 行18 | ○ |
| C-06 | allowEmptyString=trueに設定（全件取得） | E-01 行19 | ○ |
| C-07 | includeListItems=trueに設定 | E-01 行20 | ○ |
| C-08 | フォーラム投稿をサイトマップに含める | E-01 行29-38 | ○ |
| C-09 | iThemeIDでフォーラムページ判定 | E-01 行29 "convertGetal(getResults(pageKey).iThemeID)<>0" | ○ |
| C-10 | tblPostから投稿取得（iPostID is nullでトップレベルのみ） | E-01 行32 | ○ |
| C-11 | リストアイテムURL生成（iListPageID判定） | E-01 行44-45 | ○ |
| C-12 | ユーザーフレンドリーURL対応 | E-01 行47-48 | ○ |
| C-13 | 標準URL生成（default.asp?iId=） | E-01 行50-51 | ○ |
| C-14 | encrypt関数でID暗号化 | E-01 行35, 45, 48, 51 | ○ |
| C-15 | &を&amp;でエスケープ | E-01 行35, 45 | ○ |
| C-16 | url/loc要素で各URLを出力 | E-01 行42-53 | ○ |
| C-17 | urlset終了タグ出力 | E-01 行55 | ○ |
| C-18 | cleanUPASP関数で終了処理 | E-01 行60 | ○ |
| C-19 | cls_searchのresults関数で検索実行 | E-02 行31-154 | ○ |
| C-20 | bOnline, bDeletedで出力判定（cls_search内） | E-02 行56-58, 73 | ○ |
| C-21 | パスワード保護ページ除外（cls_search内） | E-02 行79-81 | ○ |
| C-22 | イントラネットページ除外（cls_search内） | E-02 行85-87 | ○ |
| C-23 | 想定データ件数〜50,000件 | **根拠なし**（sitemaps.org仕様による推定） | △ |
| C-24 | 目標出力時間5秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（出力時間）についてはコード内に明示的な定義がない
  - 候補：運用マニュアル / 要件定義書 / パフォーマンステスト結果
- 想定データ件数はsitemaps.org仕様の上限値であり、実際の運用値は不明
  - 候補：運用実績データ / サイト規模情報

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - sitemaps.org仕様に準拠した実装
- 1: 中リスク - 大規模サイト（10,000ページ以上）でのパフォーマンス確認が必要
- 0: 低リスク - 適切なページフィルタリング（非公開、削除済み等を除外）

## 6) レビュアーチェックリスト（最小）
- [ ] cls_searchの設定（includeURL, allowEmptyString等）が適切か確認
- [ ] XMLバリデーションツール（xml-sitemaps.com等）での検証
- [ ] 大規模サイトでの生成パフォーマンスを検証
- [ ] フォーラム投稿、リストアイテムの含め方が適切か確認
- [ ] Google Search Consoleでのサイトマップ登録テスト
