---
generated_at: 2026-01-24 00:03:00
metrics:
  claims_total: 52
  claims_with_evidence: 48
  claims_without_evidence: 4
confidence_derived: 0.92
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：48 / 52、根拠なし：4
- 優先レビュー（高）
  1. **BR-044（ショッピングカート機能）**：実装が限定的な可能性
  2. **BR-045（テンプレート作成・エクスポート）**：詳細なエクスポート仕様が不明
  3. **BR-048（データベース接続管理）**：MySQL接続の実装状況が不確定
  4. **BR-050（キャッシュ管理）**：キャッシュ無効化の詳細条件が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_login.asp` - 管理者ログイン処理
- E-02: `asp/process_login.asp` - ページ認証処理
- E-03: `asp/includes/page.asp` - ページ管理クラス（cls_page）
- E-04: `asp/includes/catalog.asp` - カタログ管理クラス（cls_catalog）
- E-05: `asp/includes/catalogItem.asp` - カタログアイテムクラス
- E-06: `asp/includes/gallery.asp` - ギャラリー管理クラス（cls_gallery）
- E-07: `asp/includes/form.asp` - フォーム管理クラス（cls_form）
- E-08: `asp/includes/newsletter.asp` - ニュースレター管理クラス（cls_newsletter）
- E-09: `asp/includes/guestbook.asp` - ゲストブック管理クラス（cls_guestbook）
- E-10: `asp/includes/theme.asp` - フォーラム/テーマ管理クラス（cls_theme）
- E-11: `asp/includes/contact.asp` - 連絡先管理クラス（cls_contact）
- E-12: `asp/includes/template.asp` - テンプレート管理クラス（cls_template）
- E-13: `asp/includes/customer.asp` - 顧客/サイト設定クラス（cls_customer）
- E-14: `asp/includes/feed.asp` - RSSフィード管理クラス（cls_feed）
- E-15: `asp/includes/database.asp` - データベース接続クラス（cls_database）
- E-16: `asp/includes/functions.asp` - 共通関数ライブラリ
- E-17: `asp/includes/sha256.asp` - SHA256ハッシュ実装
- E-18: `asp/includes/mail.asp` - メール送信機能
- E-19: `asp/includes/mail_message.asp` - メールメッセージクラス
- E-20: `asp/includes/search.asp` - 検索機能
- E-21: `asp/includes/ticket.asp` - CSRFトークン管理
- E-22: `asp/includes/secondAdmin.asp` - セカンド管理者機能
- E-23: `asp/includes/newsletterSubscriber.asp` - ニュースレター購読者
- E-24: `asp/includes/newsletterMailing.asp` - ニュースレター配信
- E-25: `asp/includes/popup.asp` - ポップアップ管理
- E-26: `asp/includes/ac_calendar.asp` - 予約カレンダー
- E-27: `asp/includes/constant.asp` - 定数管理
- E-28: `asp/includes/label.asp` - ラベル管理（多言語）
- E-29: `asp/includes/shopMake.asp` - ショップ構築

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001: 管理者がパスワードとCAPTCHAを使用してログイン可能 | E-01, E-17 | ○ |
| C-02 | BR-002: 個別ページにパスワード保護設定可能 | E-02, E-03 | ○ |
| C-03 | BR-003: イントラネットユーザーの登録・認証・権限管理 | E-11, E-13 | ○ |
| C-04 | BR-004: セカンド管理者アカウント設定 | E-22 | ○ |
| C-05 | BR-005: ページの作成・編集・削除・並べ替え | E-03 | ○ |
| C-06 | BR-006: テンプレートの作成・編集・適用 | E-12 | ○ |
| C-07 | BR-007: メニューの階層管理 | E-03, showmenu.asp | ○ |
| C-08 | BR-008: ヘッダー・フッター管理 | E-13, header.asp | ○ |
| C-09 | BR-009: SEO設定（メタ情報、ユーザーフレンドリーURL） | E-03, E-13 | ○ |
| C-10 | BR-010: カタログの作成・編集・削除 | E-04 | ○ |
| C-11 | BR-011: カタログアイテムの管理 | E-05 | ○ |
| C-12 | BR-012: カタログフィールドのカスタマイズ | E-04, catalogField.asp | ○ |
| C-13 | BR-013: カタログファイルタイプ管理 | E-04, catalogFileType.asp | ○ |
| C-14 | BR-014: 画像ギャラリーの作成・管理 | E-06 | ○ |
| C-15 | BR-015: サムネイル自動生成・リサイズ | E-06, showThumb.aspx | ○ |
| C-16 | BR-016: Webフォームの作成・管理 | E-07 | ○ |
| C-17 | BR-017: フォームフィールドの定義 | E-07, FormField.asp | ○ |
| C-18 | BR-018: フォーム送信処理（メール、Cookie、リダイレクト） | E-07, E-18 | ○ |
| C-19 | BR-019: ニュースレターの作成・編集 | E-08 | ○ |
| C-20 | BR-020: ニュースレター購読者管理 | E-23 | ○ |
| C-21 | BR-021: ニュースレター配信 | E-08, E-24 | ○ |
| C-22 | BR-022: ゲストブック管理 | E-09 | ○ |
| C-23 | BR-023: フォーラム/掲示板機能 | E-10 | ○ |
| C-24 | BR-024: 投稿管理 | E-10, post.asp | ○ |
| C-25 | BR-025: ファイルエクスプローラ | fileexplorer.asp | ○ |
| C-26 | BR-026: ファビコン管理 | bs_favicon.asp | ○ |
| C-27 | BR-027: ピールアドバナー管理 | E-13, bs_peel.asp | ○ |
| C-28 | BR-028: RSSフィード管理 | E-14 | ○ |
| C-29 | BR-029: RSS配信機能 | rss_writer.asp, E-03 | ○ |
| C-30 | BR-030: 予約カレンダー機能 | E-26 | ○ |
| C-31 | BR-031: メール送信機能 | E-18, E-19 | ○ |
| C-32 | BR-032: 連絡先へのメール送信 | E-11, E-18 | ○ |
| C-33 | BR-033: アクセス統計 | logvisit.asp, bs_stats.asp | ○ |
| C-34 | BR-034: 連絡先管理 | E-11 | ○ |
| C-35 | BR-035: 連絡先一括操作 | contactSearch.asp | ○ |
| C-36 | BR-036: サイト基本設定管理 | E-13 | ○ |
| C-37 | BR-037: Cookie警告管理 | E-13, bs_cookiewarning.asp | ○ |
| C-38 | BR-038: モバイル対応設定 | E-13, E-12 | ○ |
| C-39 | BR-039: 定数管理 | E-27 | ○ |
| C-40 | BR-040: セキュリティ設定 | bs_security.asp, E-03 | ○ |
| C-41 | BR-041: 暗号化機能 | E-17, md5.asp, encryption.asp | ○ |
| C-42 | BR-042: CAPTCHA機能 | captcha.asp, E-07 | ○ |
| C-43 | BR-043: CSRF対策 | E-21, E-07 | ○ |
| C-44 | BR-044: ショッピングカート機能 | E-29 | △ |
| C-45 | BR-045: テンプレート作成・エクスポート | bs_CreateTemplate.asp | △ |
| C-46 | BR-046: サイト内検索 | E-20, fullsearch.asp | ○ |
| C-47 | BR-047: 多言語ラベル管理 | E-28, languageInit.asp | ○ |
| C-48 | BR-048: データベース接続管理 | E-15 | △ |
| C-49 | BR-049: エラーハンドリング | E-16, messages.asp | ○ |
| C-50 | BR-050: キャッシュ管理 | E-03, E-13 | △ |
| C-51 | BR-051: ポップアップ管理 | E-25 | ○ |
| C-52 | BR-052: リストページ管理 | E-03, bs_listPage.asp | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-044（ショッピングカート機能）**：shopMake.aspの実装は確認できたが、完全なECカート機能（決済連携等）の詳細が不明
  - 候補：決済API連携ドキュメント / 注文管理機能 / 在庫管理機能
- **BR-045（テンプレート作成・エクスポート）**：テンプレート作成ファイルは存在するが、エクスポート形式や再インポート手順が不明
  - 候補：テンプレートパッケージ仕様書 / インストール手順
- **BR-048（データベース接続管理）**：Access、SQL Server対応は確認できたが、MySQLドライバの可用性が環境依存
  - 候補：サポートされるMySQLバージョン / ODBCドライバ要件
- **BR-050（キャッシュ管理）**：1時間ごとのキャッシュクリアは確認できたが、手動キャッシュクリアやキャッシュ戦略の詳細が不明
  - 候補：キャッシュ設定画面 / キャッシュ無効化トリガー

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：基本的なCMS機能（ページ管理、コンテンツ編集、メニュー管理等）は十分な根拠あり
- **1（中リスク）**：ショッピングカート機能は基本実装のみで、本格的なEC運用には追加開発が必要な可能性
- **1（中リスク）**：セキュリティ関連機能（SHA256、CAPTCHA）は実装されているが、最新のセキュリティベストプラクティスとの比較検証が必要
- **0（低リスク）**：多言語対応はラベルシステムとして実装されており、日本語を含む各言語に対応可能

## 6) レビュアーチェックリスト（最小）
- [ ] BR-044（ショッピングカート）が実際に必要な機能要件か確認
- [ ] データベースの種類（Access/SQL Server/MySQL）のうち、実際に使用するものを確認
- [ ] セキュリティ要件（パスワードポリシー、アカウントロックアウト等）が現行基準を満たすか確認
- [ ] イントラネット機能の利用有無と権限設計の妥当性を確認
- [ ] ニュースレター・メール機能のSPAM対策が十分か確認
- [ ] 本番環境でのキャッシュ設定（有効/無効）の方針を確認
