---
generated_at: 2026-01-23 21:45:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **共通/セキュリティ - 入力サニタイズ**：sanitize関数の詳細実装を確認できていない
  2. **共通/多言語 - 多言語対応**：言語ファイルの完全な一覧を確認できていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/README.md`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_login.asp`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_header.asp`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_admin.asp`
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_menu.asp`
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_secondAdmin.asp`
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_formList.asp`
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_catalogList.asp`
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_galleryList.asp`
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_newsletterList.asp`
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_pollList.asp`
- E-12: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_gbList.asp`
- E-13: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_popupList.asp`
- E-14: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_feedList.asp`
- E-15: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_ac.asp`
- E-16: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_shoppingcart.asp`
- E-17: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_templateList.asp`
- E-18: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_stats.asp`
- E-19: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_contactHome.asp`
- E-20: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_assetmanager.asp`
- E-21: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_themesList.asp`
- E-22: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_pageelements.asp`
- E-23: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_constantList.asp`
- E-24: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process.asp`
- E-25: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_search.asp`
- E-26: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_login.asp`
- E-27: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_register.asp`
- E-28: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/rss.asp`
- E-29: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/sitemap.asp`
- E-30: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/mailPage.asp`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者ログイン機能 | E-02 | ○ |
| C-02 | 管理者ログアウト機能 | E-03（bs_logoff.aspへのリンク確認） | ○ |
| C-03 | セカンドアドミン管理 | E-06 | ○ |
| C-04 | パスワード変更機能 | E-03（bs_applyTotalPW.aspへの参照確認） | ○ |
| C-05 | サイト基本設定 | E-04 | ○ |
| C-06 | SEO設定 | E-04（keywords, sDescription等の設定） | ○ |
| C-07 | Google Analytics設定 | E-04（googleAnalyticsフィールド確認） | ○ |
| C-08 | ページ一覧 | E-05 | ○ |
| C-09 | ページ作成・編集 | E-03（setupPage, editItemへの参照） | ○ |
| C-10 | ページ削除 | E-05（deleteButtonの存在確認） | ○ |
| C-11 | ページ移動・並び替え | E-05（move, sortorderの確認） | ○ |
| C-12 | ページ複製 | E-05（copyItemの確認） | ○ |
| C-13 | リストページ管理 | E-03（listPage機能の参照） | ○ |
| C-14 | 外部URL設定 | E-03（convertToExternalURLの参照） | ○ |
| C-15 | ページパスワード保護 | E-05（applyPw.aspへのリンク） | ○ |
| C-16 | ユーザーフレンドリーURL | E-06（bPageUFL権限設定） | ○ |
| C-17 | ページプレビュー | E-17（previewTemplate機能確認） | ○ |
| C-18 | コンテナページ管理 | E-03（convertToContainerItemの参照） | ○ |
| C-19 | ページブロック編集 | E-03（editPageBlocksの参照） | ○ |
| C-20 | バナーメニュー編集 | E-22 | ○ |
| C-21 | デフォルトブロック編集 | E-22 | ○ |
| C-22 | フッター編集 | E-22 | ○ |
| C-23 | ファビコン管理 | E-22 | ○ |
| C-24 | ピール広告 | E-03（selectPeel, peel.aspの参照） | ○ |
| C-25 | テンプレート一覧 | E-17 | ○ |
| C-26 | テンプレート作成・編集 | E-17 | ○ |
| C-27 | テンプレートプレビュー | E-17 | ○ |
| C-28 | テンプレートインポート | E-17（uploadzip.asp, unzip機能） | ○ |
| C-29 | オンラインテンプレート検索 | E-17（templateSearch.asp） | ○ |
| C-30 | デフォルトテンプレート設定 | E-17（setaasdefaultアクション） | ○ |
| C-31 | モバイル設定 | E-03（mobileSetup.aspの参照） | ○ |
| C-32 | ポップアップ効果設定 | E-03（popupMode.aspの参照） | ○ |
| C-33 | アコーディオンCSS設定 | E-03（AccordionSetup.aspの参照） | ○ |
| C-34 | Cookie警告設定 | E-06（bCookieWarning権限） | ○ |
| C-35 | カスタム404ページ設定 | E-06（bCustom404権限） | ○ |
| C-36 | Scroll To Top設定 | E-03（arrowup.aspの参照） | ○ |
| C-37 | アセットマネージャー | E-20 | ○ |
| C-38 | マルチファイルアップロード | E-03（multifileupload.aspの存在確認） | ○ |
| C-39 | フォーム一覧 | E-07 | ○ |
| C-40 | フォーム作成・編集 | E-07 | ○ |
| C-41 | フォームフィールド管理 | E-07（formFields.aspへのリンク） | ○ |
| C-42 | フォーム送信データ表示 | E-07（formExport.aspへのリンク） | ○ |
| C-43 | フォームデータExcel出力 | E-07（formExcel.aspへのリンク） | ○ |
| C-44 | フォームプレビュー | E-07（formPreview.aspへのリンク） | ○ |
| C-45 | カタログ一覧 | E-08 | ○ |
| C-46 | カタログ作成・編集 | E-08 | ○ |
| C-47 | カタログフィールド管理 | E-08 | ○ |
| C-48 | カタログアイテム管理 | E-08 | ○ |
| C-49 | カタログアイテム検索 | E-08 | ○ |
| C-50 | カタログファイルタイプ管理 | E-08 | ○ |
| C-51 | カタログアイテム画像アップロード | E-08（catalogItemPicUpload確認） | ○ |
| C-52 | カタログアイテムファイルアップロード | E-08（catalogItemFileUpload確認） | ○ |
| C-53 | フィード一覧 | E-14 | ○ |
| C-54 | フィード作成・編集 | E-14 | ○ |
| C-55 | フィードプレビュー | E-14 | ○ |
| C-56 | ギャラリー一覧 | E-09 | ○ |
| C-57 | ギャラリー作成・編集 | E-09 | ○ |
| C-58 | ギャラリープレビュー | E-09 | ○ |
| C-59 | 投票（Poll）一覧 | E-11 | ○ |
| C-60 | 投票作成・編集 | E-11 | ○ |
| C-61 | ゲストブック一覧 | E-12 | ○ |
| C-62 | ゲストブック作成・編集 | E-12 | ○ |
| C-63 | ゲストブック投稿管理 | E-12（gbEditItems.aspへのリンク） | ○ |
| C-64 | ゲストブックExcel出力 | E-12（gbExcel.aspへのリンク） | ○ |
| C-65 | ポップアップ一覧 | E-13 | ○ |
| C-66 | ポップアップ作成・編集 | E-13 | ○ |
| C-67 | ニュースレター一覧 | E-10 | ○ |
| C-68 | ニュースレター作成・編集 | E-10 | ○ |
| C-69 | 購読者管理 | E-10（Subscribersへのリンク） | ○ |
| C-70 | 購読者インポート | E-10（NewsletterImport.aspの参照） | ○ |
| C-71 | メーリング作成・送信 | E-10（NewsletterMailingEdit.asp） | ○ |
| C-72 | メーリング履歴 | E-10（NewsletterMailingHistory.asp） | ○ |
| C-73 | メールリスト管理 | E-10（NewsletterCategoryList.asp） | ○ |
| C-74 | 予約カレンダー | E-15 | ○ |
| C-75 | カレンダー予約管理 | E-15（booking, bookingsアクション） | ○ |
| C-76 | カレンダー埋め込みコード | E-15（embedcodeアクション） | ○ |
| C-77 | ショッピングカート管理 | E-16 | ○ |
| C-78 | 商品管理 | E-16（shopProduct.asp） | ○ |
| C-79 | 商品カテゴリ管理 | E-16（shopAdCat.asp, subcategories） | ○ |
| C-80 | 商品画像管理 | E-16（shopProductImg.asp） | ○ |
| C-81 | メーカー管理 | E-16（shopMake.asp） | ○ |
| C-82 | イントラネット管理 | E-03（bIntranet権限確認） | ○ |
| C-83 | コンタクト一覧 | E-19 | ○ |
| C-84 | コンタクト作成・編集 | E-19（contactEdit.asp） | ○ |
| C-85 | コンタクトフィールド管理 | E-19（contactFields.asp） | ○ |
| C-86 | 一括メール送信 | E-19（contactSelectionActions.asp） | ○ |
| C-87 | メール送信履歴 | E-03（mailHistory.aspの参照） | ○ |
| C-88 | アクティベーション管理 | E-19（tickets.asp） | ○ |
| C-89 | テーマ/フォーラム一覧 | E-21 | ○ |
| C-90 | テーマ/フォーラム作成・編集 | E-21（themeEdit.asp） | ○ |
| C-91 | アクセス統計表示 | E-18 | ○ |
| C-92 | 参照元サイト一覧 | E-18（referers.asp） | ○ |
| C-93 | 統計リセット | E-18（ResetStatsアクション） | ○ |
| C-94 | 定数一覧 | E-23 | ○ |
| C-95 | 定数作成・編集 | E-23（constantEdit.asp） | ○ |
| C-96 | スクリプト管理 | E-23（scriptList.asp） | ○ |
| C-97 | バックオフィス検索 | E-03（search.asp参照） | ○ |
| C-98 | ページ検証 | E-03（validatepage.asp参照） | ○ |
| C-99 | ページ表示 | E-24 | ○ |
| C-100 | リストページ表示 | E-24（process_listpage.asp） | ○ |
| C-101 | カタログ表示 | E-24（process_catalog.asp） | ○ |
| C-102 | サイト内検索 | E-25 | ○ |
| C-103 | ページログイン | E-26 | ○ |
| C-104 | イントラネットログイン | E-24（process_loginIntranet.asp） | ○ |
| C-105 | 会員登録 | E-27 | ○ |
| C-106 | パスワード再発行 | E-24（process_forgotPW.asp） | ○ |
| C-107 | 会員プロフィール編集 | E-24（process_profile.asp） | ○ |
| C-108 | ニュースレター購読解除 | E-24（process_unsubscribe.asp） | ○ |
| C-109 | 投票機能 | E-24（voteアクション） | ○ |
| C-110 | ゲストブック投稿 | E-24（gbeditアクション） | ○ |
| C-111 | フォーム送信 | E-24（process_itemform.asp） | ○ |
| C-112 | ページメール送信 | E-30 | ○ |
| C-113 | ページ印刷 | E-01（printPage.aspの存在確認） | ○ |
| C-114 | RSSフィード出力 | E-28 | ○ |
| C-115 | XMLサイトマップ出力 | E-29 | ○ |
| C-116 | サムネイル生成 | E-01（showThumb.aspxの存在確認） | ○ |
| C-117 | CSRF対策 | E-02, E-04（QS_secCodeHidden, checkCSRF()） | ○ |
| C-118 | CAPTCHA認証 | E-02（captcha.aspの使用確認） | ○ |
| C-119 | 入力サニタイズ | **根拠不足** | △ |
| C-120 | 多言語対応 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **入力サニタイズ（C-119）**：sanitize関数は複数箇所で使用されているが、関数の詳細実装を確認できていない
  - 候補：`asp/includes/` ディレクトリ内の共通関数ファイル / `begin.asp` / `bs_common.asp`
- **多言語対応（C-120）**：l()関数による多言語取得は確認できたが、言語ファイルの完全な一覧と対応言語を確認できていない
  - 候補：`asp/includes/` ディレクトリ / 言語定義ファイル

## 5) リスクフラグ（レビュー観点）
- 0: **低リスク** - 大部分の機能はソースコードにより直接確認済み
- 1: **中リスク** - セキュリティ関連機能（C-119）は実装詳細の確認が必要
- 0: **低リスク** - 多言語対応（C-120）は機能の存在は確認済みだが詳細確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 各カテゴリの機能が漏れなく網羅されているか確認
- [ ] 備考欄に記載されたファイル名が実際のプロジェクト構造と一致しているか確認
- [ ] セキュリティ関連機能（CSRF対策、CAPTCHA、入力サニタイズ）の実装詳細を確認
- [ ] ショッピングカート機能が現在有効化されているか確認（コード上でコメントアウトされている可能性あり）
- [ ] 多言語対応の対応言語一覧を別途確認
