# 機能設計書 1-管理者ログイン

## 概要

本ドキュメントは、QuickerSite CMSの管理画面（バックサイト）へのログイン認証機能について記述する。

### 本機能の処理概要

本機能は、管理者がCMSのバックサイト（管理画面）にアクセスするための認証処理を提供する。パスワードとCAPTCHA（画像認証）を組み合わせた二要素認証により、不正アクセスを防止する。

**業務上の目的・背景**：CMSの管理画面は、サイトコンテンツの作成・編集・削除、ユーザー管理、サイト設定など、サイト運営に関わる重要な操作を行う場所である。そのため、不正アクセスを防止し、正当な管理者のみがアクセスできるよう、堅牢な認証機能が必要となる。ブルートフォース攻撃対策としてログイン試行回数制限も実装されている。

**機能の利用シーン**：
- サイト管理者が日常的に管理画面にアクセスする際
- セカンドアドミン（副管理者）が制限された権限で管理画面にアクセスする際
- セッションタイムアウト後の再認証時

**主要な処理内容**：
1. ログイン画面の表示（パスワード入力フィールド、CAPTCHA画像の表示）
2. CAPTCHA画像の検証
3. パスワードのSHA-256ハッシュ化と照合
4. セッション認証情報の設定
5. ログイン試行回数のカウントとブロック処理
6. デフォルトパスワード使用時の初期セットアップ画面へのリダイレクト

**関連システム・外部連携**：なし（内部認証のみ）

**権限による制御**：
- メイン管理者（adminPassword）：全権限でログイン
- セカンドアドミン（secondAdmin.sPassword）：制限された権限でログイン

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | バックサイトログイン画面 | 主画面 | パスワードとCAPTCHA認証によるログイン処理の主画面 |
| 2 | 管理者ログイン画面 | 主画面 | システム管理者（Admin）向けログイン認証処理 |
| 113 | セキュリティ設定 | 参照画面 | バックサイトのセキュリティ・アクセス制御設定 |
| 114 | 管理者セキュリティ | 参照画面 | 管理者の認証・セキュリティ設定 |
| 197 | バックサイトエントリー | 参照画面 | バックサイト管理画面のエントリーポイント |

## 機能種別

認証処理 / セキュリティ / セッション管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| password | String | Yes | 管理者パスワード | 最大50文字、SHA-256でハッシュ化して照合 |
| captcha | String | Yes | CAPTCHA画像に表示された4文字 | 最大4文字、セッション値と大文字小文字を無視して比較 |
| btnaction | String | Yes | 実行アクション（"Login"） | 固定値 |
| bs_page | String | No | ログイン後のリダイレクト先 | HTMLエンコード処理 |

### 入力データソース

- 画面入力（ログインフォーム）
- セッション（CAPTCHA検証用）
- データベース（tblCustomer.adminPassword、tblSecondAdmin.sPassword）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Session(cId & "isAUTHENTICATED") | Boolean | 認証成功フラグ |
| Session(cId & "isAUTHENTICATEDSecondAdmin") | Boolean | セカンドアドミン認証フラグ |
| Cookie(cId & "hfsdsiiqqssdfjf") | String | パスワードハッシュ（Cookieモード有効時） |

### 出力先

- セッション変数（認証状態の保持）
- Cookie（Cookieモード有効時）
- 画面リダイレクト（bs_default.asp または指定されたbs_page）

## 処理フロー

### 処理シーケンス

```
1. ログイン画面表示
   └─ CAPTCHA画像生成・表示
   └─ パスワード入力フォーム表示
   └─ ログイン試行回数表示

2. フォーム送信（btnaction="Login"）
   └─ CAPTCHA検証
      └─ 失敗時：エラーメッセージ追加（err_captcha）
   └─ パスワード検証（logon.logon()）
      └─ SHA-256ハッシュ化
      └─ adminPassword または secondAdmin.sPassword と照合
      └─ 成功時：セッション設定、リダイレクト
      └─ 失敗時：エラーメッセージ追加（err_login）

3. ログイン試行回数カウント
   └─ application("bsLoginCount"&UserIP)をインクリメント
   └─ 上限到達時：アクセスブロック

4. ブロック判定（lockBSAdmin）
   └─ 試行回数超過時：エラー発生、処理終了
```

### フローチャート

```mermaid
flowchart TD
    A[ログイン画面表示] --> B{フォーム送信?}
    B -->|No| A
    B -->|Yes| C{CAPTCHA検証}
    C -->|失敗| D[エラー: err_captcha]
    D --> E[試行回数カウント]
    C -->|成功| F{パスワード検証}
    F -->|失敗| G[エラー: err_login]
    G --> E
    F -->|成功| H{セカンドアドミン?}
    H -->|Yes| I[SecondAdmin認証フラグ設定]
    H -->|No| J[通常認証フラグ設定]
    I --> K[セッション設定]
    J --> K
    K --> L{bs_page指定?}
    L -->|Yes| M[指定ページへリダイレクト]
    L -->|No| N[bs_default.aspへリダイレクト]
    E --> O{試行回数超過?}
    O -->|Yes| P[アクセスブロック]
    O -->|No| A
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | CAPTCHA必須 | 全てのログイン試行でCAPTCHA認証が必要 | 常時 |
| BR-02 | パスワードハッシュ化 | パスワードはSHA-256でハッシュ化して保存・照合 | 常時 |
| BR-03 | 試行回数制限 | ログイン試行はQS_number_of_allowed_attempts_to_login回まで | IP単位で適用 |
| BR-04 | デフォルトパスワード禁止 | デフォルトパスワード"admin"使用時は初期セットアップへ強制リダイレクト | 本番環境のみ |
| BR-05 | Cookieモード | QS_enableCookieMode有効時、パスワードハッシュをCookieに保存 | 設定による |

### 計算ロジック

- パスワードハッシュ: `sha256(入力パスワード)` = `customer.adminPassword` または `customer.secondAdmin.sPassword`
- CAPTCHA検証: `LCase(session("captcha"))` = `LCase(Left(Request.Form("captcha"),4))`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 認証 | tblCustomer | SELECT | 管理者パスワードの取得 |
| 認証 | tblSecondAdmin | SELECT | セカンドアドミンパスワードの取得 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | adminPassword | iId = cId | SHA-256ハッシュ化されたパスワード |

#### tblSecondAdmin

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sPassword | iCustomerID = cId | SHA-256ハッシュ化されたパスワード |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_captcha | 認証エラー | CAPTCHA入力値が不一致 | 再入力を促す |
| err_login | 認証エラー | パスワードが不一致 | 再入力を促す |
| IP Block | セキュリティエラー | 試行回数超過 | IPブロック、管理者へメール通知 |

### リトライ仕様

- ログイン失敗時は同一画面で再試行可能
- 試行回数上限（QS_number_of_allowed_attempts_to_login）到達時はIPがブロックされる

## トランザクション仕様

認証処理はトランザクション制御なし（読み取り専用操作）

## パフォーマンス要件

- 通常のログイン処理: 1秒以内
- CAPTCHA画像生成: 即座に完了

## セキュリティ考慮事項

- パスワードはSHA-256でハッシュ化して保存
- CAPTCHA認証による自動化攻撃の防止
- IP単位でのログイン試行回数制限
- 試行回数超過時の管理者へのメール通知
- デフォルトパスワード使用時の強制変更
- セッションタイムアウト（30分）

## 備考

- Cookieモード（QS_enableCookieMode）は、ホスティング環境がアプリケーションを頻繁にリサイクルする場合に有効
- セカンドアドミンは制限された権限を持ち、メイン管理者とは異なる機能セットにアクセス可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログイン認証に関わるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | cls_customerクラスのadminPasswordプロパティ（102-127行目付近）とsecondAdminプロパティ（1257-1262行目）の構造を理解 |
| 1-2 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | cls_secondAdminクラス全体（2-232行目）。sPassword、各種権限フラグの構造 |

**読解のコツ**: ASP Classic（VBScript）では、Classキーワードでクラスを定義し、PublicプロパティとPrivate変数を使い分ける。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_login.asp | `asp/bs_login.asp` | ログイン画面のメインファイル。全体で29行程度の短いファイル |

**主要処理フロー**:
1. **4行目**: bUseArtLoginTemplate=true でテンプレート使用を指定
2. **8-25行目**: btnaction="Login"時の認証処理
3. **9-11行目**: CAPTCHA検証ロジック
4. **12-20行目**: logon.logon()による認証とリダイレクト
5. **24行目**: ログイン試行回数のインクリメント
6. **26行目**: lockBSAdmin()によるブロック判定

#### Step 3: 認証クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LogonEdit.asp | `asp/includes/LogonEdit.asp` | cls_LogonEditクラス。認証の中核ロジック |

**主要処理フロー**:
- **22-44行目**: logon関数 - パスワード検証の本体
- **25行目**: adminPasswordまたはsecondAdmin.sPasswordとの照合
- **27行目**: セッション認証フラグの設定
- **29-31行目**: Cookieモード時のパスワード保存
- **33-35行目**: セカンドアドミン認証時の追加フラグ設定
- **86-98行目**: lockBSAdmin関数 - 試行回数超過時のブロック処理

#### Step 4: CAPTCHA生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | captcha.asp | `asp/includes/captcha.asp` | CAPTCHA画像生成処理 |

**主要処理フロー**:
- **75-87行目**: CreateGUID関数 - ランダム文字列生成
- **404-413行目**: CAPTCHA生成メイン処理。Session("CAPTCHA")に保存

### プログラム呼び出し階層図

```
bs_login.asp
    │
    ├─ begin.asp（インクルード）
    │      ├─ includes/sha256.asp（ハッシュ関数）
    │      ├─ includes/customer.asp（顧客クラス）
    │      ├─ includes/secondAdmin.asp（セカンドアドミンクラス）
    │      └─ includes/LogonEdit.asp（認証クラス）
    │
    ├─ includes/header.asp（HTMLヘッダー）
    │
    ├─ bs_initBackShort.asp（初期化）
    │
    ├─ bs_header.asp（バックサイトヘッダー）
    │
    ├─ logon.logon()（認証処理）
    │      └─ sha256()（パスワードハッシュ化）
    │
    ├─ logon.lockBSAdmin()（ブロック処理）
    │
    └─ includes/captcha.asp（CAPTCHA画像生成 - img srcで参照）
```

### データフロー図

```
[入力]               [処理]                    [出力]

password ─────────▶ sha256() ─────────────────▶ ハッシュ値
                         │
                         ▼
                    logon.logon()
                         │
                    ┌────┴────┐
                    ▼         ▼
              adminPassword  secondAdmin.sPassword
              (tblCustomer)  (tblSecondAdmin)
                    │         │
                    └────┬────┘
                         ▼
                    照合結果
                         │
        ┌────────────────┼────────────────┐
        ▼                ▼                ▼
   Session設定      Cookie設定     application変数
   (認証フラグ)    (Cookieモード時)  (ログイン回数)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_login.asp | `asp/bs_login.asp` | ソース | ログイン画面メインファイル |
| LogonEdit.asp | `asp/includes/LogonEdit.asp` | ソース | 認証処理クラス定義 |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
| sha256.asp | `asp/includes/sha256.asp` | ソース | SHA-256ハッシュ関数 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客（サイト）情報クラス |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | セカンドアドミンクラス |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化・インクルード管理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | バックサイトヘッダー表示 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック処理 |
| web_config.asp | `asp/config/web_config.asp` | 設定 | QS_number_of_allowed_attempts_to_login等の設定 |
