# 機能設計書 10-ページ削除

## 概要

本ドキュメントは、QuickerSite CMSのページ削除機能について記述する。

### 本機能の処理概要

本機能は、既存ページの削除を行うための機能を提供する。削除は論理削除として実装されており、データベースからの物理削除は行わない。削除されたページはフロントサイトに表示されなくなり、管理画面のページ一覧からも非表示となる。

**業務上の目的・背景**：サイト運営において不要になったページを整理し、サイト構造を最適化するために削除機能が必要となる。論理削除を採用することで、誤削除時のデータ復旧可能性を維持している。

**機能の利用シーン**：
- 不要になったコンテンツページの削除
- キャンペーン終了後のランディングページ削除
- サイトリニューアル時の旧ページ整理
- テスト用ページの削除

**主要な処理内容**：
1. 削除確認ダイアログの表示
2. 論理削除フラグの設定（bDeleted=true）
3. 表示順序のリセット（iRang=0）
4. オンライン状態の解除（bOnline=false）
5. ホームページフラグの解除（bHomepage=false）
6. 関連リストアイテムの削除
7. 連絡先ページ関連の削除

**関連システム・外部連携**：なし

**権限による制御**：secondAdmin.bPagesDelete 権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | ページ編集 | 主画面 | 削除ボタンの表示・実行 |
| 10 | 管理画面トップ | 遷移先画面 | 削除後のリダイレクト先 |

## 機能種別

CRUD操作 / 削除処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| btnaction | String | Yes | "delete"（削除アクション） | l("delete")と一致 |
| iId | String(暗号化) | Yes | 削除対象ページID | 復号化後に数値チェック |

### 入力データソース

- 画面操作（削除ボタンクリック）
- JavaScriptによる確認ダイアログ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| page.bDeleted | Boolean | 論理削除フラグ（true） |
| page.bOnline | Boolean | オンライン状態（false） |
| page.bHomepage | Boolean | ホームページフラグ（false） |
| page.iRang | Integer | 表示順序（0） |

### 出力先

- データベース（tblPage）
- データベース（tblContactPage）- 関連レコード削除

## 処理フロー

### 処理シーケンス

```
1. 削除ボタンクリック
   └─ JavaScript: deletePage()関数呼び出し

2. 確認ダイアログ表示
   └─ confirm('削除してもよろしいですか？')

3. 確認OK時
   └─ フォームのbtnactionを"delete"に設定
   └─ フォームsubmit

4. 削除処理（btnaction="delete"）
   └─ CSRF検証
   └─ page.bDeleted = true
   └─ page.parentPage.removeRang(page) - 親ページから順位を除去
   └─ page.iRang = 0
   └─ page.bOnline = false
   └─ page.bHomepage = false
   └─ page.deleteListItems() - 関連リストアイテム削除
   └─ page.save()
   └─ tblContactPage関連レコード削除

5. リダイレクト
   └─ イントラネットページ: bs_intranet.asp
   └─ 通常ページ: bs_default.asp
   └─ リストアイテム: bs_listPage.asp
```

### フローチャート

```mermaid
flowchart TD
    A[編集画面] --> B{削除ボタン表示?}
    B -->|canBeDeleted=false| C[ボタン非表示]
    B -->|canBeDeleted=true| D[削除ボタン表示]
    D --> E{削除ボタンクリック}
    E -->|No| D
    E -->|Yes| F[確認ダイアログ]
    F --> G{確認OK?}
    G -->|No| D
    G -->|Yes| H[フォームsubmit]
    H --> I[CSRF検証]
    I --> J[bDeleted=true]
    J --> K[removeRang - 順位除去]
    K --> L[iRang=0]
    L --> M[bOnline=false]
    M --> N[bHomepage=false]
    N --> O[deleteListItems]
    O --> P[save]
    P --> Q[tblContactPage削除]
    Q --> R{ページ種別}
    R -->|イントラネット| S[bs_intranet.aspへ]
    R -->|リストアイテム| T[bs_listPage.aspへ]
    R -->|通常ページ| U[bs_default.aspへ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 論理削除 | 物理削除ではなく論理削除（bDeleted=true） | 常時 |
| BR-02 | 削除確認 | JavaScriptで削除確認ダイアログを表示 | 常時 |
| BR-03 | 削除可能判定 | canBeDeletedがtrueの場合のみ削除ボタン表示 | 常時 |
| BR-04 | オンライン解除 | 削除時はオンライン状態を解除 | 常時 |
| BR-05 | ホームページ解除 | 削除時はホームページフラグを解除 | 常時 |
| BR-06 | 順位リセット | 削除時は表示順序を0にリセット | 常時 |
| BR-07 | リストアイテム連動 | リストページ削除時は関連アイテムも削除 | リストページの場合 |

### 計算ロジック

- canBeDeleted: secondAdmin.bPagesDelete 権限があり、かつページが削除可能な状態

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ削除 | tblPage | UPDATE | bDeleted=true、関連フラグ更新 |
| リストアイテム削除 | tblPage | UPDATE | 関連リストアイテムのbDeleted=true |
| 連絡先関連削除 | tblContactPage | DELETE | 関連レコードの物理削除 |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bDeleted | true | 論理削除フラグ |
| UPDATE | bOnline | false | オンライン解除 |
| UPDATE | bHomepage | false | ホームページ解除 |
| UPDATE | iRang | 0 | 順位リセット |
| UPDATE | updatedTS | now() | 更新日時 |

#### tblContactPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | iTitleID = iId OR iBodyID = iId | 関連レコード削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| （なし） | - | 削除処理自体のバリデーションエラーは発生しない | - |

### リトライ仕様

- 削除失敗時は同一画面に戻る

## トランザクション仕様

- 削除処理: 単一トランザクションで完結

## パフォーマンス要件

- ページ削除: 即座に完了
- メニューキャッシュクリア: 削除後に自動実行

## セキュリティ考慮事項

- CSRF対策トークン検証
- secondAdmin.bPagesDelete 権限チェック
- 削除前の確認ダイアログ表示
- ページIDの暗号化（EnCrypt/DeCrypt）

## 備考

- 論理削除のため、データベースからは削除されない
- 削除されたページはフロントサイトに表示されない
- 管理画面のページ一覧からも非表示となる
- 物理削除の機能は提供されていない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 削除ボタン表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_delete.asp | `asp/bs_delete.asp` | 削除ボタン表示条件（3行） |

**読解のコツ**:
```vbscript
if page.canBeDeleted then
  &nbsp;<a href="javascript:deletePage();">...
end if
```
canBeDeletedプロパティがtrueの場合のみ削除ボタンが表示される。

#### Step 2: 削除確認ダイアログを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_processPage.asp | `asp/bs_processPage.asp` | deletePage関数（2-7行目） |

**主要処理フロー**:
```javascript
function deletePage(){
  if (confirm('<%=l("deletecomplete")%>')){
    document.mainform.btnaction.value='<%=l("delete")%>';
    document.mainform.submit();
  }
}
```

#### Step 3: 削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_processPage.asp | `asp/bs_processPage.asp` | 削除処理（26-44行目） |

**主要処理フロー**:
- **26行目**: `case l("delete")`
- **27行目**: `checkCSRF()`
- **28行目**: `page.bDeleted=true`
- **29行目**: `page.parentPage.removeRang(page)` - 親ページから順位除去
- **30行目**: `page.iRang=0`
- **31行目**: `page.bOnline=false`
- **32行目**: `page.bHomepage=false`
- **33行目**: `page.deleteListItems()` - リストアイテム削除
- **34行目**: `page.save()`
- **35-44行目**: リダイレクト処理

#### Step 4: 保存処理での削除関連処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | page.asp | `asp/includes/page.asp` | save関数内の削除関連処理 |

**主要処理フロー**:
- **337-342行目**: check関数でbDeleted時は即リターン
- **520行目**: `rs("bDeleted") = bDeleted`
- **589-591行目**: 削除時のtblContactPage関連レコード削除
```vbscript
if bDeleted then
  db.execute("delete from tblContactPage where iTitleID=" & iId & " or iBodyID=" & iId)
end if
```

### プログラム呼び出し階層図

```
bs_editItem.asp（またはその他の編集画面）
    │
    ├─ bs_delete.asp（インクルード）
    │      └─ 削除ボタン表示判定
    │             └─ page.canBeDeleted
    │
    ├─ bs_processPage.asp（インクルード）
    │      │
    │      ├─ deletePage()（JavaScript関数）
    │      │      ├─ confirm() - 確認ダイアログ
    │      │      └─ form.submit()
    │      │
    │      └─ btnaction = l("delete")
    │             ├─ checkCSRF()
    │             ├─ page.bDeleted = true
    │             ├─ page.parentPage.removeRang(page)
    │             ├─ page.iRang = 0
    │             ├─ page.bOnline = false
    │             ├─ page.bHomepage = false
    │             ├─ page.deleteListItems()
    │             └─ page.save()
    │                    ├─ tblPage UPDATE (bDeleted=true)
    │                    └─ tblContactPage DELETE
    │
    └─ リダイレクト
           ├─ bs_intranet.asp（イントラネット）
           ├─ bs_listPage.asp（リストアイテム）
           └─ bs_default.asp（通常ページ）
```

### データフロー図

```
[入力]               [処理]                    [出力]

削除ボタン ────────▶ deletePage()
クリック                 │
                        │
                        ▼
                   confirm()
                   (確認ダイアログ)
                        │
               ┌────────┴────────┐
               ▼                 ▼
           キャンセル          確認OK
               │                 │
               ▼                 ▼
           何もしない      form.submit()
                                 │
                                 ▼
                           bs_processPage.asp
                           (btnaction="delete")
                                 │
                                 ▼
                           checkCSRF()
                                 │
                                 ▼
                        ┌────────┴────────┐
                        ▼                 ▼
                   page設定          removeRang()
                   bDeleted=true     (親から除去)
                   iRang=0
                   bOnline=false
                   bHomepage=false
                        │
                        ▼
                   deleteListItems()
                   (リストアイテム削除)
                        │
                        ▼
                   page.save()
                        │
                   ┌────┴────┐
                   ▼         ▼
             tblPage     tblContactPage
             (UPDATE)    (DELETE)
                   │
                   └────────┬────────┘
                            ▼
                      リダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_delete.asp | `asp/bs_delete.asp` | ソース | 削除ボタン表示 |
| bs_processPage.asp | `asp/bs_processPage.asp` | ソース | 削除処理実行 |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | コンテンツページ編集画面 |
| page.asp | `asp/includes/page.asp` | ソース | cls_pageクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証・権限チェック |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限定義 |
