# 機能設計書 100-リストページ表示

## 概要

本ドキュメントは、QuickerSite CMSのフロントエンドにおけるリストページ表示機能の設計を記述する。ブログ、ニュース、FAQ等の一覧形式ページをレンダリングし、訪問者に表示するための機能である。

### 本機能の処理概要

リストページ表示機能は、複数のアイテム（記事、投稿等）を持つ一覧形式のページを表示する機能である。

**業務上の目的・背景**：ブログ、ニュース、FAQ、製品一覧など、同一形式の複数アイテムを時系列や分類別に表示する一覧ページは、CMSにおいて頻繁に使用されるコンテンツ形式である。本機能により、管理画面で作成されたリストアイテムを適切な形式で表示し、展開/折りたたみ、アコーディオン表示、外部リンク対応など、多様な表示オプションを提供する。

**機能の利用シーン**：ブログ記事一覧の閲覧時、ニュース一覧の閲覧時、FAQページでのQ&A展開時、製品情報一覧の閲覧時に利用される。

**主要な処理内容**：
1. リストページのアイテム一覧取得（fastlistitems）
2. 各アイテムの展開/折りたたみ状態の判定
3. 外部リンクアイテムの処理
4. アコーディオン表示モードの処理
5. アイテム内フィード組み込み
6. 定数置換処理

**関連システム・外部連携**：外部URLへのリンク対応、RSSフィード組み込み。

**権限による制御**：親ページの認証設定に従う（パスワード保護・イントラネット認証）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 172 | リストページ処理 | 主画面 | 一覧形式ページ（ブログ等）の表示処理 |
| 9 | リストページ編集 | 管理画面 | 一覧形式ページの作成・設定 |
| 10 | リストアイテム編集 | 管理画面 | リストページ内の個別アイテム編集 |

## 機能種別

ページレンダリング・リスト表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| item | String(暗号化) | No | 展開するアイテムID | 復号化後に数値チェック |
| item=close | String | No | 全アイテム折りたたみ | 固定値チェック |

### 入力データソース

- URLパラメータ（item）
- tblPageテーブル（リストアイテムデータ）
- セッション情報（認証状態）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pageListPage | String | リストアイテム一覧HTML |
| QS_list | String | リスト全体のラッパーDIV |
| QS_listitem | String | 各アイテムのDIV |
| QS_listitemtitle | String | アイテムタイトルDIV |
| QS_listitemvalue | String | アイテム本文DIV |
| QS_listminusplus | String | 展開/折りたたみアイコンDIV |

### 出力先

- 親ページのpageListPage変数に格納
- HTMLとしてテンプレートに組み込み

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ pageListPageにQS_list開始DIVを設定
2. リストアイテム取得
   └─ selectedPage.fastlistitemsでアイテム一覧取得
3. 表示モード判定
   └─ アコーディオンモードか通常モードか判定
4. 通常モード処理
   └─ 各アイテムをループ
   └─ 展開/折りたたみ状態を判定
   └─ 外部リンクアイテムの処理
   └─ HTML生成
5. アコーディオンモード処理
   └─ getAccordeonList()でHTML生成
6. 定数置換
   └─ treatConstants()で定数を置換
7. 出力
   └─ pageListPage変数に結果を格納
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[pageListPage初期化]
    B --> C[fastlistitems取得]
    C --> D{アコーディオンモード?}
    D -->|Yes| E[getAccordeonList呼び出し]
    D -->|No| F[ループ開始]
    F --> G[アイテム取得]
    G --> H{外部リンクあり?}
    H -->|Yes| I[外部リンク処理]
    H -->|No| J{展開条件判定}
    J -->|展開| K[本文表示]
    J -->|折りたたみ| L[タイトルのみ表示]
    I --> M[展開/折りたたみアイコン設定]
    K --> M
    L --> M
    M --> N{フィードあり?}
    N -->|Yes| O[フィード組み込み]
    N -->|No| P[アイテムHTML完成]
    O --> P
    P --> Q{次のアイテムあり?}
    Q -->|Yes| F
    Q -->|No| R[定数置換]
    E --> R
    R --> S[DIV閉じタグ]
    S --> T[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-100-1 | 展開条件1 | URLパラメータで指定されたアイテムは展開 | item=encryptedId |
| BR-100-2 | 展開条件2 | デフォルト展開数以内のアイテムは展開 | LPCounter < iLPOpenByDefault |
| BR-100-3 | 展開条件3 | bOpenOnload=trueの場合は全アイテム展開 | item未指定時 |
| BR-100-4 | 折りたたみ | item=closeで全アイテム折りたたみ | item=close |
| BR-100-5 | 外部リンク | 外部リンクアイテムは展開せず直接リンク | sLPExternalURL設定時 |
| BR-100-6 | 新規ウィンドウ | bLPExternalOINW=trueで新規ウィンドウ | 外部リンクアイテム |
| BR-100-7 | 日付非表示 | bHideDate=trueの場合は日付を非表示 | 親ページ設定 |

### 計算ロジック

- 展開判定：`printReplies or pageCondition or (LPCounter<iLPOpenByDefault and item<>"close" and decrypt(item)=0) or item=encryptedListkey or (bOpenOnload and isLeeg(item))`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| アイテム取得 | tblPage | SELECT | リストアイテムの取得 |

### テーブル別操作詳細

#### tblPage（リストアイテム）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sTitle, sValue, sLPExternalURL, bLPExternalOINW, iFeedId, 日付関連 | iListPageID = selectedPage.iId AND bOnline=true | fastlistitems経由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アイテムなし | リストアイテムが存在しない | 空のリストとして表示 |

### リトライ仕様

特になし

## トランザクション仕様

読み取り専用の処理のため、トランザクション管理は不要

## パフォーマンス要件

- fastlistitems使用による高速取得
- 大量アイテム時はページング考慮（現状は全件表示）

## セキュリティ考慮事項

- 親ページの認証設定を継承
- 出力時のquotRep処理によるXSS対策
- 外部リンクはtarget="_blank"で新規ウィンドウ表示可能

## 備考

- CSSクラス名は`QS_list`、`QS_listitem`、`QS_listitemtitle`、`QS_listitemvalue`、`QS_listminusplus`
- アコーディオンモードは別途CSS設定が必要
- フィード組み込みはiFeedIdが設定されているアイテムのみ

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | process_listpage.asp | `asp/process_listpage.asp` | リストページ処理のメインファイル |

**主要処理フロー**:
1. **2行目**: pageListPage初期化（`<div id='QS_list'>`）
2. **3行目**: アイテム取得（`selectedPage.fastlistitems`）
3. **4-10行目**: フォーム有無判定
4. **12-81行目**: 通常モード処理（アコーディオンでない場合）
5. **82-87行目**: アコーディオンモード処理

**読解のコツ**:
- `selectedListItem`は各ループでの現在アイテム
- `encryptedListkey`はアイテムIDの暗号化版
- `isLPEU`は外部リンクアイテムかどうかのフラグ

#### Step 2: 展開/折りたたみロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_listpage.asp | `asp/process_listpage.asp` | 36-43行目の条件判定 |

**展開条件**:
```asp
if printReplies or pageCondition or (LPCounter<convertGetal(selectedPage.iLPOpenByDefault) and Request.QueryString ("item")<>"close" and convertGetal(decrypt(Request.Querystring ("item")))=0) or Request.QueryString ("item")=encryptedListkey or (convertBool(selectedPage.bOpenOnload) and isLeeg(Request.QueryString ("item"))) then
```

**条件の内訳**:
- `printReplies`：印刷モード
- `pageCondition`：フォーム送信時
- `LPCounter < iLPOpenByDefault`：デフォルト展開数以内
- `item=encryptedListkey`：URL指定で展開
- `bOpenOnload and isLeeg(item)`：全展開設定

#### Step 3: HTML構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process_listpage.asp | `asp/process_listpage.asp` | 27-76行目のHTML生成 |

**HTML構造**:
```html
<div id='QS_list'>
  <div class='QS_listitem'>
    <div class='QS_listminusplus'>
      <!-- 展開/折りたたみアイコン -->
    </div>
    <div class='QS_listitemtitle'>
      <!-- タイトル -->
    </div>
    <div class='QS_listitemvalue'>
      <!-- 本文（展開時のみ） -->
    </div>
  </div>
  <!-- 繰り返し -->
</div>
```

### プログラム呼び出し階層図

```
process.asp
    │
    └─ process_listpage.asp（インクルード）
           │
           ├─ selectedPage.fastlistitems
           │      └─ tblPage SELECT (iListPageID)
           │
           ├─ ループ処理
           │      ├─ selectedListItem設定
           │      ├─ 外部リンク判定（isLPEU）
           │      ├─ 展開/折りたたみ判定
           │      ├─ HTML生成
           │      │      ├─ QS_listminusplus
           │      │      ├─ QS_listitemtitle
           │      │      └─ QS_listitemvalue
           │      └─ フィード組み込み
           │             └─ selectedListItem.Feed.build()
           │
           ├─ アコーディオンモード
           │      └─ selectedPage.getAccordeonList()
           │
           └─ treatConstants()（定数置換）
```

### データフロー図

```
[入力]               [処理]                    [出力]

selectedPage ──────▶ fastlistitems取得 ────▶ アイテム配列
                        │
                        ▼
URLパラメータ ────────▶ 展開判定 ─────────────▶ 展開/折りたたみ状態
(item)                  │
                        ▼
              ┌─────────┴─────────┐
              ▼                   ▼
        通常モード          アコーディオンモード
              │                   │
              ▼                   ▼
        HTML生成            getAccordeonList()
              │                   │
              └─────────┬─────────┘
                        ▼
                   定数置換
                        │
                        ▼
                  pageListPage
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_listpage.asp | `asp/process_listpage.asp` | ソース | リストページ処理メイン |
| process.asp | `asp/process.asp` | ソース | 親処理（インクルード元） |
| bs_listPage.asp | `asp/bs_listPage.asp` | ソース | 管理画面リストページ設定 |
| bs_editListItem.asp | `asp/bs_editListItem.asp` | ソース | 管理画面アイテム編集 |
