# 機能設計書 101-カタログ表示

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントエンドのカタログ表示機能について記載する。商品カタログや各種アイテム一覧を公開サイト上で閲覧者に表示するための機能である。

### 本機能の処理概要

**業務上の目的・背景**：企業や店舗がウェブサイト上で商品やサービスの一覧を公開し、閲覧者が容易に情報を検索・閲覧できるようにするために本機能が必要である。ECサイトや製品紹介サイトにおいて、カタログ形式での情報提供は閲覧者の利便性向上と購買意欲促進に直結する業務課題を解決する。

**機能の利用シーン**：サイト訪問者が商品一覧ページにアクセスした際に利用される。検索フォームからキーワードや各種条件で絞り込みを行い、目的の商品・アイテムを探す場面で使用される。また、ページネーションを使用して大量のアイテムを効率的に閲覧する際にも活用される。

**主要な処理内容**：
1. 選択されたページに関連付けられたカタログ情報の取得
2. カタログがオンライン状態かどうかの確認
3. 検索フォームの生成（検索可能な場合）
4. 検索条件に基づくアイテムの絞り込み処理
5. 検索結果のページネーション処理
6. カタログアイテムの詳細情報（画像、フィールド、ファイル）の表示
7. 関連フォームへのリンク生成（登録フォームがある場合）

**関連システム・外部連携**：データベースからカタログ情報を取得し、テンプレートエンジンと連携してHTML出力を行う。画像表示のためのサムネイル生成機能とも連携する。

**権限による制御**：特別な権限制御はないが、カタログのオンライン期間（dOnlineFrom〜dOnlineUntill）による表示制御が行われる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 171 | カタログ処理 | 主画面 | カタログ・商品一覧の表示処理 |

## 機能種別

データ検索・表示処理 / ページネーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pageAction | String | Yes | アクション種別（"catalog"） | 固定値チェック |
| iID | String | Yes | ページID（暗号化済み） | 復号化処理 |
| pageSize | Integer | No | 1ページあたりの表示件数 | 数値チェック |
| absolutepage | Integer | No | 現在のページ番号 | 数値チェック、デフォルト1 |
| sTitle | String | No | タイトル検索キーワード | 最大100文字 |
| 各検索フィールド | Mixed | No | カスタムフィールド検索条件 | フィールドタイプに応じた検証 |

### 入力データソース

- POSTリクエスト: 検索フォームからの入力値
- セッション: ページ情報
- データベース: tblCatalog, tblCatalogItem, tblCatalogField, tbCatalogItemFields

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pageCatalog | String | 生成されたカタログHTML |
| catForm | String | 検索フォームHTML |
| browseTable | String | ページネーションナビゲーションHTML |

### 出力先

画面表示（HTMLとしてレンダリング）

## 処理フロー

### 処理シーケンス

```
1. カタログ情報の取得
   └─ selectedPage.catalogからカタログオブジェクトを取得

2. オンライン状態チェック
   └─ catalog.bOnlineがtrueの場合のみ処理続行

3. 検索フィールド・ファイルタイプの取得
   └─ catalog.fields("public")でpublic属性のフィールドを取得
   └─ catalog.fields("public,search")で検索可能フィールドを取得

4. 検索条件の取得
   └─ cls_itemSearchクラスを生成
   └─ getRequestValues()でフォーム入力値を取得

5. 検索フォームの生成（bSearchableがtrueの場合）
   └─ 各検索フィールドタイプに応じた入力コントロール生成

6. 検索実行・結果取得
   └─ itemSearch.resultItemsで検索結果を取得

7. 結果表示
   └─ 各アイテムの詳細情報をHTML生成
   └─ 画像、フィールド値、添付ファイルを表示

8. ページネーション表示
   └─ browseTableでページナビゲーションを生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{カタログ取得}
    B --> C{オンライン?}
    C -->|No| Z[終了]
    C -->|Yes| D[検索フィールド取得]
    D --> E[検索条件取得]
    E --> F{検索可能?}
    F -->|Yes| G[検索フォーム生成]
    F -->|No| H[結果取得]
    G --> H
    H --> I[アイテムループ]
    I --> J[詳細情報表示]
    J --> K[ファイル表示]
    K --> L{フォームあり?}
    L -->|Yes| M[フォームリンク生成]
    L -->|No| N[ページネーション]
    M --> N
    N --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-101 | オンライン期間制御 | dOnlineFrom〜dOnlineUntillの期間内のみアイテム表示 | bOnline=trueの場合 |
| BR-102 | 検索キーワード分割 | スペース区切りで複数キーワードをOR検索 | sTitle入力時 |
| BR-103 | ページサイズ上限 | 未指定時は9999件を上限とする | pageSize未指定時 |

### 計算ロジック

- ページネーション計算: `First_Record = (absolutepage * pageSize) - (pageSize - 1)`
- 最終レコード計算: `Last_Record = absolutepage * pageSize`（recordcountを超えない）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| カタログアイテム検索 | tblCatalogItem, tbCatalogItemFields, tblCatalogField | SELECT | 検索条件に合致するアイテムを取得 |

### テーブル別操作詳細

#### tblCatalogItem

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sTitle, dOnlineFrom, dOnlineUntill, sPicExt | カタログIDと検索条件でフィルタ | オンライン期間も条件に含む |

#### tbCatalogItemFields

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iFieldID, iItemID, sValue | iCatalogIDでフィルタ | JOINで関連テーブルと結合 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 表示なし | カタログがオフライン | 処理をスキップ |
| - | 結果0件 | 検索条件に合致するアイテムなし | "0 resultsforsearch"を表示 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。

## パフォーマンス要件

- ページサイズによる件数制限でレスポンス時間を制御
- ADOのpagesizeプロパティを使用したサーバーサイドページング

## セキュリティ考慮事項

- 入力値はencrypt/decrypt関数で暗号化・復号化
- sanitize関数による出力エスケープ（XSS対策）
- cleanup関数によるSQLインジェクション対策

## 備考

- オランダ語のコメント（"cataloog ophalen"など）が含まれている
- Classic ASP/VBScriptで実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、カタログとアイテムの検索に関わるクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ItemSearch.asp | `asp/includes/ItemSearch.asp` | cls_itemSearchクラスの構造、検索ロジック |

**読解のコツ**: VBScriptのClassモジュールでは、Public/Privateでメンバーのスコープを制御。propertyキーワードでgetter/setterを定義。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process.asp | `asp/process.asp` | pageAction="catalog"時のinclude処理（249行目） |

**主要処理フロー**:
1. **249行目**: `<!-- #include file="process_catalog.asp"-->`でカタログ処理をインクルード

#### Step 3: カタログ表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process_catalog.asp | `asp/process_catalog.asp` | カタログ表示のメインロジック |

**主要処理フロー**:
- **3行目**: `set catalog=selectedPage.catalog` - カタログオブジェクト取得
- **4行目**: `if catalog.bOnline then` - オンライン状態チェック
- **8-13行目**: `cls_itemSearch`インスタンス生成と検索条件設定
- **18-45行目**: 検索フォームHTML生成
- **51行目**: `set resultItems=itemSearch.resultItems` - 検索実行
- **55-120行目**: 結果アイテムのループ処理と表示

### プログラム呼び出し階層図

```
process.asp (エントリーポイント)
    │
    ├─ process_catalog.asp (カタログ表示処理)
    │      │
    │      ├─ cls_itemSearch (検索クラス)
    │      │      ├─ getRequestValues() - フォーム値取得
    │      │      ├─ resultItems() - 検索結果取得
    │      │      └─ browseTable() - ページネーション生成
    │      │
    │      └─ cls_catalogItem (アイテムクラス)
    │             ├─ fields - フィールド値取得
    │             ├─ showPic() - 画像表示
    │             └─ files - 添付ファイル取得
    │
    └─ template (テンプレート処理)
```

### データフロー図

```
[入力]               [処理]                    [出力]

POSTパラメータ ───▶ cls_itemSearch ───▶ pageCatalog変数
  ・sTitle            ├─ fixedSQL()              │
  ・検索フィールド     ├─ resultItems()           ▼
  ・pageSize          └─ browseTable()      HTMLレンダリング
  ・absolutepage                                  │
       │                                         ▼
       ▼                                    ブラウザ表示
tblCatalogItem ───▶ SELECT ───▶ 検索結果
tbCatalogItemFields
tblCatalogField
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_catalog.asp | `asp/process_catalog.asp` | ソース | カタログ表示メイン処理 |
| process.asp | `asp/process.asp` | ソース | ページアクションルーター |
| ItemSearch.asp | `asp/includes/ItemSearch.asp` | ソース | 検索クラス定義 |
| catalog.asp | `asp/includes/catalog.asp` | ソース | カタログクラス定義 |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | カタログアイテムクラス定義 |
| catalogField.asp | `asp/includes/catalogField.asp` | ソース | カタログフィールドクラス定義 |
| encryption.asp | `asp/includes/encryption.asp` | ソース | 暗号化・復号化関数 |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通関数（sanitize等） |
