# 機能設計書 103-ページログイン

## 概要

本ドキュメントは、QuickerSite CMSにおけるパスワード保護ページへのログイン機能について記載する。個別ページにパスワードを設定し、閲覧者が正しいパスワードを入力した場合のみコンテンツを表示できるようにする機能である。

### 本機能の処理概要

**業務上の目的・背景**：特定のページを限られた人にのみ公開したい場合に、簡易的なアクセス制御を提供するために本機能が必要である。会員限定コンテンツや社内向け情報など、一般公開したくないページをパスワードで保護することで、情報セキュリティを確保できる。

**機能の利用シーン**：パスワード保護が設定されたページにアクセスした際に利用される。訪問者はパスワード入力フォームでパスワードを入力し、正しいパスワードの場合はページ内容が表示される。パスワードを知らない訪問者はWebマスターにメールでパスワードを問い合わせることができる。

**主要な処理内容**：
1. パスワード入力フォームの表示
2. 入力パスワードの検証
3. 認証成功時のページリダイレクト
4. 認証失敗時のエラーメッセージ表示
5. パスワード問い合わせメールリンクの生成

**関連システム・外部連携**：logonクラスによる認証処理。Cookieによるパスワード記憶機能と連携。

**権限による制御**：ページごとに個別のパスワードを設定可能。正しいパスワードを入力したユーザーのみページ閲覧可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 164 | ログイン処理 | 主画面 | ユーザーログイン処理 |

## 機能種別

認証処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pageAction | String | Yes | アクション種別（"login"） | 固定値チェック |
| iId | String | Yes | ページID（暗号化済み） | 復号化処理 |
| sPw | String | Yes | パスワード | 最大15文字 |

### 入力データソース

- POSTリクエスト: パスワード入力フォームからの値
- Cookie: 保存されたパスワード（自動ログイン用）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pageBody | String | ログインフォームHTML |
| pageTitle | String | ページタイトル |

### 出力先

画面表示（認証成功時はリダイレクト）

## 処理フロー

### 処理シーケンス

```
1. ログインフォーム送信チェック
   └─ pageAction="login"の場合、認証処理を実行

2. パスワード検証
   └─ logon.logonItem()でパスワードをチェック

3. 認証結果判定
   ├─ 成功: ページにリダイレクト
   └─ 失敗: エラーメッセージ追加

4. ログインフォーム生成
   └─ パスワード入力フィールド
   └─ パスワード問い合わせリンク
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{POSTデータあり?}
    B -->|Yes| C[パスワード検証]
    B -->|No| F[フォーム表示]
    C --> D{認証成功?}
    D -->|Yes| E[ページリダイレクト]
    D -->|No| G[エラー追加]
    G --> F
    F --> H[フォームHTML生成]
    H --> I[終了]
    E --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-301 | パスワード長制限 | 最大15文字まで | 常時 |
| BR-302 | Cookie保存 | 認証成功時にCookieにパスワード保存 | 認証成功時 |
| BR-303 | 自動フォーカス | パスワードフィールドに自動フォーカス | フォーム表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パスワード検証 | tblPage | SELECT | ページのパスワードを取得して比較 |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sPw | iIdでページ取得 | logon.logonItem内で実行 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_login | 認証エラー | パスワード不一致 | エラーメッセージ表示 |

### リトライ仕様

リトライ制限なし。繰り返しパスワード入力可能。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。

## パフォーマンス要件

単純なパスワード比較のため、特別な要件なし。

## セキュリティ考慮事項

- パスワード入力フィールドはtype="password"で表示をマスク
- encrypt関数によるページIDの暗号化
- sanitize関数による出力エスケープ

## 備考

- ページ単位での簡易パスワード保護機能
- イントラネット認証とは別の機能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

処理の起点となるファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | process.asp | `asp/process.asp` | pageAction="login"時のinclude処理（133行目） |

**主要処理フロー**:
1. **133行目**: `case lcase(clogin)` - ログインアクションの分岐
2. **133行目**: `<!-- #include file="process_login.asp"-->` - ログイン処理インクルード

#### Step 2: ログイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_login.asp | `asp/process_login.asp` | ログイン処理のメインロジック |

**主要処理フロー**:
- **2行目**: POSTアクションチェック
- **3行目**: `logon.logonItem()` - パスワード検証
- **4行目**: 認証成功時のリダイレクト
- **6行目**: 認証失敗時のエラー追加
- **9-25行目**: ログインフォームHTML生成

### プログラム呼び出し階層図

```
process.asp (エントリーポイント)
    │
    ├─ process_login.asp (ログイン処理)
    │      │
    │      └─ logon.logonItem() (認証メソッド)
    │             └─ パスワード比較
    │
    └─ template (テンプレート処理)
```

### データフロー図

```
[入力]               [処理]                    [出力]

sPw ────────────▶ logon.logonItem() ──▶ 認証結果
  │                     │                    │
  ▼                     ▼                    ▼
tblPage.sPw ◀──── パスワード比較 ────▶ リダイレクト
                                       or エラー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_login.asp | `asp/process_login.asp` | ソース | ログイン処理メイン |
| process.asp | `asp/process.asp` | ソース | ページアクションルーター |
| LogonEdit.asp | `asp/includes/LogonEdit.asp` | ソース | logonクラス定義 |
| encryption.asp | `asp/includes/encryption.asp` | ソース | 暗号化関数 |
| messages.asp | `asp/includes/messages.asp` | ソース | エラーメッセージ管理 |
