# 機能設計書 104-イントラネットログイン

## 概要

本ドキュメントは、QuickerSite CMSにおける会員専用エリア（イントラネット）へのログイン機能について記載する。登録済み会員がメールアドレス（またはニックネーム）とパスワードで認証し、会員限定コンテンツにアクセスできるようにする機能である。

### 本機能の処理概要

**業務上の目的・背景**：会員制サイトやコミュニティサイトにおいて、登録会員のみがアクセスできる専用エリアを提供するために本機能が必要である。会員限定コンテンツ、フォーラム、マイページ機能など、認証されたユーザーのみに提供するサービスを実現する。

**機能の利用シーン**：会員限定ページにアクセスした際、または明示的にログインを行う際に利用される。メールアドレス/ニックネームとパスワード、さらにCAPTCHA認証を入力してログインする。ログイン状態の保持期間を選択可能。

**主要な処理内容**：
1. ログインフォームの表示（メール/ニックネーム、パスワード、CAPTCHA）
2. CAPTCHA検証
3. 認証情報の検証（logon.logonIntranet）
4. セッション保持モードの設定
5. 認証成功時のリダイレクト処理
6. パスワード忘れ・新規登録リンクの表示

**関連システム・外部連携**：会員情報データベース（tblContact）との連携。CAPTCHA画像生成機能との連携。セッション管理機能との連携。

**権限による制御**：会員ステータス（iStatus）による画面遷移制御。cs_silent/cs_profile/cs_writeステータスの会員は特定画面にリダイレクト。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 164 | ログイン処理 | 主画面 | ユーザーログイン処理 |

## 機能種別

認証処理 / セッション管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pageAction | String | Yes | アクション種別（"loginIntranet"） | 固定値チェック |
| iId | String | Yes | ページID（暗号化済み） | 復号化処理 |
| sEmail | String | Yes | メールアドレスまたはニックネーム | 必須チェック |
| sPw | String | Yes | パスワード | 必須チェック |
| captcha | String | Yes | CAPTCHA入力値 | 4文字、セッション値と比較 |
| mode | String | No | ログイン保持モード（mode1/mode2/mode3） | 選択肢チェック |
| item | String | No | 遷移先アイテムID | 任意 |
| iPostID | String | No | 遷移先投稿ID | 任意 |

### 入力データソース

- POSTリクエスト: ログインフォームからの入力値
- セッション: CAPTCHA検証用の値

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pageBody | String | ログインフォームHTML |
| pageTitle | String | イントラネット名 |

### 出力先

画面表示（認証成功時はリダイレクト）

## 処理フロー

### 処理シーケンス

```
1. ログインフォーム送信チェック
   └─ pageAction="loginIntranet"の場合、認証処理を実行

2. CAPTCHA検証
   └─ セッションのcaptcha値と入力値を比較（大文字小文字無視）

3. 認証処理
   └─ logon.logonIntranet()でメール/パスワード検証

4. 認証結果判定
   ├─ 成功: 適切なページにリダイレクト
   │    ├─ iPostID指定時: 投稿ページへ
   │    ├─ item指定時: アイテムページへ
   │    └─ その他: 指定ページへ
   └─ 失敗: エラーメッセージ追加

5. ログインフォーム生成
   └─ メール/ニックネーム入力フィールド
   └─ パスワード入力フィールド
   └─ CAPTCHA画像と入力フィールド
   └─ パスワード忘れリンク
   └─ 新規登録リンク（許可時のみ）
   └─ ログイン保持モード選択
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{POSTデータあり?}
    B -->|Yes| C[CAPTCHA検証]
    B -->|No| J[フォーム表示]
    C --> D{CAPTCHA正しい?}
    D -->|No| E[CAPTCHAエラー]
    D -->|Yes| F[認証処理]
    E --> J
    F --> G{認証成功?}
    G -->|Yes| H[リダイレクト先決定]
    G -->|No| I[ログインエラー]
    I --> J
    H --> K[リダイレクト]
    J --> L[フォームHTML生成]
    L --> M[終了]
    K --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-401 | ログインモード切替 | iLoginMode=0でメール、1でニックネーム認証 | 設定に応じて |
| BR-402 | 新規登録リンク表示 | bAllowNewRegistrations=trueの場合のみ表示 | 設定に応じて |
| BR-403 | ステータスチェック | cs_silent/cs_profile/cs_writeはウェルカムページへ | 認証成功後 |
| BR-404 | セッション保持 | mode1/mode2/mode3で保持期間を選択 | ログイン時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 認証 | tblContact | SELECT | メール/ニックネームとパスワードで検索 |
| ログイン日時更新 | tblContact | UPDATE | dLastLoginTSを更新 |

### テーブル別操作詳細

#### tblContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sEmail, sNickName, sPw, iStatus | 認証条件で検索 | logon.logonIntranet内 |
| UPDATE | dLastLoginTS | now() | 認証成功時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_captcha | CAPTCHA エラー | CAPTCHA不一致 | エラーメッセージ表示 |
| err_login | 認証エラー | メール/パスワード不一致 | エラーメッセージ表示 |

### リトライ仕様

リトライ制限なし。繰り返しログイン試行可能。

## トランザクション仕様

認証成功時のdLastLoginTS更新は単一UPDATE文で実行。

## パフォーマンス要件

単純な認証処理のため、特別な要件なし。

## セキュリティ考慮事項

- CAPTCHA認証によるボット対策
- パスワード入力フィールドはtype="password"で表示をマスク
- encrypt関数によるページIDの暗号化
- sanitize関数による出力エスケープ
- セッションによるCAPTCHA値管理

## 備考

- イントラネット機能が有効（customer.intranetUse=true）の場合のみ動作
- ユーザーフレンドリーURL対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、会員情報を保持するクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contact.asp | `asp/includes/contact.asp` | cls_contactクラスの構造、会員情報 |

**読解のコツ**: iStatusプロパティが会員のステータス（権限レベル）を管理。cs_silent, cs_profile, cs_writeなどの定数と比較される。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process.asp | `asp/process.asp` | pageAction="loginIntranet"時のinclude処理（144-146行目） |

**主要処理フロー**:
1. **144行目**: `case lcase(cloginIntranet)` - イントラネットログインアクションの分岐
2. **145行目**: `if customer.intranetUse then` - イントラネット有効チェック
3. **145行目**: `<!-- #include file="process_loginIntranet.asp"-->` - ログイン処理インクルード

#### Step 3: ログイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process_loginIntranet.asp | `asp/process_loginIntranet.asp` | イントラネットログインのメインロジック |

**主要処理フロー**:
- **2行目**: POSTアクションチェック
- **4-5行目**: CAPTCHA検証
- **6行目**: `logon.logonIntranet()` - 認証処理
- **9-19行目**: リダイレクト先の決定
- **30-87行目**: ログインフォームHTML生成

### プログラム呼び出し階層図

```
process.asp (エントリーポイント)
    │
    ├─ process_loginIntranet.asp (ログイン処理)
    │      │
    │      ├─ CAPTCHA検証 (session比較)
    │      │
    │      └─ logon.logonIntranet() (認証メソッド)
    │             └─ tblContact検索
    │
    └─ template (テンプレート処理)
```

### データフロー図

```
[入力]               [処理]                    [出力]

sEmail ─────────▶ logon.logonIntranet() ──▶ 認証結果
sPw ────────────▶       │                      │
captcha ────────▶ CAPTCHA検証              ▼
mode ───────────▶       │              リダイレクト
       │                ▼              or エラー
       ▼          tblContact検索
session(captcha) ──▶ 比較
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_loginIntranet.asp | `asp/process_loginIntranet.asp` | ソース | イントラネットログイン処理 |
| process.asp | `asp/process.asp` | ソース | ページアクションルーター |
| contact.asp | `asp/includes/contact.asp` | ソース | 会員クラス定義 |
| LogonEdit.asp | `asp/includes/LogonEdit.asp` | ソース | logonクラス定義 |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客設定クラス |
