# 機能設計書 105-会員登録

## 概要

本ドキュメントは、QuickerSite CMSにおける新規会員の仮登録・アクティベーションメール送信機能について記載する。メールアドレスを入力して仮登録を行い、送信されるアクティベーションリンクをクリックして本登録を完了するダブルオプトイン方式の会員登録機能である。

### 本機能の処理概要

**業務上の目的・背景**：会員制サイトやコミュニティサイトにおいて、新規会員を受け付けるために本機能が必要である。ダブルオプトイン方式により、メールアドレスの有効性を確認し、なりすまし登録やスパム登録を防止できる。

**機能の利用シーン**：サイト訪問者が新規会員登録を希望する際に利用される。メールアドレスとCAPTCHAを入力して登録申請を行い、入力メールアドレスに送信されるアクティベーションリンクをクリックしてプロフィール登録画面に進む。

**主要な処理内容**：
1. 仮登録フォームの表示（メールアドレス、CAPTCHA）
2. CAPTCHA検証
3. メールアドレスの重複チェック
4. チケット（仮登録レコード）の生成
5. アクティベーションメールの送信
6. 登録完了ページへのリダイレクト

**関連システム・外部連携**：メール送信機能との連携。チケット管理（tblContactRegistration）との連携。

**権限による制御**：customer.bAllowNewRegistrations=trueの場合のみ機能が有効。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 167 | 登録処理 | 主画面 | 新規会員の仮登録・アクティベーションメール送信 |

## 機能種別

データ登録処理 / メール送信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pageAction | String | Yes | アクション種別（"register"） | 固定値チェック |
| sEmail | String | Yes | メールアドレス | 必須、メール形式、最大100文字 |
| captcha | String | Yes | CAPTCHA入力値 | 4文字、セッション値と比較 |
| QS_secCode | String | Yes | CSRFトークン | セッション値と比較 |

### 入力データソース

- POSTリクエスト: 登録フォームからの入力値
- セッション: CAPTCHA検証用の値、CSRFトークン

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pageBody | String | 登録フォームHTML |
| pageTitle | String | 登録画面タイトル（customer.sLabelRegister） |

### 出力先

画面表示（登録成功時はリダイレクト）、メール送信

## 処理フロー

### 処理シーケンス

```
1. 登録フォーム送信チェック
   └─ pageAction="register"の場合、登録処理を実行

2. CSRF検証
   └─ checkCSRF()でトークン検証

3. チケット生成・保存・送信
   └─ cls_ticketインスタンス生成
   └─ sEmailを設定
   └─ saveAndSend()で検証・保存・メール送信

4. 検証処理（saveAndSend内）
   ├─ メールアドレス空チェック
   ├─ メールアドレス形式チェック
   ├─ CAPTCHA検証
   ├─ 既存チケット重複チェック
   └─ 既存会員重複チェック

5. 保存処理
   └─ tblContactRegistrationにチケット保存
   └─ sTicketを生成（ランダム文字列）

6. メール送信
   └─ アクティベーションリンク含むメールを送信

7. リダイレクト
   └─ ログイン画面へリダイレクト（fb_activationlinkメッセージ付き）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{POSTデータあり?}
    B -->|Yes| C[CSRF検証]
    B -->|No| K[フォーム表示]
    C --> D[チケット生成]
    D --> E[メールアドレス検証]
    E --> F{検証OK?}
    F -->|No| K
    F -->|Yes| G[CAPTCHA検証]
    G --> H{CAPTCHA OK?}
    H -->|No| K
    H -->|Yes| I[チケット保存]
    I --> J[メール送信]
    J --> L[リダイレクト]
    K --> M[フォームHTML生成]
    M --> N[終了]
    L --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-501 | ダブルオプトイン | メールアドレス確認後にプロフィール登録 | 常時 |
| BR-502 | メール重複禁止 | 既存会員・既存チケットと同一メール禁止 | 登録時 |
| BR-503 | チケット有効性 | sTicketは一意のランダム文字列 | チケット生成時 |
| BR-504 | 新規登録許可 | bAllowNewRegistrations=trueの場合のみ | 常時 |

### 計算ロジック

- チケット生成: `sTicket = GeneratePassWord() & GeneratePassWord()` （16文字のランダム文字列）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 重複チェック | tblContactRegistration | SELECT | 同一メールのチケット存在チェック |
| 重複チェック | tblContact | SELECT | 同一メールの会員存在チェック |
| チケット保存 | tblContactRegistration | INSERT | 新規チケットを保存 |

### テーブル別操作詳細

#### tblContactRegistration

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId | sEmailで検索 | 重複チェック |
| INSERT | sEmail, sTicket, sVisitorDetails, dCreatedTS, iCustomerID | フォーム入力値とシステム値 | 新規チケット |

#### tblContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId | sEmail, iStatus>cs_silentで検索 | 重複チェック |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_email | メールエラー | メールアドレス未入力または形式不正 | エラーメッセージ表示 |
| err_captcha | CAPTCHAエラー | CAPTCHA不一致 | エラーメッセージ表示 |
| err_activationlink | 重複エラー | 既存チケットと同一メール | エラーメッセージ表示 |
| err_doubleemail | 重複エラー | 既存会員と同一メール | エラーメッセージ表示 |

### リトライ仕様

リトライ制限なし。エラー修正後に再送信可能。

## トランザクション仕様

チケット保存は単一INSERT文で実行。

## パフォーマンス要件

単純な登録処理のため、特別な要件なし。

## セキュリティ考慮事項

- CSRF対策（QS_secCodeHidden、checkCSRF()）
- CAPTCHA認証によるボット対策
- メールアドレス形式チェック
- sanitize関数による出力エスケープ
- ダブルオプトインによるなりすまし防止

## 備考

- イントラネット機能が有効（customer.intranetUse=true）かつ新規登録許可（customer.bAllowNewRegistrations=true）の場合のみ動作
- 訪問者詳細情報（getVisitorDetails）もチケットに記録

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、チケット（仮登録）を管理するクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ticket.asp | `asp/includes/ticket.asp` | cls_ticketクラスの構造、検証・保存・メール送信 |

**読解のコツ**: check()関数が各種バリデーションを実行。saveAndSend()がメイン処理で、check()成功後に保存とメール送信を行う。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process.asp | `asp/process.asp` | pageAction="register"時のinclude処理（152-154行目） |

**主要処理フロー**:
1. **152行目**: `case cRegister` - 登録アクションの分岐
2. **153行目**: `if customer.intranetUse and customer.bAllowNewRegistrations then` - 機能有効チェック
3. **153行目**: `<!-- #include file="process_register.asp"-->` - 登録処理インクルード

#### Step 3: 登録処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process_register.asp | `asp/process_register.asp` | 会員登録のメインロジック |

**主要処理フロー**:
- **2行目**: POSTアクションチェック
- **3行目**: CSRF検証
- **4-5行目**: チケット生成とメールアドレス設定
- **6行目**: `saveAndSend()` - 保存とメール送信
- **7行目**: リダイレクト
- **10-29行目**: 登録フォームHTML生成

### プログラム呼び出し階層図

```
process.asp (エントリーポイント)
    │
    ├─ process_register.asp (登録処理)
    │      │
    │      ├─ checkCSRF() (CSRF検証)
    │      │
    │      └─ cls_ticket
    │             ├─ check() - バリデーション
    │             │    ├─ メールアドレス検証
    │             │    ├─ CAPTCHA検証
    │             │    └─ 重複チェック
    │             ├─ saveAndSend() - 保存とメール送信
    │             └─ sendTicket() - メール送信
    │
    └─ template (テンプレート処理)
```

### データフロー図

```
[入力]               [処理]                    [出力]

sEmail ─────────▶ cls_ticket.check() ───▶ 検証結果
captcha ────────▶       │                    │
                        ▼                    ▼
                 tblContactRegistration ─▶ INSERT
                        │                    │
                        ▼                    ▼
                 sendTicket() ─────────▶ メール送信
                        │
                        ▼
                 リダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_register.asp | `asp/process_register.asp` | ソース | 会員登録処理メイン |
| process.asp | `asp/process.asp` | ソース | ページアクションルーター |
| ticket.asp | `asp/includes/ticket.asp` | ソース | チケットクラス定義 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通関数（checkCSRF等） |
