# 機能設計書 106-パスワード再発行

## 概要

本ドキュメントは、QuickerSite CMSにおけるパスワードを忘れた会員への再発行機能について記載する。登録済みメールアドレスを入力することで、新しいパスワードを生成しメールで送信する機能である。

### 本機能の処理概要

**業務上の目的・背景**：会員がパスワードを忘れた場合に、自己解決でパスワードを再設定できるようにするために本機能が必要である。管理者への問い合わせを減らし、会員の利便性を向上させる。

**機能の利用シーン**：会員がログイン時にパスワードを忘れた際に利用される。ログイン画面の「パスワードを忘れた方」リンクからアクセスし、メールアドレスとCAPTCHAを入力して新しいパスワードを受け取る。

**主要な処理内容**：
1. パスワード再発行フォームの表示（メールアドレス、CAPTCHA）
2. CAPTCHA検証
3. メールアドレスの存在確認
4. 新しいパスワードの生成
5. パスワード更新
6. 新パスワードのメール送信
7. ログイン画面へのリダイレクト

**関連システム・外部連携**：会員情報データベース（tblContact）との連携。メール送信機能との連携。

**権限による制御**：特になし。イントラネット機能が有効な場合に利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 170 | パスワード忘れ処理 | 主画面 | パスワードを忘れた会員への再発行処理 |

## 機能種別

パスワード管理 / メール送信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pageAction | String | Yes | アクション種別（"forgotPW"） | 固定値チェック |
| sEmail | String | Yes | 登録メールアドレス | 必須、メール形式 |
| captcha | String | Yes | CAPTCHA入力値 | 4文字、セッション値と比較 |

### 入力データソース

- POSTリクエスト: パスワード再発行フォームからの入力値
- セッション: CAPTCHA検証用の値

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pageBody | String | 再発行フォームHTML |
| pageTitle | String | パスワード忘れタイトル（l("forgotPW")） |

### 出力先

画面表示（処理成功時はリダイレクト）、メール送信

## 処理フロー

### 処理シーケンス

```
1. フォーム送信チェック
   └─ pageAction="forgotPW"の場合、再発行処理を実行

2. CAPTCHA検証
   └─ セッションのcaptcha値と入力値を比較（大文字小文字無視）

3. パスワードリセット
   └─ logon.resetPW()でメールアドレス検証とパスワード再発行

4. resetPW内部処理
   ├─ メールアドレスで会員検索
   ├─ 新パスワード生成
   ├─ パスワード更新
   └─ メール送信

5. 結果判定
   ├─ 成功: ログイン画面へリダイレクト（fb_emailFoundメッセージ付き）
   └─ 失敗: エラーメッセージ追加

6. フォーム生成
   └─ メールアドレス入力フィールド
   └─ CAPTCHA画像と入力フィールド
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{POSTデータあり?}
    B -->|Yes| C[CAPTCHA検証]
    B -->|No| J[フォーム表示]
    C --> D{CAPTCHA正しい?}
    D -->|No| E[CAPTCHAエラー]
    D -->|Yes| F[resetPW実行]
    E --> J
    F --> G{メール存在?}
    G -->|Yes| H[パスワード更新・メール送信]
    G -->|No| I[メール不存在エラー]
    I --> J
    H --> K[リダイレクト]
    J --> L[フォームHTML生成]
    L --> M[終了]
    K --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-601 | 自動パスワード生成 | GeneratePassWord()でランダムパスワード生成 | リセット時 |
| BR-602 | メール通知 | 新パスワードをメールで通知 | リセット成功時 |
| BR-603 | メール存在確認 | 登録済みメールアドレスのみ対象 | リセット時 |

### 計算ロジック

- パスワード生成: `sPw = GeneratePassWord()` （8文字のランダム文字列）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 会員検索 | tblContact | SELECT | メールアドレスで会員を検索 |
| パスワード更新 | tblContact | UPDATE | 新パスワードで更新 |

### テーブル別操作詳細

#### tblContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sEmail, sPw | sEmailで検索 | 会員存在確認 |
| UPDATE | sPw | GeneratePassWord()の値 | パスワード更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_captcha | CAPTCHAエラー | CAPTCHA不一致 | エラーメッセージ表示 |
| err_emailNotFound | メール不存在 | 登録されていないメールアドレス | エラーメッセージ表示 |

### リトライ仕様

リトライ制限なし。繰り返しリセット要求可能。

## トランザクション仕様

パスワード更新は単一UPDATE文で実行。

## パフォーマンス要件

単純な更新処理のため、特別な要件なし。

## セキュリティ考慮事項

- CAPTCHA認証によるボット対策
- 登録済みメールアドレスのみ受付
- 新パスワードはランダム生成
- sanitize関数による出力エスケープ

## 備考

- イントラネット機能が有効（customer.intranetUse=true）の場合のみ動作
- メール本文はcustomer.intranetPWEmailテンプレートを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

処理の起点となるファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | process.asp | `asp/process.asp` | pageAction="forgotPW"時のinclude処理（148-150行目） |

**主要処理フロー**:
1. **148行目**: `case lcase(cForgotPW)` - パスワード忘れアクションの分岐
2. **149行目**: `if customer.intranetUse then` - イントラネット有効チェック
3. **149行目**: `<!-- #include file="process_forgotPW.asp"-->` - 処理インクルード

#### Step 2: パスワード再発行処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process_forgotPW.asp | `asp/process_forgotPW.asp` | パスワード再発行のメインロジック |

**主要処理フロー**:
- **2行目**: POSTアクションチェック
- **3-4行目**: CAPTCHA検証
- **5行目**: `logon.resetPW()` - パスワードリセット実行
- **6行目**: 成功時リダイレクト
- **8行目**: メール不存在エラー
- **12-29行目**: フォームHTML生成

#### Step 3: パスワードリセット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | contact.asp | `asp/includes/contact.asp` | cls_contact.resetPW()メソッド |

**主要処理フロー**:
- **288-306行目**: resetPWメソッド
  - パスワード生成
  - データベース更新
  - メール送信

### プログラム呼び出し階層図

```
process.asp (エントリーポイント)
    │
    ├─ process_forgotPW.asp (パスワード再発行処理)
    │      │
    │      ├─ CAPTCHA検証 (session比較)
    │      │
    │      └─ logon.resetPW()
    │             └─ cls_contact.resetPW()
    │                    ├─ GeneratePassWord()
    │                    ├─ UPDATE tblContact
    │                    └─ cls_mail_message.send()
    │
    └─ template (テンプレート処理)
```

### データフロー図

```
[入力]               [処理]                    [出力]

sEmail ─────────▶ logon.resetPW() ────▶ 結果
captcha ────────▶       │                 │
       │                ▼                 ▼
       ▼          tblContact検索    新パスワード
session(captcha)        │                 │
                        ▼                 ▼
                  パスワード更新     メール送信
                        │
                        ▼
                  リダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| process_forgotPW.asp | `asp/process_forgotPW.asp` | ソース | パスワード再発行処理メイン |
| process.asp | `asp/process.asp` | ソース | ページアクションルーター |
| contact.asp | `asp/includes/contact.asp` | ソース | 会員クラス（resetPWメソッド） |
| LogonEdit.asp | `asp/includes/LogonEdit.asp` | ソース | logonクラス定義 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
