# 機能設計書 110-ゲストブック投稿

## 概要

本ドキュメントは、QuickerSite CMSにおけるゲストブック（掲示板）への投稿・承認フロー機能について記載する。サイト訪問者がゲストブックにメッセージを投稿し、管理者が承認・編集・削除を行える機能である。

### 本機能の処理概要

**業務上の目的・背景**：サイト訪問者からのコメントやメッセージを受け付け、コミュニケーションを促進するために本機能が必要である。訪問者の声を収集し、サイトの活性化やフィードバック収集に活用できる。

**機能の利用シーン**：ゲストブックが設置されたページで、訪問者が名前・メールアドレス・メッセージを入力して投稿する際に利用される。また、管理者がメール内のリンクから投稿を承認・編集・削除する際にも使用される。

**主要な処理内容**：
1. ゲストブック投稿フォームの表示
2. CAPTCHA検証
3. 投稿の保存（承認待ち状態で）
4. 管理者への通知メール送信
5. 管理者による承認・編集・削除処理
6. ゲストブック一覧の表示（承認済み投稿のみ）

**関連システム・外部連携**：ゲストブックデータベース（tblGuestbook, tblGuestbookItem）との連携。メール送信機能との連携（管理者通知）。

**権限による制御**：投稿は誰でも可能。承認・編集・削除はメール内の一意キーを持つリクエストのみ可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ゲストブック投稿 | 主機能 | ゲストブックへの投稿・承認フロー |

## 機能種別

データ登録処理 / 承認ワークフロー

## 入力仕様

### 入力パラメータ（投稿時）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| author | String | Yes | 投稿者名 | 必須、最大50文字 |
| email | String | No | メールアドレス | 最大50文字 |
| {encrypted_id} | String | Yes | メッセージ本文 | 必須、最大5000文字 |
| captcha | String | Yes | CAPTCHA入力値 | セッション値と比較 |
| postbackGB | Boolean | Yes | 投稿フラグ | true |

### 入力パラメータ（管理操作時）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| pageAction | String | Yes | アクション種別（"gbedit"） | 固定値チェック |
| ac | String | Yes | アクション（approve/delete/edit） | 固定値チェック |
| sKey | String | Yes | 投稿の一意キー | 存在確認 |
| redPage | String | No | リダイレクト先ページID | 暗号化値 |

### 入力データソース

- POSTリクエスト: 投稿フォームからの入力値
- QueryStringリクエスト: 管理操作パラメータ
- セッション: CAPTCHA検証用の値

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ゲストブックHTML | String | 投稿一覧とフォームのHTML |

### 出力先

画面表示、データベース登録、メール送信（管理者通知）

## 処理フロー

### 処理シーケンス（投稿時）

```
1. フォーム送信チェック
   └─ postbackGB=trueの場合、投稿処理を実行

2. CAPTCHA検証
   └─ セッションのcaptcha値と入力値を比較

3. 入力値検証
   └─ 投稿者名、メッセージの必須チェック
   └─ HTMLリンク禁止チェック

4. IPブロックチェック
   └─ ブロックリストに含まれるIPは投稿不可

5. 投稿保存
   └─ 一意キー生成
   └─ tblGuestbookItemにINSERT
   └─ bApproved=承認設定に従う（bRequireValidation）

6. 管理者通知メール送信
   └─ 承認・削除・編集リンクを含むメール

7. 投稿完了表示
   └─ セッションに投稿IDを記録（自分の投稿を表示するため）
```

### 処理シーケンス（管理操作時）

```
1. アクション判定
   └─ pageAction="gbedit"でルーティング

2. 投稿検索
   └─ sKeyで投稿を検索

3. アクション実行
   ├─ approve: bApproved=trueに更新
   ├─ delete: 投稿を削除
   └─ edit: 管理画面へリダイレクト

4. リダイレクト
   └─ 成功メッセージ付きでページへリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{投稿?}
    B -->|Yes| C[CAPTCHA検証]
    B -->|No| D{管理操作?}
    C --> E{CAPTCHA OK?}
    E -->|No| F[エラー表示]
    E -->|Yes| G[入力検証]
    G --> H{検証OK?}
    H -->|No| F
    H -->|Yes| I[IPブロックチェック]
    I --> J{ブロック?}
    J -->|Yes| K[処理終了]
    J -->|No| L[投稿保存]
    L --> M[管理者通知]
    M --> N[完了表示]
    D -->|Yes| O[投稿検索]
    D -->|No| P[一覧表示]
    O --> Q{アクション?}
    Q -->|approve| R[承認更新]
    Q -->|delete| S[投稿削除]
    Q -->|edit| T[管理画面へ]
    R --> U[リダイレクト]
    S --> U
    N --> V[終了]
    F --> V
    K --> V
    P --> V
    T --> V
    U --> V
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-1001 | 承認制 | bRequireValidation=trueの場合、管理者承認後に公開 | 設定に応じて |
| BR-1002 | HTMLリンク禁止 | メッセージ内に"href="を含む投稿は拒否 | 投稿時 |
| BR-1003 | IPブロック | sBlockIPに含まれるIPからの投稿を拒否 | 投稿時 |
| BR-1004 | 一意キー | 各投稿に16文字の一意キーを発行 | 投稿時 |
| BR-1005 | 公開期間 | dOnlineFrom〜dOnlineUntilの期間内のみ投稿可 | 設定に応じて |

### 計算ロジック

- キー生成: `sKey = GeneratePassWord() & GeneratePassWord()` （16文字のランダム文字列）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 投稿登録 | tblGuestbookItem | INSERT | 新規投稿を登録 |
| 承認更新 | tblGuestbookItem | UPDATE | bApproved=trueに更新 |
| 投稿削除 | tblGuestbookItem | DELETE | 投稿を削除 |
| 投稿検索 | tblGuestbookItem | SELECT | キーで投稿を検索 |

### テーブル別操作詳細

#### tblGuestbookItem

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sValue, sMessageBy, sMessageByEmail, iGuestBookID, bApproved, sKey, ip, dCreatedTS | 投稿情報 | 新規投稿 |
| UPDATE | bApproved | true | 承認処理 |
| DELETE | - | iIdで削除 | 削除処理 |
| SELECT | * | sKeyで検索 | キー検索 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_captcha | CAPTCHAエラー | CAPTCHA不一致 | エラーメッセージ表示 |
| err_mandatory | 必須エラー | 必須フィールド未入力 | エラーメッセージ表示 |
| - | 投稿拒否 | HTMLリンク含む | 投稿処理スキップ |
| - | 投稿拒否 | IPブロック | 投稿処理スキップ |

### リトライ仕様

エラー修正後に再投稿可能。

## トランザクション仕様

投稿保存は単一INSERT文で実行。

## パフォーマンス要件

- ページング機能（iPaging設定）で1ページあたりの表示件数を制限
- 大量投稿時の表示負荷に注意

## セキュリティ考慮事項

- CAPTCHA認証によるボット対策
- HTMLリンク禁止によるスパム対策
- IPブロック機能
- encrypt関数によるIDの暗号化
- sanitize関数による出力エスケープ
- 一意キーによる管理操作の認証

## 備考

- スマイリー（絵文字）機能をサポート
- 管理者返信機能（sReply）をサポート
- テンプレートによる表示カスタマイズ可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ゲストブックとアイテムを管理するクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | guestbook.asp | `asp/includes/guestbook.asp` | cls_guestbookクラス、build()メソッド |
| 1-2 | guestbookitem.asp | `asp/includes/guestbookitem.asp` | cls_guestbookitemクラス、save()メソッド |

**読解のコツ**: cls_guestbook.build()がゲストブック全体のHTML生成。投稿処理もこのメソッド内で実行される。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process.asp | `asp/process.asp` | pageAction="gbedit"時の処理（107-128行目） |

**主要処理フロー**:
1. **107行目**: `case "gbedit"` - ゲストブック編集アクションの分岐
2. **109-115行目**: approve処理
3. **116-121行目**: delete処理
4. **122-127行目**: edit処理（管理画面へリダイレクト）

#### Step 3: 投稿処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | guestbook.asp | `asp/includes/guestbook.asp` | build()内の投稿処理（159-214行目） |
| 3-2 | guestbookitem.asp | `asp/includes/guestbookitem.asp` | save()メソッド（83-138行目） |

**主要処理フロー**:
- **173-175行目**: CAPTCHA検証
- **183-204行目**: 投稿保存処理
- **96-122行目**: 管理者通知メール送信（guestbookitem.asp内）

### プログラム呼び出し階層図

```
process.asp (エントリーポイント)
    │
    ├─ gbedit (管理操作)
    │      ├─ approve → cls_guestbookitem.approve()
    │      ├─ delete → cls_guestbookitem.remove()
    │      └─ edit → 管理画面リダイレクト
    │
    └─ ページ表示時
           │
           └─ cls_guestbook.build()
                  │
                  ├─ CAPTCHA検証
                  │
                  ├─ cls_guestbookitem.save()
                  │      ├─ check() - バリデーション
                  │      ├─ IPブロックチェック
                  │      ├─ INSERT tblGuestbookItem
                  │      └─ 管理者通知メール
                  │
                  └─ 投稿一覧HTML生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

投稿フォーム ───▶ cls_guestbook.build() ──▶ HTML
       │                │
       ▼                ▼
CAPTCHA検証 ────▶ cls_guestbookitem.save()
       │                │
       ▼                ▼
tblGuestbookItem ◀── INSERT ──────────▶ 保存結果
                        │
                        ▼
                 管理者通知メール

管理操作 ──────▶ approve/delete/edit ──▶ リダイレクト
       │
       ▼
sKey検索 ───────▶ UPDATE/DELETE
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| guestbook.asp | `asp/includes/guestbook.asp` | ソース | ゲストブッククラス定義 |
| guestbookitem.asp | `asp/includes/guestbookitem.asp` | ソース | ゲストブックアイテムクラス |
| process.asp | `asp/process.asp` | ソース | ページアクションルーター |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
| database.asp | `asp/includes/database.asp` | ソース | データベース接続クラス |
| functions.asp | `asp/includes/functions.asp` | ソース | 共通関数（sanitize等） |
