# 機能設計書 111-フォーム送信

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントエンド「フォーム送信」機能の設計仕様を定義する。

### 本機能の処理概要

お問い合わせフォーム等の送信処理を行うフロントエンド機能である。ユーザーが入力したフォームデータを検証し、データベースへ保存するとともに、管理者へのメール通知や自動応答メール送信を行う。

**業務上の目的・背景**：ウェブサイト訪問者からの問い合わせ、資料請求、申し込みなど様々な情報収集を実現するために、フォーム送信機能は不可欠である。フォームビルダーで作成した動的フォームをフロントエンドで表示・処理することで、コーディング不要でフォーム機能を提供できる。

**機能の利用シーン**：
- サイト訪問者がお問い合わせフォームから問い合わせを送信する場面
- 資料請求フォームからダウンロード資料を申し込む場面
- イベント参加申込フォームから参加登録を行う場面
- カタログアイテムに対する問い合わせを送信する場面

**主要な処理内容**：
1. フォームフィールドの動的レンダリング（テキスト、メール、URL、テキストエリア、チェックボックス、セレクト、ラジオボタン、日付、ファイル、画像など）
2. 入力値のバリデーション（必須チェック、メール形式チェック、ファイルサイズチェック、ファイルタイプチェック）
3. CAPTCHA認証による不正送信防止
4. CSRF対策によるセキュリティ保護
5. 送信データのデータベース保存（tblFormSubmission、tblFormFieldValue）
6. 管理者への通知メール送信（添付ファイル対応）
7. 自動応答メール送信（オプション）
8. カスタムスクリプト実行（オプション）
9. フィードバック表示またはリダイレクト

**関連システム・外部連携**：
- メール送信システム（cls_mail_message）
- ファイルアップロードシステム（FreeASPUpload）
- CAPTCHA認証システム（captcha.asp）

**権限による制御**：特になし（公開フォームは誰でも送信可能）。ただし、イントラネット用フォームは会員認証が必要な場合がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 166 | メール送信処理 | 主機能 | フォームからのメール送信処理 |

## 機能種別

データ入力・送信処理 / メール通知 / バリデーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iFormID | String | Yes | フォームID（暗号化） | 復号後に数値チェック |
| postBack | Boolean | Yes | ポストバックフラグ | true/false |
| QSSEC | String | Yes | CSRFトークン | セッショントークンと一致確認 |
| captcha | String | Conditional | CAPTCHA入力値 | フォーム設定でCAPTCHA有効時に必須、セッション値と一致確認 |
| [fieldID] | Mixed | Varies | 各フォームフィールドの値 | フィールド設定に応じた検証 |
| your message | String | No | ハニーポット（スパム対策） | 空であること |

### 入力データソース

- フォーム画面からのPOSTリクエスト（multipart/form-data）
- セッション（CAPTCHA検証用、CSRFトークン）
- データベース（フォーム定義、フィールド定義）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| submission.iId | Integer | 送信データID |
| フィードバックメッセージ | String | 送信完了メッセージ |
| リダイレクト | - | 設定されたリダイレクト先への遷移 |
| 通知メール | - | 管理者への通知メール |
| 自動応答メール | - | 送信者への自動応答メール |

### 出力先

- データベース（tblFormSubmission、tblFormFieldValue）
- 画面（フィードバックメッセージ）
- メール（管理者通知、自動応答）
- リダイレクト先ページ

## 処理フロー

### 処理シーケンス

```
1. フォーム表示（初回アクセス）
   └─ フォーム定義をDBから取得し、フィールドを動的生成
2. フォーム送信（postBack=true）
   ├─ ハニーポットチェック（スパム判定）
   ├─ CSRF検証
   ├─ フォーム定義取得
   ├─ CAPTCHA検証（設定時）
   ├─ フィールドバリデーション
   │   ├─ 必須チェック
   │   ├─ メール形式チェック
   │   ├─ ファイルサイズチェック
   │   └─ ファイルタイプチェック
   └─ バリデーション結果分岐
       ├─ エラーあり → エラーメッセージ表示、フォーム再表示
       └─ エラーなし → 送信処理
           ├─ 送信データ保存（tblFormSubmission）
           ├─ フィールド値保存（tblFormFieldValue）
           ├─ アップロードファイル保存
           ├─ カスタムスクリプト実行（設定時）
           ├─ 管理者通知メール送信（設定時）
           ├─ 自動応答メール送信（設定時）
           └─ フィードバック表示 or リダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[フォームアクセス] --> B{postBack?}
    B -->|No| C[フォーム表示]
    B -->|Yes| D{ハニーポット<br>チェック}
    D -->|NG| E[処理終了]
    D -->|OK| F[CSRF検証]
    F --> G{CAPTCHA<br>有効?}
    G -->|Yes| H{CAPTCHA<br>検証}
    G -->|No| I[フィールド検証]
    H -->|NG| J[エラー追加]
    H -->|OK| I
    I --> K{バリデーション<br>結果}
    J --> K
    K -->|エラーあり| L[エラー表示<br>フォーム再表示]
    K -->|OK| M[送信データ保存]
    M --> N[フィールド値保存]
    N --> O{スクリプト<br>設定?}
    O -->|Yes| P[スクリプト実行]
    O -->|No| Q{メール通知<br>設定?}
    P --> Q
    Q -->|Yes| R[管理者メール送信]
    Q -->|No| S{自動応答<br>設定?}
    R --> S
    S -->|Yes| T[自動応答メール送信]
    S -->|No| U{リダイレクト<br>設定?}
    T --> U
    U -->|Yes| V[リダイレクト]
    U -->|No| W[フィードバック表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-111-01 | 必須フィールド検証 | bMandatory=trueのフィールドは入力必須 | 全てのフォーム送信時 |
| BR-111-02 | メール形式検証 | sb_ff_email型フィールドはメールアドレス形式必須 | メールフィールド入力時 |
| BR-111-03 | ファイルサイズ制限 | iMaxFileSizeを超えるファイルは拒否 | ファイルアップロード時 |
| BR-111-04 | ファイルタイプ制限 | 許可拡張子リストにないファイルは拒否 | ファイルアップロード時 |
| BR-111-05 | CAPTCHA必須 | bCaptcha=trueの場合、正しいCAPTCHA入力必須 | CAPTCHA有効フォーム |
| BR-111-06 | フィードバック/リダイレクト排他 | sFeedbackまたはsRedirectのいずれか一方を設定 | フォーム定義時 |

### 計算ロジック

- ファイルサイズ検証: `file.length > cFields(fFieldKey).iMaxFileSize * 1010` （1010倍でマージン含む）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 送信データ登録 | tblFormSubmission | INSERT | フォーム送信メタデータ保存 |
| フィールド値登録 | tblFormFieldValue | INSERT | 各フィールドの入力値保存 |
| フォーム情報取得 | tblForm | SELECT | フォーム定義取得 |
| フィールド情報取得 | tblFormField | SELECT | フィールド定義取得 |

### テーブル別操作詳細

#### tblFormSubmission

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iFormID | フォームID | - |
| INSERT | iItemID | カタログアイテムID（オプション） | カタログフォームの場合 |
| INSERT | dCreatedTS | now() | 送信日時 |
| INSERT | sVisitorDetails | getVisitorDetails | 訪問者情報 |

#### tblFormFieldValue

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iFormFieldId | フィールドID | - |
| INSERT | iSubmissionId | 送信データID | - |
| INSERT | sValue | 入力値/ファイル名 | ファイルの場合はファイル名 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | バリデーション | 必須フィールド未入力 | フィールド入力を促す |
| err_email | バリデーション | メール形式不正 | 正しいメールアドレス入力を促す |
| err_fileSize | バリデーション | ファイルサイズ超過 | より小さいファイルでの再送信を促す |
| err_fileType | バリデーション | 許可されていないファイル形式 | 許可形式での再送信を促す |
| err_JPGGIF_file | バリデーション | 画像ファイル形式不正 | JPG/GIF形式での再送信を促す |
| err_captcha | バリデーション | CAPTCHA不一致 | 再度CAPTCHA入力を促す |

### リトライ仕様

エラー発生時はフォームを再表示し、入力済み値を保持した状態でユーザーに再入力を促す。

## トランザクション仕様

各INSERTは個別に実行される。送信データ保存とフィールド値保存は連続して実行され、途中でエラーが発生した場合は部分的なデータが残る可能性がある。

## パフォーマンス要件

- フォーム送信処理: 3秒以内
- ファイルアップロード: ファイルサイズに応じて変動（上限は管理者設定による）

## セキュリティ考慮事項

1. **CSRF対策**: QS_secCodeHiddenによるCSRFトークン検証
2. **CAPTCHA認証**: スパム送信防止
3. **ハニーポット**: 「your message」フィールドによるボット検知
4. **入力サニタイズ**: sanitize()関数によるXSS対策
5. **ファイルタイプ制限**: 許可されたファイル拡張子のみアップロード可能
6. **ファイルサイズ制限**: DoS攻撃防止

## 備考

- フォーム定義は管理画面（bs_formEdit.asp）で設定
- 送信データは管理画面（bs_formExport.asp）で確認可能
- Excel出力機能あり（bs_formExcel.asp）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォームクラスと関連テーブル構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form.asp | `asp/includes/form.asp` | cls_formクラスの構造、プロパティ定義を確認 |

**読解のコツ**: ASPのクラス構文に注意。`Public`プロパティがフォーム属性、`Public Function`がメソッドを定義。

#### Step 2: エントリーポイントを理解する

フロントエンドからのフォーム送信処理の起点を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process.asp | `asp/process.asp` | pageAction分岐処理、フォーム処理への遷移 |

**主要処理フロー**:
1. **40-50行目**: pageActionのswitch分岐
2. **240-243行目**: フォーム表示呼び出し（selectedPage.form.build）

#### Step 3: フォーム処理を理解する

フォームの表示と送信処理のメインロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | form.asp | `asp/includes/form.asp` | build関数（250-805行目）がフォーム表示・送信処理の中核 |

**主要処理フロー**:
- **269-275行目**: ハニーポットチェック、CSRF検証
- **285-295行目**: CAPTCHA検証
- **296-373行目**: フィールドバリデーションループ
- **374-560行目**: 送信処理（DB保存、メール送信）
- **565-787行目**: フォームHTML生成

#### Step 4: セキュリティ機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | functions.asp | `asp/includes/functions.asp` | CSRF対策関数（1613-1628行目） |
| 4-2 | captcha.asp | `asp/includes/captcha.asp` | CAPTCHA画像生成処理 |

### プログラム呼び出し階層図

```
default.asp
    │
    ├─ asp/begin.asp (初期化)
    │
    ├─ asp/process.asp
    │      │
    │      └─ selectedPage.form.build()
    │             │
    │             ├─ cls_form.pick() ... フォーム定義取得
    │             │
    │             ├─ cls_form.fields ... フィールド定義取得
    │             │
    │             ├─ FreeASPUpload.Save() ... ファイルアップロード
    │             │
    │             ├─ checkCSRF_Upload() ... CSRF検証
    │             │
    │             ├─ cls_submission.save() ... 送信データ保存
    │             │
    │             └─ cls_mail_message.send() ... メール送信
    │
    └─ asp/includes/form.asp (cls_form)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

POSTデータ ─────────────> FreeASPUpload.Save() ─────> 一時ファイル保存
(フィールド値)              │
                          v
セッション ─────────────> checkCSRF_Upload() ─────────> CSRF検証結果
(CSRFトークン)             │
                          v
セッション ─────────────> CAPTCHA検証 ─────────────────> 検証結果
(CAPTCHA値)                │
                          v
                    バリデーション ────────────────> エラーメッセージ
                          │
                          v
                    cls_submission.save() ─────────> tblFormSubmission
                          │
                          v
                    フィールド値保存 ─────────────> tblFormFieldValue
                          │
                          v
                    cls_mail_message.send() ─────> 管理者メール
                          │                        自動応答メール
                          v
                    フィードバック/リダイレクト ──> ユーザー画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| form.asp | `asp/includes/form.asp` | ソース | フォームクラス定義、表示・送信処理 |
| process.asp | `asp/process.asp` | ソース | フロントエンド処理分岐 |
| functions.asp | `asp/includes/functions.asp` | ソース | CSRF対策、sanitize等のユーティリティ |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
| submission.asp | `asp/includes/submission.asp` | ソース | 送信データクラス |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス |
| formField.asp | `asp/includes/formField.asp` | ソース | フォームフィールドクラス |
| freeASPUpload.asp | `asp/includes/freeASPUpload.asp` | ソース | ファイルアップロード処理 |
