# 機能設計書 112-ページメール送信

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントエンド「ページメール送信」機能の設計仕様を定義する。

### 本機能の処理概要

ウェブサイトのページ内容を指定したメールアドレスに送信する機能である。訪問者がページの情報を他の人と共有したい場合に、ページのコンテンツをメールで送信できる。

**業務上の目的・背景**：ウェブサイトの情報を簡単に共有できる手段を提供することで、コンテンツの拡散やユーザー間の情報共有を促進する。ソーシャルメディア共有とは別のアプローチとして、メールによる直接的な情報共有を可能にする。

**機能の利用シーン**：
- 商品ページの情報を知人に共有する場面
- ニュース記事を同僚に転送する場面
- イベント情報を友人に知らせる場面
- 企業情報を取引先に送信する場面

**主要な処理内容**：
1. メール送信フォームの表示
2. CAPTCHA認証によるスパム防止
3. CSRF対策によるセキュリティ保護
4. メールアドレス形式の検証
5. ページタイトルとコンテンツを含むHTMLメールの生成
6. メール送信処理
7. 送信完了メッセージの表示

**関連システム・外部連携**：
- メール送信システム（cls_mail_message）
- CAPTCHA認証システム（captcha.asp）
- ページ処理システム（process.asp）

**権限による制御**：特になし（公開ページは誰でもメール送信可能）。ただし、パスワード保護ページやイントラネットページは認証後のみ利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 160 | メールページ | 主機能 | ページ内容を指定メールアドレスに送信 |

## 機能種別

メール送信処理 / コンテンツ共有

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iId | String | Yes | ページID（暗号化） | 復号後に数値チェック |
| btnAction | String | Yes | アクション種別 | "sendPage" |
| sEmail | String | Yes | 送信先メールアドレス | メールアドレス形式チェック |
| CAPTCHA | String | Yes | CAPTCHA入力値 | セッション値の先頭4文字と一致確認（大文字小文字区別なし） |
| QSSEC | String | Yes | CSRFトークン | セッショントークンと一致確認 |

### 入力データソース

- フォーム画面からのPOSTリクエスト
- セッション（CAPTCHA検証用、CSRFトークン、メールアドレス履歴）
- データベース（ページ情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 送信完了メッセージ | String | "pageIsSent"ラベルの表示 |
| メール | HTMLメール | ページタイトルとコンテンツを含むHTMLメール |

### 出力先

- 画面（送信フォームまたは完了メッセージ）
- メール（指定されたメールアドレス）
- セッション（メールアドレス保存）

## 処理フロー

### 処理シーケンス

```
1. mailPage.aspアクセス
   └─ begin.asp、process.aspインクルード（ページ情報取得）
2. アクション判定
   ├─ btnAction != "sendPage" → メール送信フォーム表示
   │   ├─ ページタイトル表示
   │   ├─ メールアドレス入力欄（セッションから前回値復元）
   │   ├─ CAPTCHA画像・入力欄表示
   │   └─ 送信ボタン
   └─ btnAction == "sendPage" → 送信処理
       ├─ CSRF検証（checkCSRF）
       ├─ CAPTCHA検証
       │   └─ 不一致 → エラー "err_captcha"
       ├─ メールアドレス検証
       │   └─ 形式不正 → エラー "err_email"
       ├─ メールアドレスをセッションに保存
       └─ エラーなし → メール送信
           ├─ メール本文生成（HTML形式）
           │   ├─ ヘッダー（タイトル、CSS）
           │   ├─ ボディ（ページタイトル、コンテンツ）
           │   └─ フッター
           ├─ cls_mail_message使用
           │   ├─ receiver: 入力メールアドレス
           │   ├─ subject: ページタイトル + " on " + サイトURL
           │   └─ body: 生成したHTML
           ├─ メール送信
           └─ 完了メッセージ表示
```

### フローチャート

```mermaid
flowchart TD
    A[mailPage.aspアクセス] --> B{btnAction=<br>sendPage?}
    B -->|No| C[送信フォーム表示]
    B -->|Yes| D[CSRF検証]
    D --> E{CAPTCHA<br>検証}
    E -->|NG| F[err_captcha追加]
    E -->|OK| G{メールアドレス<br>検証}
    F --> G
    G -->|NG| H[err_email追加]
    G -->|OK| I{エラー<br>あり?}
    H --> I
    I -->|Yes| C
    I -->|No| J[メール本文生成]
    J --> K[cls_mail_message<br>送信]
    K --> L[完了メッセージ表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-112-01 | CAPTCHA必須 | 4文字のCAPTCHA入力が必須（大文字小文字区別なし） | 全てのメール送信 |
| BR-112-02 | メール形式検証 | 有効なメールアドレス形式が必須 | 全てのメール送信 |
| BR-112-03 | セッション保存 | 入力メールアドレスをセッションに保存 | 送信処理時 |
| BR-112-04 | HTML形式メール | ページコンテンツをHTML形式で送信 | 全てのメール送信 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ情報取得 | tblPage | SELECT | 送信対象ページの情報取得 |

### テーブル別操作詳細

#### tblPage（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sTitle | ページタイトル取得 | メール件名に使用 |
| SELECT | sValue | ページコンテンツ取得 | メール本文に使用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_captcha | バリデーション | CAPTCHA入力値がセッション値と不一致、または空 | 正しいCAPTCHA入力を促す |
| err_email | バリデーション | メールアドレス形式不正 | 正しいメールアドレス入力を促す |

### リトライ仕様

エラー発生時はフォームを再表示し、ユーザーに再入力を促す。前回入力したメールアドレスはセッションから復元される。

## トランザクション仕様

データベース更新を伴わないため、トランザクション管理は不要。

## パフォーマンス要件

- メール送信処理: 5秒以内

## セキュリティ考慮事項

1. **CSRF対策**: checkCSRF()関数によるCSRFトークン検証
2. **CAPTCHA認証**: スパムメール送信防止
3. **入力検証**: メールアドレス形式チェック
4. **HTMLエスケープ**: quotRep()関数によるXSS対策

## 備考

- ポップアップウィンドウとして開かれることを想定（window.focus()、window.close()使用）
- pagetoemailbody変数が設定されている場合はカスタム本文を使用可能
- CSSはcss()関数で取得したスタイルシートを含む

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページ情報とメール送信に必要なデータ構造を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mailPage.asp | `mailPage.asp` | 使用変数（mailSent、trimEmail、mailBody等）を確認 |

**読解のコツ**: ASP Classicの変数スコープに注意。dimで宣言された変数はページ全体で有効。

#### Step 2: エントリーポイントを理解する

メール送信ページの起点を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mailPage.asp | `mailPage.asp` | インクルードファイルとページ処理の流れ |

**主要処理フロー**:
1. **1-3行目**: begin.asp、process.aspのインクルード
2. **11行目**: sApplication空チェック（アプリケーションページは処理終了）
3. **17行目**: btnAction="sendPage"の判定で送信処理分岐

#### Step 3: 送信処理を理解する

メール送信のメインロジック。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mailPage.asp | `mailPage.asp` | 17-51行目の送信処理ロジック |

**主要処理フロー**:
- **17行目**: btnAction判定
- **18行目**: メールアドレスのtrim処理
- **19行目**: CSRF検証（checkCSRF()）
- **20行目**: メールアドレスをセッションに保存
- **22行目**: CAPTCHA検証
- **25-27行目**: メールアドレス形式検証
- **29-41行目**: メール本文生成
- **42-48行目**: cls_mail_message使用してメール送信

#### Step 4: 関連機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | functions.asp | `asp/includes/functions.asp` | checkCSRF()、CheckEmailSyntax()関数 |
| 4-2 | captcha.asp | `asp/includes/captcha.asp` | CAPTCHA画像生成とセッション保存 |
| 4-3 | mail_message.asp | `asp/includes/mail_message.asp` | cls_mail_messageクラス |

### プログラム呼び出し階層図

```
mailPage.asp
    │
    ├─ asp/begin.asp (初期化)
    │
    ├─ asp/process.asp (ページ情報取得)
    │      │
    │      └─ selectedPage ... ページオブジェクト
    │
    ├─ checkCSRF() ... CSRF検証
    │
    ├─ CheckEmailSyntax() ... メール形式検証
    │
    ├─ css() ... CSSスタイル取得
    │
    ├─ selectedPage.replaceBlocks() ... ブロック置換
    │
    └─ cls_mail_message ... メール送信
           ├─ receiver ... 送信先設定
           ├─ subject ... 件名設定
           ├─ body ... 本文設定
           └─ send() ... 送信実行
```

### データフロー図

```
[入力]                      [処理]                           [出力]

フォーム送信 ────────────> checkCSRF() ────────────────> CSRF検証結果
(sEmail, CAPTCHA)          │
                          v
セッション ─────────────> CAPTCHA検証 ─────────────────> 検証結果
(CAPTCHA値)                │
                          v
                    CheckEmailSyntax() ──────────────> メール形式検証
                          │
                          v
ページ情報 ─────────────> メール本文生成 ─────────────> HTMLメール本文
(pageTitle, pageBody)      │
                          v
                    cls_mail_message.send() ─────────> 送信先メール
                          │
                          v
                    完了メッセージ表示 ───────────────> ユーザー画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mailPage.asp | `mailPage.asp` | ソース | メール送信メイン処理 |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| process.asp | `asp/process.asp` | ソース | ページ情報取得 |
| functions.asp | `asp/includes/functions.asp` | ソース | CSRF検証、メール形式検証 |
| captcha.asp | `asp/includes/captcha.asp` | ソース | CAPTCHA画像生成 |
| mail_message.asp | `asp/includes/mail_message.asp` | ソース | メール送信クラス |
| messages.asp | `asp/includes/messages.asp` | ソース | エラーメッセージ管理 |
