# 機能設計書 113-ページ印刷

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントエンド「ページ印刷」機能の設計仕様を定義する。

### 本機能の処理概要

印刷用レイアウトでのページ表示を行うフロントエンド機能である。通常のテンプレートを使用せず、シンプルな印刷向けレイアウトでページのタイトルとコンテンツを表示し、自動的に印刷ダイアログを開く。

**業務上の目的・背景**：ウェブサイトのコンテンツを紙に印刷して保存・配布したいというユーザーニーズに応える。通常のページレイアウト（ナビゲーション、サイドバー等）を除去した印刷専用表示を提供することで、インク消費を抑え、必要な情報のみを印刷できる。

**機能の利用シーン**：
- 製品情報を紙で保管したい場面
- 会議資料としてページ内容を印刷する場面
- 手続き案内やマニュアルを印刷する場面
- 記事やニュースを印刷して読む場面

**主要な処理内容**：
1. 印刷ページへのアクセス
2. ページ情報の取得（process.asp経由）
3. 印刷用シンプルレイアウトの生成
4. 定数の展開（treatConstants）
5. ブロック置換（replaceBlocks）
6. 印刷ダイアログの自動起動

**関連システム・外部連携**：
- ページ処理システム（process.asp）
- 定数処理システム（treatConstants関数）

**権限による制御**：特になし（公開ページは誰でも印刷可能）。ただし、パスワード保護ページやイントラネットページは認証後のみ利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 161 | 印刷ページ | 主機能 | 印刷用レイアウトでのページ表示 |

## 機能種別

表示処理 / コンテンツ出力

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iId | String | Yes | ページID（暗号化） | 復号後に数値チェック |

### 入力データソース

- URLパラメータ（ページID）
- データベース（ページ情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTML | String | 印刷用レイアウトのHTMLページ |

### 出力先

- ブラウザ（HTMLレンダリング）
- 印刷ダイアログ（JavaScript経由）

## 処理フロー

### 処理シーケンス

```
1. printPage.aspアクセス
   └─ begin.asp、process.aspインクルード
2. ページ情報取得
   └─ selectedPageオブジェクトからタイトル・コンテンツ取得
3. HTML生成
   ├─ DOCTYPE宣言（XHTML 1.0 Transitional）
   ├─ <head>セクション
   │   ├─ <title>タグ（ページタイトル）
   │   ├─ Content-Type META（文字コード）
   │   ├─ CSSリンク（qs_[tdir].css）
   │   └─ sorttable.jsスクリプト
   └─ <body>セクション
       ├─ onload: window.focus(); window.print();
       ├─ <b>タグ（ページタイトル）
       ├─ <hr />区切り線
       └─ ページコンテンツ（pageBody）
4. 定数・ブロック置換処理
   ├─ treatConstants（定数展開）
   └─ replaceBlocks（ブロック置換）
5. クリーンアップ処理
   └─ cleanUPASP()
```

### フローチャート

```mermaid
flowchart TD
    A[printPage.aspアクセス] --> B[begin.asp/process.asp<br>インクルード]
    B --> C[ページ情報取得]
    C --> D[HTML<head>生成]
    D --> E[HTML<body>生成]
    E --> F[ページタイトル出力]
    F --> G[ページコンテンツ出力]
    G --> H[treatConstants<br>定数展開]
    H --> I[replaceBlocks<br>ブロック置換]
    I --> J[印刷ダイアログ表示<br>window.print]
    J --> K[cleanUPASP<br>クリーンアップ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-113-01 | 自動印刷ダイアログ | ページ読込完了時に自動的に印刷ダイアログを表示 | 全ての印刷ページアクセス |
| BR-113-02 | シンプルレイアウト | ナビゲーションやサイドバーを含まないシンプルなレイアウト | 全ての印刷ページ |
| BR-113-03 | 定数展開 | ページコンテンツ内の定数を実際の値に展開 | コンテンツ出力時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ情報取得 | tblPage | SELECT | 印刷対象ページの情報取得（process.asp経由） |

### テーブル別操作詳細

#### tblPage（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | showTitle | ページタイトル取得 | <title>タグと本文見出しに使用 |
| SELECT | sValue | ページコンテンツ取得 | 本文出力に使用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ページ未検出 | 指定IDのページが存在しない | ホームページへリダイレクト（process.asp経由） |
| - | アプリケーションページ | sApplicationが設定されている | Response.Endで処理終了 |

### リトライ仕様

特になし

## トランザクション仕様

データベース更新を伴わないため、トランザクション管理は不要。

## パフォーマンス要件

- ページ表示処理: 2秒以内

## セキュリティ考慮事項

1. **XSS対策**: treatConstants関数によるエスケープ処理
2. **アクセス制御**: パスワード保護ページは認証が必要（process.asp経由）

## 備考

- printReplies=trueを設定することでprocess.aspの出力をテンプレートレンダリングせずに使用
- XHTML 1.0 Transitional準拠
- sorttable.jsによるテーブルソート機能対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

印刷ページで使用されるデータ構造を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | printPage.asp | `printPage.asp` | 使用変数（printReplies、selectedPage、pageTitle、pageBody）を確認 |

**読解のコツ**: printReplies=trueの設定により、process.aspでテンプレートレンダリングをスキップする動作を理解することが重要。

#### Step 2: エントリーポイントを理解する

印刷ページの起点を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printPage.asp | `printPage.asp` | 14行という非常にコンパクトなファイル全体 |

**主要処理フロー**:
1. **1行目**: begin.asp、process.aspのインクルード（printReplies=trueを先に設定）
2. **4-8行目**: HTMLヘッダー生成（title、meta、css、script）
3. **8行目**: sApplicationチェック（アプリケーションページは終了）
4. **10行目**: onload="window.focus();window.print();"で自動印刷
5. **11行目**: タイトルとコンテンツ出力（treatConstants、replaceBlocks適用）

#### Step 3: 関連処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process.asp | `asp/process.asp` | printReplies変数による分岐処理（278-280行目付近） |
| 3-2 | functions.asp | `asp/includes/functions.asp` | treatConstants関数 |

### プログラム呼び出し階層図

```
printPage.asp
    │
    ├─ printReplies = true (フラグ設定)
    │
    ├─ asp/begin.asp (初期化)
    │
    ├─ asp/process.asp (ページ情報取得)
    │      │
    │      └─ selectedPage ... ページオブジェクト
    │             ├─ showTitle ... タイトル
    │             └─ replaceBlocks() ... ブロック置換
    │
    ├─ treatConstants() ... 定数展開
    │
    ├─ window.print() ... ブラウザ印刷ダイアログ
    │
    └─ cleanUPASP() ... クリーンアップ
```

### データフロー図

```
[入力]                      [処理]                           [出力]

URLパラメータ ──────────> process.asp ───────────────> ページオブジェクト
(iId)                      │
                          v
ページ情報 ─────────────> replaceBlocks() ────────────> ブロック置換済み
(selectedPage)             │                             コンテンツ
                          v
                    treatConstants() ────────────────> 定数展開済み
                          │                             コンテンツ
                          v
                    HTML生成 ────────────────────────> 印刷用HTML
                          │
                          v
                    window.print() ──────────────────> 印刷ダイアログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printPage.asp | `printPage.asp` | ソース | 印刷ページメイン処理 |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| process.asp | `asp/process.asp` | ソース | ページ情報取得 |
| functions.asp | `asp/includes/functions.asp` | ソース | treatConstants等のユーティリティ |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス（replaceBlocks） |
| qs_ltr.css | `QuickerSite/css/qs_ltr.css` | CSS | 印刷ページスタイル（LTR） |
| qs_rtl.css | `QuickerSite/css/qs_rtl.css` | CSS | 印刷ページスタイル（RTL） |
| sorttable.js | `QuickerSite/js/sorttable.js` | JavaScript | テーブルソート機能 |
