# 機能設計書 114-RSSフィード出力

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントエンド「RSSフィード出力」機能の設計仕様を定義する。

### 本機能の処理概要

サイト全体またはページ単位のRSSフィード（RSS 2.0形式）を生成・配信する機能である。RSSリーダーやニュースアグリゲーターからの購読を可能にし、サイトの更新情報を自動的に配信する。

**業務上の目的・背景**：サイトの更新情報を自動的に配信することで、訪問者が定期的にサイトを訪問しなくても新着情報を受け取れる仕組みを提供する。ブログ、ニュースサイト、企業サイトなど幅広い用途で利用される標準的なWeb技術である。

**機能の利用シーン**：
- ニュースサイトの最新記事を配信する場面
- ブログの新着投稿を購読者に届ける場面
- 商品カタログの新商品情報を配信する場面
- フォーラムの新規投稿を配信する場面

**主要な処理内容**：
1. サイト全体RSS配信（bEnableMainRSS有効時）
2. リストページのRSS配信（bPushRSS有効時）
3. フォーラム/テーマのRSS配信
4. カタログのRSS配信
5. RSS 2.0形式XMLの生成
6. 結果のキャッシュ（Application変数使用）
7. RSSアクセス統計記録

**関連システム・外部連携**：
- RSSリーダー/ニュースアグリゲーター
- 検索エンジンのフィードクローラー

**権限による制御**：イントラネットページのRSSは認証後のみアクセス可能。未認証の場合は「No Access」を返す。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 162 | RSS | 主機能 | サイト・ページのRSSフィード生成 |

## 機能種別

XML生成・配信処理 / シンジケーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iId | String | No | ページID（暗号化）。未指定時はサイト全体RSS | 復号後に数値チェック |
| viewtype | String | No | 表示タイプ（キャッシュキーに使用） | - |

### 入力データソース

- URLパラメータ（ページID）
- データベース（ページ情報、リストアイテム、フォーラム投稿、カタログアイテム）
- Application変数（キャッシュ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| XML | String | RSS 2.0形式のXMLドキュメント |

### 出力先

- HTTPレスポンス（Content-Type: application/xml）

### RSS構造

```xml
<?xml version="1.0" encoding="UTF-8"?>
<rss version="2.0">
  <channel>
    <title>チャンネルタイトル</title>
    <link>サイトURL</link>
    <description>説明</description>
    <language>言語コード</language>
    <item>
      <title>アイテムタイトル</title>
      <link>アイテムURL</link>
      <pubDate>RFC822形式日時</pubDate>
      <author>作成者</author>
      <guid>一意識別子</guid>
      <description>コンテンツ</description>
      <enclosure url="画像URL" length="0" type="image/jpeg"/> <!-- オプション -->
      <comments>コメントURL</comments> <!-- フォーラム投稿時 -->
    </item>
    ...
  </channel>
</rss>
```

## 処理フロー

### 処理シーケンス

```
1. rss.aspアクセス
   └─ begin.asp、rss_writer.aspインクルード
2. Content-Type設定（application/xml）
3. ページID判定
   ├─ iId=0（サイト全体RSS）
   │   ├─ bEnableMainRSS確認
   │   ├─ キャッシュ確認（Application("RSS" & cId)）
   │   ├─ キャッシュなし → ページ一覧取得・RSS生成
   │   │   ├─ 最大300件まで取得
   │   │   ├─ オンライン、非削除、非コンテナ、非イントラネット等フィルタ
   │   │   └─ 各ページ情報をRSSアイテム化
   │   └─ キャッシュあり → キャッシュ出力
   │
   └─ iId>0（ページ単位RSS）
       ├─ イントラネットページ認証確認
       │   └─ 未認証 → "No Access" RSS出力
       ├─ キャッシュ確認
       ├─ リストページ（bPushRSS=true）
       │   └─ リストアイテムをRSSアイテム化
       ├─ フォーラム/テーマ（bPushRSS=true）
       │   └─ 投稿をRSSアイテム化
       ├─ カタログ（bOnline=true）
       │   └─ カタログアイテムをRSSアイテム化
       ├─ RSS出力
       ├─ ヒット数記録（addHitRSS）
       └─ リファラー記録（logReferer）
```

### フローチャート

```mermaid
flowchart TD
    A[rss.aspアクセス] --> B{iId指定?}
    B -->|No| C{bEnableMainRSS?}
    C -->|No| Z[終了]
    C -->|Yes| D{キャッシュ<br>あり?}
    D -->|Yes| E[キャッシュ出力]
    D -->|No| F[ページ一覧取得]
    F --> G[RSS生成]
    G --> H[キャッシュ保存]
    H --> E

    B -->|Yes| I{イントラネット<br>認証?}
    I -->|NG| J[No Access RSS]
    I -->|OK| K{キャッシュ<br>あり?}
    K -->|Yes| L[キャッシュ出力]
    K -->|No| M{リストページ?}
    M -->|Yes| N[リストアイテムRSS]
    M -->|No| O{フォーラム?}
    O -->|Yes| P[投稿RSS]
    O -->|No| Q{カタログ?}
    Q -->|Yes| R[カタログRSS]
    Q -->|No| S[空RSS]
    N --> T[キャッシュ保存]
    P --> T
    R --> T
    S --> T
    T --> L
    L --> U[ヒット数記録]
    U --> V[リファラー記録]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-114-01 | サイト全体RSS制限 | 最大300件まで出力 | サイト全体RSS |
| BR-114-02 | ページフィルタ | オンライン、非削除、非コンテナ、非イントラネット、非アプリケーション、パスワードなしのページのみ | サイト全体RSS |
| BR-114-03 | イントラネットアクセス制限 | 未認証の場合は"No Access"を返す | イントラネットページRSS |
| BR-114-04 | キャッシュ利用 | Application変数でキャッシュし、パフォーマンスを向上 | 全てのRSS |
| BR-114-05 | 日時形式 | RFC822形式で出力 | 全てのpubDate |

### 計算ロジック

- RFC822日時変換: Format_RFC822_DateAndTime関数使用

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ一覧取得 | tblPage | SELECT | サイト全体RSS用ページ取得 |
| リストアイテム取得 | tblPage（リスト関連） | SELECT | リストページRSS用アイテム取得 |
| フォーラム投稿取得 | tblPost | SELECT | フォーラムRSS用投稿取得 |
| カタログアイテム取得 | tblCatalogItem | SELECT | カタログRSS用アイテム取得 |
| RSSヒット記録 | tblPage | UPDATE | RSSアクセス数記録 |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sTitle, sValue, updatedTS | iCustomerID=cId、bOnline=true等 | RSS対象ページ取得 |
| UPDATE | iHitRSS | +1 | RSSアクセス数加算 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アクセス拒否 | イントラネットページに未認証アクセス | "No Access"アイテムを含むRSS出力 |
| - | RSS無効 | bEnableMainRSS=falseのサイト | 空レスポンス |

### リトライ仕様

特になし

## トランザクション仕様

データベース更新（ヒット数記録）は単一UPDATE文で実行。トランザクション管理は不要。

## パフォーマンス要件

- RSS生成処理: キャッシュヒット時1秒以内、キャッシュミス時5秒以内
- キャッシュはApplication変数で保持

## セキュリティ考慮事項

1. **アクセス制御**: イントラネットページは認証必須
2. **パスワード保護ページ除外**: パスワード保護ページはRSSに含まれない
3. **暗号化ID**: ページIDは暗号化してURL出力
4. **CDATA使用**: HTMLコンテンツはCDATAでラップ

## 備考

- kwRSS_writerクラスでRSS生成
- aspXMLクラスでXML構築
- RFC822日時形式への変換にFormat_RFC822_DateAndTime関数使用
- enclosure要素で画像添付対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

RSS生成に使用するクラス構造を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | rss_writer.asp | `asp/includes/rss_writer.asp` | kwRSS_writerクラス、aspXMLクラスの構造 |

**読解のコツ**: kwRSS_writerクラスはItems配列でRSSアイテムを管理。AddNew()でインデックス増加、Set*関数で各項目設定。

#### Step 2: エントリーポイントを理解する

RSS出力の起点を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | rss.asp | `rss.asp` | RSS出力処理全体の流れ |

**主要処理フロー**:
1. **4行目**: Content-Type設定（application/xml）
2. **9行目**: iId=0判定（サイト全体RSS）
3. **61行目**: else（ページ単位RSS）
4. **63-79行目**: イントラネット認証チェック
5. **91-130行目**: リストページRSS生成
6. **133-171行目**: フォーラムRSS生成
7. **175-213行目**: カタログRSS生成

#### Step 3: キャッシュ機構を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rss.asp | `rss.asp` | Application変数によるキャッシュ（13行目、51行目、84行目、217行目） |

### プログラム呼び出し階層図

```
rss.asp
    │
    ├─ asp/begin.asp (初期化)
    │
    ├─ asp/includes/rss_writer.asp
    │      │
    │      ├─ kwRSS_writer クラス
    │      │      ├─ AddNew() ... 新規アイテム追加
    │      │      ├─ SetTitle() ... タイトル設定
    │      │      ├─ SetLink() ... リンク設定
    │      │      ├─ SetDesc() ... 説明設定
    │      │      ├─ SetPubDate() ... 日時設定
    │      │      ├─ SetAuthor() ... 作成者設定
    │      │      ├─ SetGUID() ... GUID設定
    │      │      ├─ SetEnclosure() ... 画像設定
    │      │      ├─ SetComments() ... コメントURL設定
    │      │      └─ GetRSS() ... XML生成
    │      │
    │      └─ aspXML クラス
    │             └─ XML構築処理
    │
    ├─ selectedPage ... ページオブジェクト
    │      ├─ fastlistitems ... リストアイテム取得
    │      ├─ theme ... フォーラムオブジェクト
    │      └─ catalog ... カタログオブジェクト
    │
    ├─ Format_RFC822_DateAndTime() ... 日時変換
    │
    ├─ treatConstants() ... 定数展開
    │
    ├─ prepareForExport() ... 出力準備
    │
    └─ logReferer() ... リファラー記録
```

### データフロー図

```
[入力]                      [処理]                           [出力]

URLパラメータ ──────────> iId判定 ─────────────────────> 処理分岐
(iId)                      │
                          v
Application変数 ────────> キャッシュ確認 ─────────────> キャッシュヒット
(RSS + cId)                │                             → 即出力
                          v (キャッシュミス)
データベース ───────────> ページ/アイテム取得 ────────> ページ一覧
(tblPage等)                │
                          v
                    kwRSS_writer ────────────────────> RSSアイテム集合
                          │
                          v
                    aspXML.GetRSS() ─────────────────> XML文字列
                          │
                          v
                    Application保存 ─────────────────> キャッシュ更新
                          │
                          v
                    Response.Write ──────────────────> XMLレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rss.asp | `rss.asp` | ソース | RSSフィード出力メイン処理 |
| rss_writer.asp | `asp/includes/rss_writer.asp` | ソース | RSS生成クラス（kwRSS_writer、aspXML） |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス（fastlistitems等） |
| listitem.asp | `asp/includes/listitem.asp` | ソース | リストアイテムクラス |
| theme.asp | `asp/includes/theme.asp` | ソース | フォーラムクラス |
| post.asp | `asp/includes/post.asp` | ソース | 投稿クラス |
| catalogItem.asp | `asp/includes/catalogItem.asp` | ソース | カタログアイテムクラス |
