# 機能設計書 115-XMLサイトマップ出力

## 概要

本ドキュメントは、QuickerSite CMSにおけるフロントエンド「XMLサイトマップ出力」機能の設計仕様を定義する。

### 本機能の処理概要

検索エンジン向けのXMLサイトマップ（sitemap.xml形式）を生成する機能である。サイト内の全ページURLを標準形式で出力し、検索エンジンのクローラーがサイト構造を効率的に把握できるようにする。

**業務上の目的・背景**：SEO（検索エンジン最適化）の基本要素として、サイト内の全ページを検索エンジンに効率的に認識させることが重要である。XMLサイトマップは、Google、Bing、Yahoo等の主要検索エンジンが標準的にサポートするフォーマットであり、新規ページや更新ページのインデックス登録を促進する。

**機能の利用シーン**：
- 検索エンジンへのサイトマップ登録（Google Search Console等）
- サイト構造の検索エンジンへの通知
- 新規ページ追加後のインデックス促進
- サイトリニューアル時の検索エンジン対応

**主要な処理内容**：
1. XMLサイトマップヘッダー生成（XML宣言、urlset要素）
2. 全ページの検索・収集（cls_search使用）
3. 各ページのURL生成
   - 通常ページ: default.asp?iId=暗号化ID
   - リストアイテム: default.asp?iId=親ID&item=アイテムID
   - ユーザーフレンドリーURL: 設定されたURL
4. フォーラム投稿のURL生成
5. XMLサイトマップ出力

**関連システム・外部連携**：
- 検索エンジン（Google、Bing、Yahoo等）
- サイトマップ検証サービス（xml-sitemaps.com等）

**権限による制御**：公開ページのみサイトマップに含まれる。パスワード保護ページ、イントラネットページは自動的に除外される（cls_searchの仕様）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 163 | サイトマップ | 主機能 | 検索エンジン向けXMLサイトマップ生成 |

## 機能種別

XML生成・出力処理 / SEO対応

## 入力仕様

### 入力パラメータ

なし（sitemap.aspへの直接アクセス）

### 入力データソース

- データベース（全ページ情報、フォーラム投稿情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| XML | String | sitemaps.org標準形式のXMLドキュメント |

### 出力先

- HTTPレスポンス（XMLテキスト）

### XMLサイトマップ構造

```xml
<?xml version="1.0" encoding="UTF-8"?>
<urlset
xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">
<url>
<loc>https://example.com/default.asp?iId=xxxxx</loc>
</url>
...
</urlset>
```

## 処理フロー

### 処理シーケンス

```
1. sitemap.aspアクセス
   └─ begin.aspインクルード
2. XMLヘッダー生成
   ├─ XML宣言（version="1.0" encoding="UTF-8"）
   └─ urlset開始タグ（namespaces定義）
3. ページ検索
   ├─ cls_search オブジェクト作成
   ├─ includeURL=false設定
   ├─ allowEmptyString=true設定
   ├─ includeListItems=true設定
   └─ results取得
4. 各ページ処理
   ├─ フォーラム投稿がある場合
   │   └─ 各投稿のURLを出力
   ├─ リストアイテムの場合
   │   └─ 親ページID+アイテムID形式でURL出力
   ├─ ユーザーフレンドリーURL設定の場合
   │   └─ UFLでURL出力
   └─ 通常ページ
       └─ 暗号化ID形式でURL出力
5. urlset終了タグ
6. XML出力（Response.Write）
7. クリーンアップ処理
```

### フローチャート

```mermaid
flowchart TD
    A[sitemap.aspアクセス] --> B[XMLヘッダー生成]
    B --> C[cls_search作成]
    C --> D[検索設定]
    D --> E[results取得]
    E --> F{ページあり?}
    F -->|No| G[urlset終了]
    F -->|Yes| H{フォーラム<br>あり?}
    H -->|Yes| I[投稿URL追加]
    H -->|No| J{リスト<br>アイテム?}
    I --> J
    J -->|Yes| K[親ID+アイテムID<br>URL追加]
    J -->|No| L{UFL<br>設定?}
    K --> M[次のページ]
    L -->|Yes| N[UFL形式<br>URL追加]
    L -->|No| O[暗号化ID形式<br>URL追加]
    N --> M
    O --> M
    M --> F
    G --> P[Response.Write]
    P --> Q[cleanUPASP]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-115-01 | sitemaps.org準拠 | XMLサイトマップはsitemaps.org/schemas/sitemap/0.9に準拠 | 全出力 |
| BR-115-02 | 公開ページのみ | 公開ページのみサイトマップに含める | 全ページ |
| BR-115-03 | リストアイテム含む | includeListItems=trueでリストアイテムも含める | リストページ |
| BR-115-04 | ユーザーフレンドリーURL優先 | UFLが設定されている場合はUFLを使用 | UFL設定ページ |
| BR-115-05 | フォーラム投稿含む | フォーラムが設定されているページは投稿URLも含める | フォーラムページ |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ検索 | tblPage | SELECT | cls_searchによる全ページ取得 |
| フォーラム投稿取得 | tblPost | SELECT | フォーラム投稿URL生成用 |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, iListPageID, iThemeID, sUserFriendlyURL | cls_searchの検索条件 | サイトマップ対象ページ |

#### tblPost

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId | iThemeID、ルート投稿（iPostID is null or iPostID=0） | フォーラム投稿URL生成 |

## エラー処理

### エラーケース一覧

特になし（エラーが発生しても空のサイトマップが出力される）

### リトライ仕様

特になし

## トランザクション仕様

データベース更新を伴わないため、トランザクション管理は不要。

## パフォーマンス要件

- サイトマップ生成処理: ページ数に依存（1000ページで10秒以内目安）

## セキュリティ考慮事項

1. **公開ページのみ**: cls_searchの仕様で非公開ページは自動除外
2. **暗号化ID使用**: ページIDは暗号化して出力
3. **XMLエスケープ**: 特殊文字は適切にエスケープ（&amp;等）

## 備考

- 検証サイト: http://www.xml-sitemaps.com/validate-xml-sitemap.html
- Google Search Console等でサイトマップURLを登録して使用
- lastmod、changefreq、priority要素は現在未実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

サイトマップ生成に使用するデータ構造を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | sitemap.asp | `sitemap.asp` | sitemap変数によるXML文字列構築 |
| 1-2 | search.asp | `asp/includes/search.asp` | cls_searchクラスの検索機能 |

**読解のコツ**: XMLは文字列連結で構築。vbcrlfで改行を挿入してフォーマット。

#### Step 2: エントリーポイントを理解する

サイトマップ出力の起点を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sitemap.asp | `sitemap.asp` | 60行程度のシンプルなファイル全体 |

**主要処理フロー**:
1. **4-14行目**: XMLヘッダーとurlset開始タグ生成
2. **16-20行目**: cls_search設定（includeURL=false、allowEmptyString=true、includeListItems=true）
3. **26行目**: ページループ開始
4. **29-37行目**: フォーラム投稿URL生成
5. **44-52行目**: ページURL生成（リストアイテム/UFL/通常）
6. **55行目**: urlset終了タグ
7. **59行目**: Response.Write出力

#### Step 3: 検索機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | search.asp | `asp/includes/search.asp` | cls_searchクラスのresultsプロパティ |

### プログラム呼び出し階層図

```
sitemap.asp
    │
    ├─ asp/begin.asp (初期化)
    │
    ├─ cls_search (検索クラス)
    │      ├─ includeURL ... 外部URL含めない
    │      ├─ allowEmptyString ... 空文字許可
    │      ├─ includeListItems ... リストアイテム含める
    │      └─ results ... 検索結果（Dictionary）
    │
    ├─ db.execute() ... フォーラム投稿取得
    │
    ├─ encrypt() ... ページID暗号化
    │
    └─ cleanUPASP() ... クリーンアップ
```

### データフロー図

```
[入力]                      [処理]                           [出力]

sitemap.aspアクセス ────> begin.asp初期化 ──────────> セッション初期化
                          │
                          v
                    XMLヘッダー生成 ───────────────> sitemap変数
                          │
                          v
                    cls_search.results ─────────> ページ一覧
                          │                       (Dictionary)
                          v
                    ページループ処理
                          │
                          ├─ フォーラム投稿取得 ──> 投稿URL
                          │
                          ├─ リストアイテム判定 ──> 親ID+アイテムID URL
                          │
                          ├─ UFL判定 ────────────> UFL URL
                          │
                          └─ 通常ページ ─────────> 暗号化ID URL
                          │
                          v
                    urlset終了 ────────────────────> sitemap変数完成
                          │
                          v
                    Response.Write ─────────────> XMLレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sitemap.asp | `sitemap.asp` | ソース | XMLサイトマップ出力メイン処理 |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
| search.asp | `asp/includes/search.asp` | ソース | 検索クラス |
| functions.asp | `asp/includes/functions.asp` | ソース | encrypt等のユーティリティ |
| customer.asp | `asp/includes/customer.asp` | ソース | customerオブジェクト（sQSUrl、bUserFriendlyURL） |
