# 機能設計書 13-リストページ管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるリストページ管理機能の設計について記述する。リストページは、ブログ、ニュース、FAQ、製品一覧など、複数のアイテムを一覧形式で表示するページタイプであり、その作成・編集・管理機能を提供する。

### 本機能の処理概要

リストページ管理機能は、一覧形式のページを作成・管理し、そのページに紐づくリストアイテム（個別記事）の追加・編集・削除・並び替えを行う機能である。

**業務上の目的・背景**：Webサイトにおいて、ブログ、ニュース、製品一覧、FAQ、イベント情報など、同種のコンテンツを時系列や特定の順序で表示するニーズは非常に多い。本機能により、コンテンツ管理者は技術的な知識なしに、一覧形式のページを簡単に作成・運用できる。また、各アイテムに日付や外部URL、画像などを設定でき、多様な一覧表示要件に対応する。

**機能の利用シーン**：
- 企業ニュースやお知らせを時系列で掲載する場合
- ブログ記事を管理・公開する場合
- 製品やサービスの一覧ページを作成する場合
- FAQやヘルプ記事を一覧形式で提供する場合
- イベント情報を日付順に掲載する場合

**主要な処理内容**：
1. リストページの作成（sOrderBYフィールドに並び順を設定）
2. リストアイテムの追加・編集（iListPageIDでリストページに関連付け）
3. リストアイテムへの画像添付（bListItemPic設定が有効な場合）
4. リストアイテムの複製・削除
5. 外部URLリンクまたはRSSフィードの設定
6. リストページテンプレートの編集
7. 通常ページへの変換

**関連システム・外部連携**：
- RSSフィード：外部RSSを取り込んでリストアイテムとして表示可能
- 外部URL：リストアイテムを外部サイトへのリンクとして設定可能

**権限による制御**：セカンドアドミン権限により、リストページの作成・編集・削除がそれぞれ個別に制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | リストページ編集 | 主機能 | 一覧形式ページの作成・設定 |
| 10 | リストアイテム編集 | 主機能 | リストページ内の個別アイテム編集 |
| 11 | リストテンプレート編集 | 補助機能 | リストページのHTMLテンプレート編集 |
| 133 | リストアイテム画像編集 | 補助機能 | リストアイテム画像の編集 |
| 134 | リストアイテム画像アップロード | 補助機能 | リストアイテム画像のアップロード |

## 機能種別

CRUD操作（Create/Read/Update/Delete） / コンテンツ管理

## 入力仕様

### 入力パラメータ

#### リストページ編集（bs_editList.asp）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iId | Integer（暗号化） | No | リストページID（新規時はなし） | 数値であること |
| sTitle | String | Yes | ページタイトル | 必須、最大100文字 |
| sOrderBY | String | Yes | リストアイテムの並び順設定 | 許可された値のみ |
| sValue | String | No | ページ本文（HTML） | XSS対策済み |
| btnaction | String | Yes | アクション種別 | "save"等 |

#### リストアイテム編集（bs_editListItem.asp）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iId | Integer（暗号化） | No | リストアイテムID（新規時はなし） | 数値であること |
| iListPageID | Integer（暗号化） | Yes | 親リストページID | 必須、存在確認 |
| sTitle | String | Yes | アイテムタイトル | 必須、最大255文字 |
| sValue | String | No | アイテム本文（HTML） | XSS対策済み |
| dPage | Date | No | 記事日付 | 日付形式 |
| dOnlineFrom | Date | No | 公開開始日 | 日付形式 |
| dOnlineUntill | Date | No | 公開終了日 | 日付形式 |
| sLPExternalURL | String | No | 外部URL | URL形式 |
| bLPExternalOINW | Boolean | No | 新しいウィンドウで開く | true/false |
| sUserFriendlyURL | String | No | ユーザーフレンドリーURL | 英数字とハイフン |

### 入力データソース

- 画面入力：各編集画面からのフォーム入力
- WYSIWYGエディタ：CKEditorによるリッチテキスト入力
- ファイルアップロード：画像ファイル（リストアイテム画像）
- 外部データ：RSSフィードからの自動取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| リストページ | cls_page | リストページオブジェクト |
| リストアイテム一覧 | Dictionary | リストアイテムのコレクション |
| プレビューURL | String | ページプレビュー用URL |

### 出力先

- 画面表示：管理画面での編集フォーム、アイテム一覧表示
- フロントエンド表示：公開サイトでの一覧ページ
- データベース：tblPageテーブル

## 処理フロー

### 処理シーケンス

```
1. リストページ作成/編集
   ├─ フォーム入力値の取得
   ├─ バリデーション実行
   ├─ sOrderBYに並び順設定を保存
   └─ tblPageに保存

2. リストアイテム管理
   ├─ iListPageIDで親ページを関連付け
   ├─ 各アイテムのコンテンツを編集
   ├─ 日付、外部URL等のメタ情報を設定
   └─ 画像添付（オプション）

3. アイテム操作
   ├─ コピー：新規アイテムとして複製
   ├─ 削除：bDeleted=true、bOnline=false
   └─ プレビュー：フロントエンドでの表示確認
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{アクション判定}
    B -->|新規作成| C[リストページ作成フォーム]
    B -->|編集| D[リストページ読み込み]
    B -->|アイテム追加| E[リストアイテム作成フォーム]
    B -->|アイテム編集| F[リストアイテム読み込み]
    B -->|アイテムコピー| G[アイテム複製処理]
    B -->|アイテム削除| H[アイテム削除処理]
    B -->|通常ページ変換| I[変換処理]

    C --> J[sOrderBY設定]
    D --> J
    J --> K[フォーム表示]
    K --> L{保存?}
    L -->|Yes| M[バリデーション]
    M --> N{OK?}
    N -->|Yes| O[tblPage保存]
    N -->|No| K
    O --> P[リダイレクト]

    E --> Q[iListPageID設定]
    F --> Q
    Q --> R[アイテムフォーム表示]
    R --> S{保存?}
    S -->|Yes| T[バリデーション]
    T --> U{OK?}
    U -->|Yes| V[tblPage保存]
    U -->|No| R
    V --> P

    G --> W[CSRF検証]
    W --> X[アイテム取得]
    X --> Y[iId=null設定]
    Y --> Z[タイトルに copy 付加]
    Z --> AA[保存]
    AA --> P

    H --> AB[CSRF検証]
    AB --> AC[アイテム取得]
    AC --> AD[bDeleted=true]
    AD --> AE[bOnline=false]
    AE --> AF[保存]
    AF --> P

    I --> AG[CSRF検証]
    AG --> AH[sOrderBY=null]
    AH --> AI[保存]
    AI --> P

    P --> AJ[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-13-01 | リストページ識別 | sOrderBYフィールドに値があるページはリストページとして扱われる | 常に適用 |
| BR-13-02 | アイテム関連付け | リストアイテムはiListPageIDで親リストページに関連付けられる | リストアイテム作成時 |
| BR-13-03 | 削除時の論理削除 | リストアイテム削除時はbDeleted=true、bOnline=falseに設定（物理削除しない） | アイテム削除時 |
| BR-13-04 | 外部URLとコンテンツの排他 | sLPExternalURLとsValueは同時に設定できない | アイテム保存時 |
| BR-13-05 | 通常ページ変換 | リストページを通常ページに変換するとsOrderBYがnullになり、リストアイテムは削除されない | 変換実行時 |
| BR-13-06 | コピー時のURL初期化 | リストアイテムコピー時、sCodeとsUserFriendlyURLは空になる | アイテムコピー時 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リストページ作成 | tblPage | INSERT | 新規リストページレコード挿入 |
| リストページ編集 | tblPage | UPDATE | リストページ情報更新 |
| リストアイテム作成 | tblPage | INSERT | 新規リストアイテムレコード挿入 |
| リストアイテム編集 | tblPage | UPDATE | リストアイテム情報更新 |
| リストアイテム削除 | tblPage | UPDATE | bDeleted=true、bOnline=false |
| リストアイテムコピー | tblPage | INSERT | 複製レコード挿入 |

### テーブル別操作詳細

#### tblPage（リストページ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sOrderBY | 並び順設定（dPage DESC等） | リストページの識別に使用 |
| INSERT/UPDATE | sTitle | ページタイトル | 必須 |
| INSERT/UPDATE | sValue | ページ本文HTML | WYSIWYGエディタから |

#### tblPage（リストアイテム）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | iListPageID | 親リストページのiId | 必須 |
| INSERT/UPDATE | sTitle | アイテムタイトル | 必須 |
| INSERT/UPDATE | sValue | アイテム本文HTML | WYSIWYGエディタから |
| INSERT/UPDATE | dPage | 記事日付 | 並び替えに使用 |
| INSERT/UPDATE | sLPExternalURL | 外部URL | sValueと排他 |
| INSERT/UPDATE | bLPExternalOINW | 新しいウィンドウで開くフラグ | Boolean |
| INSERT/UPDATE | sUserFriendlyURL | ユーザーフレンドリーURL | SEO用 |
| INSERT/UPDATE | sItemPicture | 画像ファイル拡張子 | 画像添付時 |
| UPDATE | bDeleted | true | 削除時 |
| UPDATE | bOnline | false | 削除時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 必須項目エラー | タイトルが未入力 | エラーメッセージを表示 |
| err_listpagepurl | 外部URL/コンテンツ競合 | sLPExternalURLとsValueが両方設定 | エラーメッセージを表示 |
| err_ufl | URL重複エラー | sUserFriendlyURLが他ページと重複 | エラーメッセージを表示 |
| - | CSRF検証エラー | セキュリティトークンが無効 | 処理中断 |

### リトライ仕様

リトライは実装されていない。エラー発生時は入力画面に戻り、ユーザーに修正を促す。

## トランザクション仕様

明示的なトランザクション制御は行われていない。各保存操作は個別に実行される。

## パフォーマンス要件

- リストページ表示: リストアイテム数に応じて表示時間が増加
- 推奨リストアイテム数: 1ページあたり100件以内
- ページネーション: 大量アイテムの場合はページネーション実装を推奨

## セキュリティ考慮事項

1. **CSRF対策**: checkCSRF()によるトークン検証
2. **XSS対策**: WYSIWYGエディタ出力のサニタイズ
3. **権限チェック**: セカンドアドミン権限による機能アクセス制御
4. **パラメータ暗号化**: IDパラメータの暗号化
5. **削除確認**: JavaScript確認ダイアログによる誤削除防止

## 備考

- リストページは通常ページと同じtblPageテーブルに格納され、sOrderBYフィールドの有無で判別される
- リストアイテムもtblPageテーブルに格納され、iListPageIDで親リストページに関連付けられる
- 画像添付機能はcustomer.bListItemPic設定で有効/無効を切り替え可能
- RSSフィードを設定した場合、外部コンテンツを自動的にリストアイテムとして表示可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リストページとリストアイテムの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | sOrderBY、iListPageIDプロパティの役割 |

**読解のコツ**: sOrderBYに値があるページがリストページ、iListPageIDに値があるページがリストアイテムとして識別される。両者は同じcls_pageクラスで扱われる。

#### Step 2: リストページ管理画面を理解する

リストページの管理画面と操作を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_listPage.asp | `asp/bs_listPage.asp` | リストページ管理画面のメイン処理 |

**主要処理フロー**:
1. **7-19行目**: リストアイテム削除処理（iDeleteLIIDパラメータ）
2. **21-36行目**: リストアイテムコピー処理（iCopyIidパラメータ）
3. **42-44行目**: アイテム一覧表示のループ処理
4. **56-66行目**: 画像添付機能のUI（customer.bListItemPic条件）
5. **69-75行目**: コピー・削除ボタンの生成

#### Step 3: リストアイテム編集を理解する

個別アイテムの編集画面を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_editListItem.asp | `asp/bs_editListItem.asp` | リストアイテム編集画面 |

**主要処理フロー**:
- **8行目**: フォームアクション設定（save_listitem）
- **12行目**: タイトル入力フィールド
- **14-16行目**: 日付設定（dPage、dOnlineFrom、dOnlineUntill）
- **17-19行目**: 外部URL設定
- **23行目**: WYSIWYGエディタによる本文編集
- **24-26行目**: ユーザーフレンドリーURL設定

#### Step 4: 保存処理を理解する

フォーム送信時の処理ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_processPage.asp | `asp/bs_processPage.asp` | ページ保存処理 |

**主要処理フロー**:
- **12-25行目**: save/save_listpage/save_listitemアクションの処理
- **19-20行目**: save_listpageの場合、リストページ管理画面へリダイレクト
- **22-23行目**: save_listitemの場合、親リストページ画面へリダイレクト

### プログラム呼び出し階層図

```
bs_listPage.asp（リストページ管理画面）
    │
    ├─ リストアイテム一覧表示
    │      └─ page.listitems(false) [アイテム取得]
    │
    ├─ アイテム削除処理
    │      ├─ checkCSRF()
    │      ├─ cls_page.pick(iDeleteLIID)
    │      ├─ bDeleted = true
    │      ├─ bOnline = false
    │      └─ save()
    │
    ├─ アイテムコピー処理
    │      ├─ checkCSRF()
    │      ├─ cls_page.pick(iCopyIid)
    │      ├─ iId = null
    │      ├─ sCode = ""
    │      ├─ sUserFriendlyURL = ""
    │      ├─ sTitle = sTitle & " (copy)"
    │      └─ save()
    │
    └─ bs_editListItem.asp（アイテム編集）
           ├─ bs_processPage.asp [保存処理]
           │      └─ cls_page.save()
           └─ リダイレクト → bs_listPage.asp
```

### データフロー図

```
[入力]                         [処理]                              [出力]

リストページ設定        ───▶  bs_listPage.asp             ───▶  tblPage (sOrderBYあり)
                              (sOrderBY設定)

リストアイテム入力      ───▶  bs_editListItem.asp         ───▶  tblPage (iListPageIDあり)
(タイトル、本文、日付)         (アイテム保存)

画像ファイル            ───▶  bs_uploadpictureLI.asp      ───▶  ファイルシステム
                              (画像アップロード)                  (listitemimages/)
                                                                  tblPage (sItemPicture)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_listPage.asp | `asp/bs_listPage.asp` | ソース | リストページ管理画面 |
| bs_editListItem.asp | `asp/bs_editListItem.asp` | ソース | リストアイテム編集画面 |
| bs_editList.asp | `asp/bs_editList.asp` | ソース | リストページ設定編集 |
| bs_editListTemplate.asp | `asp/bs_editListTemplate.asp` | ソース | リストテンプレート編集 |
| bs_processPage.asp | `asp/bs_processPage.asp` | ソース | ページ保存処理 |
| bs_editpictureLI.asp | `asp/bs_editpictureLI.asp` | ソース | リストアイテム画像編集 |
| bs_uploadpictureLI.asp | `asp/bs_uploadpictureLI.asp` | ソース | リストアイテム画像アップロード |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス（listitems関数含む） |
| process_listpage.asp | `asp/process_listpage.asp` | ソース | フロントエンドでのリストページ表示 |
| bs_deletelistitem.asp | `asp/bs_deletelistitem.asp` | ソース | リストアイテム削除ボタン |
