# 機能設計書 14-外部URL設定

## 概要

本ドキュメントは、QuickerSite CMSにおける外部URL設定機能の設計について記述する。この機能により、メニュー項目として外部サイトへのリンクを設定でき、サイトナビゲーションの柔軟性を向上させる。

### 本機能の処理概要

外部URL設定機能は、メニュー内に外部Webサイトへのリンクを作成する機能である。コンテンツを持たないリダイレクト専用のページとして機能し、クリック時に指定した外部URLに遷移する。

**業務上の目的・背景**：企業サイトでは、関連会社サイト、SNSアカウント、外部予約システム、ECサイトなど、外部サービスへのリンクをメインメニューに含める必要がある。本機能により、サイトのメニュー構造を保ちながら、外部リソースへのシームレスなナビゲーションを提供できる。

**機能の利用シーン**：
- 外部のECサイトへのリンクをメニューに追加する場合
- SNS（Facebook、Twitter等）のプロフィールページへリンクする場合
- グループ会社や提携先サイトへのリンクを設置する場合
- 外部の予約・問い合わせシステムへ誘導する場合

**主要な処理内容**：
1. 外部URLページの作成（sExternalURLフィールドに外部URLを設定）
2. URLプレフィックス（http://、https://、mailto:等）の選択
3. 新しいウィンドウで開く設定（bOpenInNewWindow）
4. rel属性、class属性のカスタム設定
5. 通常ページやコンテナページへの変換

**関連システム・外部連携**：指定された任意の外部サイトへリダイレクト

**権限による制御**：セカンドアドミン権限の`bPageBody`により、外部URL設定へのアクセスが制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | 外部URL編集 | 主機能 | 外部サイトへのリダイレクト先URL設定 |
| 182 | 外部URL変換 | 補助機能 | ページを外部URLに変換 |
| 195 | リダイレクト先設定 | 関連機能 | リダイレクト先URLの設定 |

## 機能種別

CRUD操作（Create/Update） / リダイレクト設定

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iId | Integer（暗号化） | No | ページID（新規時はなし） | 数値であること |
| iParentID | Integer（暗号化） | No | 親ページID | 数値であること |
| sTitle | String | Yes | メニューに表示されるタイトル | 必須、最大100文字 |
| sExternalURLPrefix | String | Yes | URLプレフィックス | http://、https://、ftp://、mailto:のいずれか |
| sExternalURL | String | Yes | 外部URL（プレフィックス除く） | 必須、URL形式 |
| bOpenInNewWindow | Boolean | No | 新しいウィンドウで開く | true/false、デフォルトtrue |
| sRel | String | No | rel属性値 | 任意文字列、最大255文字 |
| sClassname | String | No | class属性値 | 任意文字列、最大255文字 |
| iRang | Integer | No | メニュー内の表示順序 | 1以上の整数 |
| bOnline | Boolean | No | オンライン状態 | true/false |
| btnaction | String | Yes | アクション種別 | "save"等 |
| QSSEC | String | Yes | CSRFトークン | 有効なセキュリティコード |

### 入力データソース

- 画面入力：外部URL編集画面（bs_editExternalURL.asp）からのフォーム入力
- セッションデータ：ログイン管理者情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 外部URLページ | cls_page | 外部URLリダイレクト設定を持つページ |
| リダイレクト先 | URL | 処理完了後の遷移先 |

### 出力先

- 画面表示：管理画面での編集フォーム
- フロントエンド：メニュークリック時に外部サイトへリダイレクト
- データベース：tblPageテーブル

## 処理フロー

### 処理シーケンス

```
1. 編集画面表示
   ├─ 既存ページ情報の読み込み（編集時）
   ├─ URLプレフィックス選択リストの生成
   └─ フォーム表示

2. 保存処理
   ├─ CSRF検証
   ├─ 入力値のバリデーション
   │   ├─ タイトル必須チェック
   │   └─ 外部URL必須チェック（sExternalURLPrefix設定時）
   ├─ URLプレフィックスの除去処理
   │   └─ http://、https://、ftp://、mailto:を除去
   ├─ tblPageへ保存
   └─ リダイレクト

3. フロントエンド表示
   ├─ メニュー生成時にsExternalURLを検出
   ├─ リンク先にsExternalURLPrefix + sExternalURLを設定
   ├─ bOpenInNewWindow=trueなら target="_blank" を付与
   └─ sRel、sClassname属性を追加
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[外部URL編集画面表示]
    B --> C[URLプレフィックス選択]
    C --> D[外部URL入力]
    D --> E[オプション設定]
    E --> F{保存?}
    F -->|No| G[キャンセル]
    F -->|Yes| H[CSRF検証]
    H --> I[バリデーション]
    I --> J{タイトルあり?}
    J -->|No| K[エラー: 必須項目]
    J -->|Yes| L{外部URLあり?}
    L -->|No| K
    L -->|Yes| M[URLプレフィックス除去]
    M --> N[tblPage保存]
    N --> O[メニューキャッシュクリア]
    O --> P[リダイレクト]
    K --> B
    G --> Q[終了]
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-14-01 | 外部URL識別 | sExternalURLフィールドに値があるページは外部URLページとして扱われる | 常に適用 |
| BR-14-02 | プレフィックス自動除去 | 入力されたURLからhttp://、https://、ftp://、mailto:を自動除去 | 保存時 |
| BR-14-03 | 新しいウィンドウ | bOpenInNewWindow=trueの場合、リンクにtarget="_blank"が付与される | フロントエンド表示時 |
| BR-14-04 | Colorboxクラス | sClassnameに"QSCCB_530_300"を設定すると、Colorboxで530x300pxで表示 | フロントエンド表示時 |
| BR-14-05 | URLプレフィックス必須 | sExternalURLPrefixが設定されている場合、sExternalURLは必須 | 保存時 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 外部URL作成 | tblPage | INSERT | 新規外部URLページレコード挿入 |
| 外部URL編集 | tblPage | UPDATE | 外部URL設定の更新 |
| 外部URL削除 | tblPage | UPDATE | bDeleted=true設定（論理削除） |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sExternalURLPrefix | http://、https://、ftp://、mailto: | 必須 |
| INSERT/UPDATE | sExternalURL | プレフィックス除去後のURL | 必須 |
| INSERT/UPDATE | bOpenInNewWindow | true/false | デフォルトtrue |
| INSERT/UPDATE | sRel | rel属性値 | オプション |
| INSERT/UPDATE | sClassname | class属性値 | オプション |
| INSERT/UPDATE | sTitle | メニュー表示タイトル | 必須 |
| INSERT/UPDATE | iRang | 表示順序 | 自動採番 |
| INSERT/UPDATE | bOnline | オンライン状態 | Boolean |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 必須項目エラー | タイトルまたは外部URLが未入力 | エラーメッセージを表示 |
| - | CSRF検証エラー | セキュリティトークンが無効 | 処理中断 |

### リトライ仕様

リトライは実装されていない。エラー発生時は入力画面に戻り、ユーザーに修正を促す。

## トランザクション仕様

明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- 保存処理: 1秒以内
- メニュー表示: キャッシュ利用時は即時表示

## セキュリティ考慮事項

1. **CSRF対策**: checkCSRF()によるトークン検証
2. **権限チェック**: secondAdmin.bPageBody権限による制御
3. **パラメータ暗号化**: IDパラメータの暗号化
4. **URL検証**: 悪意あるURLの入力に注意（管理者の責任で設定）
5. **rel属性**: noopener/noreferrerなどのセキュリティ属性を設定可能

## 備考

- 外部URLページはメニュー上では通常のリンクとして表示されるが、クリック時に外部サイトに遷移
- URLプレフィックスはcls_urlTypeListクラスで管理され、選択可能な値が制限される
- 通常ページやコンテナページから外部URLページへの変換、およびその逆変換が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

外部URLページの識別方法とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | sExternalURLPrefix、sExternalURL、bOpenInNewWindowプロパティ |

**読解のコツ**: sExternalURLに値があるページが外部URLページとして識別される。sExternalURLPrefixとsExternalURLを連結して完全なURLを構成する。

#### Step 2: 編集画面を理解する

外部URL編集画面の構造と入力項目を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editExternalURL.asp | `asp/bs_editExternalURL.asp` | 外部URL編集画面のフォーム構造 |

**主要処理フロー**:
- **4-5行目**: URLTypeListクラスのインスタンス化とプレフィックス選択リスト生成
- **5行目**: プレフィックス選択ドロップダウン、外部URL入力フィールド
- **5行目**: bOpenInNewWindowチェックボックス
- **5行目**: sRel、sClassname入力フィールド

#### Step 3: リンク生成を理解する

フロントエンドでの外部URLリンク生成を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | page.asp | `asp/includes/page.asp` | getClickLinkプロパティ（911-952行目） |

**主要処理フロー**:
- **925-934行目**: sExternalURLが存在する場合のリンク生成
- **926-927行目**: bOpenInNewWindowによるtarget="_blank"設定
- **928行目**: URLプレフィックスとURLの連結
- **929-934行目**: sRel、sClassname属性の追加

#### Step 4: 変換機能を理解する

通常ページから外部URLページへの変換を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_convertToExternalURL.asp | `asp/bs_convertToExternalURL.asp` | 変換リンクの生成 |

**主要処理フロー**:
- **2行目**: ページIDの存在確認とホームページでないことの確認
- **2行目**: secondAdmin.bPageBody権限チェック
- **2行目**: 変換リンクの生成

### プログラム呼び出し階層図

```
bs_editExternalURL.asp（外部URL編集画面）
    │
    ├─ bs_process.asp [ページオブジェクト初期化]
    ├─ bs_processPage.asp [保存処理]
    │      ├─ checkCSRF()
    │      ├─ cls_page.getRequestValues()
    │      ├─ cls_page.check()
    │      │      └─ sExternalURL必須チェック
    │      └─ cls_page.save()
    │             └─ URLプレフィックス除去
    │
    ├─ cls_urlTypeList [プレフィックスリスト]
    │
    └─ 変換機能
           ├─ bs_convertToContainerItem.asp
           ├─ bs_convertToListpage.asp
           └─ bs_convertToItemWithContent.asp
```

### データフロー図

```
[入力]                         [処理]                              [出力]

URLプレフィックス      ───▶  bs_editExternalURL.asp      ───▶  tblPage
外部URL                       (フォーム処理)                      (sExternalURLPrefix)
                                                                   (sExternalURL)
タイトル               ───▶  cls_page.save()             ───▶  メニューキャッシュ更新
オプション設定                (URL保存)

                       フロントエンド表示
                              │
                              ▼
                       cls_page.getClickLink
                              │
                              ▼
                       <a href="外部URL" target="_blank">
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editExternalURL.asp | `asp/bs_editExternalURL.asp` | ソース | 外部URL編集画面 |
| bs_convertToExternalURL.asp | `asp/bs_convertToExternalURL.asp` | ソース | 外部URLへの変換リンク |
| URLTypeList.asp | `asp/includes/URLTypeList.asp` | ソース | URLプレフィックスリストクラス |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス（getClickLinkプロパティ） |
| bs_processPage.asp | `asp/bs_processPage.asp` | ソース | ページ保存処理 |
| menu.asp | `asp/includes/menu.asp` | ソース | メニュー生成（外部URLリンク表示） |
