# 機能設計書 15-ページパスワード保護

## 概要

本ドキュメントは、QuickerSite CMSにおけるページパスワード保護機能の設計について記述する。この機能により、特定のページに対してパスワードを設定し、認証されたユーザーのみがコンテンツにアクセスできるようにする。

### 本機能の処理概要

ページパスワード保護機能は、個別のページまたはサイト全体に対してパスワードを設定し、訪問者がページにアクセスする際にパスワード認証を要求する機能である。サブページへのパスワード継承や一括削除も可能。

**業務上の目的・背景**：会員限定コンテンツや社内向け情報など、一般公開したくないページを保護する必要がある。イントラネット機能よりも簡易な方法で、特定ページへのアクセス制限を実現できる。ページ単位でのきめ細かな制御と、階層構造を活かしたパスワード継承により、柔軟なアクセス管理が可能。

**機能の利用シーン**：
- 会員向け限定コンテンツを保護する場合
- 社内向け情報を外部から保護する場合
- イベント参加者のみに公開したいページがある場合
- 特定のクライアント向け資料を保護する場合

**主要な処理内容**：
1. 個別ページへのパスワード設定（sPwフィールド）
2. パスワードの保存と削除
3. サブページへのパスワード一括適用（resetAllSubPasswords）
4. サブページのパスワード一括削除（removeAllSubPasswords）
5. サイト全体へのパスワード適用（sTotalPW）
6. フロントエンドでのパスワード認証画面表示

**関連システム・外部連携**：なし

**権限による制御**：セカンドアドミン権限の`bPagesPW`により、パスワード管理機能へのアクセスが制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | パスワード適用 | 主機能 | 個別ページへのパスワード保護設定 |
| 18 | 全体パスワード適用 | 関連機能 | サイト全体へのパスワード保護・変更 |

## 機能種別

CRUD操作（Create/Update/Delete） / 認証・認可

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iId | Integer（暗号化） | Yes | 対象ページID | 数値であること |
| sPw | String | No | 設定するパスワード | 3文字以上15文字以下 |
| btnaction | String | Yes | アクション種別 | save_pw/delete_pw/delete_pw_all |
| QSSEC | String | Yes | CSRFトークン | 有効なセキュリティコード |

### 入力データソース

- 画面入力：パスワード適用画面（bs_applyPW.asp）からのフォーム入力
- セッションデータ：ログイン管理者情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| パスワード設定結果 | Boolean | 設定の成功/失敗 |
| リダイレクト先 | URL | 処理完了後の遷移先 |

### 出力先

- 画面表示：管理画面での設定フォーム
- フロントエンド：パスワード認証画面
- データベース：tblPageテーブルのsPwカラム

## 処理フロー

### 処理シーケンス

```
1. パスワード設定画面表示
   ├─ 権限チェック（bPagesPW）
   ├─ サイト全体パスワード（sTotalPW）の確認
   │   └─ 設定済みの場合は個別設定不可の旨を表示
   └─ 現在のパスワード表示

2. パスワード保存（save_pw）
   ├─ CSRF検証
   ├─ パスワード長チェック（3文字以上）
   ├─ 小文字に変換して保存
   └─ サブページへ一括適用（resetAllSubPasswords）

3. パスワード削除（delete_pw）
   ├─ CSRF検証
   ├─ sPwを空に設定
   └─ 保存

4. サブページ含め削除（delete_pw_all）
   ├─ CSRF検証
   ├─ 対象ページのsPwを空に設定
   └─ 全サブページのsPwを空に設定（removeAllSubPasswords）

5. フロントエンド認証
   ├─ ページアクセス時にsPwをチェック
   ├─ パスワード入力フォーム表示
   ├─ 入力値とsPwを比較
   └─ 認証成功でセッションに記録
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{サイト全体PW設定済み?}
    B -->|Yes| C[個別設定不可メッセージ表示]
    B -->|No| D[パスワード設定フォーム表示]
    D --> E{アクション判定}
    E -->|save_pw| F[CSRF検証]
    E -->|delete_pw| G[CSRF検証]
    E -->|delete_pw_all| H[CSRF検証]

    F --> I{PW長 >= 3?}
    I -->|No| J[エラー: パスワード短すぎ]
    I -->|Yes| K[小文字に変換]
    K --> L[sPw保存]
    L --> M[サブページに一括適用]
    M --> N[リダイレクト]

    G --> O[sPw = 空]
    O --> P[保存]
    P --> N

    H --> Q[sPw = 空]
    Q --> R[保存]
    R --> S[全サブページのPW削除]
    S --> N

    J --> D
    C --> T[終了]
    N --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-15-01 | パスワード長制限 | パスワードは3文字以上15文字以下 | パスワード保存時 |
| BR-15-02 | 小文字変換 | パスワードは保存時に小文字に変換される | パスワード保存時 |
| BR-15-03 | サブページ継承 | パスワード設定時、全サブページにも同じパスワードを適用 | パスワード保存時 |
| BR-15-04 | 親ページ制約 | 親ページにパスワードが設定されている場合、子ページの個別削除は不可 | 削除ボタン表示時 |
| BR-15-05 | サイト全体PW優先 | sTotalPWが設定されている場合、個別ページのパスワード設定は無効 | 設定画面表示時 |
| BR-15-06 | 移動時継承 | ページ移動時、移動先親ページのパスワードを継承 | ページ移動時 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パスワード設定 | tblPage | UPDATE | 対象ページのsPwを更新 |
| サブページ一括設定 | tblPage | UPDATE | 全サブページのsPwを更新 |
| パスワード削除 | tblPage | UPDATE | sPwを空文字に更新 |
| サブページ一括削除 | tblPage | UPDATE | 全サブページのsPwを空文字に更新 |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sPw | 入力パスワード（小文字） | 3-15文字 |
| UPDATE | sPw | 空文字 | 削除時 |
| UPDATE | updatedTS | 現在日時 | 更新時に自動設定 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_pw | パスワードエラー | パスワードが3文字未満 | エラーメッセージを表示 |
| - | CSRF検証エラー | セキュリティトークンが無効 | 処理中断 |

### リトライ仕様

リトライは実装されていない。エラー発生時は入力画面に戻り、ユーザーに修正を促す。

## トランザクション仕様

明示的なトランザクション制御は行われていない。サブページへの一括適用は再帰的に各ページを個別に保存する。

## パフォーマンス要件

- 単一ページ設定: 1秒以内
- サブページ一括設定: サブページ数に比例（1ページあたり約0.1秒）

## セキュリティ考慮事項

1. **CSRF対策**: checkCSRF()によるトークン検証
2. **権限チェック**: secondAdmin.bPagesPW権限による制御
3. **パスワード保存**: 平文保存（ハッシュ化されていない）
4. **パスワード複雑性**: 最小3文字の長さ制限のみ
5. **セッション管理**: フロントエンドでの認証成功時にセッションに記録

## 備考

- パスワードは平文でデータベースに保存されるため、セキュリティ要件が高い場合はイントラネット機能の使用を推奨
- サイト全体パスワード（sTotalPW）が設定されている場合、全ページに同一パスワードが適用され、個別設定は無効になる
- ページ移動時、移動先の親ページにパスワードがある場合は自動的に継承される
- メニュー表示時、パスワード保護されたページには鍵アイコンが表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パスワード保護に関連するプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | sPwプロパティ、resetAllSubPasswords/removeAllSubPasswords関数 |

**読解のコツ**: sPwプロパティに値があるページはパスワード保護されている。親ページからの継承とサブページへの一括適用が再帰的に行われる。

#### Step 2: パスワード設定画面を理解する

パスワード設定画面の構造と処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_applyPW.asp | `asp/bs_applyPW.asp` | パスワード設定フォームと条件分岐 |

**主要処理フロー**:
- **4行目**: 権限チェック（secondAdmin.bPagesPW）
- **4行目**: サイト全体パスワード確認（isleeg(customer.sTotalPW)）
- **4行目**: パスワード入力フィールドと操作ボタン
- **4行目**: 親ページパスワード確認（削除ボタン表示制御）

#### Step 3: 保存処理を理解する

パスワード保存・削除のロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_processPage.asp | `asp/bs_processPage.asp` | save_pw/delete_pw/delete_pw_allアクション（45-81行目） |

**主要処理フロー**:
- **45-60行目**: save_pwアクション - パスワード長チェック、小文字変換、保存、サブページ一括適用
- **61-70行目**: delete_pwアクション - 個別ページのパスワード削除
- **71-82行目**: delete_pw_allアクション - 対象ページとサブページのパスワード一括削除

#### Step 4: サブページ一括処理を理解する

再帰的なパスワード適用・削除を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | page.asp | `asp/includes/page.asp` | resetAllSubPasswords（978-992行目）、removeAllSubPasswords（993行目〜） |

**主要処理フロー**:
- **978-992行目**: resetAllSubPasswords - 再帰的にサブページのsPwを親と同じ値に設定
- **993行目以降**: removeAllSubPasswords - 再帰的にサブページのsPwを空に設定

### プログラム呼び出し階層図

```
bs_applyPW.asp（パスワード設定画面）
    │
    ├─ bs_security.asp [権限チェック: bPagesPW]
    ├─ bs_processPage.asp [保存処理]
    │      │
    │      ├─ save_pwアクション
    │      │      ├─ checkCSRF()
    │      │      ├─ パスワード長チェック（< 3文字でエラー）
    │      │      ├─ lcase() [小文字変換]
    │      │      ├─ cls_page.save()
    │      │      └─ resetAllSubPasswords()
    │      │             └─ [再帰処理]
    │      │                    ├─ 各サブページ.sPw = 親.sPw
    │      │                    ├─ save()
    │      │                    └─ resetAllSubPasswords(子ページID)
    │      │
    │      ├─ delete_pwアクション
    │      │      ├─ checkCSRF()
    │      │      ├─ sPw = ""
    │      │      └─ save()
    │      │
    │      └─ delete_pw_allアクション
    │             ├─ checkCSRF()
    │             ├─ sPw = ""
    │             ├─ save()
    │             └─ removeAllSubPasswords()
    │                    └─ [再帰処理]
    │
    └─ リダイレクト（bs_default.asp / bs_intranet.asp）
```

### データフロー図

```
[入力]                         [処理]                              [出力]

パスワード入力         ───▶  bs_applyPW.asp              ───▶  tblPage.sPw
アクション選択                (save_pw / delete_pw)              更新
                              │
                              ▼
                       bs_processPage.asp
                              │
                              ├─ 長さチェック
                              ├─ 小文字変換
                              └─ save()
                                    │
                                    ▼
                       resetAllSubPasswords() / removeAllSubPasswords()
                              │
                              ▼
                       [サブページ再帰処理]
                              │
                              ▼
                       メニューキャッシュクリア
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_applyPW.asp | `asp/bs_applyPW.asp` | ソース | パスワード設定画面 |
| bs_applyTotalPW.asp | `asp/bs_applyTotalPW.asp` | ソース | サイト全体パスワード設定 |
| bs_processPage.asp | `asp/bs_processPage.asp` | ソース | パスワード保存・削除処理 |
| page.asp | `asp/includes/page.asp` | ソース | resetAllSubPasswords/removeAllSubPasswords関数 |
| menu.asp | `asp/includes/menu.asp` | ソース | パスワード保護アイコン表示 |
| process_login.asp | `asp/process_login.asp` | ソース | フロントエンドでのパスワード認証 |
