# 機能設計書 16-ユーザーフレンドリーURL設定

## 概要

本ドキュメントは、QuickerSite CMSにおけるユーザーフレンドリーURL設定機能の設計について記述する。この機能により、SEOに配慮した人間が読みやすいURL形式を各ページに設定できる。

### 本機能の処理概要

ユーザーフレンドリーURL設定機能は、従来の`default.asp?iId=xxx`形式のURLに代わり、`/about-us`や`/products/widget`といった意味のあるURL形式を設定する機能である。

**業務上の目的・背景**：検索エンジン最適化（SEO）において、URLはページ内容を反映した分かりやすい形式であることが推奨される。また、ユーザーにとってもURLを見ただけでページの内容を推測でき、ソーシャルメディアでの共有時にも効果的である。本機能により、技術的なURLパラメータを隠し、ブランディングとSEOの両面でメリットを得られる。

**機能の利用シーン**：
- 製品ページに製品名を含むURLを設定する場合
- 会社概要ページに「about-us」のようなURLを設定する場合
- ブログ記事に記事タイトルを含むURLを設定する場合
- 多言語サイトで言語コードを含むURLを設定する場合

**主要な処理内容**：
1. sUserFriendlyURLフィールドへのURL設定
2. 新規ページ作成時のURLタイトルからの自動生成
3. URL重複チェック
4. 英数字・ハイフンのみの入力制限
5. フロントエンドでのURL解決とリダイレクト
6. アプリケーションキャッシュへのURL登録

**関連システム・外部連携**：なし

**権限による制御**：セカンドアドミン権限の`bPageUFL`および顧客設定`bUserFriendlyURL`により制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | コンテンツ付きアイテム編集 | 主機能 | ページ編集画面内でのURL設定 |
| 10 | リストアイテム編集 | 補助機能 | リストアイテムのURL設定 |
| 192 | URL設定 | 主機能 | URL設定・SEOフレンドリーURL管理 |

## 機能種別

CRUD操作（Create/Update） / SEO設定

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sUserFriendlyURL | String | No | ユーザーフレンドリーURL | 英数字・ハイフン・スラッシュのみ、最大50文字、重複不可 |

### 入力データソース

- 画面入力：ページ編集画面からのフォーム入力
- 自動生成：新規ページ作成時にタイトルから自動生成（bUserFriendlyURL=true かつ bCopy=false の場合）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sUserFriendlyURL | String | 設定されたURL |
| アクセスURL | URL | フロントエンドでのアクセス用URL |

### 出力先

- データベース：tblPageテーブルのsUserFriendlyURLカラム
- アプリケーションキャッシュ：QS_UFL_プレフィックス付きでページIDを保持

## 処理フロー

### 処理シーケンス

```
1. URL設定（管理画面）
   ├─ 入力値の正規化
   │   ├─ スペースをハイフンに変換
   │   ├─ 連続スラッシュを単一に
   │   ├─ 先頭・末尾のスラッシュを除去
   │   └─ 小文字に変換
   ├─ 重複チェック
   └─ 保存

2. 自動生成（新規ページ作成時）
   ├─ タイトルから生成
   ├─ 特殊文字の除去・置換
   ├─ 50文字に切り詰め
   └─ 小文字に変換

3. URL解決（フロントエンド）
   ├─ キャッシュ確認
   ├─ キャッシュヒットならページ表示
   ├─ キャッシュミスならDB検索
   ├─ 見つかればキャッシュに登録
   └─ 見つからなければ404またはホームページへリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{新規ページ?}
    B -->|Yes| C{bUserFriendlyURL有効?}
    B -->|No| D[既存URL表示]
    C -->|Yes| E[タイトルからURL自動生成]
    C -->|No| F[URL入力フィールド非表示]
    E --> G[特殊文字除去・置換]
    G --> H[小文字変換]
    H --> I[50文字に切り詰め]
    I --> D
    D --> J{保存?}
    J -->|No| K[キャンセル]
    J -->|Yes| L[入力値正規化]
    L --> M{英数字のみ?}
    M -->|No| N[エラー: 不正文字]
    M -->|Yes| O{重複チェック}
    O -->|重複| P[エラー: 重複URL]
    O -->|OK| Q[tblPage保存]
    Q --> R[UFLキャッシュクリア]
    R --> S[終了]
    N --> D
    P --> D
    K --> S
    F --> S
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-16-01 | 文字制限 | 英数字、ハイフン、スラッシュのみ使用可能（IsAlphaNumeric関数でチェック） | 保存時 |
| BR-16-02 | 長さ制限 | 最大50文字 | 保存時 |
| BR-16-03 | 重複禁止 | 同一顧客ID内で重複するURLは設定不可 | 保存時 |
| BR-16-04 | 自動生成 | 新規ページ作成時、タイトルからURLを自動生成（コピー時は除く） | 新規作成時 |
| BR-16-05 | 正規化 | スペースはハイフンに変換、連続ハイフンは単一に、先頭末尾のスラッシュは除去 | 保存時 |
| BR-16-06 | 小文字変換 | URLは全て小文字で保存される | 保存時 |
| BR-16-07 | コピー時クリア | ページコピー時はsUserFriendlyURLは空になる | コピー時 |

### 計算ロジック

**URL自動生成ロジック（forceUFL関数）**：
```
1. タイトルを取得
2. スペースをハイフンに置換
3. "?", "!", "'", を削除
4. "/" と "\" をハイフンに置換
5. 連続ハイフンを単一ハイフンに（最大7回繰り返し）
6. 末尾のハイフンを除去
7. IsAlphaNumericチェック
8. 50文字に切り詰め
9. 小文字に変換
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| URL設定 | tblPage | UPDATE | sUserFriendlyURLを更新 |
| URL解決 | tblPage | SELECT | URLからページIDを検索 |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sUserFriendlyURL | 正規化されたURL | 最大50文字 |
| SELECT | iId | sUserFriendlyURL一致条件 | フロントエンドでのURL解決 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_ufl | URL重複エラー | 同一URLが既に存在 | エラーメッセージを表示 |
| err_ufl_an | 不正文字エラー | 英数字以外の文字が含まれる | エラーメッセージを表示 |
| - | 404エラー | 存在しないURLにアクセス | カスタム404ページまたはホームページへリダイレクト |

### リトライ仕様

リトライは実装されていない。エラー発生時は入力画面に戻り、ユーザーに修正を促す。

## トランザクション仕様

明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- URL解決: キャッシュヒット時は即時（アプリケーションキャッシュ利用）
- キャッシュミス時: データベース検索（通常0.1秒以内）
- キャッシュ有効期限: アプリケーション再起動またはページ更新まで

## セキュリティ考慮事項

1. **入力検証**: IsAlphaNumeric関数による文字種制限
2. **SQLインジェクション対策**: パラメータクエリ使用
3. **パストラバーサル対策**: スラッシュの正規化処理

## 備考

- ユーザーフレンドリーURL機能はcustomer.bUserFriendlyURL設定で有効/無効を切り替え可能
- URLは顧客のベースURL（sVDUrl）からの相対パスとして設定される
- アプリケーションキャッシュには「QS_UFL_」プレフィックス付きでURLとページIDのマッピングが保存される
- ページ更新時にキャッシュはクリアされ、次回アクセス時に再登録される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーフレンドリーURLに関連するプロパティと検証ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | sUserFriendlyURLプロパティ、Check関数内のURL検証ロジック（384-412行目） |

**読解のコツ**: Check関数内でsUserFriendlyURLの正規化（スラッシュ除去、IsAlphaNumericチェック）と重複チェックが行われる。

#### Step 2: 自動生成ロジックを理解する

新規ページ作成時のURL自動生成を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page.asp | `asp/includes/page.asp` | forceUFL関数（84-114行目） |

**主要処理フロー**:
- **86-87行目**: 新規ページかつbCopyでない場合のみ実行
- **88行目**: bUserFriendlyURL有効確認
- **89-101行目**: タイトルからURL生成（特殊文字置換、連続ハイフン除去）
- **105-106行目**: IsAlphaNumericチェックと小文字変換

#### Step 3: 入力フィールドを理解する

編集画面でのURL入力フィールドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_url.asp | `asp/bs_url.asp` | URL入力フィールドの表示条件 |

**主要処理フロー**:
- **2行目**: customer.bUserFriendlyURLとsecondAdmin.bPageUFL両方の権限チェック
- **2行目**: sVDUrl（ベースURL）の表示と入力フィールド

#### Step 4: URL解決を理解する

フロントエンドでのURL解決処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | page.asp | `asp/includes/page.asp` | pickByUserFriendlyURL関数（115-237行目） |

**主要処理フロー**:
- **121-125行目**: クエリ文字列からURLを取得
- **126-132行目**: アプリケーションキャッシュ確認
- **200-218行目**: データベース検索とキャッシュ登録
- **222-230行目**: 404処理（カスタム404ページまたはホームページリダイレクト）

### プログラム呼び出し階層図

```
[管理画面]
bs_editItem.asp（ページ編集）
    │
    ├─ bs_url.asp [URL入力フィールド表示]
    │      └─ customer.bUserFriendlyURL
    │      └─ secondAdmin.bPageUFL
    │
    └─ bs_processPage.asp [保存処理]
           └─ cls_page.save()
                  ├─ forceUFL() [新規時の自動生成]
                  └─ Check() [検証]
                         ├─ 正規化処理
                         ├─ IsAlphaNumericチェック
                         └─ 重複チェック

[フロントエンド]
default.asp
    │
    └─ cls_page.pickByUserFriendlyURL()
           ├─ アプリケーションキャッシュ確認
           ├─ DB検索
           ├─ キャッシュ登録
           └─ 404処理
```

### データフロー図

```
[入力]                         [処理]                              [出力]

URL入力                ───▶  bs_url.asp                  ───▶  フォーム表示
（または自動生成）            │
                              ▼
                       cls_page.save()
                              │
                              ├─ forceUFL() [自動生成]
                              └─ Check() [検証]
                                    │
                                    ▼
                              tblPage.sUserFriendlyURL

[フロントエンドアクセス]

/about-us              ───▶  pickByUserFriendlyURL()    ───▶  ページ表示
                              │
                              ├─ キャッシュ確認
                              ├─ DB検索
                              └─ ページID取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_url.asp | `asp/bs_url.asp` | ソース | URL入力フィールド表示 |
| page.asp | `asp/includes/page.asp` | ソース | forceUFL、pickByUserFriendlyURL、Check関数 |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | ページ編集画面 |
| bs_editListItem.asp | `asp/bs_editListItem.asp` | ソース | リストアイテム編集画面 |
| default.asp | `default.asp` | ソース | フロントエンドエントリーポイント |
| functions.asp | `asp/includes/functions.asp` | ソース | IsAlphaNumeric関数 |
