# 機能設計書 17-ページプレビュー

## 概要

本ドキュメントは、QuickerSite CMSにおけるページプレビュー機能の設計について記述する。この機能により、管理者はページを公開する前にフロントエンドでの表示を確認できる。

### 本機能の処理概要

ページプレビュー機能は、管理画面から編集中のページをフロントエンドで表示確認する機能である。新しいウィンドウ（タブ）でプレビューページを開き、公開時と同様のレイアウト・スタイルで内容を確認できる。

**業務上の目的・背景**：コンテンツ管理において、公開前に最終的な表示を確認することは品質管理上不可欠である。特にWYSIWYGエディタで編集したコンテンツは、管理画面での表示とフロントエンドでの表示が異なる場合がある。本機能により、公開前に問題を発見し、修正することで、品質の高いコンテンツ提供が可能になる。

**機能の利用シーン**：
- ページ編集後に公開前の最終確認を行う場合
- テンプレート変更後の表示確認を行う場合
- 画像やメディアの配置を確認する場合
- リストページのアイテム表示を確認する場合

**主要な処理内容**：
1. 管理画面でのプレビューボタン/リンク表示
2. 新しいウィンドウでフロントエンドページを開く
3. ページIDを暗号化してURLパラメータとして渡す
4. フロントエンドでページをレンダリング

**関連システム・外部連携**：なし

**権限による制御**：ページ編集権限を持つユーザーのみプレビュー可能。特別な権限設定は不要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | プレビュー画面 | 主機能 | 公開前のページプレビュー表示 |
| 8 | コンテンツ付きアイテム編集 | 参照元 | プレビューボタン配置 |
| 10 | リストアイテム編集 | 参照元 | プレビューボタン配置 |

## 機能種別

表示機能 / プレビュー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iId | Integer（暗号化） | Yes | プレビュー対象ページID | 数値であること |
| iID | Integer（暗号化） | No | リストページID（リストアイテムプレビュー時） | 数値であること |
| item | Integer（暗号化） | No | リストアイテムID（リストアイテムプレビュー時） | 数値であること |

### 入力データソース

- 画面操作：管理画面のプレビューボタン/リンクのクリック
- URLパラメータ：暗号化されたページID

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| プレビューURL | URL | フロントエンドプレビュー用URL |
| ページHTML | String | レンダリングされたページコンテンツ |

### 出力先

- 新しいブラウザウィンドウ/タブ：フロントエンドでのページ表示

## 処理フロー

### 処理シーケンス

```
1. プレビューリンク生成（管理画面）
   ├─ ページIDを暗号化
   ├─ プレビューURL構築
   │   ├─ 通常ページ: default.asp?iID={暗号化ID}
   │   └─ リストアイテム: default.asp?iID={リストページID}&item={アイテムID}#アイテムID
   └─ target="_blank"属性でリンク生成

2. プレビュー表示（フロントエンド）
   ├─ URLパラメータからページIDを復号
   ├─ ページ情報を取得
   ├─ テンプレート適用
   ├─ コンテンツ展開
   └─ HTML出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[管理画面ページ編集]
    B --> C{ページID存在?}
    C -->|No| D[プレビューボタン非表示]
    C -->|Yes| E[プレビューリンク生成]
    E --> F{リストアイテム?}
    F -->|Yes| G[リストページ用URL生成]
    F -->|No| H[通常ページ用URL生成]
    G --> I[target=_blank リンク]
    H --> I
    I --> J[ユーザークリック]
    J --> K[新しいウィンドウで開く]
    K --> L[default.asp読み込み]
    L --> M[ページID復号]
    M --> N[ページ情報取得]
    N --> O[テンプレート適用]
    O --> P[コンテンツレンダリング]
    P --> Q[HTML出力]
    Q --> R[終了]
    D --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-17-01 | 新規ページ | 保存前の新規ページ（iId=0）はプレビュー不可 | ページIDが0または空の場合 |
| BR-17-02 | 新しいウィンドウ | プレビューは常に新しいウィンドウ/タブで開く | 常に適用 |
| BR-17-03 | リストアイテムアンカー | リストアイテムプレビュー時はアンカーリンクで該当アイテム位置へスクロール | リストアイテムの場合 |
| BR-17-04 | ユーザーフレンドリーURL優先 | ユーザーフレンドリーURLが設定されている場合はそちらを使用 | sUserFriendlyURLが設定済みの場合 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ取得 | tblPage | SELECT | プレビュー対象ページの情報取得 |

### テーブル別操作詳細

プレビュー機能はデータの読み取りのみを行い、更新は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ページ不存在 | 指定されたページIDが存在しない | 404エラーまたはホームページへリダイレクト |

### リトライ仕様

リトライは実装されていない。

## トランザクション仕様

読み取り専用のため、トランザクション制御は不要。

## パフォーマンス要件

- プレビュー表示: 通常のページ表示と同等（通常1秒以内）
- 新しいウィンドウのオープン: ブラウザ依存

## セキュリティ考慮事項

1. **パラメータ暗号化**: ページIDはencrypt関数で暗号化
2. **認証不要**: プレビューURLを知っていれば誰でもアクセス可能（ただしページのオンライン/オフライン設定は考慮されない場合がある）
3. **パスワード保護**: パスワード保護されたページもプレビューでは表示される（要確認）

## 備考

- プレビュー機能はオフラインページでも表示可能
- メディアボタンからは画像・ファイルの管理が可能
- リストアイテムのプレビューではアンカーリンクを使用して該当アイテム位置へスクロール
- ユーザーフレンドリーURLが設定されている場合は、そのURLでプレビューが開く

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: プレビューリンク生成を理解する

管理画面でのプレビューリンク生成を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_preview.asp | `asp/bs_preview.asp` | プレビューリンク生成ロジック |

**主要処理フロー**:
- **3行目**: ページIDが存在する場合の条件分岐
- **5行目**: メディアボタンリンク生成
- **7-8行目**: リストアイテムの場合のプレビューURL生成（アンカーリンク付き）
- **10-14行目**: 通常ページの場合のプレビューURL生成

**読解のコツ**: リストアイテム（iListPageID存在）と通常ページでURLの構造が異なる点に注意。

#### Step 2: リストページでのプレビューを理解する

リストページ管理画面でのプレビューリンクを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_listPage.asp | `asp/bs_listPage.asp` | リストアイテム一覧でのプレビューリンク生成 |

**主要処理フロー**:
- **49-53行目**: ユーザーフレンドリーURL設定状況による分岐
- **50行目**: 通常URL形式のプレビュー
- **52行目**: ユーザーフレンドリーURL形式のプレビュー

#### Step 3: フロントエンドでのページ表示を理解する

プレビュー時のフロントエンド処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | default.asp | `default.asp` | フロントエンドエントリーポイント |

**読解のコツ**: default.aspはプレビューと通常表示の両方で使用される。パラメータの有無でページを特定する。

### プログラム呼び出し階層図

```
[管理画面]
bs_editItem.asp / bs_editListItem.asp
    │
    └─ bs_preview.asp [プレビューリンク生成]
           │
           ├─ ページIDの暗号化 (encrypt)
           │
           └─ プレビューURL構築
                  │
                  ├─ 通常ページ: default.asp?iID={ID}
                  │
                  └─ リストアイテム: default.asp?iID={リストID}&item={アイテムID}

[フロントエンド]
default.asp
    │
    ├─ パラメータ復号 (decrypt)
    │
    ├─ cls_page.pick() [ページ情報取得]
    │
    └─ テンプレート適用・レンダリング
```

### データフロー図

```
[入力]                         [処理]                              [出力]

管理画面操作           ───▶  bs_preview.asp              ───▶  プレビューリンク
(プレビュークリック)          (URL生成)                          (target="_blank")
                              │
                              ▼
                       新しいウィンドウ
                              │
                              ▼
                       default.asp
                              │
                              ├─ パラメータ解析
                              ├─ ページ取得
                              └─ レンダリング
                                    │
                                    ▼
                              ページHTML表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_preview.asp | `asp/bs_preview.asp` | ソース | プレビューリンク生成コンポーネント |
| bs_editItem.asp | `asp/bs_editItem.asp` | ソース | ページ編集画面（プレビューリンク配置） |
| bs_editListItem.asp | `asp/bs_editListItem.asp` | ソース | リストアイテム編集画面 |
| bs_listPage.asp | `asp/bs_listPage.asp` | ソース | リストページ管理画面（プレビューリンク配置） |
| default.asp | `default.asp` | ソース | フロントエンドエントリーポイント |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス（表示処理） |
