# 機能設計書 18-コンテナページ管理

## 概要

本ドキュメントは、QuickerSite CMSにおけるコンテナページ管理機能の設計について記述する。コンテナページは、子ページをグループ化するための親ページとして機能し、サイトの階層構造を整理するために使用される。

### 本機能の処理概要

コンテナページ管理機能は、子ページを持つ親ページ（コンテナ）を作成・管理する機能である。コンテナページ自体にはコンテンツを持たず、メニュー上では子ページへのナビゲーションポイントとして機能する。

**業務上の目的・背景**：大規模なWebサイトでは、コンテンツを論理的にグループ化し、階層的なナビゲーションを提供することが重要である。例えば「製品情報」という親カテゴリの下に複数の製品ページを配置するような構造が必要になる。本機能により、コンテンツ自体を持たないカテゴリページを作成し、サイト構造を整理できる。

**機能の利用シーン**：
- 複数の関連ページをグループ化するカテゴリを作成する場合
- ドロップダウンメニューの親項目を設定する場合
- サイト構造のナビゲーション階層を整理する場合
- 製品カテゴリ、サービスカテゴリなどの分類ページを作成する場合

**主要な処理内容**：
1. コンテナページの作成（bContainerPage=true）
2. コンテナページのタイトル・設定編集
3. 子ページの追加・管理
4. 並び順設定
5. コンテンツ付きページへの変換
6. 外部URLページへの変換

**関連システム・外部連携**：なし

**権限による制御**：セカンドアドミン権限の`bPageBody`により、コンテナページ編集機能へのアクセスが制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | コンテナ編集 | 主機能 | 子ページを持つコンテナページの管理 |
| 183 | コンテナ変換 | 補助機能 | ページをコンテナアイテムに変換 |

## 機能種別

CRUD操作（Create/Update/Delete） / ページ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iId | Integer（暗号化） | No | コンテナページID（新規時はなし） | 数値であること |
| iParentID | Integer（暗号化） | No | 親ページID | 数値であること |
| sTitle | String | Yes | ページタイトル | 必須、最大100文字 |
| bContainerPage | Boolean | Yes | コンテナページフラグ | true固定（hidden） |
| iRang | Integer | No | メニュー内の表示順序 | 1以上の整数 |
| bOnline | Boolean | No | オンライン状態 | true/false |
| sCode | String | No | ページコード | 英大文字、重複不可 |
| btnaction | String | Yes | アクション種別 | "save"等 |
| QSSEC | String | Yes | CSRFトークン | 有効なセキュリティコード |

### 入力データソース

- 画面入力：コンテナ編集画面（bs_editContainer.asp）からのフォーム入力
- セッションデータ：ログイン管理者情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| コンテナページ | cls_page | コンテナページオブジェクト |
| リダイレクト先 | URL | 処理完了後の遷移先 |

### 出力先

- 画面表示：管理画面での編集フォーム
- フロントエンド：メニュー上での表示（ドロップダウン親項目等）
- データベース：tblPageテーブル

## 処理フロー

### 処理シーケンス

```
1. コンテナページ編集画面表示
   ├─ ページ情報読み込み
   ├─ bContainerPage=true（hidden）
   └─ 共通入力フィールド表示

2. 保存処理
   ├─ CSRF検証
   ├─ バリデーション
   │   └─ タイトル必須チェック
   ├─ bContainerPage=trueで保存
   └─ リダイレクト

3. 変換処理
   ├─ コンテンツ付きページへ変換（bs_convertToItemWithContent）
   └─ 外部URLページへ変換（bs_convertToExternalURL）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{新規作成?}
    B -->|Yes| C[コンテナ作成フォーム]
    B -->|No| D[既存コンテナ読み込み]
    C --> E[タイトル入力]
    D --> E
    E --> F[オプション設定]
    F --> G{保存?}
    G -->|No| H[キャンセル]
    G -->|Yes| I[CSRF検証]
    I --> J[バリデーション]
    J --> K{タイトルあり?}
    K -->|No| L[エラー: 必須項目]
    K -->|Yes| M[bContainerPage=true]
    M --> N[tblPage保存]
    N --> O[メニューキャッシュクリア]
    O --> P[リダイレクト]
    L --> E
    H --> Q[終了]
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-18-01 | コンテナ識別 | bContainerPage=trueのページはコンテナページとして扱われる | 常に適用 |
| BR-18-02 | コンテンツなし | コンテナページは本文（sValue）を持たない | 常に適用 |
| BR-18-03 | メニュー表示 | コンテナページはメニュー上でドロップダウンの親として表示される | フロントエンド表示時 |
| BR-18-04 | リンク無効 | パスワードが設定されていないコンテナページのリンクはクリック不可（cursor: default） | フロントエンド表示時 |
| BR-18-05 | ホームページ不可 | コンテナページはホームページに設定できない | ホームページ設定時 |
| BR-18-06 | 子ページ管理 | コンテナページからは子ページの追加が可能 | ページ追加時 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コンテナ作成 | tblPage | INSERT | 新規コンテナページレコード挿入 |
| コンテナ編集 | tblPage | UPDATE | コンテナページ情報更新 |
| コンテナ削除 | tblPage | UPDATE | bDeleted=true設定（論理削除） |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | bContainerPage | true | コンテナページ識別フラグ |
| INSERT/UPDATE | sTitle | ページタイトル | 必須 |
| INSERT/UPDATE | sValue | null/空 | コンテンツなし |
| INSERT/UPDATE | iRang | 表示順序 | 自動採番または手動設定 |
| INSERT/UPDATE | bOnline | オンライン状態 | Boolean |
| INSERT/UPDATE | sCode | ページコード | オプション |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 必須項目エラー | タイトルが未入力 | エラーメッセージを表示 |
| err_appCode | コード重複エラー | sCodeが他ページと重複 | エラーメッセージを表示 |
| - | CSRF検証エラー | セキュリティトークンが無効 | 処理中断 |

### リトライ仕様

リトライは実装されていない。エラー発生時は入力画面に戻り、ユーザーに修正を促す。

## トランザクション仕様

明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- 保存処理: 1秒以内
- メニュー表示: キャッシュ利用時は即時表示

## セキュリティ考慮事項

1. **CSRF対策**: checkCSRF()によるトークン検証
2. **権限チェック**: secondAdmin.bPageBody権限による制御（変換機能時）
3. **パラメータ暗号化**: IDパラメータの暗号化

## 備考

- コンテナページはメニュー上でアイコン（コンテナアイコン）付きで表示される
- 子ページを持つ通常ページをコンテナに変換することも可能
- コンテナページからコンテンツ付きページへの変換も可能
- パスワードが設定されたコンテナページはクリック可能（ログイン画面へ遷移）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コンテナページの識別方法とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page.asp | `asp/includes/page.asp` | bContainerPageプロパティの役割 |

**読解のコツ**: bContainerPage=trueのページがコンテナとして識別される。Check関数やSave関数でホームページ設定時の制約が確認できる。

#### Step 2: 編集画面を理解する

コンテナ編集画面の構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editContainer.asp | `asp/bs_editContainer.asp` | コンテナ編集フォームの構成 |

**主要処理フロー**:
- **4行目**: 共通処理のインクルード（bs_process, bs_processPage）
- **4行目**: bContainerPage=1のhidden input
- **4行目**: bs_commoncont.asp（共通入力フィールド）のインクルード
- **4行目**: bs_sortorder.asp（並び順）のインクルード
- **4行目**: 変換リンク（bs_convertToItemWithContent, bs_convertToExternalURL）

#### Step 3: メニュー表示を理解する

コンテナページのメニュー表示ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | page.asp | `asp/includes/page.asp` | getLinkプロパティ（891-903行目） |

**主要処理フロー**:
- **892行目**: bContainerPageかつsPw未設定の場合の処理
- **893行目**: クリック不可のリンク生成（cursor: default、onclick="javascript:return false;"）
- **898-901行目**: サブページがある場合の'subcontainer'クラス追加

#### Step 4: 変換機能を理解する

コンテナから他のページタイプへの変換を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_convertToContainerItem.asp | `asp/bs_convertToContainerItem.asp` | 通常ページからコンテナへの変換リンク |

**主要処理フロー**:
- **2行目**: 変換可能条件（iId存在、ホームページでない、bPageBody権限あり）

### プログラム呼び出し階層図

```
bs_editContainer.asp（コンテナ編集画面）
    │
    ├─ bs_process.asp [ページオブジェクト初期化]
    ├─ bs_processPage.asp [保存処理]
    │      ├─ checkCSRF()
    │      ├─ cls_page.getRequestValues()
    │      │      └─ bContainerPage = true
    │      ├─ cls_page.check()
    │      └─ cls_page.save()
    │             └─ bHomepage時はbContainerPage=false
    │
    ├─ bs_commoncont.asp [共通入力フィールド]
    │      └─ タイトル入力
    │
    ├─ bs_sortorder.asp [並び順設定]
    │
    ├─ bs_onlineOrNot.asp [オンライン設定]
    │
    └─ 変換リンク
           ├─ bs_convertToItemWithContent.asp
           └─ bs_convertToExternalURL.asp
```

### データフロー図

```
[入力]                         [処理]                              [出力]

タイトル               ───▶  bs_editContainer.asp        ───▶  tblPage
並び順設定                    (フォーム処理)                      (bContainerPage=true)
オンライン設定                │
                              ▼
                       bs_processPage.asp
                              │
                              └─ cls_page.save()
                                    │
                                    ▼
                              メニューキャッシュクリア

[フロントエンド表示]

メニュー生成           ───▶  cls_page.getLink           ───▶  <a>（クリック不可）
                              │                               または
                              └─ bContainerPage判定            ドロップダウン親
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editContainer.asp | `asp/bs_editContainer.asp` | ソース | コンテナ編集画面 |
| bs_convertToContainerItem.asp | `asp/bs_convertToContainerItem.asp` | ソース | コンテナへの変換リンク |
| bs_commoncont.asp | `asp/bs_commoncont.asp` | ソース | 共通入力フィールド（タイトル等） |
| bs_sortorder.asp | `asp/bs_sortorder.asp` | ソース | 並び順選択 |
| page.asp | `asp/includes/page.asp` | ソース | ページクラス（bContainerPage、getLink） |
| menu.asp | `asp/includes/menu.asp` | ソース | メニュー生成（コンテナアイコン表示） |
| bs_processPage.asp | `asp/bs_processPage.asp` | ソース | 保存処理 |
