# 機能設計書 2-管理者ログアウト

## 概要

本ドキュメントは、QuickerSite CMSの管理画面（バックサイト）からのログアウト機能について記述する。

### 本機能の処理概要

本機能は、管理者がCMSのバックサイト（管理画面）からログアウトするための機能を提供する。セッションの破棄、Cookie認証情報のクリア、キャッシュのクリアを行い、セキュアなログアウト処理を実現する。

**業務上の目的・背景**：管理画面での作業終了時や、共有端末での作業後に確実にセッションを終了させることで、不正アクセスを防止する。また、セカンドアドミンとメイン管理者の切り替えや、権限の異なるユーザーへの端末引き渡し時にも使用される。

**機能の利用シーン**：
- 管理作業終了時のセキュアなログアウト
- 共有端末での作業後のセッション終了
- 管理者アカウント切り替え時
- セキュリティ上の理由でのセッション強制終了

**主要な処理内容**：
1. logoffBO()メソッドによるバックオフィスログオフ処理
2. 認証Cookie情報のクリア
3. セカンドアドミン認証フラグのクリア
4. メイン管理者認証フラグのクリア
5. バックオフィスメニューキャッシュのクリア
6. ログイン画面へのリダイレクト

**関連システム・外部連携**：なし

**権限による制御**：認証済みユーザーのみがアクセス可能（bs_security.aspによるチェック）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | ログオフ画面 | 主画面 | バックサイトからのセッション終了・ログアウト処理 |
| 4 | 管理者ログオフ画面 | 主画面 | 管理者画面からのセッション終了・ログアウト処理 |

## 機能種別

セッション管理 / 認証終了処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| loggedoff | String | No | ログオフ完了フラグ（QueryString） | 空以外の値でログオフ完了画面を表示 |

### 入力データソース

- なし（セッション情報のみ使用）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Session(cId & "isAUTHENTICATED") | Boolean | 認証フラグをfalseに設定 |
| Session(cId & "isAUTHENTICATEDSecondAdmin") | Boolean | セカンドアドミン認証フラグをfalseに設定 |
| Cookie(cId & "hfsdsiiqqssdfjf") | String | 空文字列に設定 |

### 出力先

- セッション変数（認証状態のクリア）
- Cookie（認証情報のクリア）
- 画面リダイレクト（QS_backsite_login_page）

## 処理フロー

### 処理シーケンス

```
1. ログオフ画面アクセス
   └─ bs_security.aspによる認証チェック

2. loggedoff パラメータ確認
   └─ 空の場合：ログオフ処理実行
   └─ 値がある場合：ログオフ完了画面表示

3. ログオフ処理（loggedoff が空の場合）
   └─ logon.logoffBO() 呼び出し
      └─ FCK許可IPキャッシュのクリア
      └─ バックオフィスメニューキャッシュのクリア
      └─ Session.Abandon() によるセッション破棄
   └─ 認証Cookie のクリア
   └─ セカンドアドミン認証フラグのクリア
   └─ メイン認証フラグのクリア
   └─ ログイン画面へリダイレクト

4. ログオフ完了画面表示（loggedoff に値がある場合）
   └─ 「ログオフしました」メッセージ表示
   └─ 「再度ログイン」リンク表示
```

### フローチャート

```mermaid
flowchart TD
    A[ログオフ画面アクセス] --> B[bs_security.asp 認証チェック]
    B --> C{認証済み?}
    C -->|No| D[noaccess.htm へリダイレクト]
    C -->|Yes| E{loggedoff パラメータ}
    E -->|空| F[logon.logoffBO 呼び出し]
    F --> G[FCKキャッシュクリア]
    G --> H[BOメニューキャッシュクリア]
    H --> I[Session.Abandon]
    I --> J[認証Cookieクリア]
    J --> K[SecondAdmin認証フラグクリア]
    K --> L[メイン認証フラグクリア]
    L --> M[ログイン画面へリダイレクト]
    E -->|値あり| N[ログオフ完了メッセージ表示]
    N --> O[再ログインリンク表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | セッション完全破棄 | Session.Abandon()により全セッション情報を破棄 | 常時 |
| BR-02 | Cookie認証情報クリア | 認証用Cookieを空文字列に設定 | 常時 |
| BR-03 | キャッシュクリア | バックオフィスメニューキャッシュをクリア | 常時 |
| BR-04 | 両認証フラグクリア | メイン管理者とセカンドアドミン両方の認証フラグをクリア | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | - | ログオフ処理にエラーケースなし | - |

### リトライ仕様

なし（一度のアクセスで完結）

## トランザクション仕様

なし（データベース操作なし）

## パフォーマンス要件

- ログオフ処理: 即座に完了

## セキュリティ考慮事項

- セッション完全破棄によるセッションハイジャック対策
- Cookie認証情報のクリアによる認証情報漏洩防止
- キャッシュクリアによる情報残存防止

## 備考

- ログオフ完了後は自動的にログイン画面へリダイレクトされる
- loggedoffパラメータ付きでアクセスすると、ログオフ完了メッセージと再ログインリンクが表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログアウト処理で操作するセッション・Cookie情報を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LogonEdit.asp | `asp/includes/LogonEdit.asp` | セッション変数名の定義を確認（cId & "isAUTHENTICATED" など） |

**読解のコツ**: cId は顧客IDを表す定数で、マルチテナント対応のために全てのセッション・Cookie名のプレフィックスとして使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_logoff.asp | `asp/bs_logoff.asp` | ログオフ画面のメインファイル。全体で11行の短いファイル |

**主要処理フロー**:
1. **4行目**: bUseArtLoginTemplate=true でログイン用テンプレートを使用
2. **4行目**: bs_security.asp インクルードで認証チェック
3. **4-9行目**: loggedoff クエリストリングが空の場合のログオフ処理
4. **5行目**: logon.logoffBO() でバックオフィスログオフ
5. **6行目**: 認証Cookie のクリア
6. **7-8行目**: セッション認証フラグのクリア
7. **9行目**: ログイン画面へリダイレクト
8. **10行目**: ログオフ完了メッセージとリンク表示

#### Step 3: ログオフ処理クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LogonEdit.asp | `asp/includes/LogonEdit.asp` | logoffBO関数の実装 |

**主要処理フロー**:
- **183-188行目**: logoffBO関数
- **184行目**: FCK許可IPキャッシュのクリア
- **185-186行目**: バックオフィスメニューキャッシュのクリア（secondAdminとadminPassword両方）
- **187行目**: Session.Abandon() でセッション破棄

### プログラム呼び出し階層図

```
bs_logoff.asp
    │
    ├─ begin.asp（インクルード）
    │      └─ includes/LogonEdit.asp（認証クラス）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ includes/header.asp（HTMLヘッダー）
    │
    ├─ bs_initBack.asp（初期化）
    │
    ├─ bs_header.asp（バックサイトヘッダー）
    │
    ├─ logon.logoffBO()（ログオフ処理）
    │      ├─ Application キャッシュクリア
    │      └─ Session.Abandon()
    │
    └─ Response.Redirect（ログイン画面へ）
```

### データフロー図

```
[入力]               [処理]                    [出力]

なし ───────────▶ logon.logoffBO()
                         │
                    ┌────┴────┐
                    ▼         ▼
             Session.Abandon  Application
             (セッション破棄)   (キャッシュクリア)
                    │         │
                    └────┬────┘
                         ▼
                  Cookie クリア
                         │
                         ▼
                  認証フラグ = false
                         │
                         ▼
                  リダイレクト ─────▶ ログイン画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_logoff.asp | `asp/bs_logoff.asp` | ソース | ログオフ画面メインファイル |
| LogonEdit.asp | `asp/includes/LogonEdit.asp` | ソース | logoffBO関数定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証チェック処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化・インクルード管理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | バックサイトヘッダー表示 |
