# 機能設計書 20-バナーメニュー編集

## 概要

本ドキュメントは、QuickerSite CMSにおけるバナーメニュー編集機能の設計について記述する。バナーメニューは、サイト全体で表示されるバナー領域（左バナー、メニュー下バナー、右バナー）およびハイライト・連絡先情報を管理するための機能である。

### 本機能の処理概要

バナーメニュー編集機能は、サイト全体で共通表示されるバナーコンテンツとヘッダー情報を管理者が編集・更新する機能である。テンプレートのレイアウトに応じて、左サイドバー、メニュー下、右サイドバーの3つのバナー領域、およびコンタクト情報とハイライト情報を設定できる。

**業務上の目的・背景**：Webサイトにおいて、全ページに共通で表示するバナー広告やプロモーション情報、連絡先情報などは一元管理が必要である。本機能により、テンプレートを変更することなく、サイト全体のバナーコンテンツを効率的に更新できる。

**機能の利用シーン**：
- サイト全体に表示するバナー広告を設定・更新する場合
- サイドバーのプロモーションコンテンツを編集する場合
- ヘッダー部分の連絡先情報やハイライト情報を更新する場合
- 外部アプリケーションパスを設定する場合（bApplication有効時）

**主要な処理内容**：
1. 左バナー（sLeftBanner）の編集
2. メニュー下バナー（sBannerMenu）の編集
3. 右バナー（sRightBanner）の編集
4. ハイライト情報（sHighlights）の編集
5. 連絡先情報（sContactInfo）の編集
6. アプリケーションパス（bannerApplication）の設定

**関連システム・外部連携**：FCKEditor（WYSIWYGエディタ）によるリッチテキスト編集機能と連携。

**権限による制御**：セカンドアドミン権限の`bSetupPageElements`により、バナーメニュー編集画面へのアクセスが制御される。アプリケーションパス設定には追加で`bApplicationpath`権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 15 | バナーメニュー編集 | 主機能 | バナーおよびヘッダー情報の編集 |

## 機能種別

CRUD操作（Update） / サイト設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sLeftBanner | String | No | 左バナーのHTMLコンテンツ | なし |
| sBannerMenu | String | No | メニュー下バナーのHTMLコンテンツ | なし |
| sRightBanner | String | No | 右バナーのHTMLコンテンツ | なし |
| sHighlights | String | No | ハイライト情報（最大50文字） | 最大50文字 |
| sContactInfo | String | No | 連絡先情報（最大50文字） | 最大50文字 |
| bannerApplication | String | No | アプリケーションパス（最大255文字） | bApplicationpath権限要 |
| btnaction | String | Yes | アクション種別 | "save"等 |
| QSSEC | String | Yes | CSRFトークン | 有効なセキュリティコード |

### 入力データソース

- 画面入力：バナーメニュー編集画面（bs_editBannerMenu.asp）からのフォーム入力
- セッションデータ：ログイン管理者情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 保存結果 | Boolean | 保存成功/失敗 |
| メッセージ | String | 処理結果メッセージ（fb_saveOK） |

### 出力先

- 画面表示：管理画面での編集フォーム
- データベース：tblCustomerテーブル
- フロントエンド：テンプレート内での表示

## 処理フロー

### 処理シーケンス

```
1. バナーメニュー編集画面表示
   ├─ 権限チェック（bSetupPageElements）
   ├─ テンプレート判定（defaultTemplate）
   │   ├─ defaultTemplate=0: 3カラムレイアウト
   │   │   ├─ 左バナー、メニュー下バナー、右バナー
   │   │   └─ アプリケーションパス（bApplication時）
   │   └─ defaultTemplate≠0: 2カラムレイアウト
   │       └─ コンタクト情報、ハイライト、メニュー下、右バナー
   └─ 各バナー入力フィールド表示（WYSIWYGエディタ）

2. 保存処理
   ├─ CSRF検証
   ├─ バナーコンテンツ取得
   │   └─ removeEmptyP()で空段落除去
   ├─ テキスト情報取得（sHighlights, sContactInfo）
   ├─ アプリケーションパス取得（権限あり時）
   └─ customer.save()実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[権限チェック]
    B --> C{bSetupPageElements?}
    C -->|No| D[アクセス拒否]
    C -->|Yes| E{defaultTemplate=0?}
    E -->|Yes| F[3カラムレイアウト表示]
    E -->|No| G[2カラムレイアウト表示]
    F --> H[左/メニュー下/右バナー入力]
    G --> I[コンタクト/ハイライト/メニュー下/右バナー入力]
    H --> J{bApplication?}
    J -->|Yes| K[アプリケーションパス入力]
    J -->|No| L[保存ボタン待機]
    K --> L
    I --> L
    L --> M{保存ボタン?}
    M -->|No| N[編集継続]
    M -->|Yes| O[CSRF検証]
    O --> P[バナー値取得]
    P --> Q[removeEmptyP処理]
    Q --> R[customer.save]
    R --> S{保存成功?}
    S -->|No| T[エラー表示]
    S -->|Yes| U[成功メッセージ]
    N --> M
    T --> L
    U --> L
    D --> V[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-20-01 | テンプレート依存レイアウト | defaultTemplate=0の場合は3カラム、それ以外は2カラムレイアウト | 編集画面表示時 |
| BR-20-02 | アプリケーションパス制御 | bApplicationとbApplicationpath両方の条件を満たす場合のみ設定可能 | 編集画面表示時 |
| BR-20-03 | 空段落除去 | バナーコンテンツ保存時にremoveEmptyP()で空のPタグを除去 | 保存処理時 |
| BR-20-04 | テキスト文字数制限 | sHighlightsとsContactInfoは最大50文字 | 入力時 |

### 計算ロジック

なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| バナー保存 | tblCustomer | UPDATE | バナー関連カラムの更新 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sLeftBanner | フォーム入力値（サニタイズ済み） | 左バナー |
| UPDATE | sBannerMenu | フォーム入力値（サニタイズ済み） | メニュー下バナー |
| UPDATE | sRightBanner | フォーム入力値（サニタイズ済み） | 右バナー |
| UPDATE | sHighlights | フォーム入力値 | ハイライト情報 |
| UPDATE | sContactInfo | フォーム入力値 | 連絡先情報 |
| UPDATE | bannerApplication | フォーム入力値 | アプリケーションパス |
| UPDATE | dUpdatedTS | now() | 更新日時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CSRF検証エラー | セキュリティトークンが無効 | 処理中断 |
| - | 権限エラー | bSetupPageElements権限なし | アクセス拒否 |

### リトライ仕様

リトライは実装されていない。エラー発生時は入力画面に戻り、ユーザーに修正を促す。

## トランザクション仕様

明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- 保存処理: 1秒以内
- 画面表示: 1秒以内（WYSIWYGエディタのロード時間含む）

## セキュリティ考慮事項

1. **CSRF対策**: checkCSRF()によるトークン検証
2. **権限チェック**: secondAdmin.bSetupPageElements権限による制御
3. **追加権限チェック**: bannerApplicationはbApplicationpath権限が必要
4. **入力サニタイズ**: convertStr()およびremoveEmptyP()による入力処理

## 備考

- 3つのバナー領域すべてがWYSIWYGエディタ（FCKEditor）で編集可能
- テンプレートのdefaultTemplateプロパティによってレイアウトが自動切り替え
- defaultTemplate=0（旧テンプレート）の場合のみ左バナーが編集可能
- sHighlightsとsContactInfoはdefaultTemplate≠0の場合にテキスト入力欄として表示
- アプリケーションパスはFlashやその他の外部アプリケーション埋め込み用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バナーメニュー関連のプロパティ定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | sBannerMenu（4行目）, sLeftBanner/sRightBanner（12行目）, sContactInfo/sHighlights（14行目） |

**読解のコツ**: cls_customerクラスのプロパティがバナー情報を保持する。defaultTemplateの値によって使用するプロパティが異なる。

#### Step 2: 編集画面を理解する

バナーメニュー編集画面の構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editBannerMenu.asp | `asp/bs_editBannerMenu.asp` | 編集フォームの構造（1-15行目） |

**主要処理フロー**:
- **4行目**: 権限チェック（secondAdmin.bSetupPageElements）
- **5-6行目**: CSRF検証とボタンアクション判定
- **6-10行目**: バナー値の取得（removeEmptyP処理）
- **11行目**: アプリケーションパス取得（bApplicationpath権限時）
- **12行目**: customer.save()による保存
- **13行目**: defaultTemplate=0の場合のレイアウト（3カラム）
- **14行目**: defaultTemplate≠0の場合のレイアウト（2カラム）

#### Step 3: 保存処理を理解する

顧客データの保存処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | save関数でのバナー保存（353, 381, 389-390, 409-410行目） |

**主要処理フロー**:
- **353行目**: rs("sBannerMenu") = sBannerMenu
- **381行目**: rs("bannerApplication") = bannerApplication
- **389-390行目**: rs("sRightBanner"), rs("sLeftBanner")
- **409-410行目**: rs("sContactInfo"), rs("sHighlights")

### プログラム呼び出し階層図

```
bs_editBannerMenu.asp（バナーメニュー編集画面）
    │
    ├─ bs_security.asp [権限チェック]
    │      └─ logon.hasaccess secondAdmin.bSetupPageElements
    │
    ├─ 保存処理
    │      ├─ checkCSRF()
    │      ├─ removeEmptyP(convertStr(Request.Form))
    │      │      └─ sLeftBanner, sBannerMenu, sRightBanner取得
    │      ├─ convertStr(Request.Form)
    │      │      └─ sHighlights, sContactInfo取得
    │      ├─ 権限チェック（secondAdmin.bApplicationpath）
    │      │      └─ bannerApplication取得
    │      └─ cls_customer.save()
    │             └─ tblCustomer UPDATE
    │
    └─ フォーム表示
           ├─ defaultTemplate=0の場合
           │      ├─ createFCKInstance (sLeftBanner)
           │      ├─ createFCKInstance (sBannerMenu)
           │      ├─ createFCKInstance (sRightBanner)
           │      └─ bannerApplication入力欄（bApplication時）
           │
           └─ defaultTemplate≠0の場合
                  ├─ sContactInfo入力欄
                  ├─ sHighlights入力欄
                  ├─ createFCKInstance (sBannerMenu)
                  └─ createFCKInstance (sRightBanner)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

sLeftBanner            ───▶  bs_editBannerMenu.asp       ───▶  tblCustomer
sBannerMenu                   (保存処理)                         (バナー関連カラム)
sRightBanner                  │
sHighlights                   ├─ removeEmptyP()
sContactInfo                  └─ cls_customer.save()
bannerApplication

[フロントエンド表示]

テンプレート           ───▶  customer.プロパティ参照     ───▶  HTML出力
                              │
                              ├─ customer.sLeftBanner
                              ├─ customer.sBannerMenu
                              ├─ customer.sRightBanner
                              ├─ customer.sHighlights
                              └─ customer.sContactInfo
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editBannerMenu.asp | `asp/bs_editBannerMenu.asp` | ソース | バナーメニュー編集画面 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客クラス（バナープロパティ、save関数） |
| bs_header.asp | `asp/bs_header.asp` | ソース | 管理画面ヘッダー |
| bs_initBack.asp | `asp/bs_initBack.asp` | ソース | 管理画面初期化 |
