# 機能設計書 21-デフォルトブロック編集

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるデフォルトブロック編集機能の詳細設計を記載する。

### 本機能の処理概要

デフォルトブロック編集機能は、サイト全体で共通使用される8つのコンテンツブロック（PAGE_BLOCK01〜PAGE_BLOCK08）を管理者が編集・更新するための機能である。

**業務上の目的・背景**：Webサイトでは、ヘッダー、サイドバー、共通お知らせエリアなど、複数のページで共通して表示したいコンテンツが存在する。これらを個々のページに設定すると管理が煩雑になり、更新時に漏れが発生するリスクがある。本機能はサイト全体で共通利用できるコンテンツブロックを一元管理し、テンプレート内に[PAGE_BLOCK01]〜[PAGE_BLOCK08]の変数として埋め込むことで、効率的なコンテンツ管理を実現する。

**機能の利用シーン**：管理者がサイト全体の共通要素（お知らせバナー、共通リンク、広告枠、連絡先情報など）を設定・更新する際に使用される。テンプレートをカスタマイズする際に、動的に変更可能なコンテンツ領域を追加したい場合にも活用される。

**主要な処理内容**：
1. 認証・権限チェック（secondAdmin.bSetupPageElements権限の確認）
2. 保存ボタン押下時のCSRFトークン検証
3. 8つのブロック（sProp01〜sProp08）の入力値取得とサニタイズ処理
4. customerオブジェクトへの値設定と保存処理
5. WYSIWYGエディタ（FCKEditor）を使用した一部ブロックのリッチテキスト編集機能

**関連システム・外部連携**：FCKEditorによるリッチテキスト編集機能と連携。テンプレートエンジンが[PAGE_BLOCKXX]変数を解釈して表示に反映。

**権限による制御**：secondAdmin.bSetupPageElements権限を持つユーザーのみがアクセス可能。この権限がない場合はアクセス拒否される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 193 | プロパティ編集 | 主画面 | ページプロパティの編集メイン画面 |

## 機能種別

CRUD操作（更新処理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| btnaction | String | Yes | アクション種別（保存時は多言語ラベル"save"の値） | l("save")との一致確認 |
| sProp01 | String | No | デフォルトブロック01の内容 | removeEmptyP、convertStrによるサニタイズ |
| sProp02 | String | No | デフォルトブロック02の内容（WYSIWYGエディタ） | removeEmptyP、convertStrによるサニタイズ |
| sProp03 | String | No | デフォルトブロック03の内容 | removeEmptyP、convertStrによるサニタイズ |
| sProp04 | String | No | デフォルトブロック04の内容（WYSIWYGエディタ） | removeEmptyP、convertStrによるサニタイズ |
| sProp05 | String | No | デフォルトブロック05の内容 | removeEmptyP、convertStrによるサニタイズ |
| sProp06 | String | No | デフォルトブロック06の内容（WYSIWYGエディタ） | removeEmptyP、convertStrによるサニタイズ |
| sProp07 | String | No | デフォルトブロック07の内容 | removeEmptyP、convertStrによるサニタイズ |
| sProp08 | String | No | デフォルトブロック08の内容（WYSIWYGエディタ） | removeEmptyP、convertStrによるサニタイズ |
| QSSEC | String | Yes | CSRFトークン | checkCSRF()による検証 |

### 入力データソース

画面入力（フォームからのPOSTリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.sProp01〜sProp08 | String | 更新されたデフォルトブロックの内容 |
| message | String | 保存成功時のフィードバックメッセージ "fb_saveOK" |

### 出力先

- データベース（customerテーブルの各sPropカラム）
- 画面表示（成功メッセージの表示）

## 処理フロー

### 処理シーケンス

```
1. ページアクセス
   └─ begin.asp、bs_security.aspのインクルードによる初期化
2. 権限チェック
   └─ logon.hasaccess secondAdmin.bSetupPageElementsで権限確認
3. POSTリクエスト判定
   └─ request("btnaction")がl("save")と一致するか確認
4. CSRFトークン検証
   └─ checkCSRF()関数による検証
5. 入力値取得・サニタイズ
   └─ removeEmptyP、convertStrによる各ブロックの値処理
6. データ保存
   └─ customer.saveによるデータベース保存
7. 結果表示
   └─ 保存成功時にmessage.Add("fb_saveOK")
```

### フローチャート

```mermaid
flowchart TD
    A[ページアクセス] --> B{権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D{保存ボタン押下?}
    D -->|No| E[編集フォーム表示]
    D -->|Yes| F[CSRFトークン検証]
    F --> G[入力値取得・サニタイズ]
    G --> H[customerオブジェクトに設定]
    H --> I[customer.save実行]
    I --> J{保存成功?}
    J -->|Yes| K[成功メッセージ追加]
    J -->|No| L[エラー表示]
    K --> E
    L --> E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-21-01 | 権限制御 | bSetupPageElements権限を持つユーザーのみ編集可能 | 全操作時 |
| BR-21-02 | CSRF保護 | 保存時は必ずCSRFトークンを検証 | 保存実行時 |
| BR-21-03 | 空タグ削除 | 空のPタグを削除してから保存 | 入力値処理時 |
| BR-21-04 | ブロック継承 | 各ページはデフォルトブロックを継承または上書き可能 | テンプレート表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 保存 | customer | UPDATE | sProp01〜sProp08カラムの更新 |

### テーブル別操作詳細

#### customerテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sProp01 | フォーム入力値（サニタイズ済） | テキストエリア入力 |
| UPDATE | sProp02 | フォーム入力値（サニタイズ済） | FCKEditor入力 |
| UPDATE | sProp03 | フォーム入力値（サニタイズ済） | テキストエリア入力 |
| UPDATE | sProp04 | フォーム入力値（サニタイズ済） | FCKEditor入力 |
| UPDATE | sProp05 | フォーム入力値（サニタイズ済） | テキストエリア入力 |
| UPDATE | sProp06 | フォーム入力値（サニタイズ済） | FCKEditor入力 |
| UPDATE | sProp07 | フォーム入力値（サニタイズ済） | テキストエリア入力 |
| UPDATE | sProp08 | フォーム入力値（サニタイズ済） | FCKEditor入力 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bSetupPageElements権限なし | アクセス拒否画面へリダイレクト |
| - | CSRFエラー | CSRFトークン不一致 | checkCSRF()でエラー処理 |

### リトライ仕様

特になし（ユーザーが再度保存操作を行う）

## トランザクション仕様

customer.save()メソッド内でトランザクション管理。保存失敗時はロールバック。

## パフォーマンス要件

一般的なフォーム送信処理のため、特別な要件なし。

## セキュリティ考慮事項

- CSRF対策: QS_secCodeHiddenによるトークン埋め込みとcheckCSRF()による検証
- XSS対策: quotrep()による出力時エスケープ、convertStr()による入力時サニタイズ
- 権限制御: secondAdmin.bSetupPageElements権限による制限
- セッション管理: bs_security.aspによるログイン状態確認

## 備考

- 奇数番号のブロック（01,03,05,07）はプレーンテキストエリア
- 偶数番号のブロック（02,04,06,08）はFCKEditorによるリッチテキスト編集

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

customerオブジェクトがデフォルトブロックのデータを保持する構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | begin.asp | `asp/begin.asp` | customerオブジェクトの初期化方法 |

**読解のコツ**: Classic ASPのinclude構文により、begin.aspで基本的なオブジェクトが初期化される。customerオブジェクトはサイト設定全般を保持する中核オブジェクト。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editProps.asp | `asp/bs_editProps.asp` | メイン処理ファイル、フォーム表示と保存処理 |

**主要処理フロー**:
1. **4行目**: bs_security.aspインクルード後、権限チェック `logon.hasaccess secondAdmin.bSetupPageElements`
2. **4行目**: `if request("btnaction")=l("save") then` で保存処理分岐
3. **5行目**: `checkCSRF()` でCSRFトークン検証
4. **6-13行目**: 8つのsPropフィールドへの値設定（removeEmptyP、convertStrでサニタイズ）
5. **14行目**: `customer.save` による保存と成功メッセージ追加

#### Step 3: セキュリティ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | 認証・権限チェックの実装 |

**主要処理フロー**:
- 認証状態の確認とlogonオブジェクトの初期化
- hasaccessメソッドによる権限制御

### プログラム呼び出し階層図

```
bs_editProps.asp
    │
    ├─ begin.asp（初期化処理）
    │      └─ customerオブジェクト初期化
    │
    ├─ bs_security.asp（認証・権限）
    │      └─ logon.hasaccess()
    │
    ├─ includes/header.asp（HTMLヘッダー）
    │
    ├─ bs_initBack.asp（バックオフィス初期化）
    │
    ├─ bs_header.asp（ナビゲーション）
    │      ├─ getBOHeader()
    │      └─ getBOSetupMenu()
    │
    ├─ checkCSRF()（CSRF検証）
    │
    ├─ removeEmptyP()（空タグ削除）
    │
    ├─ convertStr()（文字列変換）
    │
    ├─ customer.save()（データ保存）
    │
    └─ createFCKInstance()（WYSIWYGエディタ生成）
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ removeEmptyP() ───▶ customer.sPropXX
(sProp01-08)        convertStr()           │
                                           ▼
                                    customer.save()
                                           │
                                           ▼
                                    データベース保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editProps.asp | `asp/bs_editProps.asp` | ソース | メイン処理ファイル |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| includes/header.asp | `asp/includes/header.asp` | インクルード | HTMLヘッダー出力 |
| bs_initBack.asp | `asp/bs_initBack.asp` | インクルード | バックオフィス初期化 |
| bs_header.asp | `asp/bs_header.asp` | インクルード | ナビゲーション |
| bs_endBack.asp | `asp/bs_endBack.asp` | インクルード | フッター処理 |
| includes/footer.asp | `asp/includes/footer.asp` | インクルード | HTMLフッター出力 |
