# 機能設計書 22-フッター編集

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるサイト共通フッター編集機能の詳細設計を記載する。

### 本機能の処理概要

フッター編集機能は、サイト全体で共通して表示されるフッターコンテンツを管理者がWYSIWYGエディタを使用して編集・更新するための機能である。

**業務上の目的・背景**：Webサイトのフッターは、コピーライト表記、連絡先情報、サイトマップリンク、プライバシーポリシーへのリンクなど、全ページで共通して表示される重要な情報を含む領域である。本機能により、HTMLの知識がなくても視覚的にフッターコンテンツを編集でき、変更が即座にサイト全体に反映される。これにより、運用担当者の作業効率が向上し、サイトの一貫性を維持できる。

**機能の利用シーン**：コピーライト年の更新、連絡先情報の変更、新しいリンクの追加、季節やキャンペーンに応じたフッターメッセージの変更など、フッター領域のコンテンツを更新する際に使用される。

**主要な処理内容**：
1. 認証・権限チェック（secondAdmin.bSetupPageElements権限の確認）
2. 保存ボタン押下時のCSRFトークン検証
3. フッターコンテンツ（sFooter）の入力値取得とサニタイズ処理
4. customerオブジェクトへの値設定と保存処理
5. FCKEditor（WYSIWYGエディタ）を使用したリッチテキスト編集インターフェース

**関連システム・外部連携**：FCKEditorによるリッチテキスト編集機能と連携。テンプレートエンジンが[FOOTER]変数または専用のフッター表示領域でコンテンツを表示。

**権限による制御**：secondAdmin.bSetupPageElements権限を持つユーザーのみがアクセス可能。この権限がない場合はアクセス拒否される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 90 | フッター編集 | 主画面 | サイト共通フッターの編集メイン画面 |

## 機能種別

CRUD操作（更新処理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| btnaction | String | Yes | アクション種別（保存時は多言語ラベル"save"の値） | l("save")との一致確認 |
| sFooter | String | No | フッターコンテンツ（HTML形式） | convertStrによるサニタイズ |
| QSSEC | String | Yes | CSRFトークン | checkCSRF()による検証 |

### 入力データソース

画面入力（フォームからのPOSTリクエスト、FCKEditorによるリッチテキスト入力）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.sFooter | String | 更新されたフッターコンテンツ |
| message | String | 保存成功時のフィードバックメッセージ "fb_saveOK" |

### 出力先

- データベース（customerテーブルのsFooterカラム）
- 画面表示（成功メッセージの表示）

## 処理フロー

### 処理シーケンス

```
1. ページアクセス
   └─ begin.asp、bs_security.aspのインクルードによる初期化
2. 権限チェック
   └─ logon.hasaccess secondAdmin.bSetupPageElementsで権限確認
3. POSTリクエスト判定
   └─ request("btnaction")がl("save")と一致するか確認
4. CSRFトークン検証
   └─ checkCSRF()関数による検証
5. 入力値取得・サニタイズ
   └─ convertStrによるフッターコンテンツの値処理
6. データ保存
   └─ customer.saveによるデータベース保存
7. 結果表示
   └─ 保存成功時にmessage.Add("fb_saveOK")
```

### フローチャート

```mermaid
flowchart TD
    A[ページアクセス] --> B{権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D{保存ボタン押下?}
    D -->|No| E[編集フォーム表示]
    D -->|Yes| F[CSRFトークン検証]
    F --> G[入力値取得・サニタイズ]
    G --> H[customer.sFooterに設定]
    H --> I[customer.save実行]
    I --> J{保存成功?}
    J -->|Yes| K[成功メッセージ追加]
    J -->|No| L[エラー表示]
    K --> E
    L --> E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-22-01 | 権限制御 | bSetupPageElements権限を持つユーザーのみ編集可能 | 全操作時 |
| BR-22-02 | CSRF保護 | 保存時は必ずCSRFトークンを検証 | 保存実行時 |
| BR-22-03 | HTML許可 | フッターコンテンツはHTMLタグを含むことができる | 入力時 |
| BR-22-04 | 全ページ適用 | 保存されたフッターは全ページで共通表示される | 表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 保存 | customer | UPDATE | sFooterカラムの更新 |

### テーブル別操作詳細

#### customerテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sFooter | フォーム入力値（サニタイズ済） | FCKEditor入力、HTML形式 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bSetupPageElements権限なし | アクセス拒否画面へリダイレクト |
| - | CSRFエラー | CSRFトークン不一致 | checkCSRF()でエラー処理 |

### リトライ仕様

特になし（ユーザーが再度保存操作を行う）

## トランザクション仕様

customer.save()メソッド内でトランザクション管理。保存失敗時はロールバック。

## パフォーマンス要件

一般的なフォーム送信処理のため、特別な要件なし。

## セキュリティ考慮事項

- CSRF対策: QS_secCodeHiddenによるトークン埋め込みとcheckCSRF()による検証
- XSS対策: quotrep()による出力時エスケープ、convertStr()による入力時サニタイズ
- 権限制御: secondAdmin.bSetupPageElements権限による制限
- セッション管理: bs_security.aspによるログイン状態確認
- HTML入力: フッターはリッチテキストのためHTMLタグを許可するが、危険なスクリプトタグ等はサニタイズ対象

## 備考

- フッターの表示位置はテンプレートの設計に依存する
- FCKEditorの設定は"siteBuilderFooter"プロファイルを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

customerオブジェクトがフッターデータを保持する構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | begin.asp | `asp/begin.asp` | customerオブジェクトの初期化方法 |

**読解のコツ**: Classic ASPのinclude構文により、begin.aspで基本的なオブジェクトが初期化される。customer.sFooterプロパティがフッターコンテンツを保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_editFooter.asp | `asp/bs_editFooter.asp` | メイン処理ファイル、フォーム表示と保存処理 |

**主要処理フロー**:
1. **4行目**: bs_security.aspインクルード後、権限チェック `logon.hasaccess secondAdmin.bSetupPageElements`
2. **4行目**: `if request("btnaction")=l("save") then` で保存処理分岐
3. **5行目**: `checkCSRF()` でCSRFトークン検証
4. **6行目**: `customer.sFooter=convertStr(Request.Form ("sFooter"))` でフッター値設定
5. **7行目**: `customer.save` による保存と成功メッセージ追加
6. **8行目**: `createFCKInstance customer.sFooter,"siteBuilderFooter","sFooter"` でWYSIWYGエディタ生成

#### Step 3: エディタ設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | createFCKInstance関数 | `asp/includes/`内 | FCKEditorの初期化設定 |

**主要処理フロー**:
- "siteBuilderFooter"プロファイルによるエディタ設定
- sFooterフィールドへのコンテンツバインディング

### プログラム呼び出し階層図

```
bs_editFooter.asp
    │
    ├─ begin.asp（初期化処理）
    │      └─ customerオブジェクト初期化
    │
    ├─ bs_security.asp（認証・権限）
    │      └─ logon.hasaccess()
    │
    ├─ includes/header.asp（HTMLヘッダー）
    │
    ├─ bs_initBack.asp（バックオフィス初期化）
    │
    ├─ bs_header.asp（ナビゲーション）
    │      ├─ getBOHeader()
    │      └─ getBOSetupMenu()
    │
    ├─ checkCSRF()（CSRF検証）
    │
    ├─ convertStr()（文字列変換）
    │
    ├─ customer.save()（データ保存）
    │
    └─ createFCKInstance()（WYSIWYGエディタ生成）
```

### データフロー図

```
[入力]               [処理]                    [出力]

FCKEditor入力 ───▶ convertStr() ───▶ customer.sFooter
(sFooter)                              │
                                       ▼
                                customer.save()
                                       │
                                       ▼
                                データベース保存
                                       │
                                       ▼
                                全ページのフッター表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_editFooter.asp | `asp/bs_editFooter.asp` | ソース | メイン処理ファイル |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| includes/header.asp | `asp/includes/header.asp` | インクルード | HTMLヘッダー出力 |
| bs_initBack.asp | `asp/bs_initBack.asp` | インクルード | バックオフィス初期化 |
| bs_header.asp | `asp/bs_header.asp` | インクルード | ナビゲーション |
| bs_endBack.asp | `asp/bs_endBack.asp` | インクルード | フッター処理 |
| includes/footer.asp | `asp/includes/footer.asp` | インクルード | HTMLフッター出力 |
