# 機能設計書 23-ファビコン管理

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるサイトファビコン管理機能の詳細設計を記載する。

### 本機能の処理概要

ファビコン管理機能は、Webサイトのブラウザタブやブックマークに表示される小さなアイコン（favicon.ico）をアップロード・設定・削除するための機能である。

**業務上の目的・背景**：ファビコンはWebサイトのブランディングにおいて重要な要素であり、ブラウザのタブ、ブックマーク、検索結果など様々な場所でサイトを識別するために使用される。本機能により、管理者は技術的な知識なしにファビコンを設定・更新でき、サイトの視認性とブランド認知度を向上させることができる。

**機能の利用シーン**：新規サイト構築時のファビコン初期設定、ブランドロゴ変更に伴うファビコン更新、季節イベントに合わせた一時的なファビコン変更などの際に使用される。

**主要な処理内容**：
1. 認証・権限チェック（secondAdmin.bSetupPageElements権限の確認）
2. 現在のファビコン状態の表示（設定済み/未設定）
3. ICO形式ファイルのアップロード処理
4. ファイル形式・サイズのバリデーション
5. 既存ファビコンの削除処理
6. customerオブジェクトの状態更新と保存

**関連システム・外部連携**：FreeASPUploadコンポーネントによるファイルアップロード処理。ファイルシステムへのファイル保存。

**権限による制御**：secondAdmin.bSetupPageElements権限を持つユーザーのみがアクセス可能。この権限がない場合はアクセス拒否される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 79 | ファビコン設定 | 主画面 | サイトのファビコン設定画面 |
| 80 | ファビコンアップロード | 補助画面 | ファビコンファイルのアップロード処理 |

## 機能種別

ファイル管理 / CRUD操作（作成・削除）

## 入力仕様

### 入力パラメータ

#### ファビコン設定画面（bs_favicon.asp）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| btnaction | String | No | アクション種別（削除時は"removeFavicon"） | 固定値との一致確認 |
| QSSEC | String | Yes（削除時） | CSRFトークン | checkCSRF()による検証 |

#### ファビコンアップロード（bs_faviconUpload.asp）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| favicon | File | Yes | アップロードするICOファイル | 拡張子がICOであること |
| QSSEC | String | Yes | CSRFトークン | checkCSRF_Upload()による検証 |

### 入力データソース

- 画面入力（ファイル選択ダイアログ）
- multipart/form-dataによるファイルアップロード

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| favicon.ico | File | アップロードされたファビコンファイル |
| customer.hasFavicon | Boolean | ファビコン設定状態フラグ |
| strMessage | String | エラーメッセージ（エラー発生時） |

### 出力先

- ファイルシステム（userfilesディレクトリ/favicon.ico）
- データベース（customerテーブルのhasFaviconカラム）
- 画面リダイレクト（処理結果に応じた遷移）

## 処理フロー

### 処理シーケンス（アップロード処理）

```
1. ページアクセス
   └─ begin.asp、bs_security.aspのインクルードによる初期化
2. アップロードディレクトリパス取得
   └─ server.MapPath()でuserfilesディレクトリのパス取得
3. FreeASPUploadオブジェクト初期化
   └─ Upload.Save()でファイル受信
4. CSRFトークン検証
   └─ checkCSRF_Upload()関数による検証
5. アップロードファイル検証
   ├─ 拡張子チェック（.icoのみ許可）
   └─ ファイルサイズチェック（20KB以下）
6. バリデーション結果判定
   ├─ エラーあり: ファイル削除、エラーページへリダイレクト
   └─ エラーなし: ファイル名をfavicon.icoに変更
7. 状態更新
   └─ customer.hasFavicon=true、customer.save()
8. 結果画面へリダイレクト
   └─ bs_favicon.aspへ遷移
```

### 処理シーケンス（削除処理）

```
1. ページアクセス
   └─ bs_process.aspでbtnaction="removeFavicon"判定
2. CSRFトークン検証
   └─ checkCSRF()関数による検証
3. ファイル削除
   └─ FileSystemObjectでfavicon.icoを削除
4. 状態更新
   └─ customer.hasFavicon=false、customer.save()
```

### フローチャート

```mermaid
flowchart TD
    A[ファビコン設定画面アクセス] --> B{権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[現在の設定状態表示]
    D --> E{アクション選択}
    E -->|アップロード| F[ファイル選択・送信]
    E -->|削除| G{確認ダイアログ}
    E -->|表示のみ| D

    F --> H[bs_faviconUpload.asp]
    H --> I[CSRFトークン検証]
    I --> J{拡張子チェック}
    J -->|ICO以外| K[エラー: err_ICO_file]
    J -->|ICO| L{サイズチェック}
    L -->|20KB超| M[エラー: err_ICO_fileSize]
    L -->|20KB以下| N[favicon.icoにリネーム]
    N --> O[customer.hasFavicon=true]
    O --> P[customer.save]
    P --> Q[bs_favicon.aspへリダイレクト]
    K --> R[ファイル削除]
    M --> R
    R --> S[エラー画面へリダイレクト]

    G -->|Yes| T[bs_process.asp]
    G -->|No| D
    T --> U[CSRFトークン検証]
    U --> V[favicon.ico削除]
    V --> W[customer.hasFavicon=false]
    W --> X[customer.save]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-23-01 | 権限制御 | bSetupPageElements権限を持つユーザーのみ操作可能 | 全操作時 |
| BR-23-02 | CSRF保護 | ファイルアップロード・削除時は必ずCSRFトークンを検証 | アップロード・削除時 |
| BR-23-03 | ファイル形式制限 | ICO形式のファイルのみアップロード可能 | アップロード時 |
| BR-23-04 | ファイルサイズ制限 | ファイルサイズは20KB以下 | アップロード時 |
| BR-23-05 | ファイル名固定 | アップロードされたファイルはfavicon.icoに自動リネーム | アップロード時 |
| BR-23-06 | 単一ファビコン | サイトには1つのファビコンのみ設定可能（上書き） | アップロード時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| アップロード成功 | customer | UPDATE | hasFavicon=trueに更新 |
| 削除 | customer | UPDATE | hasFavicon=falseに更新 |

### テーブル別操作詳細

#### customerテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | hasFavicon | true | アップロード成功時 |
| UPDATE | hasFavicon | false | 削除時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_ICO_file | ファイル形式エラー | ICO以外のファイルをアップロード | ICO形式ファイルを選択するよう案内 |
| err_ICO_fileSize | ファイルサイズエラー | 20KBを超えるファイル | ファイルサイズを小さくするよう案内 |
| err_newFile | ファイル未選択エラー | ファイルが選択されていない | ファイルを選択するよう案内 |
| - | 権限エラー | bSetupPageElements権限なし | アクセス拒否画面へリダイレクト |

### リトライ仕様

特になし（ユーザーが適切なファイルで再アップロード）

## トランザクション仕様

ファイルアップロードとcustomer.save()は順次実行。ファイルアップロード成功後にcustomer.save()が失敗した場合、ファイルは残るがhasFaviconフラグは更新されない可能性がある。

## パフォーマンス要件

- ファイルサイズ上限: 20KB
- アップロード処理は同期的に完了

## セキュリティ考慮事項

- CSRF対策: QS_secCodeHiddenによるトークン埋め込みとcheckCSRF_Upload()による検証
- ファイル形式制限: ICO形式のみに制限することで不正なファイルのアップロードを防止
- ファイルサイズ制限: DoS攻撃防止のため20KB上限
- 権限制御: secondAdmin.bSetupPageElements権限による制限
- ファイル名固定: ユーザー指定のファイル名を使用せず、固定名（favicon.ico）に変更

## 備考

- ファビコンはブラウザキャッシュの影響で即時反映されない場合がある
- IrfanViewなどのツールでICO形式への変換が可能（画面内でリンク案内あり）
- Wikipediaへのファビコン説明リンクを提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

customerオブジェクトがファビコン状態を保持する構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | begin.asp | `asp/begin.asp` | customerオブジェクトの初期化、hasFaviconプロパティ |

**読解のコツ**: customer.hasFaviconはBoolean型で、ファビコンの設定有無を管理する。

#### Step 2: 表示画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_favicon.asp | `asp/bs_favicon.asp` | ファビコン設定画面、現在状態の表示 |

**主要処理フロー**:
1. **4行目**: 権限チェック `logon.hasaccess secondAdmin.bSetupPageElements`
2. **7行目**: `convertBool(customer.hasFavicon)`で現在の設定状態を確認
3. **7行目**: 設定済みの場合は現在のファビコン画像を表示
4. **7行目**: 新規ファイルアップロードフォーム（multipart/form-data）
5. **7行目**: 削除リンク（設定済みの場合のみ表示）

#### Step 3: アップロード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_faviconUpload.asp | `asp/bs_faviconUpload.asp` | ファイルアップロード処理 |

**主要処理フロー**:
1. **4-5行目**: uploadsDirVar設定、FreeASPUpload初期化
2. **6-8行目**: Upload.Save()でファイル受信
3. **9行目**: `checkCSRF_Upload(Upload.form("QSSEC"))`でCSRF検証
4. **14行目**: 拡張子チェック（`GetFileExtension()`でICO確認）
5. **17行目**: サイズチェック（20000バイト=約20KB以下）
6. **21行目**: バリデーションエラー時はファイル削除
7. **24行目**: `Upload.UploadedFiles(fileKey).rename "favicon.ico"`でリネーム
8. **31-32行目**: `customer.hasFavicon=true`、`customer.save`

#### Step 4: 削除処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_process.asp | `asp/bs_process.asp` | 削除処理（removeFaviconアクション） |

**主要処理フロー**:
- **93-102行目**: `case "removeFavicon"`
  - checkCSRF()でトークン検証
  - FileSystemObjectでファイル存在確認・削除
  - customer.hasFavicon=false
  - customer.save

### プログラム呼び出し階層図

```
bs_favicon.asp（表示画面）
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ bs_security.asp（認証・権限）
    │
    ├─ bs_process.asp（削除処理）
    │      └─ case "removeFavicon"
    │             ├─ checkCSRF()
    │             ├─ FileSystemObject.DeleteFile()
    │             └─ customer.save()
    │
    └─ フォーム送信 → bs_faviconUpload.asp
           │
           ├─ FreeASPUpload.Save()
           │
           ├─ checkCSRF_Upload()
           │
           ├─ GetFileExtension()（拡張子チェック）
           │
           ├─ Upload.UploadedFiles.rename()
           │
           └─ customer.save()
```

### データフロー図

```
[入力]                  [処理]                      [出力]

ICOファイル ───────▶ FreeASPUpload.Save() ───▶ userfiles/
選択                    │                      favicon.ico
                        ▼
                  バリデーション
                  (拡張子/サイズ)
                        │
                        ▼
                  favicon.icoリネーム
                        │
                        ▼
              customer.hasFavicon=true
                        │
                        ▼
                 customer.save()
                        │
                        ▼
                  データベース更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_favicon.asp | `asp/bs_favicon.asp` | ソース | ファビコン設定画面 |
| bs_faviconUpload.asp | `asp/bs_faviconUpload.asp` | ソース | ファイルアップロード処理 |
| bs_process.asp | `asp/bs_process.asp` | ソース | 削除処理（removeFaviconアクション） |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| includes/header.asp | `asp/includes/header.asp` | インクルード | HTMLヘッダー出力 |
| bs_initBack.asp | `asp/bs_initBack.asp` | インクルード | バックオフィス初期化 |
| bs_header.asp | `asp/bs_header.asp` | インクルード | ナビゲーション |
