# 機能設計書 24-ピール広告

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるピール広告（Page Peel）機能の詳細設計を記載する。

### 本機能の処理概要

ピール広告機能は、Webサイトのページコーナー（右上）に表示される「ページめくり」効果のある広告バナーを管理者が設定・管理するための機能である。マウスホバーで画像が展開し、クリックで指定URLへ遷移する視覚的に訴求力の高い広告形式を提供する。

**業務上の目的・背景**：Webサイトでは、重要なお知らせやキャンペーン情報、特別なリンクをユーザーの目を引く形で表示したいニーズがある。ピール広告（ページピール）は、ページの角をめくるようなアニメーション効果により、バナー広告よりも高いクリック率が期待できる広告形式である。本機能により、管理者は簡単にピール広告を設定でき、サイトのプロモーション効果を向上させることができる。

**機能の利用シーン**：季節キャンペーン、セール告知、新商品のプロモーション、重要なお知らせへの誘導、外部サイト（SNSなど）への誘導などの際に使用される。

**主要な処理内容**：
1. 認証・権限チェック（secondAdmin.bSetupPageElements権限の確認）
2. ピール広告の基本設定（リンクURL、新しいウィンドウで開くオプション）
3. フリップカラー（めくり部分の色）の選択（16色から選択）
4. ピールサイズの設定（アイドル時/アクティブ時）
5. ピール画像のアップロード（PNG/JPG/GIF）
6. 有効/無効の切り替え
7. 設定の削除

**関連システム・外部連携**：FreeASPUploadコンポーネントによるファイルアップロード処理。フロントエンドでのJavaScriptによるピール効果の表示。

**権限による制御**：secondAdmin.bSetupPageElements権限を持つユーザーのみがアクセス可能。この権限がない場合はアクセス拒否される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 81 | ピール設定 | 主画面 | ピール広告の基本設定 |
| 82 | ピール選択 | 補助画面 | ピール画像の選択・アップロード画面への遷移 |
| 83 | ピールアップロード | 補助画面 | ピール画像のアップロード処理 |

## 機能種別

ファイル管理 / CRUD操作（作成・更新・削除）

## 入力仕様

### 入力パラメータ

#### ピール設定画面（bs_peel.asp）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| btnAction | String | Yes | アクション種別（"savepeel"） | 固定値との一致確認 |
| sPeelURL | String | Yes | クリック時の遷移先URL | 最大255文字、"http://"以外の値が必要 |
| bPeelOINW | Boolean | No | 新しいウィンドウで開くフラグ | true/false |
| sPeelFlipColor | Integer | Yes | フリップカラー（0-15） | 0〜15の数値 |
| sPeelIdleSize | Integer | No | アイドル時のサイズ（px） | 50〜300の範囲 |
| sPeelMOSize | Integer | No | アクティブ時のサイズ（px） | 200〜700の範囲 |
| bPeelEnabled | Boolean | No | ピール広告の有効フラグ | true/false |
| btnDelete | String | No | 削除ボタン押下フラグ | 存在確認 |
| QSSEC | String | Yes | CSRFトークン | checkCSRF()による検証 |

#### ピール画像アップロード（bs_peelUpload.asp）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| peel | File | Yes | アップロードする画像ファイル | PNG/JPG/GIF形式、2MB以下 |
| QSSEC | String | Yes | CSRFトークン | checkCSRF_Upload()による検証 |

### 入力データソース

- 画面入力（フォームからのPOSTリクエスト）
- ファイル選択ダイアログ（画像アップロード）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.sPeelURL | String | クリック時の遷移先URL |
| customer.bPeelOINW | Boolean | 新しいウィンドウで開くフラグ |
| customer.sPeelFlipColor | Integer | フリップカラー番号 |
| customer.sPeelIdleSize | Integer | アイドル時のサイズ |
| customer.sPeelMOSize | Integer | アクティブ時のサイズ |
| customer.sPeelImage | String | ピール画像ファイル名 |
| customer.bPeelEnabled | Boolean | ピール広告有効フラグ |
| peel_*.png/jpg/gif | File | アップロードされたピール画像 |

### 出力先

- データベース（customerテーブルの各ピール関連カラム）
- ファイルシステム（userfilesディレクトリ/peel_*.拡張子）
- 画面リダイレクト（処理結果に応じた遷移）

## 処理フロー

### 処理シーケンス（設定保存）

```
1. ページアクセス
   └─ begin.asp、bs_security.aspのインクルードによる初期化
2. 権限チェック
   └─ logon.hasaccess secondAdmin.bSetupPageElementsで権限確認
3. bs_process.aspで"savepeel"アクション処理
4. 削除ボタン判定
   ├─ 削除の場合: 全ピール設定をクリア
   └─ 保存の場合: 入力値を設定
5. 入力値バリデーション
   └─ URL、フリップカラーの必須チェック
6. 画像アップロード状態確認
   ├─ 画像未設定: 画像アップロード画面へリダイレクト
   └─ 画像設定済: 設定画面へ戻る
```

### 処理シーケンス（画像アップロード）

```
1. ファイルアップロード受信
   └─ FreeASPUpload.Save()でファイル受信
2. CSRFトークン検証
   └─ checkCSRF_Upload()関数による検証
3. ファイルバリデーション
   ├─ 拡張子チェック（PNG/JPG/GIF）
   └─ サイズチェック（2MB以下）
4. ファイル処理
   ├─ エラーあり: ファイル削除、エラーページへリダイレクト
   └─ エラーなし: ランダムファイル名で保存
5. 状態更新
   └─ customer.sPeelImageにファイル名設定、customer.save()
```

### フローチャート

```mermaid
flowchart TD
    A[ピール設定画面アクセス] --> B{権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[現在の設定表示]
    D --> E{アクション選択}

    E -->|保存| F{削除ボタン?}
    F -->|Yes| G[全設定クリア]
    G --> H[customer.save]
    H --> I[設定画面へリダイレクト]

    F -->|No| J[入力値取得]
    J --> K{バリデーション}
    K -->|エラー| L[エラー表示]
    K -->|OK| M[customer設定更新]
    M --> N[customer.save]
    N --> O{画像設定済?}
    O -->|No| P[画像アップロード画面へ]
    O -->|Yes| I

    E -->|画像アップロード| Q[bs_selectPeel.asp]
    Q --> R[ファイル選択]
    R --> S[bs_peelUpload.asp]
    S --> T[CSRFトークン検証]
    T --> U{拡張子チェック}
    U -->|NG| V[エラー: err_fileType]
    U -->|OK| W{サイズチェック}
    W -->|2MB超| X[エラー: err_fileSize]
    W -->|OK| Y[ランダム名でファイル保存]
    Y --> Z[customer.sPeelImage設定]
    Z --> AA[customer.save]
    AA --> I

    V --> AB[ファイル削除]
    X --> AB
    AB --> AC[エラー画面へリダイレクト]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-24-01 | 権限制御 | bSetupPageElements権限を持つユーザーのみ操作可能 | 全操作時 |
| BR-24-02 | CSRF保護 | 保存・アップロード時は必ずCSRFトークンを検証 | 保存・アップロード時 |
| BR-24-03 | URL必須 | ピール広告を保存するにはURLが必要（"http://"のみは不可） | 保存時 |
| BR-24-04 | フリップカラー必須 | ピール広告を保存するにはフリップカラーの選択が必要 | 保存時 |
| BR-24-05 | 画像形式制限 | PNG/JPG/GIF形式のファイルのみアップロード可能 | アップロード時 |
| BR-24-06 | ファイルサイズ制限 | ファイルサイズは2MB以下 | アップロード時 |
| BR-24-07 | デフォルトサイズ | アイドル時70px、アクティブ時300pxがデフォルト | 初期表示時 |
| BR-24-08 | 2段階設定 | URL設定後に画像アップロードが可能 | 設定フロー |
| BR-24-09 | ランダムファイル名 | アップロード画像はpeel_+ランダム文字列+拡張子で保存 | アップロード時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 保存 | customer | UPDATE | ピール関連カラムの更新 |
| 削除 | customer | UPDATE | ピール関連カラムのクリア |
| 画像アップロード | customer | UPDATE | sPeelImageの更新 |

### テーブル別操作詳細

#### customerテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sPeelURL | フォーム入力値（最大255文字） | 遷移先URL |
| UPDATE | bPeelOINW | true/false | 新しいウィンドウで開く |
| UPDATE | sPeelFlipColor | 0-15 | フリップカラー番号 |
| UPDATE | sPeelIdleSize | 50-300 | アイドル時サイズ（px） |
| UPDATE | sPeelMOSize | 200-700 | アクティブ時サイズ（px） |
| UPDATE | sPeelImage | ファイル名 | アップロード画像名 |
| UPDATE | bPeelEnabled | true/false | 有効/無効フラグ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 必須エラー | URLまたはフリップカラー未設定 | 必須項目を入力するよう案内 |
| err_fileType | ファイル形式エラー | PNG/JPG/GIF以外のファイル | 対応形式のファイルを選択 |
| err_fileSize | ファイルサイズエラー | 2MBを超えるファイル | ファイルサイズを小さくする |
| err_newFile | ファイル未選択エラー | ファイルが選択されていない | ファイルを選択する |
| - | 権限エラー | bSetupPageElements権限なし | アクセス拒否 |

### リトライ仕様

特になし（ユーザーが適切な値/ファイルで再操作）

## トランザクション仕様

customer.save()メソッド内でトランザクション管理。画像アップロードとデータベース更新は順次実行。

## パフォーマンス要件

- ファイルサイズ上限: 2MB
- アップロード処理は同期的に完了

## セキュリティ考慮事項

- CSRF対策: QS_secCodeHiddenによるトークン埋め込みとcheckCSRF()/checkCSRF_Upload()による検証
- ファイル形式制限: PNG/JPG/GIF形式のみに制限
- ファイルサイズ制限: DoS攻撃防止のため2MB上限
- 権限制御: secondAdmin.bSetupPageElements権限による制限
- URL入力: left()関数で255文字に制限

## 備考

- フリップカラーは16種類（0-15）の固定画像から選択
- JPG画像の場合、サムネイル表示にshowthumb.aspxを使用
- ピール画像は右上コーナーに配置（CSSで制御）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

customerオブジェクトがピール広告設定を保持する構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | begin.asp | `asp/begin.asp` | customerオブジェクトの初期化、ピール関連プロパティ |

**読解のコツ**: customerオブジェクトには以下のピール関連プロパティがある：sPeelURL, bPeelOINW, sPeelFlipColor, sPeelIdleSize, sPeelMOSize, sPeelImage, bPeelEnabled

#### Step 2: 設定画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_peel.asp | `asp/bs_peel.asp` | ピール設定画面、フォーム構成 |

**主要処理フロー**:
1. **4行目**: 権限チェック、bs_process.aspインクルード
2. **5-6行目**: デフォルト値設定（URLが空の場合は"http://"）
3. **8-12行目**: サイズのデフォルト値設定（アイドル70px、アクティブ300px）
4. **13行目**: URLとフリップカラーのフォーム
5. **14-23行目**: フリップカラー選択（16色のラジオボタン生成）
6. **24-29行目**: 現在のピール画像プレビュー表示

#### Step 3: 保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_process.asp | `asp/bs_process.asp` | savepeel処理（185-213行目） |

**主要処理フロー**:
- **186行目**: checkCSRF()でトークン検証
- **187-196行目**: btnDeleteボタン判定による削除処理
- **198-203行目**: 各設定値をcustomerオブジェクトに設定
- **204-206行目**: バリデーション（URL、フリップカラー必須）
- **207-211行目**: 画像設定状態による遷移先判定

#### Step 4: 画像アップロード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_selectPeel.asp | `asp/bs_selectPeel.asp` | 画像選択画面 |
| 4-2 | bs_peelUpload.asp | `asp/bs_peelUpload.asp` | アップロード処理 |

**主要処理フロー**:
- **bs_peelUpload.asp 4-8行目**: FreeASPUpload初期化
- **9行目**: checkCSRF_Upload()でトークン検証
- **14-18行目**: 拡張子チェック（png/jpg/gif）
- **22-23行目**: サイズチェック（2000000バイト=2MB）
- **30行目**: generatePassword()でランダムファイル名生成
- **31行目**: リネームして保存
- **32行目**: customer.sPeelImageに設定

### プログラム呼び出し階層図

```
bs_peel.asp（設定画面）
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ bs_security.asp（認証・権限）
    │
    ├─ bs_process.asp（保存/削除処理）
    │      └─ case "savepeel"
    │             ├─ checkCSRF()
    │             ├─ 削除処理（全設定クリア）
    │             ├─ 保存処理（各設定値更新）
    │             └─ customer.save()
    │
    └─ 画像アップロードリンク → bs_selectPeel.asp
           │
           └─ フォーム送信 → bs_peelUpload.asp
                  │
                  ├─ FreeASPUpload.Save()
                  │
                  ├─ checkCSRF_Upload()
                  │
                  ├─ GetFileExtension()
                  │
                  ├─ generatePassword()
                  │
                  └─ customer.save()
```

### データフロー図

```
[入力]                    [処理]                       [出力]

URL/設定入力 ────────▶ bs_process.asp ──────▶ customer.*
                       (savepeel)            設定プロパティ
                            │
                            ▼
                      customer.save()
                            │
                            ▼
                       データベース更新

画像ファイル ────────▶ bs_peelUpload.asp ──▶ userfiles/
選択                        │              peel_*.拡張子
                            ▼
                      バリデーション
                      (形式/サイズ)
                            │
                            ▼
                      ランダム名保存
                            │
                            ▼
                 customer.sPeelImage設定
                            │
                            ▼
                      customer.save()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_peel.asp | `asp/bs_peel.asp` | ソース | ピール設定画面 |
| bs_selectPeel.asp | `asp/bs_selectPeel.asp` | ソース | 画像選択画面 |
| bs_peelUpload.asp | `asp/bs_peelUpload.asp` | ソース | 画像アップロード処理 |
| bs_process.asp | `asp/bs_process.asp` | ソース | savepeel処理（185-213行目） |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| fixedImages/peels/pageflipX.png | 固定画像 | リソース | フリップカラー画像（0-15） |
