# 機能設計書 25-テンプレート一覧

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるテンプレート一覧表示機能の詳細設計を記載する。

### 本機能の処理概要

テンプレート一覧機能は、サイトに登録されているデザインテンプレートの一覧を表示し、各テンプレートに対する操作（編集・プレビュー・コピー・削除・デフォルト設定）への導線を提供する機能である。

**業務上の目的・背景**：CMSでは、サイトのデザインをテンプレートで管理することで、コンテンツとデザインの分離を実現している。管理者は複数のテンプレートを作成・管理し、用途に応じて切り替えることができる。本機能は登録済みテンプレートの全体像を把握し、各種管理操作を行うための中心的なハブとなる画面を提供する。

**機能の利用シーン**：テンプレートの管理作業全般（新規作成、既存テンプレートの編集・確認、デザイン切り替え、不要テンプレートの削除など）を行う際のエントリーポイントとして使用される。

**主要な処理内容**：
1. 認証・権限チェック（secondAdmin.bTemplates権限の確認）
2. テンプレートのコピー・削除・デフォルト設定アクションの処理
3. 登録済みテンプレート一覧の表示
4. 各テンプレートの操作リンク（編集・プレビュー・コピー・削除）の表示
5. ZIPテンプレートインポート機能へのリンク（サポートされている場合）
6. オンラインテンプレート検索機能へのリンク（有効な場合）
7. ローカルテンプレートライブラリからのインストール機能

**関連システム・外部連携**：cls_templateクラスによるテンプレートオブジェクト管理。cls_zipperクラスによるZIP解凍サポート確認。

**権限による制御**：secondAdmin.bTemplates権限を持つユーザーのみがアクセス可能。この権限がない場合はアクセス拒否される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 71 | テンプレート一覧 | 主画面 | サイトデザインテンプレートの一覧表示 |

## 機能種別

一覧表示 / CRUD操作（コピー・削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| a | String | No | アクション種別（"copy", "delete", "default"） | 固定値との一致確認 |
| itemplateID | String | No（アクション実行時はYes） | 操作対象テンプレートID（暗号化済） | decrypt()で復号、数値チェック |
| QSSEC | String | Yes（アクション実行時） | CSRFトークン | checkCSRF()による検証 |
| sInstallPath | String | No | ローカルテンプレートインストールパス | パス存在チェック |
| look | String | No | テンプレートカテゴリ選択 | パス存在チェック |
| postback | Boolean | No | フォームポストバックフラグ | - |

### 入力データソース

- URLクエリストリング（アクション、テンプレートID）
- フォームPOST（テンプレートカテゴリ選択）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| テンプレート一覧 | HTML | 登録済みテンプレートのリスト表示 |
| 操作リンク | HTML | 編集・プレビュー・コピー・削除のリンク/アイコン |
| デフォルト表示 | HTML | 現在のデフォルトテンプレート表示 |

### 出力先

- 画面表示（HTML）
- データベース（デフォルト設定変更時）
- リダイレクト（アクション完了時）

## 処理フロー

### 処理シーケンス

```
1. ページアクセス
   └─ begin.asp、bs_security.aspのインクルードによる初期化
2. 権限チェック
   └─ logon.hasaccess secondAdmin.bTemplatesで権限確認
3. アクション判定（itemplateIDが指定されている場合）
   ├─ copy: テンプレートをコピー
   ├─ delete: テンプレートを削除
   └─ default: デフォルトテンプレートに設定
4. テンプレート一覧取得
   └─ customer.templatesでテンプレートコレクション取得
5. 一覧表示
   ├─ 各テンプレートの名前とリンク表示
   ├─ デフォルトテンプレートの表示
   └─ 操作アイコン（編集・プレビュー・コピー・削除）表示
6. 追加機能リンク表示
   ├─ ZIPインポート（サポートされている場合）
   └─ オンラインテンプレート検索（有効な場合）
7. ローカルテンプレートライブラリ（設定されている場合）
   └─ カテゴリ選択・プレビュー・インストール
```

### フローチャート

```mermaid
flowchart TD
    A[テンプレート一覧アクセス] --> B{権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D{itemplateID指定?}

    D -->|Yes| E[CSRFトークン検証]
    E --> F{アクション判定}
    F -->|copy| G[template.copy]
    F -->|delete| H[template.remove]
    F -->|default| I[customer.defaultTemplate設定]
    G --> J[一覧表示]
    H --> J
    I --> K[customer.save]
    K --> J

    D -->|No| J

    J --> L[テンプレート一覧ループ]
    L --> M[各テンプレートの操作リンク表示]
    M --> N{ZIPサポート?}
    N -->|Yes| O[ZIPインポートリンク表示]
    N -->|No| P[XStandardインストール案内]
    O --> Q{オンライン検索有効?}
    P --> Q
    Q -->|Yes| R[オンライン検索リンク表示]
    Q -->|No| S{ローカルライブラリ設定?}
    R --> S
    S -->|Yes| T[カテゴリ選択フォーム表示]
    S -->|No| U[終了]
    T --> V{カテゴリ選択済?}
    V -->|Yes| W[テンプレートボックス表示]
    V -->|No| U
    W --> U
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-25-01 | 権限制御 | bTemplates権限を持つユーザーのみアクセス可能 | 全操作時 |
| BR-25-02 | CSRF保護 | アクション実行時は必ずCSRFトークンを検証 | copy/delete/default時 |
| BR-25-03 | 削除制限 | テンプレートが1つしかない場合は削除不可 | 削除アイコン表示時 |
| BR-25-04 | デフォルト削除禁止 | デフォルトテンプレートは削除不可 | 削除アイコン表示時 |
| BR-25-05 | 単一デフォルト | デフォルトテンプレートは1つのみ | デフォルト設定時 |
| BR-25-06 | ID暗号化 | テンプレートIDはURLパラメータ時に暗号化 | ID受け渡し時 |

### 計算ロジック

- 削除可能判定: `templates.count > 1 AND customer.defaultTemplate <> templatekey`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コピー | template | INSERT | テンプレートを複製して新規作成 |
| 削除 | template | DELETE | テンプレートを削除 |
| デフォルト設定 | customer | UPDATE | defaultTemplateを更新 |
| インストール | template | INSERT | ローカルライブラリからテンプレート作成 |

### テーブル別操作詳細

#### templateテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT（コピー） | 全カラム | 元テンプレートの値を複製 | copy()メソッド |
| DELETE | - | iId=対象テンプレートID | remove()メソッド |

#### customerテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | defaultTemplate | 指定されたテンプレートID | デフォルト設定時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bTemplates権限なし | アクセス拒否 |
| - | CSRFエラー | CSRFトークン不一致 | checkCSRF()でエラー処理 |
| - | パス不存在 | ローカルライブラリパスが存在しない | エラーメッセージ表示 |

### リトライ仕様

特になし

## トランザクション仕様

- コピー・削除・デフォルト設定は個別にトランザクション管理
- ローカルテンプレートインストールはテンプレート作成とファイルコピーを順次実行

## パフォーマンス要件

一般的な一覧表示処理のため、特別な要件なし。

## セキュリティ考慮事項

- CSRF対策: QS_secCodeURLによるトークン付与とcheckCSRF()による検証
- ID暗号化: encrypt()/decrypt()による暗号化でIDの推測を防止
- 権限制御: secondAdmin.bTemplates権限による制限
- 確認ダイアログ: コピー・削除時にJavaScript確認ダイアログを表示

## 備考

- ZIPコンポーネント（XStandard）がインストールされていない場合、インストール案内を表示
- オンラインテンプレート検索は設定(bBrowseOnlineTemplates)により有効/無効が切り替わる
- ローカルテンプレートライブラリは設定(sNewTemplatesPath)により有効/無効が切り替わる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テンプレートオブジェクトとcustomerのテンプレート関連プロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | begin.asp | `asp/begin.asp` | customerオブジェクト、templatesコレクション |

**読解のコツ**: cls_templateクラスはテンプレートの属性（sName, sValue, iId等）を保持。customer.templatesはテンプレートのDictionaryコレクション。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_templateList.asp | `asp/bs_templateList.asp` | メイン処理ファイル |

**主要処理フロー**:
1. **4行目**: 権限チェック `logon.hasaccess secondAdmin.bTemplates`
2. **4-5行目**: cls_templateオブジェクト生成
3. **6-17行目**: アクション処理（copy/delete/default）
4. **19-20行目**: customer.templatesでテンプレートコレクション取得
5. **21-24行目**: 削除可否判定（templates.count<=1ならば削除不可）
6. **25-26行目**: テンプレート一覧ループと表示
7. **27-29行目**: ZIPサポート確認とリンク表示
8. **30行目**: オンラインテンプレート検索リンク
9. **31-38行目**: ローカルテンプレートライブラリ処理

#### Step 3: テンプレート操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cls_templateクラス | インクルード内 | copy(), remove()メソッド |

**主要処理フロー**:
- **copy()**: テンプレートの複製を作成
- **remove()**: テンプレートを削除

#### Step 4: ローカルテンプレートインストールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | installTemplate関数 | `asp/bs_templateList.asp` 83-125行目 | ローカルライブラリからのインストール |

**主要処理フロー**:
- **92-97行目**: cls_templateオブジェクト生成、基本設定
- **98行目**: HTMLファイル読み込み
- **101-111行目**: テンプレートフォルダの作成
- **117行目**: Artisteerテンプレートとして処理
- **118-122行目**: WAP/Print/Mobile/Email初期化
- **123行目**: template.save()

### プログラム呼び出し階層図

```
bs_templateList.asp
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ bs_security.asp（認証・権限）
    │      └─ logon.hasaccess()
    │
    ├─ cls_template（テンプレートクラス）
    │      ├─ copy()
    │      └─ remove()
    │
    ├─ customer.templates（テンプレートコレクション）
    │
    ├─ customer.defaultTemplate（デフォルト設定）
    │      └─ customer.save()
    │
    ├─ cls_zipper（ZIP解凍クラス）
    │      └─ supportZipper判定
    │
    ├─ getIcon()（アイコン表示）
    │
    ├─ getArtLink()（リンク生成）
    │
    ├─ templateCatList()（カテゴリリスト）
    │
    ├─ showTemplateBox()（テンプレートボックス）
    │
    └─ installTemplate()（インストール処理）
           ├─ FileSystemObject
           └─ template.save()
```

### データフロー図

```
[入力]                    [処理]                      [出力]

アクション指定 ────────▶ アクション処理 ─────▶ リダイレクト
(copy/delete/default)   (template.copy等)     (bs_templateList.asp)
        │
        ▼
テンプレート一覧 ─────▶ customer.templates ──▶ 一覧HTML
                                              操作リンク

カテゴリ選択 ─────────▶ showTemplateBox() ──▶ テンプレート
                                              プレビュー/
                                              インストール

インストール選択 ─────▶ installTemplate() ──▶ template
                       FileSystemObject      テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_templateList.asp | `asp/bs_templateList.asp` | ソース | メイン処理ファイル |
| bs_templateEdit.asp | `asp/bs_templateEdit.asp` | 遷移先 | テンプレート編集画面 |
| bs_uploadzip.asp | `asp/bs_uploadzip.asp` | 遷移先 | ZIPアップロード画面 |
| bs_templateSearch.asp | `asp/bs_templateSearch.asp` | 遷移先 | オンライン検索画面 |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| includes/header.asp | `asp/includes/header.asp` | インクルード | HTMLヘッダー出力 |
| bs_initBack.asp | `asp/bs_initBack.asp` | インクルード | バックオフィス初期化 |
| bs_header.asp | `asp/bs_header.asp` | インクルード | ナビゲーション |
