# 機能設計書 26-テンプレート作成・編集

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるテンプレート作成・編集機能の詳細設計を記載する。

### 本機能の処理概要

テンプレート作成・編集機能は、サイトのデザインを定義するHTMLテンプレートを新規作成または既存テンプレートを編集するための機能である。テンプレートはサイトの見た目を決定する重要な要素であり、本機能によりHTML/CSSの直接編集が可能となる。

**業務上の目的・背景**：CMSにおいてデザインの柔軟性は重要な要素である。テンプレートを編集することで、サイトのレイアウト、デザイン、機能配置を自由にカスタマイズできる。HTML/CSSに精通した管理者やデザイナーが、ブランドに合わせたオリジナルデザインを実装したり、外部から取得したテンプレートを調整したりする際に本機能が使用される。

**機能の利用シーン**：新規テンプレートの作成、既存テンプレートのHTML修正、CSSの調整、レイアウト変更、新機能用のプレースホルダー追加などの際に使用される。

**主要な処理内容**：
1. 認証・権限チェック（secondAdmin.bTemplates権限の確認）
2. 新規テンプレート作成時の初期化処理
3. 既存テンプレートの読み込み・表示
4. HTML/CSSコードの編集（テキストエリア）
5. テンプレートの保存処理
6. テンプレートの削除処理
7. テンプレートのプレビュー処理

**関連システム・外部連携**：cls_templateクラスによるテンプレートオブジェクト管理。テンプレートエンジンによるページ表示との連携。

**権限による制御**：secondAdmin.bTemplates権限を持つユーザーのみがアクセス可能。この権限がない場合はアクセス拒否される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 72 | テンプレート編集 | 主画面 | テンプレートのHTML/CSS編集 |
| 73 | テンプレート作成 | 主画面 | 新規テンプレートの作成 |

## 機能種別

CRUD操作（作成・読取・更新・削除）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| btnaction | String | Yes（保存/削除/プレビュー時） | アクション種別 | l("save"), l("delete"), l("preview")との一致確認 |
| itemplateId | String | No（編集時はYes） | テンプレートID（暗号化済） | decrypt()で復号、数値チェック |
| sName | String | Yes | テンプレート名 | 最大255文字 |
| sValue | String | Yes | HTMLテンプレートコード | - |
| bCompress | Boolean | No | 圧縮版使用フラグ | true/false |
| QSSEC | String | Yes | CSRFトークン | checkCSRF()による検証 |

### 入力データソース

- URLクエリストリング（テンプレートID）
- フォームPOST（テンプレート名、HTML、設定）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| template.sName | String | テンプレート名 |
| template.sValue | String | HTMLテンプレートコード |
| template.bCompress | Boolean | 圧縮版使用フラグ |
| message | String | 保存成功時のフィードバックメッセージ |

### 出力先

- データベース（templateテーブル）
- 画面表示（編集フォーム、メッセージ）
- リダイレクト（削除完了時はテンプレート一覧へ、プレビュー時は新しいウィンドウ）

## 処理フロー

### 処理シーケンス

```
1. ページアクセス
   └─ begin.asp、bs_security.aspのインクルードによる初期化
2. 権限チェック
   └─ logon.hasaccess secondAdmin.bTemplatesで権限確認
3. テキスト方向設定
   └─ application(QS_textDirection)=QS_ltr（LTR固定）
4. cls_templateオブジェクト生成
5. アクション判定
   ├─ save: CSRFチェック、入力値取得、保存、メッセージ追加
   ├─ delete: CSRFチェック、削除、テンプレート一覧へリダイレクト
   ├─ preview: CSRFチェック、保存、セッションにID設定、プレビューページへリダイレクト
   └─ その他: 新規の場合はinit()で初期化
6. 削除可否判定
   └─ templates.count<=1またはデフォルトテンプレートの場合は削除不可
7. フォーム表示
   └─ テンプレート名、HTML、設定フィールド
```

### フローチャート

```mermaid
flowchart TD
    A[テンプレート編集画面アクセス] --> B{権限チェック}
    B -->|権限なし| C[アクセス拒否]
    B -->|権限あり| D[テキスト方向LTR設定]
    D --> E[cls_template生成]
    E --> F{アクション判定}

    F -->|save| G[CSRFトークン検証]
    G --> H[getRequestValues]
    H --> I[template.save]
    I --> J{保存成功?}
    J -->|Yes| K[成功メッセージ追加]
    J -->|No| L[エラー処理]
    K --> M[フォーム表示]
    L --> M

    F -->|delete| N[CSRFトークン検証]
    N --> O[template.remove]
    O --> P[テンプレート一覧へリダイレクト]

    F -->|preview| Q[CSRFトークン検証]
    Q --> R[getRequestValues]
    R --> S[template.save]
    S --> T[セッションにID設定]
    T --> U[プレビューページへリダイレクト]

    F -->|なし| V{新規作成?}
    V -->|Yes| W[template.init]
    V -->|No| M
    W --> M

    M --> X[削除可否判定]
    X --> Y[保存/削除/プレビューボタン表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-26-01 | 権限制御 | bTemplates権限を持つユーザーのみアクセス可能 | 全操作時 |
| BR-26-02 | CSRF保護 | 保存・削除・プレビュー時は必ずCSRFトークンを検証 | 各アクション時 |
| BR-26-03 | 名前必須 | テンプレート名は必須項目 | 保存時 |
| BR-26-04 | HTML必須 | HTMLテンプレートコードは必須項目 | 保存時 |
| BR-26-05 | 削除制限 | テンプレートが1つしかない場合は削除不可 | 削除ボタン表示時 |
| BR-26-06 | デフォルト削除禁止 | デフォルトテンプレートは削除不可 | 削除ボタン表示時 |
| BR-26-07 | LTRモード | テンプレート編集時はテキスト方向をLTR固定 | 画面表示時 |

### 計算ロジック

- 削除可能判定: `templates.count > 1 AND customer.defaultTemplate <> template.iId`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 新規作成 | template | INSERT | 新しいテンプレートを作成 |
| 更新 | template | UPDATE | 既存テンプレートを更新 |
| 削除 | template | DELETE | テンプレートを削除 |

### テーブル別操作詳細

#### templateテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | sName | フォーム入力値 | テンプレート名 |
| INSERT/UPDATE | sValue | フォーム入力値 | HTMLテンプレートコード |
| INSERT/UPDATE | bCompress | フォーム入力値 | 圧縮版使用フラグ |
| DELETE | - | iId=対象テンプレートID | remove()メソッド |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bTemplates権限なし | アクセス拒否 |
| - | CSRFエラー | CSRFトークン不一致 | checkCSRF()でエラー処理 |
| - | 必須エラー | 名前またはHTMLが空 | エラーメッセージ表示 |

### リトライ仕様

特になし（ユーザーが修正して再保存）

## トランザクション仕様

template.save()メソッド内でトランザクション管理。保存失敗時はロールバック。

## パフォーマンス要件

- HTMLテンプレートは大きくなる可能性があるため、テキストエリアは十分なサイズ（60行x110列）
- 圧縮版使用オプションにより、フロントエンド表示時のパフォーマンス向上が可能

## セキュリティ考慮事項

- CSRF対策: QS_secCodeHiddenによるトークン埋め込みとcheckCSRF()による検証
- XSS対策: sanitize()、quotrep()による出力時エスケープ
- 権限制御: secondAdmin.bTemplates権限による制限
- HTML入力: テンプレートはHTMLコードを受け付けるため、管理者のみがアクセス可能な設計

## 備考

- テンプレート編集画面には「Common variables」へのリンクがあり、使用可能な変数を参照可能
- 圧縮版使用オプションは、HTML/CSS/JSの圧縮により表示速度を向上させる
- プレビュー機能はセッションにテンプレートIDを設定して新しいウィンドウで表示

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テンプレートオブジェクトの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | begin.asp | `asp/begin.asp` | cls_templateクラスの初期化 |

**読解のコツ**: cls_templateクラスの主要プロパティ：sName（名前）、sValue（HTML）、iId（ID）、bCompress（圧縮フラグ）

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_templateEdit.asp | `asp/bs_templateEdit.asp` | メイン処理ファイル |

**主要処理フロー**:
1. **4行目**: 権限チェック `logon.hasaccess secondAdmin.bTemplates`
2. **4行目**: `application(QS_textDirection)=QS_ltr` でテキスト方向設定
3. **4-5行目**: cls_templateオブジェクト生成
4. **6-28行目**: Select Caseによるアクション分岐
   - **7-12行目**: l("save") - 保存処理
   - **13-16行目**: l("delete") - 削除処理
   - **17-23行目**: l("preview") - プレビュー処理
   - **24-27行目**: else - 新規初期化
5. **29-32行目**: 削除可否判定
6. **33行目以降**: フォーム表示

#### Step 3: テンプレートクラスメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cls_templateクラス | インクルード内 | getRequestValues(), save(), init()メソッド |

**主要処理フロー**:
- **getRequestValues()**: フォームから値を取得してオブジェクトに設定
- **save()**: データベースに保存（INSERT or UPDATE）
- **init()**: 新規テンプレート用の初期値設定
- **remove()**: テンプレート削除

#### Step 4: ZIPインポートからのテンプレート作成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_CreateTemplate.asp | `asp/bs_CreateTemplate.asp` | ZIPからのテンプレート作成 |

**主要処理フロー**:
- **19-67行目**: ポストバック処理（HTMLファイル選択、名前設定）
- **36-66行目**: テンプレート作成処理
- **41-42行目**: HTMLファイル読み込み
- **48-54行目**: Artisteerテンプレート処理
- **56-60行目**: 各種初期化（WAP/Print/Mobile/Email）
- **62行目**: template.save()

### プログラム呼び出し階層図

```
bs_templateEdit.asp
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ bs_security.asp（認証・権限）
    │      └─ logon.hasaccess()
    │
    ├─ cls_template（テンプレートクラス）
    │      ├─ getRequestValues()
    │      ├─ save()
    │      ├─ init()
    │      └─ remove()
    │
    ├─ checkCSRF()（CSRF検証）
    │
    ├─ sanitize()（サニタイズ）
    │
    ├─ quotrep()（引用符エスケープ）
    │
    └─ message.Add()（メッセージ追加）

bs_CreateTemplate.asp（ZIPインポート用）
    │
    ├─ cls_template（テンプレートクラス）
    │      ├─ treatAsArtisteer()
    │      ├─ initWAP()
    │      ├─ initPrint()
    │      ├─ initMobile()
    │      ├─ initEmail()
    │      └─ save()
    │
    └─ FileSystemObject（ファイル操作）
```

### データフロー図

```
[入力]                    [処理]                      [出力]

テンプレート名 ─────────▶ getRequestValues() ─────▶ template.sName
HTMLコード                                           template.sValue
圧縮フラグ                                           template.bCompress
        │
        ▼
  template.save()
        │
        ▼
  データベース保存
        │
        ▼
  message.Add("fb_saveOK")
        │
        ▼
  フォーム再表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_templateEdit.asp | `asp/bs_templateEdit.asp` | ソース | テンプレート編集メイン |
| bs_CreateTemplate.asp | `asp/bs_CreateTemplate.asp` | ソース | ZIPからのテンプレート作成 |
| bs_templateBack.asp | `asp/bs_templateBack.asp` | インクルード | テンプレート編集補助 |
| bs_variables.asp | `asp/bs_variables.asp` | 参照先 | 使用可能変数一覧 |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| includes/header.asp | `asp/includes/header.asp` | インクルード | HTMLヘッダー出力 |
| bs_initBack.asp | `asp/bs_initBack.asp` | インクルード | バックオフィス初期化 |
| bs_header.asp | `asp/bs_header.asp` | インクルード | ナビゲーション |
