# 機能設計書 27-テンプレートプレビュー

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるテンプレートプレビュー機能の詳細設計を記載する。

### 本機能の処理概要

テンプレートプレビュー機能は、テンプレートを実際にサイトに適用した際の見た目を事前に確認するための機能である。テンプレート一覧画面からのプレビューリンク、およびテンプレート編集画面からのプレビューボタンの2つの導線から利用できる。

**業務上の目的・背景**：テンプレートの変更は、サイト全体の見た目に大きな影響を与える。本番環境に適用する前に、変更内容がどのように表示されるかを確認することは、品質管理と運用リスク軽減の観点から重要である。本機能により、管理者はテンプレートの変更内容を安全に確認し、意図した通りのデザインであることを検証できる。

**機能の利用シーン**：テンプレートの編集中や編集後の確認、新しいテンプレートの適用判断、複数テンプレートの比較検討などの際に使用される。

**主要な処理内容**：
1. テンプレート一覧からのプレビュー：プレビュー対象テンプレートIDを指定してフロントエンド表示
2. テンプレート編集からのプレビュー：編集中のテンプレートを一時保存してセッションに設定後、フロントエンド表示
3. フロントエンド表示エンジンがセッション/パラメータのテンプレートIDを優先適用
4. 新しいブラウザウィンドウでプレビュー表示

**関連システム・外部連携**：フロントエンド表示エンジン（default.asp）と連携。セッション変数によるテンプレートID受け渡し。

**権限による制御**：secondAdmin.bTemplates権限を持つユーザーのみがアクセス可能。テンプレート一覧・編集画面へのアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 71 | テンプレート一覧 | 起点画面 | プレビューリンクによるプレビュー開始 |
| 72 | テンプレート編集 | 起点画面 | プレビューボタンによるプレビュー開始 |
| 22 | プレビュー画面 | 結果画面 | テンプレート適用状態の表示 |

## 機能種別

表示処理 / プレビュー機能

## 入力仕様

### 入力パラメータ

#### テンプレート一覧からのプレビュー

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| previewTemplate | String | Yes | プレビュー対象テンプレートID（暗号化済） | decrypt()で復号、数値チェック |
| iId | String | Yes | 表示対象ページID（通常はホームページ、暗号化済） | decrypt()で復号 |

#### テンプレート編集からのプレビュー

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| btnaction | String | Yes | アクション種別（l("preview")） | 固定値との一致確認 |
| itemplateId | String | Yes | テンプレートID（暗号化済） | decrypt()で復号 |
| sName | String | Yes | テンプレート名 | - |
| sValue | String | Yes | HTMLテンプレートコード | - |
| QSSEC | String | Yes | CSRFトークン | checkCSRF()による検証 |

### 入力データソース

- URLクエリストリング（プレビューテンプレートID、ページID）
- フォームPOST（テンプレート編集画面から）
- セッション変数（iTemplateID）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| プレビューページ | HTML | 指定テンプレートを適用したページのHTML |
| session("iTemplateID") | Integer | プレビュー用テンプレートID（編集画面からの場合） |

### 出力先

- 新しいブラウザウィンドウでのHTML表示
- セッション変数（テンプレートID）

## 処理フロー

### 処理シーケンス（テンプレート一覧からのプレビュー）

```
1. テンプレート一覧画面でプレビューアイコンクリック
   └─ JavaScriptでwindow.openを実行
2. URLパラメータ構築
   └─ default.asp?iId={ホームページID}&previewTemplate={テンプレートID}
3. 新しいウィンドウでフロントエンドページ表示
   └─ previewTemplateパラメータにより指定テンプレートを適用
```

### 処理シーケンス（テンプレート編集からのプレビュー）

```
1. テンプレート編集画面でプレビューボタンクリック
   └─ フォームを新しいウィンドウをターゲットに送信
2. bs_templateEdit.aspでプレビューアクション処理
   ├─ CSRFトークン検証
   ├─ getRequestValues()で入力値取得
   └─ template.save()で一時保存
3. セッション変数設定
   └─ session("iTemplateID")=template.iId
4. フロントエンドページへリダイレクト
   └─ default.asp?iId={ホームページID}
5. フロントエンド表示エンジンがセッションのテンプレートIDを適用
```

### フローチャート

```mermaid
flowchart TD
    subgraph "テンプレート一覧からのプレビュー"
        A1[プレビューアイコンクリック] --> B1[window.open実行]
        B1 --> C1[default.asp?previewTemplate=ID]
        C1 --> D1[指定テンプレートで表示]
    end

    subgraph "テンプレート編集からのプレビュー"
        A2[プレビューボタンクリック] --> B2[フォーム送信（target=_new）]
        B2 --> C2[CSRFトークン検証]
        C2 --> D2[getRequestValues]
        D2 --> E2[template.save]
        E2 --> F2[session設定]
        F2 --> G2[default.aspへリダイレクト]
        G2 --> H2[セッションのテンプレートで表示]
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-27-01 | 権限制御 | bTemplates権限を持つユーザーのみプレビュー可能 | 全操作時 |
| BR-27-02 | CSRF保護 | 編集画面からのプレビュー時は必ずCSRFトークンを検証 | プレビュー時 |
| BR-27-03 | 一時保存 | 編集画面からのプレビューは保存してからプレビュー | プレビュー時 |
| BR-27-04 | 新しいウィンドウ | プレビューは常に新しいブラウザウィンドウで表示 | 表示時 |
| BR-27-05 | ホームページ表示 | プレビューは基本的にホームページで確認 | 表示時 |
| BR-27-06 | ID暗号化 | テンプレートIDはURLパラメータ時に暗号化 | ID受け渡し時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 編集画面プレビュー | template | UPDATE | 一時保存のため更新 |

### テーブル別操作詳細

#### templateテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sName, sValue等 | フォーム入力値 | プレビュー前の一時保存 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bTemplates権限なし | アクセス拒否 |
| - | CSRFエラー | CSRFトークン不一致 | checkCSRF()でエラー処理 |
| - | テンプレート未存在 | 指定IDのテンプレートが存在しない | デフォルトテンプレートで表示 |

### リトライ仕様

特になし

## トランザクション仕様

編集画面からのプレビュー時、template.save()でトランザクション管理。

## パフォーマンス要件

特になし（通常のページ表示と同等）。

## セキュリティ考慮事項

- CSRF対策: 編集画面からのプレビュー時にcheckCSRF()で検証
- ID暗号化: encrypt()/decrypt()による暗号化でIDの推測を防止
- 権限制御: secondAdmin.bTemplates権限による制限
- 新しいウィンドウ: 管理画面とフロントエンドの分離により操作継続性を確保

## 備考

- テンプレート一覧からのプレビューはJavaScriptのwindow.openで新しいウィンドウを開く
- テンプレート編集からのプレビューはフォームのtarget属性で新しいウィンドウを開く
- セッション変数のテンプレートIDは次回のページ表示に影響するため、プレビュー後にクリアされることが望ましい

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: プレビューリンクの実装を理解する

テンプレート一覧画面のプレビューリンクの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_templateList.asp | `asp/bs_templateList.asp` | プレビューリンクの生成 |

**主要処理フロー**:
- **26行目**: `getIcon(l("preview"),"search","#","javascript:window.open(...)","search"&templatekey)`
- URL構造: `C_DIRECTORY_QUICKERSITE/default.asp?iId={ホームページID}&previewTemplate={テンプレートID}`
- window.openでウィンドウ名を暗号化テンプレートIDに設定

**読解のコツ**: getIcon関数は5つの引数を取り、4番目がonclick属性のJavaScriptコード。

#### Step 2: 編集画面からのプレビュー処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_templateEdit.asp | `asp/bs_templateEdit.asp` | プレビューアクション処理 |

**主要処理フロー**:
1. **17行目**: `case l("preview")` でプレビューアクション判定
2. **18行目**: `checkCSRF()` でトークン検証
3. **19行目**: `template.getRequestValues()` で入力値取得
4. **20行目**: `template.save` で一時保存
5. **21行目**: `session("iTemplateID")=template.iId` でセッション設定
6. **22行目**: フロントエンドへリダイレクト

#### Step 3: プレビューボタンの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_templateEdit.asp | `asp/bs_templateEdit.asp` | プレビューボタンのHTML |

**主要処理フロー**:
- **34-35行目**: プレビューボタンの生成
- `onclick="javascript:document.mainform.target='_new'"` で新しいウィンドウをターゲットに設定
- 既存テンプレート（isNumeriek(template.iID)）の場合のみ表示

#### Step 4: フロントエンドでのテンプレート適用を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | default.asp | `asp/default.asp` | フロントエンド表示エンジン |

**主要処理フロー**:
- previewTemplateパラメータまたはsession("iTemplateID")の確認
- 指定されたテンプレートIDでページをレンダリング

### プログラム呼び出し階層図

```
テンプレート一覧からのプレビュー:
bs_templateList.asp
    │
    └─ JavaScript: window.open()
           │
           └─ default.asp?iId=...&previewTemplate=...
                  │
                  └─ 指定テンプレートでレンダリング

テンプレート編集からのプレビュー:
bs_templateEdit.asp
    │
    ├─ checkCSRF()
    │
    ├─ template.getRequestValues()
    │
    ├─ template.save()
    │
    ├─ session("iTemplateID")設定
    │
    └─ Response.Redirect(default.asp)
           │
           └─ セッションのテンプレートでレンダリング
```

### データフロー図

```
[テンプレート一覧からのプレビュー]

bs_templateList.asp          default.asp
       │                          │
       │  previewTemplate=ID      │
       ├─────────────────────────▶│
       │                          │
       │                    テンプレート適用
       │                          │
       │                          ▼
       │                    プレビュー表示


[テンプレート編集からのプレビュー]

bs_templateEdit.asp     →     default.asp
       │                          │
   save()                         │
       │                          │
session("iTemplateID")            │
       │                          │
   redirect ──────────────────────▶│
                                  │
                            セッション参照
                                  │
                                  ▼
                            プレビュー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_templateList.asp | `asp/bs_templateList.asp` | ソース | プレビューリンク生成 |
| bs_templateEdit.asp | `asp/bs_templateEdit.asp` | ソース | プレビューアクション処理 |
| default.asp | `asp/default.asp` | ソース | フロントエンド表示エンジン |
| process.asp | `asp/process.asp` | ソース | フロントエンド処理 |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
