# 機能設計書 28-テンプレートインポート

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるテンプレートインポート機能の詳細設計を記載する。

### 本機能の処理概要

テンプレートインポート機能は、ZIPファイル形式でパッケージされたテンプレートをアップロードし、解凍してシステムに登録するための機能である。JStemplates.com等のテンプレート配布サイトから取得したテンプレートや、自作のテンプレートをまとめてインポートできる。

**業務上の目的・背景**：プロフェッショナルなデザインのテンプレートを外部から取得して利用することは、CMSの大きなメリットである。本機能により、HTML/CSSファイル、画像、JavaScript等を含むテンプレートパッケージを一括でインポートでき、管理者のデザイン作業効率を大幅に向上させることができる。

**機能の利用シーン**：外部から取得したテンプレートの導入、テンプレートのバックアップからの復元、他サイトからのテンプレート移行などの際に使用される。

**主要な処理内容**：
1. 認証・権限チェック（secondAdmin.bTemplates権限の確認）
2. ZIPコンポーネントのサポート確認
3. ZIPファイルのアップロード処理
4. ファイル形式のバリデーション（ZIP形式のみ）
5. ZIPファイルの解凍処理
6. 解凍先フォルダの選択
7. HTMLテンプレートファイルの選択
8. テンプレートとしての登録処理

**関連システム・外部連携**：cls_zipperクラスによるZIP解凍。FreeASPUploadコンポーネントによるファイルアップロード。FileSystemObjectによるフォルダ操作。

**権限による制御**：secondAdmin.bTemplates権限を持つユーザーのみがアクセス可能。ZIPコンポーネントがインストールされていない場合は機能が利用不可。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 75 | ZIPアップロード | 主画面 | テンプレートZIPファイルのアップロード |
| 76 | ZIP解凍 | 主画面 | アップロードしたZIPファイルの解凍処理 |
| 73 | テンプレート作成 | 結果画面 | 解凍後のテンプレート作成処理 |

## 機能種別

ファイル管理 / インポート処理

## 入力仕様

### 入力パラメータ

#### ZIPアップロード画面（bs_uploadzip.asp）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sName | File | Yes | アップロードするZIPファイル | ZIP形式のみ許可 |
| QSSEC | String | Yes | CSRFトークン | checkCSRF_Upload()による検証 |

#### ZIP解凍画面（bs_unzip.asp）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| zip | String | Yes | アップロードしたZIPファイル名 | 存在確認 |
| sPath | String | No | 解凍先フォルダパス | デフォルトは/templates |
| foldername | String | No | テンプレートフォルダ名 | - |
| bRemove | Boolean | No | ZIP削除フラグ | true/false |
| postBack | Boolean | No | ポストバックフラグ | - |
| QSSEC | String | Yes | CSRFトークン | フォーム内に埋め込み |

### 入力データソース

- ファイルアップロード（multipart/form-data）
- フォームPOST（解凍設定）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 解凍されたファイル | Files | テンプレートファイル群 |
| テンプレートフォルダ | Directory | userfiles/templates/配下のフォルダ |

### 出力先

- ファイルシステム（userfilesディレクトリおよびtemplatesサブディレクトリ）
- リダイレクト（bs_CreateTemplate.aspへ）

## 処理フロー

### 処理シーケンス

```
1. テンプレート一覧から「Upload zipped template」リンクをクリック
   └─ bs_uploadzip.aspへ遷移
2. ZIPサポート確認
   └─ サポートなしの場合はテンプレート一覧へリダイレクト
3. ZIPファイルアップロード
   ├─ FreeASPUploadでファイル受信
   ├─ CSRFトークン検証
   └─ 拡張子チェック（ZIPのみ）
4. 解凍設定画面（bs_unzip.asp）へリダイレクト
5. 解凍設定入力
   ├─ 解凍先フォルダ選択
   └─ ZIPファイル削除オプション
6. 解凍処理実行
   ├─ cls_zipper.unpack()でZIP解凍
   └─ オプションによりZIPファイル削除
7. テンプレート作成画面（bs_CreateTemplate.asp）へリダイレクト
8. HTMLファイル選択・テンプレート名設定
9. テンプレート登録
```

### フローチャート

```mermaid
flowchart TD
    A[テンプレート一覧] --> B{ZIPサポート?}
    B -->|No| C[インストール案内表示]
    B -->|Yes| D[ZIPアップロードリンク]
    D --> E[bs_uploadzip.asp]
    E --> F[ZIPファイル選択]
    F --> G[アップロード実行]
    G --> H[CSRFトークン検証]
    H --> I{拡張子チェック}
    I -->|ZIP以外| J[エラー: err_fileType]
    I -->|ZIP| K[bs_unzip.aspへリダイレクト]

    K --> L[解凍設定画面]
    L --> M[設定入力]
    M --> N[解凍実行]
    N --> O{解凍成功?}
    O -->|No| P[エラー表示]
    O -->|Yes| Q{ZIP削除?}
    Q -->|Yes| R[ZIPファイル削除]
    Q -->|No| S[そのまま]
    R --> T[bs_CreateTemplate.aspへ]
    S --> T

    T --> U[HTMLファイル選択]
    U --> V[テンプレート名設定]
    V --> W[テンプレート登録]
    W --> X[テンプレート一覧へリダイレクト]

    J --> Y[ファイル削除]
    Y --> E
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-28-01 | 権限制御 | bTemplates権限を持つユーザーのみ操作可能 | 全操作時 |
| BR-28-02 | ZIPコンポーネント必須 | ZIPコンポーネントがインストールされていないと利用不可 | 機能アクセス時 |
| BR-28-03 | ZIP形式のみ | アップロード可能なファイルはZIP形式のみ | アップロード時 |
| BR-28-04 | CSRF保護 | アップロード時は必ずCSRFトークンを検証 | アップロード時 |
| BR-28-05 | デフォルト解凍先 | デフォルトの解凍先は/templatesフォルダ | 解凍設定時 |
| BR-28-06 | 自動ファイル名 | フォルダ名未指定時はZIPファイル名から自動生成 | 解凍時 |
| BR-28-07 | Artisteerテンプレート | JStemplate/Artisteer形式のテンプレートは自動検出・処理 | テンプレート作成時 |
| BR-28-08 | 許可ファイルタイプ | 不許可のファイルタイプは解凍時に削除 | 解凍時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テンプレート作成 | template | INSERT | 解凍したテンプレートを登録 |

### テーブル別操作詳細

テンプレート登録処理はbs_CreateTemplate.aspで実行される。詳細は「26-テンプレート作成・編集」を参照。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_fileType | ファイル形式エラー | ZIP以外のファイルをアップロード | ZIP形式ファイルを選択 |
| err_newFile | ファイル未選択エラー | ファイルが選択されていない | ファイルを選択 |
| - | ZIPコンポーネントエラー | ZIPコンポーネント未インストール | XStandardをインストール |
| - | 解凍エラー | ZIPファイルが不正または解凍失敗 | 正しいZIPファイルを再アップロード |
| - | パス不存在 | 解凍先パスが存在しない | 別のパスを選択 |

### リトライ仕様

特になし（ユーザーが適切なファイルで再アップロード）

## トランザクション仕様

- ファイルアップロードとZIP解凍は順次実行
- テンプレート登録はtemplate.save()でトランザクション管理

## パフォーマンス要件

- ファイルサイズに応じて処理時間が変動
- 200KB制限がある場合があり（サーバー設定依存）

## セキュリティ考慮事項

- CSRF対策: QS_secCodeHiddenによるトークン埋め込みとcheckCSRF_Upload()による検証
- ファイル形式制限: ZIP形式のみに制限
- 不許可ファイルタイプの削除: 解凍時に不許可ファイルを自動削除
- 権限制御: secondAdmin.bTemplates権限による制限
- ZIPコンポーネント: 信頼性の高いコンポーネント（aspEasyZip by John Lohmeyer）を使用

## 備考

- JStemplates.com形式のテンプレートに対応
- Artisteerテンプレート（旧形式）にも対応
- ZIPコンポーネントがない場合はXStandardのインストールを案内

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ZIPサポート確認を理解する

テンプレート一覧でのZIPサポート判定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_templateList.asp | `asp/bs_templateList.asp` | ZIPサポート確認とリンク表示 |

**主要処理フロー**:
- **27-29行目**: cls_zipper生成、supportZipper判定
- サポートありの場合: アップロードリンク表示
- サポートなしの場合: XStandardインストール案内表示

#### Step 2: アップロード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_uploadzip.asp | `asp/bs_uploadzip.asp` | ZIPファイルアップロード |

**主要処理フロー**:
1. **4-6行目**: 権限チェック、ZIPサポート確認（なければリダイレクト）
2. **7-11行目**: FreeASPUploadでファイル受信
3. **17行目**: checkCSRF_Upload()でトークン検証
4. **22-26行目**: 拡張子チェック（ZIPのみ許可）
5. **27-31行目**: エラー時はファイル削除、成功時はbs_unzip.aspへリダイレクト

#### Step 3: 解凍処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_unzip.asp | `asp/bs_unzip.asp` | ZIP解凍処理 |

**主要処理フロー**:
1. **11-15行目**: 権限チェック、ZIPサポート確認
2. **16-21行目**: cls_fileexplorer初期化、デフォルト設定
3. **22-57行目**: ポストバック処理（解凍実行）
   - **24-30行目**: フォルダ名設定（未指定時はZIPファイル名から生成）
   - **34行目**: zipper.unpack()で解凍実行
   - **36-39行目**: オプションによりZIPファイル削除
   - **42-49行目**: 解凍成功時はbs_CreateTemplate.aspへリダイレクト
4. **58行目以降**: 解凍設定フォーム表示

#### Step 4: テンプレート作成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_CreateTemplate.asp | `asp/bs_CreateTemplate.asp` | テンプレート作成処理 |

**主要処理フロー**:
- 詳細は「26-テンプレート作成・編集」を参照

### プログラム呼び出し階層図

```
bs_templateList.asp（起点）
    │
    ├─ cls_zipper（ZIPサポート確認）
    │
    └─ bs_uploadzip.asp（アップロード画面）
           │
           ├─ FreeASPUpload.Save()
           │
           ├─ checkCSRF_Upload()
           │
           ├─ GetFileExtension()
           │
           └─ bs_unzip.asp（解凍画面）
                  │
                  ├─ cls_zipper
                  │      └─ unpack()
                  │
                  ├─ cls_fileexplorer
                  │      ├─ SelectBoxFolders()
                  │      └─ deleteFile()
                  │
                  └─ bs_CreateTemplate.asp（テンプレート作成）
                         │
                         ├─ cls_template
                         │      ├─ treatAsArtisteer()
                         │      └─ save()
                         │
                         └─ FileSystemObject
```

### データフロー図

```
[入力]                    [処理]                      [出力]

ZIPファイル ────────────▶ FreeASPUpload.Save() ────▶ userfiles/
                               │                    *.zip
                               ▼
                        拡張子チェック
                               │
                               ▼
                        bs_unzip.asp
                               │
                               ▼
                        zipper.unpack()
                               │
                               ▼
                        テンプレートフォルダ ──────▶ userfiles/
                                                  templates/
                                                  {フォルダ}/
                               │
                               ▼
                        bs_CreateTemplate.asp
                               │
                               ▼
                        template.save()
                               │
                               ▼
                        データベース登録
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_uploadzip.asp | `asp/bs_uploadzip.asp` | ソース | ZIPアップロード画面 |
| bs_unzip.asp | `asp/bs_unzip.asp` | ソース | ZIP解凍処理 |
| bs_CreateTemplate.asp | `asp/bs_CreateTemplate.asp` | ソース | テンプレート作成 |
| bs_templateList.asp | `asp/bs_templateList.asp` | ソース | 起点画面 |
| bs_templateBack.asp | `asp/bs_templateBack.asp` | インクルード | テンプレート編集補助 |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
