# 機能設計書 29-オンラインテンプレート検索

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるオンラインテンプレート検索機能の詳細設計を記載する。

### 本機能の処理概要

オンラインテンプレート検索機能は、外部のオンラインテンプレートギャラリーからテンプレートを検索・プレビュー・ダウンロード・インストールするための機能である。インターネット経由でテンプレートリストを取得し、ワンクリックでテンプレートをシステムに追加できる。

**業務上の目的・背景**：高品質なテンプレートを外部から取得することは、サイトデザインの選択肢を大幅に広げる。本機能により、管理者は外部のテンプレートギャラリーを直接検索し、プレビューで確認してから必要なテンプレートをインストールできる。これにより、テンプレート取得・インポート作業が大幅に効率化される。

**機能の利用シーン**：新規サイト構築時のテンプレート選定、既存サイトのデザインリニューアル時、複数のテンプレート候補を比較検討する際に使用される。

**主要な処理内容**：
1. 認証・権限チェック（secondAdmin.bTemplates権限の確認）
2. 外部サーバーからテンプレートリストを取得（MSXML2.ServerXMLHTTP）
3. テンプレート一覧のページング表示
4. テンプレートプレビュー（ポップアップ）
5. テンプレートのダウンロード・インストール処理
6. ローカルへのファイル保存とフォルダ構造の作成
7. テンプレート作成画面への遷移

**関連システム・外部連携**：MSXML2.ServerXMLHTTPによる外部API通信。外部テンプレートギャラリーサーバー（sBrowseOnlineTemplatesUrl設定）との連携。

**権限による制御**：secondAdmin.bTemplates権限を持つユーザーのみがアクセス可能。bBrowseOnlineTemplates設定が有効な場合のみ機能が利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 74 | テンプレート検索 | 主画面 | オンラインテンプレートギャラリーからの検索 |
| 73 | テンプレート作成 | 遷移先画面 | ダウンロード後のテンプレート作成処理 |

## 機能種別

外部連携 / 検索・インポート処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iStart | Integer | No | ページング開始位置（1始まり） | 数値チェック、デフォルト1 |
| install | String | No | インストール対象テンプレートパス | URLエンコード済 |
| sBrowseOnlineTemplatesUrl | String | No | オンラインギャラリーURL（上書き用） | URL形式 |

### 入力データソース

- URLクエリストリング（ページング、インストール対象）
- 外部API（テンプレートリスト取得）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| テンプレート一覧 | HTML | サムネイル画像とインストールリンクの一覧 |
| ダウンロードファイル | Files | テンプレートファイル群 |
| session("fullListTemplates") | String | テンプレートリストのキャッシュ |

### 出力先

- 画面表示（テンプレート一覧）
- ファイルシステム（userfiles/templates/配下）
- リダイレクト（bs_CreateTemplate.aspへ）

## 処理フロー

### 処理シーケンス（テンプレートリスト表示）

```
1. テンプレート一覧から「Search for templates online」リンクをクリック
   └─ bs_templateSearch.aspへ遷移
2. 権限チェック
   └─ logon.hasaccess secondAdmin.bTemplates
3. セッションキャッシュ確認
   ├─ キャッシュなし: 外部サーバーからリスト取得
   └─ キャッシュあり: セッションから取得
4. 外部APIリクエスト
   └─ MSXML2.ServerXMLHTTPでリスト取得
5. ページング処理
   └─ browseBy（30件）ずつ表示
6. テンプレート一覧表示
   └─ サムネイル画像とインストールリンク
```

### 処理シーケンス（テンプレートインストール）

```
1. インストールリンクをクリック
   └─ install パラメータ付きでbs_templateSearch.aspへ
2. ファイルリスト取得
   └─ 外部サーバーからテンプレートのファイルリスト取得
3. フォルダ構造作成
   └─ templates/{カテゴリ}/{テンプレート名}/images
4. ファイルダウンロード
   └─ 各ファイルをHTTP経由でダウンロード
5. ローカル保存
   └─ SaveBinaryData関数でファイル保存
6. テンプレート作成画面へリダイレクト
   └─ bs_CreateTemplate.aspへ
```

### フローチャート

```mermaid
flowchart TD
    A[テンプレート一覧] --> B{オンライン検索有効?}
    B -->|No| C[リンク非表示]
    B -->|Yes| D[オンライン検索リンク]
    D --> E[bs_templateSearch.asp]
    E --> F{権限チェック}
    F -->|権限なし| G[アクセス拒否]
    F -->|権限あり| H{installパラメータ?}

    H -->|Yes| I[インストール処理]
    I --> J[ファイルリスト取得]
    J --> K[フォルダ構造作成]
    K --> L[ファイルダウンロード]
    L --> M[ローカル保存]
    M --> N[bs_CreateTemplate.aspへリダイレクト]

    H -->|No| O{セッションキャッシュ?}
    O -->|なし| P[外部API呼び出し]
    P --> Q[セッションに保存]
    Q --> R[テンプレート一覧表示]
    O -->|あり| R

    R --> S[ページングナビゲーション]
    S --> T[サムネイル画像表示]
    T --> U[プレビュー/インストールリンク]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-29-01 | 権限制御 | bTemplates権限を持つユーザーのみ操作可能 | 全操作時 |
| BR-29-02 | 機能有効設定 | bBrowseOnlineTemplates設定が有効な場合のみ利用可能 | 機能アクセス時 |
| BR-29-03 | ページング | 1ページあたり30件のテンプレートを表示 | 一覧表示時 |
| BR-29-04 | セッションキャッシュ | テンプレートリストはセッションにキャッシュ | リスト取得時 |
| BR-29-05 | インストール確認 | インストール前に確認ダイアログを表示 | インストール時 |
| BR-29-06 | フォルダ自動作成 | テンプレートフォルダ構造を自動作成 | インストール時 |
| BR-29-07 | バイナリ保存 | ファイルはバイナリモードで保存 | ファイルダウンロード時 |

### 計算ロジック

- ページ数計算: `max(配列上限) / browseBy`
- 表示開始位置: `iStart * browseBy`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| テンプレート作成 | template | INSERT | ダウンロード後にbs_CreateTemplate.aspで登録 |

### テーブル別操作詳細

テンプレート登録処理はbs_CreateTemplate.aspで実行される。詳細は「26-テンプレート作成・編集」を参照。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bTemplates権限なし | アクセス拒否 |
| - | 通信エラー | 外部サーバーに接続できない | エラーメッセージ表示 |
| - | ダウンロードエラー | HTTP status != 200 | ファイルスキップ |
| - | フォルダ作成エラー | パーミッション不足 | on error resume nextで継続 |

### リトライ仕様

特になし（ユーザーが再度アクセス）

## トランザクション仕様

- ファイルダウンロードは個別に実行（1ファイルずつ）
- テンプレート登録はtemplate.save()でトランザクション管理

## パフォーマンス要件

- 外部APIへの接続タイムアウトはServerXMLHTTPのデフォルト設定
- セッションキャッシュにより2回目以降の表示を高速化

## セキュリティ考慮事項

- 権限制御: secondAdmin.bTemplates権限による制限
- 外部通信: MSXML2.ServerXMLHTTPによる安全な通信
- URL検証: server.URLEncode()による適切なエンコード
- エラー処理: on error resume nextによる継続的処理（フォルダ作成時）

## 備考

- オンラインギャラリーのURLは設定（sBrowseOnlineTemplatesUrl）で指定
- プレビューはポップアップウィンドウ（bPopupFullWidthNoReloadクラス使用）
- テンプレートリストはvbCrLf区切りのテキスト形式
- バージョン情報（C_QS_VERSION）を外部APIに送信

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 機能有効設定の確認を理解する

テンプレート一覧での表示条件を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_templateList.asp | `asp/bs_templateList.asp` | bBrowseOnlineTemplates設定によるリンク表示 |

**主要処理フロー**:
- **30行目**: `if bBrowseOnlineTemplates then` で有効判定
- 有効な場合のみ「Search for templates online」リンクを表示

#### Step 2: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_templateSearch.asp | `asp/bs_templateSearch.asp` | オンラインテンプレート検索メイン |

**主要処理フロー**:
1. **4行目**: 権限チェック `logon.hasaccess secondAdmin.bTemplates`
2. **5行目**: browseBy=30（ページング件数）
3. **6-8行目**: クエリストリングからURL上書き
4. **10-38行目**: インストール処理
5. **40-49行目**: テンプレートリスト取得（APIまたはキャッシュ）
6. **50-51行目**: ページング開始位置取得
7. **52-65行目**: テンプレート一覧生成
8. **66-78行目**: ページングナビゲーション（navbalk関数）

#### Step 3: インストール処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_templateSearch.asp | `asp/bs_templateSearch.asp` | installパラメータ時の処理（10-38行目） |

**主要処理フロー**:
1. **11-14行目**: MSXML2.ServerXMLHTTPでファイルリスト取得
2. **16-17行目**: インストールパスの解析
3. **20-26行目**: フォルダ構造作成（on error resume nextで継続）
4. **27-35行目**: ファイルダウンロードループ
   - **29行目**: 各ファイルをHTTP GET
   - **31行目**: status=200の場合のみ保存
   - **32行目**: SaveBinaryData関数でバイナリ保存
5. **38行目**: bs_CreateTemplate.aspへリダイレクト

#### Step 4: テンプレート一覧表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bs_templateSearch.asp | `asp/bs_templateSearch.asp` | 一覧表示部分（52-65行目） |

**主要処理フロー**:
- **55-64行目**: 配列ループでテンプレート表示
- **57行目**: ページング範囲内のアイテムのみ表示
- **58-60行目**: サムネイル画像とリンクの生成
- プレビュー: `bPopupFullWidthNoReload`クラスでポップアップ
- インストール: 確認ダイアログ後にinstallパラメータ付きでアクセス

### プログラム呼び出し階層図

```
bs_templateList.asp（起点）
    │
    └─ bs_templateSearch.asp（オンライン検索）
           │
           ├─ MSXML2.ServerXMLHTTP
           │      ├─ テンプレートリスト取得
           │      └─ ファイルダウンロード
           │
           ├─ FileSystemObject
           │      └─ フォルダ作成
           │
           ├─ SaveBinaryData()
           │      └─ バイナリファイル保存
           │
           ├─ navbalk()（ページング）
           │
           └─ bs_CreateTemplate.asp（テンプレート作成）
```

### データフロー図

```
[外部サーバー]          [処理]                      [出力]

ギャラリーサーバー ────▶ ServerXMLHTTP ────────▶ テンプレートリスト
(list.asp)                   │                  (session保存)
                             ▼
                       一覧表示HTML
                             │
                             ▼
インストール選択 ────────────▶ ファイルリスト取得
                             │
                             ▼
                       フォルダ構造作成
                             │
                             ▼
ファイルダウンロード ────────▶ SaveBinaryData ────▶ userfiles/
(各ファイル)                                     templates/
                             │
                             ▼
                       bs_CreateTemplate.asp
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_templateSearch.asp | `asp/bs_templateSearch.asp` | ソース | オンライン検索メイン |
| bs_templateList.asp | `asp/bs_templateList.asp` | ソース | 起点画面 |
| bs_CreateTemplate.asp | `asp/bs_CreateTemplate.asp` | 遷移先 | テンプレート作成 |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| includes/header.asp | `asp/includes/header.asp` | インクルード | HTMLヘッダー出力 |
