# 機能設計書 3-セカンドアドミン管理

## 概要

本ドキュメントは、QuickerSite CMSの制限された権限を持つ副管理者（セカンドアドミン）アカウントの作成・管理機能について記述する。

### 本機能の処理概要

本機能は、メイン管理者が副管理者（セカンドアドミン）を作成・管理するための機能を提供する。セカンドアドミンには個別に権限を設定でき、サイト管理業務の分担や、特定の管理機能のみを許可した限定的な管理者アカウントを作成できる。

**業務上の目的・背景**：大規模なサイト運営や複数人での管理体制において、全権限を持つメイン管理者以外に、特定の業務のみを担当する管理者が必要となる場合がある。セカンドアドミン機能により、コンテンツ編集のみ、フォーム管理のみなど、業務に応じた権限分離が可能となり、セキュリティと運用効率の両立を実現する。

**機能の利用シーン**：
- 新規セカンドアドミンアカウントの作成
- 既存セカンドアドミンの権限変更
- セカンドアドミンアカウントの削除
- コンテンツ編集者への限定権限付与
- 外部委託先への限定的なアクセス権付与

**主要な処理内容**：
1. セカンドアドミンパスワードの設定（2段階：パスワード設定後に権限設定）
2. 40以上の個別権限フラグの設定
3. 権限設定の保存
4. セカンドアドミンアカウントの削除

**関連システム・外部連携**：なし

**権限による制御**：メイン管理者のみがセカンドアドミンを管理可能。セカンドアドミンはこの画面にアクセスできない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 113 | セキュリティ設定 | 主画面 | バックサイトのセキュリティ・アクセス制御設定 |
| 115 | セカンド管理者 | 主画面 | 制限付き副管理者アカウントの作成・管理 |
| 116 | セカンド管理者PW | 参照画面 | セカンド管理者のパスワード設定 |

## 機能種別

アカウント管理 / 権限管理 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sPassword | String | Yes | セカンドアドミンパスワード | SHA-256ハッシュ化 |
| sPasswordConfirm | String | Yes | パスワード確認 | sPasswordと一致 |
| bPagesAdd | Boolean | No | ページ追加権限 | true/false |
| bPagesPW | Boolean | No | ページパスワード管理権限 | true/false |
| bPagesMove | Boolean | No | ページ移動権限 | true/false |
| bPagesDelete | Boolean | No | ページ削除権限 | true/false |
| bPageTitle | Boolean | No | ページタイトル編集権限 | true/false |
| bPageBody | Boolean | No | ページ本文編集権限 | true/false |
| bSetupGeneral | Boolean | No | 一般設定権限 | true/false |
| bSetupPageElements | Boolean | No | ページ要素設定権限 | true/false |
| bStats | Boolean | No | 統計閲覧権限 | true/false |
| bTemplates | Boolean | No | テンプレート管理権限 | true/false |
| bHomeConstants | Boolean | No | 定数管理権限 | true/false |
| bFiles | Boolean | No | ファイル管理権限 | true/false |
| bForms | Boolean | No | フォーム管理権限 | true/false |
| bIntranet | Boolean | No | イントラネット管理権限 | true/false |
| bCatalog | Boolean | No | カタログ管理権限 | true/false |
| bFeed | Boolean | No | フィード管理権限 | true/false |
| bGallery | Boolean | No | ギャラリー管理権限 | true/false |
| btnaction | String | Yes | 実行アクション | "save" または "delete" |

### 入力データソース

- 画面入力（権限設定フォーム）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sPassword | String | SHA-256ハッシュ化されたパスワード |
| 各権限フラグ | Boolean | 40以上の権限設定フラグ |

### 出力先

- データベース（tblSecondAdmin）

## 処理フロー

### 処理シーケンス

```
1. セカンドアドミン管理画面アクセス
   └─ メイン管理者のみアクセス可能（セカンドアドミンの場合はbs_default.aspへリダイレクト）
   └─ パスワード未設定の場合はbs_secondAdminPW.aspへリダイレクト

2. 権限設定フォーム表示
   └─ 現在の権限設定を読み込み
   └─ チェックボックス形式で表示

3. 保存処理（btnaction="save"）
   └─ CSRF検証
   └─ getRequestValues()で権限フラグ取得
   └─ save()でデータベース保存
   └─ メニューキャッシュクリア

4. 削除処理（btnaction="delete"）
   └─ CSRF検証
   └─ delete()でtblSecondAdminレコード削除
   └─ bs_applyTotalPW.aspへリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[セカンドアドミン管理画面] --> B{メイン管理者?}
    B -->|No| C[bs_default.aspへリダイレクト]
    B -->|Yes| D{パスワード設定済み?}
    D -->|No| E[bs_secondAdminPW.aspへリダイレクト]
    D -->|Yes| F[権限設定フォーム表示]
    F --> G{アクション}
    G -->|保存| H[CSRF検証]
    H --> I[getRequestValues]
    I --> J[save]
    J --> K[メニューキャッシュクリア]
    K --> L[成功メッセージ表示]
    G -->|削除| M[CSRF検証]
    M --> N[delete]
    N --> O[bs_applyTotalPW.aspへリダイレクト]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | メイン管理者専用 | セカンドアドミンはこの機能にアクセス不可 | 常時 |
| BR-02 | パスワード設定必須 | 権限設定前にパスワード設定が必要 | 初回設定時 |
| BR-03 | パスワード確認必須 | パスワードと確認用パスワードの一致が必要 | パスワード設定時 |
| BR-04 | メイン管理者と同一パスワード禁止 | セカンドアドミンパスワードはメイン管理者と異なる必要あり | パスワード設定時 |
| BR-05 | デフォルトパスワード禁止 | "admin"などのデフォルトパスワードは使用不可 | パスワード設定時 |

### 計算ロジック

- パスワードハッシュ: `sha256(入力パスワード)`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 権限取得 | tblSecondAdmin | SELECT | 現在の権限設定を取得 |
| 権限保存 | tblSecondAdmin | INSERT/UPDATE | 権限設定を保存 |
| アカウント削除 | tblSecondAdmin | DELETE | セカンドアドミンレコード削除 |

### テーブル別操作詳細

#### tblSecondAdmin

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iCustomerID = cId | 全カラム取得 |
| INSERT/UPDATE | sPassword | sha256(入力値) | ハッシュ化して保存 |
| INSERT/UPDATE | bSetupGeneral | true/false | 一般設定権限 |
| INSERT/UPDATE | bPagesAdd | true/false | ページ追加権限 |
| INSERT/UPDATE | 他40以上の権限フラグ | true/false | 各種権限 |
| DELETE | - | iCustomerID = cId | 全レコード削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 入力エラー | パスワードまたは確認用パスワードが空 | 再入力を促す |
| pwnomatch | 入力エラー | パスワードと確認用パスワードが不一致 | 再入力を促す |
| err_firstandsecondpassword | 入力エラー | メイン管理者と同一パスワード | 異なるパスワードを設定 |
| err_backsitepw | 入力エラー | デフォルトパスワード使用 | 異なるパスワードを設定 |

### リトライ仕様

- エラー時は同一画面で再入力可能

## トランザクション仕様

- 保存処理: 単一UPDATE/INSERTで完結
- 削除処理: 単一DELETEで完結

## パフォーマンス要件

- 権限設定保存: 即座に完了

## セキュリティ考慮事項

- パスワードはSHA-256でハッシュ化して保存
- CSRF対策トークン検証
- メイン管理者のみアクセス可能
- 権限の最小付与原則に基づく個別権限設定

## 備考

- セカンドアドミンの権限は40以上の細かい項目に分かれており、きめ細かな権限管理が可能
- 一部の権限は階層構造になっており、親権限がないと子権限が表示されない（例：bIntranet がtrueでないとbIntranetSetupは表示されない）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

セカンドアドミンの権限フラグ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | cls_secondAdminクラス全体。40以上の権限フラグの定義（2-8行目） |

**読解のコツ**: cls_secondAdminクラスのPublicプロパティが全て権限フラグ。bで始まるBooleanプロパティが権限を表す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_secondAdmin.asp | `asp/bs_secondAdmin.asp` | 権限管理画面のメインファイル |

**主要処理フロー**:
1. **4行目**: メイン管理者チェック（セカンドアドミンの場合はリダイレクト）
2. **7行目**: パスワード未設定チェック（未設定の場合はbs_secondAdminPW.aspへ）
3. **13-21行目**: btnaction処理分岐（save/delete）
4. **15-17行目**: save処理（checkCSRF、getRequestValues、save）
5. **18-21行目**: delete処理（checkCSRF、delete、リダイレクト）

#### Step 3: 権限クラスの保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | secondAdmin.asp | `asp/includes/secondAdmin.asp` | save関数とcheck関数 |

**主要処理フロー**:
- **75-94行目**: check関数 - パスワード検証
- **77-79行目**: 空チェック
- **80-82行目**: パスワード確認一致チェック
- **83-85行目**: メイン管理者パスワード重複チェック
- **86-89行目**: デフォルトパスワードチェック
- **95-172行目**: save関数 - 権限設定の保存
- **103-104行目**: レコード存在チェック（INSERT/UPDATE判定）

### プログラム呼び出し階層図

```
bs_secondAdmin.asp
    │
    ├─ begin.asp（インクルード）
    │      └─ includes/secondAdmin.asp（cls_secondAdminクラス）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ メイン管理者チェック
    │      └─ セカンドアドミンの場合 → bs_default.asp
    │
    ├─ パスワード設定チェック
    │      └─ 未設定の場合 → bs_secondAdminPW.asp
    │
    ├─ cls_secondAdmin.new()
    │      └─ pick() - 現在の設定読み込み
    │
    ├─ btnaction="save"
    │      ├─ checkCSRF()
    │      ├─ getRequestValues()
    │      ├─ save()
    │      │      ├─ check() - 検証
    │      │      └─ INSERT/UPDATE
    │      └─ clearMenuCache()
    │
    └─ btnaction="delete"
           ├─ checkCSRF()
           ├─ delete()
           └─ Response.Redirect
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ────▶ getRequestValues()
(40+権限フラグ)           │
                         ▼
                    check() 検証
                         │
                    ┌────┴────┐
                    ▼         ▼
               検証OK      検証NG
                  │           │
                  ▼           ▼
             save()      エラー表示
                  │
                  ▼
         tblSecondAdmin
         (INSERT/UPDATE)
                  │
                  ▼
         clearMenuCache()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_secondAdmin.asp | `asp/bs_secondAdmin.asp` | ソース | 権限管理画面メインファイル |
| bs_secondAdminPW.asp | `asp/bs_secondAdminPW.asp` | ソース | パスワード設定画面 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | cls_secondAdminクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | 認証チェック・権限適用 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化・インクルード管理 |
