# 機能設計書 30-デフォルトテンプレート設定

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるデフォルトテンプレート設定機能の詳細設計を記載する。

### 本機能の処理概要

デフォルトテンプレート設定機能は、サイト全体で使用される標準テンプレートを指定するための機能である。テンプレート一覧画面から「set as default」リンクをクリックすることで、選択したテンプレートをサイトのデフォルトテンプレートとして設定できる。

**業務上の目的・背景**：CMSでは複数のテンプレートを管理できるが、個々のページにテンプレートが指定されていない場合に使用されるデフォルトテンプレートを設定する必要がある。本機能により、管理者はサイト全体のベースとなるデザインを簡単に切り替えることができ、サイトのリニューアルやデザイン変更を効率的に行える。

**機能の利用シーン**：サイトのデザイン変更、新しいテンプレートへの切り替え、A/Bテスト用のテンプレート切り替えなどの際に使用される。

**主要な処理内容**：
1. 認証・権限チェック（secondAdmin.bTemplates権限の確認）
2. CSRFトークンの検証
3. 指定されたテンプレートIDの復号と検証
4. customer.defaultTemplateの更新
5. customer.save()による永続化
6. テンプレート一覧画面の再表示

**関連システム・外部連携**：フロントエンド表示エンジンがdefaultTemplateを参照してページ表示時のテンプレートを決定。

**権限による制御**：secondAdmin.bTemplates権限を持つユーザーのみがアクセス可能。この権限がない場合はアクセス拒否される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 71 | テンプレート一覧 | 主画面 | デフォルト設定リンクによる設定変更 |

## 機能種別

設定変更 / CRUD操作（更新）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| a | String | Yes | アクション種別（"default"） | 固定値との一致確認 |
| itemplateID | String | Yes | デフォルトに設定するテンプレートID（暗号化済） | decrypt()で復号、数値チェック |
| QSSEC | String | Yes | CSRFトークン | checkCSRF()による検証 |

### 入力データソース

- URLクエリストリング（アクション、テンプレートID、CSRFトークン）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.defaultTemplate | Integer | 更新されたデフォルトテンプレートID |

### 出力先

- データベース（customerテーブルのdefaultTemplateカラム）
- 画面表示（テンプレート一覧の更新表示）

## 処理フロー

### 処理シーケンス

```
1. テンプレート一覧画面で「set as default」リンクをクリック
   └─ bs_templateList.asp?a=default&itemplateID=...&{CSRFトークン}
2. 権限チェック
   └─ logon.hasaccess secondAdmin.bTemplates
3. パラメータ検証
   └─ itemplateIDが数値として有効か確認
4. CSRFトークン検証
   └─ checkCSRF()関数による検証
5. アクション判定
   └─ a="default"であることを確認
6. デフォルトテンプレート設定
   └─ customer.defaultTemplate=template.iId
7. 保存処理
   └─ customer.save()
8. 画面表示
   └─ 更新されたテンプレート一覧を表示
```

### フローチャート

```mermaid
flowchart TD
    A[テンプレート一覧] --> B[set as defaultリンククリック]
    B --> C[bs_templateList.asp?a=default&...]
    C --> D{権限チェック}
    D -->|権限なし| E[アクセス拒否]
    D -->|権限あり| F{itemplateID有効?}
    F -->|No| G[処理スキップ]
    F -->|Yes| H[CSRFトークン検証]
    H --> I{アクション判定}
    I -->|a=default| J[customer.defaultTemplate設定]
    I -->|その他| G
    J --> K[customer.save]
    K --> L[テンプレート一覧表示]
    G --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-30-01 | 権限制御 | bTemplates権限を持つユーザーのみ操作可能 | 全操作時 |
| BR-30-02 | CSRF保護 | 設定変更時は必ずCSRFトークンを検証 | 設定変更時 |
| BR-30-03 | 単一デフォルト | デフォルトテンプレートは常に1つのみ | 設定時 |
| BR-30-04 | ID暗号化 | テンプレートIDはURLパラメータ時に暗号化 | ID受け渡し時 |
| BR-30-05 | 既デフォルト非表示 | 既にデフォルトのテンプレートには設定リンクを表示しない | 一覧表示時 |
| BR-30-06 | デフォルト削除禁止 | デフォルトテンプレートは削除不可（関連） | 削除操作時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| デフォルト設定 | customer | UPDATE | defaultTemplateカラムの更新 |

### テーブル別操作詳細

#### customerテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | defaultTemplate | 指定されたテンプレートID（復号後） | デフォルト設定時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bTemplates権限なし | アクセス拒否 |
| - | CSRFエラー | CSRFトークン不一致 | checkCSRF()でエラー処理 |
| - | ID不正 | テンプレートIDが無効 | 処理スキップ |

### リトライ仕様

特になし（ユーザーが再度操作）

## トランザクション仕様

customer.save()メソッド内でトランザクション管理。保存失敗時はロールバック。

## パフォーマンス要件

単一カラムの更新のため、特別な要件なし。

## セキュリティ考慮事項

- CSRF対策: QS_secCodeURLによるトークン付与とcheckCSRF()による検証
- ID暗号化: encrypt()/decrypt()による暗号化でIDの推測を防止
- 権限制御: secondAdmin.bTemplates権限による制限
- 即時反映: 設定変更は即座にサイト全体に影響するため、権限管理が重要

## 備考

- デフォルトテンプレートの変更は、個別にテンプレートが指定されていないページすべてに影響する
- テンプレート一覧では、現在のデフォルトテンプレートに「(default)」と表示される
- デフォルト以外のテンプレートには「(set as default)」リンクが表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: デフォルト設定リンクの表示を理解する

テンプレート一覧でのデフォルト設定リンクの表示条件を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_templateList.asp | `asp/bs_templateList.asp` | デフォルト設定リンクの生成 |

**主要処理フロー**:
- **26行目**: テンプレートループ内での表示処理
- `if convertGetal(templateKey)=convertGetal(customer.defaultTemplate) then` で現在のデフォルト判定
- デフォルトの場合: `(default)` を表示
- デフォルトでない場合: `(set as default)` リンクを表示
- リンクURL: `bs_templateList.asp?a=default&{CSRFトークン}&iTemplateID={暗号化ID}`

#### Step 2: デフォルト設定処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_templateList.asp | `asp/bs_templateList.asp` | defaultアクション処理 |

**主要処理フロー**:
1. **6行目**: `convertGetal(decrypt(request("itemplateID")))<>0` でID有効性チェック
2. **7行目**: `checkCSRF()` でトークン検証
3. **8行目**: `select case Request.QueryString("a")` でアクション判定
4. **13-15行目**: `case "default"` - デフォルト設定処理
   - **14行目**: `customer.defaultTemplate=template.iId`
   - **15行目**: `customer.save()`

#### Step 3: 表示への反映を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_templateList.asp | `asp/bs_templateList.asp` | 設定後の一覧表示 |

**主要処理フロー**:
- **25-26行目**: テンプレート一覧のループ
- `customer.defaultTemplate`との比較で表示を分岐
- デフォルトテンプレートには削除リンクを非表示

### プログラム呼び出し階層図

```
bs_templateList.asp
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ bs_security.asp（認証・権限）
    │      └─ logon.hasaccess()
    │
    ├─ decrypt()（ID復号）
    │
    ├─ checkCSRF()（CSRF検証）
    │
    ├─ cls_template（テンプレートクラス）
    │      └─ iId取得
    │
    ├─ customer.defaultTemplate（デフォルト設定）
    │
    ├─ customer.save()（保存）
    │
    └─ テンプレート一覧表示
           ├─ デフォルト判定
           │      └─ customer.defaultTemplate比較
           │
           ├─ (default)表示
           │
           └─ (set as default)リンク表示
```

### データフロー図

```
[入力]                    [処理]                      [出力]

a=default ────────────────▶ アクション判定
itemplateID ──▶ decrypt() ─▶ テンプレートID
QSSEC ────────▶ checkCSRF()
                    │
                    ▼
            customer.defaultTemplate設定
                    │
                    ▼
              customer.save()
                    │
                    ▼
              データベース更新
                    │
                    ▼
            テンプレート一覧表示更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_templateList.asp | `asp/bs_templateList.asp` | ソース | デフォルト設定処理・一覧表示 |
| begin.asp | `asp/begin.asp` | インクルード | 初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | インクルード | 認証・権限チェック |
| includes/header.asp | `asp/includes/header.asp` | インクルード | HTMLヘッダー出力 |
| bs_initBack.asp | `asp/bs_initBack.asp` | インクルード | バックオフィス初期化 |
| bs_header.asp | `asp/bs_header.asp` | インクルード | ナビゲーション |
| default.asp | `asp/default.asp` | 関連 | フロントエンドでのデフォルトテンプレート参照 |
