# 機能設計書 31-モバイル設定

## 概要

本ドキュメントは、QuickerSite CMSにおけるモバイル端末向けテンプレート・表示設定機能の設計を記述する。

### 本機能の処理概要

モバイル設定機能は、スマートフォンやモバイル端末からのアクセス時に、専用のテンプレートを適用したりモバイル版サイトにリダイレクトしたりするための設定を管理する機能である。

**業務上の目的・背景**：
現代のWebサイトでは、PCとモバイル端末で異なるUI/UXを提供することが求められている。本機能により、管理者はHTTP_USER_AGENTを解析してモバイル端末を判別し、適切なテンプレートやリダイレクト先を設定できる。これにより、モバイルユーザーに対して最適化されたコンテンツを提供し、ユーザビリティを向上させることができる。

**機能の利用シーン**：
- スマートフォン向けに軽量なテンプレートを適用したい場合
- モバイル専用サイト（m.example.comなど）へリダイレクトしたい場合
- 特定のブラウザ・デバイスに対して異なる表示を行いたい場合

**主要な処理内容**：
1. HTTP_USER_AGENTを判別するためのキーワードを設定
2. モバイル端末用テンプレートを選択
3. モバイル版サイトへのリダイレクトURLを設定
4. 設定内容をデータベースに保存

**関連システム・外部連携**：
- tblCustomerテーブル（顧客設定情報の永続化）
- テンプレート管理機能（モバイル用テンプレートの選択）

**権限による制御**：
- 管理者権限が必要（bs_security.aspによる認証）
- セカンドアドミンには別途アクセス権限設定が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 85 | モバイル設定 | 主画面 | モバイル端末向けテンプレート・表示設定 |

## 機能種別

設定管理 / CRUD操作（Update）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| postback | String | Yes | ポストバック判定フラグ | "1"固定 |
| sMOBBrowsers | String | No | モバイル判別キーワード（複数行） | 最大長はDB定義による |
| iDefaultMobileTemplate | String(暗号化) | No | モバイル用テンプレートID | 暗号化された数値 |
| sMOBUrl | String | No | リダイレクト先URL | URL形式、最大255文字 |

### 入力データソース

- 画面入力（フォーム）
- 既存設定値はtblCustomerテーブルから取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.sMOBBrowsers | String | USER_AGENT判別キーワード |
| customer.sMOBUrl | String | リダイレクト先URL |
| customer.iDefaultMobileTemplate | Integer | モバイル用テンプレートID |

### 出力先

- tblCustomerテーブル（設定の永続化）
- 画面（設定完了後のリダイレクト）

## 処理フロー

### 処理シーケンス

```
1. ページ読み込み
   └─ 既存のモバイル設定をcustomerオブジェクトから読み込み
2. sMOBUrlの初期値設定
   └─ 空の場合は"http://"を設定
3. フォーム送信時（postback=1）
   └─ セッションのcheckMobileBrowserをクリア
   └─ sMOBBrowsers, sMOBUrl, iDefaultMobileTemplateを取得
4. 保存ボタン押下時
   └─ customer.save()でデータベースに保存
   └─ 成功メッセージ付きでリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ページ読み込み]
    B --> C{sMOBUrlが空?}
    C -->|Yes| D[sMOBUrl = "http://"]
    C -->|No| E{postback=1?}
    D --> E
    E -->|Yes| F[フォーム値を取得]
    E -->|No| G[フォーム表示]
    F --> H{btnaction=save?}
    H -->|Yes| I[customer.save]
    H -->|No| G
    I --> J[リダイレクト]
    J --> K[終了]
    G --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-031-1 | URL初期値設定 | sMOBUrlが空の場合は"http://"を初期値として設定 | 画面表示時 |
| BR-031-2 | セッションクリア | 設定変更時にcheckMobileBrowserセッションをクリア | ポストバック時 |
| BR-031-3 | テンプレートまたはURL | テンプレートとURLは排他的に使用（テンプレート優先） | リダイレクト設定時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | tblCustomer | UPDATE | モバイル設定の更新 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sMOBBrowsers | フォーム入力値（トリム済み） | モバイル判別キーワード |
| UPDATE | sMOBUrl | フォーム入力値（トリム済み） | リダイレクト先URL |
| UPDATE | iDefaultMobileTemplate | 復号化されたテンプレートID | 暗号化解除後の整数 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | ログインしていない場合 | ログイン画面へリダイレクト |
| - | 権限エラー | 権限がない場合 | アクセス拒否 |

### リトライ仕様

特になし（同期的な設定保存のため）

## トランザクション仕様

customer.save()メソッド内でトランザクション管理。単一レコード更新のため、失敗時は自動ロールバック。

## パフォーマンス要件

- レスポンス時間: 1秒以内
- 同時アクセス: 管理画面のため低負荷を想定

## セキュリティ考慮事項

- bs_security.aspによる管理者認証
- テンプレートIDは暗号化して送受信（encrypt/decrypt関数）
- 入力値はsanitize関数でXSS対策
- セカンドアドミンのアクセス権限制御

## 備考

- HTTP_USER_AGENTの最新履歴が画面下部に表示される（デバッグ・設定支援用）
- テンプレートを設定しない場合は、URLリダイレクトが使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

モバイル設定はcustomerオブジェクトのプロパティとして管理される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | sMOBBrowsers, sMOBUrl, iDefaultMobileTemplateプロパティの定義（16行目） |

**読解のコツ**: cls_customerクラスの定義を確認し、モバイル関連プロパティがどのようにPickメソッド（190-192行目）とSaveメソッド（437-439行目）で処理されるかを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_mobileSetup.asp | `asp/bs_mobileSetup.asp` | メイン処理ファイル、フォーム処理とUI定義 |

**主要処理フロー**:
1. **4-6行目**: sMOBUrlの初期値設定
2. **7-12行目**: ポストバック時のフォーム値取得
3. **13-16行目**: 保存処理とリダイレクト

#### Step 3: セキュリティ・認証を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_security.asp | `asp/bs_security.asp` | 管理者認証のチェック処理 |

### プログラム呼び出し階層図

```
bs_mobileSetup.asp
    │
    ├─ begin.asp（共通初期化）
    │      └─ customer.asp（customerオブジェクト定義）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ bs_initBack.asp（バックサイト初期化）
    │
    ├─ bs_header.asp（ヘッダー表示）
    │
    └─ customer.save()（設定保存）
           └─ tblCustomer UPDATE
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ bs_mobileSetup.asp ───▶ tblCustomer
                        │
                        ├─ sMOBBrowsers
                        ├─ sMOBUrl
                        └─ iDefaultMobileTemplate
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_mobileSetup.asp | `asp/bs_mobileSetup.asp` | ソース | モバイル設定画面のメイン処理 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客設定クラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
| bs_header.asp | `asp/bs_header.asp` | ソース | ヘッダー表示処理 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
