# 機能設計書 32-ポップアップ効果設定

## 概要

本ドキュメントは、QuickerSite CMSにおけるポップアップウィンドウの表示エフェクト設定機能の設計を記述する。

### 本機能の処理概要

ポップアップ効果設定機能は、サイト内でポップアップウィンドウを表示する際のビジュアルエフェクト（スタイル）を選択・設定する機能である。

**業務上の目的・背景**：
Webサイトにおいてモーダルウィンドウやポップアップは、重要な情報の表示や確認ダイアログとして頻繁に使用される。本機能により、サイトのデザインテーマに合わせたポップアップのビジュアルスタイルを選択でき、統一感のあるユーザー体験を提供できる。

**機能の利用シーン**：
- サイトデザインに合わせてポップアップの見た目を変更したい場合
- ダーク/ライトテーマに合わせたポップアップスタイルを選択したい場合
- 角丸・角なしなどのデザイン詳細を調整したい場合

**主要な処理内容**：
1. 5種類のポップアップスタイルからラジオボタンで選択
2. 選択されたスタイルをデータベースに保存
3. 保存完了後、成功メッセージ付きでリダイレクト

**関連システム・外部連携**：
- tblCustomerテーブル（顧客設定情報の永続化）
- ポップアップ表示機能（フロントエンド）

**権限による制御**：
- 管理者権限が必要（bs_security.aspによる認証）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 67 | ポップアップモード | 主画面 | ポップアップの表示エフェクト設定 |

## 機能種別

設定管理 / CRUD操作（Update）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sPopupViewmode | String | Yes | ポップアップスタイル（1-5） | 1-5の数値文字列 |

### 入力データソース

- 画面入力（ラジオボタン）
- 既存設定値はtblCustomerテーブルから取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.sPopupViewmode | String | 選択されたポップアップスタイル（1-5） |

### 出力先

- tblCustomerテーブル（設定の永続化）
- 画面（設定完了後のリダイレクト）

## 処理フロー

### 処理シーケンス

```
1. ページ読み込み
   └─ 既存のポップアップスタイル設定を読み込み
2. スタイル選択（ラジオボタン）
   └─ 5種類のスタイルから1つを選択
3. 保存ボタン押下時
   └─ sPopupViewmodeが空でないことを確認
   └─ customer.sPopupViewmodeに値を設定
   └─ customer.save()でデータベースに保存
   └─ 成功メッセージ付きでリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ページ読み込み]
    B --> C[現在の設定を表示]
    C --> D{sPopupViewmode送信?}
    D -->|No| E[フォーム表示]
    D -->|Yes| F[customer.sPopupViewmode設定]
    F --> G[customer.save]
    G --> H[リダイレクト]
    H --> I[終了]
    E --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-032-1 | デフォルトスタイル | sPopupViewmodeが0または空の場合は"1"を使用 | ポップアップ表示時 |
| BR-032-2 | 単一選択 | スタイルは5種類から1つのみ選択可能 | 設定時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | tblCustomer | UPDATE | ポップアップスタイル設定の更新 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sPopupViewmode | フォーム入力値（1-5） | ポップアップスタイルコード |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | ログインしていない場合 | ログイン画面へリダイレクト |

### リトライ仕様

特になし

## トランザクション仕様

customer.save()メソッド内でトランザクション管理。単一レコード更新のため、失敗時は自動ロールバック。

## パフォーマンス要件

- レスポンス時間: 1秒以内
- 同時アクセス: 管理画面のため低負荷を想定

## セキュリティ考慮事項

- bs_security.aspによる管理者認証
- 入力値は数値文字列のみ許可

## 備考

利用可能なポップアップスタイル:
1. Dark Rounded Square（ダーク角丸四角）
2. Light Square（ライト四角）
3. Dark Square（ダーク四角）
4. Light Rounded Square（ライト角丸四角）
5. Gray Square（グレー四角）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | sPopupViewmodeプロパティの定義（9行目） |

**読解のコツ**: sPopupViewmodeは文字列型として定義され、"1"〜"5"の値を取る。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_popupMode.asp | `asp/bs_popupMode.asp` | メイン処理ファイル |

**主要処理フロー**:
1. **4行目**: sPopupViewmodeの存在チェック
2. **5行目**: customer.sPopupViewmodeへの値設定
3. **6行目**: customer.save()で保存
4. **7行目**: リダイレクト処理

#### Step 3: フロントエンドでの使用を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | sGetPopupModeプロパティ（1517-1523行目） |

### プログラム呼び出し階層図

```
bs_popupMode.asp
    │
    ├─ begin.asp（共通初期化）
    │      └─ customer.asp（customerオブジェクト定義）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ bs_header.asp（ヘッダー表示）
    │
    └─ customer.save()（設定保存）
           └─ tblCustomer UPDATE
```

### データフロー図

```
[入力]               [処理]                    [出力]

ラジオボタン ───▶ bs_popupMode.asp ───▶ tblCustomer
(1-5選択)                                 sPopupViewmode
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_popupMode.asp | `asp/bs_popupMode.asp` | ソース | ポップアップモード設定画面 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客設定クラス定義 |
| popupModeList.asp | `asp/includes/popupModeList.asp` | ソース | ポップアップモードリスト定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・認証処理 |
