# 機能設計書 33-アコーディオンCSS設定

## 概要

本ドキュメントは、QuickerSite CMSにおけるjQueryアコーディオンプラグインのCSS設定機能の設計を記述する。

### 本機能の処理概要

アコーディオンCSS設定機能は、リストページなどで使用されるjQueryアコーディオンUIコンポーネントの見た目（CSS）をカスタマイズする機能である。

**業務上の目的・背景**：
アコーディオンUIは、FAQページやコンテンツの折りたたみ表示に広く使用される。本機能により、管理者はサイトのデザインテーマに合わせてアコーディオンのメイン、ヘッダー、コンテンツ部分のCSSを個別にカスタマイズでき、統一感のあるデザインを実現できる。

**機能の利用シーン**：
- サイトのカラースキームに合わせてアコーディオンの色を変更したい場合
- ダーク/ライトテーマに切り替えたい場合
- フォントやボーダーのスタイルを調整したい場合
- 色を選択してCSS自動生成したい場合

**主要な処理内容**：
1. メインCSS、ヘッダーCSS、コンテンツCSSの3つのテキストエリアで編集
2. 色を選択して三色配色のCSS自動生成（トライアド配色）
3. プリセット（デフォルト/ダーク）からワンクリックで設定読み込み
4. リアルタイムプレビュー表示
5. 設定内容をデータベースに保存

**関連システム・外部連携**：
- tblCustomerテーブル（顧客設定情報の永続化）
- jQueryアコーディオンプラグイン（フロントエンド）
- 色変換関数（HEXCOL2RGB）

**権限による制御**：
- 管理者権限が必要（bs_security.aspによる認証）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 189 | アコーディオンセットアップ | 主画面 | アコーディオンUIコンポーネントの設定 |

## 機能種別

設定管理 / CRUD操作（Update） / 計算処理（CSS自動生成）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sQSAccordionMain | String | No | メイン部分のCSS | CSS構文 |
| sQSAccordionHeader | String | No | ヘッダー部分のCSS | CSS構文 |
| sQSAccordionContent | String | No | コンテンツ部分のCSS | CSS構文 |
| sCWLinkColor | String | No | 色選択（CSS自動生成用） | 16進カラーコード |
| loaddefault | String | No | デフォルトCSS読み込みフラグ | "1" |
| loaddark | String | No | ダークCSS読み込みフラグ | "1" |
| suggestcss | String | No | CSS自動生成ボタン | "Suggest CSS" |

### 入力データソース

- 画面入力（テキストエリア、カラーピッカー）
- 既存設定値はtblCustomerテーブルから取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.sQSAccordionMain | String | メイン部分のCSS |
| customer.sQSAccordionHeader | String | ヘッダー部分のCSS |
| customer.sQSAccordionContent | String | コンテンツ部分のCSS |

### 出力先

- tblCustomerテーブル（設定の永続化）
- 画面（プレビュー表示、設定完了後のリダイレクト）

## 処理フロー

### 処理シーケンス

```
1. ページ読み込み
   └─ 既存のアコーディオンCSS設定を読み込み
   └─ 選択色の初期化（デフォルト: #000000）
2. ダークCSS読み込み（loaddark=1）
   └─ ダークプリセット値を設定
   └─ customer.save()で保存
   └─ リダイレクト
3. デフォルトCSS読み込み（loaddefault=1）
   └─ 空値（デフォルト）を設定
   └─ customer.save()で保存
   └─ リダイレクト
4. CSS自動生成（suggestcss）
   └─ 選択色からトライアド配色を計算
   └─ ヘッダーとコンテンツのCSSを自動生成
   └─ customer.save()で保存
   └─ リダイレクト
5. 保存ボタン押下（btnaction）
   └─ フォーム入力値を取得
   └─ customer.save()で保存
   └─ リダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ページ読み込み]
    B --> C{loaddark=1?}
    C -->|Yes| D[ダークCSS設定]
    C -->|No| E{loaddefault=1?}
    D --> F[保存・リダイレクト]
    E -->|Yes| G[デフォルトCSS設定]
    E -->|No| H{suggestcss?}
    G --> F
    H -->|Yes| I[トライアド配色計算]
    H -->|No| J{btnaction?}
    I --> K[CSS自動生成]
    K --> F
    J -->|Yes| L[フォーム値保存]
    J -->|No| M[フォーム表示]
    L --> F
    F --> N[終了]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-033-1 | デフォルトメインCSS | 空の場合は"font-family: inherit; font-size: 1em;"を使用 | 表示時 |
| BR-033-2 | デフォルトヘッダーCSS | 空の場合は"background-color: #DDDDDD; color: #000000; font-weight: 700;"を使用 | 表示時 |
| BR-033-3 | デフォルトコンテンツCSS | 空の場合は"background-color: #FFFFFF; color: #000000;"を使用 | 表示時 |
| BR-033-4 | トライアド配色 | 色相環で120度ずつ離れた3色を自動生成 | CSS自動生成時 |

### 計算ロジック

**トライアド配色計算**：
```
入力色: color1 (HEX)
helpColor = HEXCOL2RGB(color1, 0)  // RGBに変換
triad = 16777216 / 3  // 色相環の1/3
color2 = helpColor + triad
color3 = helpColor + triad * 2

// 値が最大値を超えた場合は巻き戻し
if color2 > 16777216 then color2 = color2 - 16777216
if color3 > 16777216 then color3 = color3 - 16777216
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | tblCustomer | UPDATE | アコーディオンCSS設定の更新 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sQSAccordionMain | フォーム入力値（トリム済み） | メインCSS |
| UPDATE | sQSAccordionHeader | フォーム入力値（トリム済み） | ヘッダーCSS |
| UPDATE | sQSAccordionContent | フォーム入力値（トリム済み） | コンテンツCSS |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | ログインしていない場合 | ログイン画面へリダイレクト |

### リトライ仕様

特になし

## トランザクション仕様

customer.save()メソッド内でトランザクション管理。

## パフォーマンス要件

- レスポンス時間: 1秒以内
- CSS自動生成は即座に完了

## セキュリティ考慮事項

- bs_security.aspによる管理者認証
- CSS入力値はそのまま保存（XSSリスクは管理者限定のため許容）
- カラーコードのバリデーション

## 備考

- ダークプリセット: 黒背景（#222222）に白文字
- jQueryアコーディオンプラグインを使用
- リアルタイムプレビューが右側に表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | sQSAccordionMain, sQSAccordionHeader, sQSAccordionContentプロパティ（18行目） |

**読解のコツ**: デフォルト値の設定（223-225行目）も確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_AccordionSetup.asp | `asp/bs_AccordionSetup.asp` | メイン処理ファイル |

**主要処理フロー**:
1. **4-11行目**: 選択色の初期化
2. **12-18行目**: ダークCSS読み込み処理
3. **19-25行目**: デフォルトCSS読み込み処理
4. **26-48行目**: CSS自動生成（トライアド配色計算）
5. **49-55行目**: 通常の保存処理

#### Step 3: フロントエンドでの使用を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | javascript.asp | `asp/includes/javascript.asp` | アコーディオンCSS出力処理 |

### プログラム呼び出し階層図

```
bs_AccordionSetup.asp
    │
    ├─ begin.asp（共通初期化）
    │      └─ customer.asp（customerオブジェクト定義）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ HEXCOL2RGB()（色変換関数）
    │
    └─ customer.save()（設定保存）
           └─ tblCustomer UPDATE
```

### データフロー図

```
[入力]               [処理]                    [出力]

テキストエリア ───▶ bs_AccordionSetup.asp ───▶ tblCustomer
                           │
カラーピッカー ──┐        │
                 │        ▼
                 └───▶ トライアド配色計算
                              │
                              ▼
                         CSS自動生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_AccordionSetup.asp | `asp/bs_AccordionSetup.asp` | ソース | アコーディオンCSS設定画面 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客設定クラス定義 |
| javascript.asp | `asp/includes/javascript.asp` | ソース | フロントエンドJS/CSS出力 |
| page.asp | `asp/includes/page.asp` | ソース | ページ表示時のアコーディオン適用 |
