# 機能設計書 34-Cookie警告設定

## 概要

本ドキュメントは、QuickerSite CMSにおけるCookie使用に関する警告表示（GDPR対応）設定機能の設計を記述する。

### 本機能の処理概要

Cookie警告設定機能は、EU一般データ保護規則（GDPR）に対応したCookie同意バナーの表示設定を管理する機能である。サイト訪問者に対してCookie使用の同意を求めるバナーを表示し、その内容やデザインをカスタマイズできる。

**業務上の目的・背景**：
EU域内でWebサービスを提供する場合、GDPRに基づきCookie使用についてユーザーの明示的な同意を得る必要がある。本機能により、管理者は法令遵守のためのCookie同意バナーを設置し、そのテキスト、色、表示位置などを自由にカスタマイズできる。

**機能の利用シーン**：
- GDPRに対応したCookie同意バナーを設置する場合
- Cookie使用ポリシーへのリンクを含めたバナーを作成する場合
- サイトデザインに合わせてバナーの色やボタンスタイルを調整する場合
- 表示回数を制限してユーザビリティを向上させたい場合

**主要な処理内容**：
1. Cookie警告の有効/無効設定
2. 表示位置（上部/下部）の選択
3. 表示回数の制限設定
4. 開示テキスト（Disclosure）のWYSIWYG編集
5. 同意チェックボックス、エラーメッセージ、ボタンテキストの設定
6. 背景色、テキスト色、リンク色の設定
7. プリセット（デフォルト/ミニマル）からの読み込み

**関連システム・外部連携**：
- tblCustomerテーブル（顧客設定情報の永続化）
- CookieDirective15.js（フロントエンド）
- FCKエディタ（WYSIWYGエディタ）

**権限による制御**：
- 管理者権限が必要
- セカンドアドミンのbCookieWarning権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 84 | クッキー警告 | 主画面 | Cookie使用に関する警告表示設定（GDPR対応） |

## 機能種別

設定管理 / CRUD操作（Update）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| postback | String | Yes | ポストバック判定 | "1"固定 |
| bCookieWarning | Boolean | No | Cookie警告有効/無効 | チェックボックス |
| sCWLocation | String | No | 表示位置 | "top" or "bottom" |
| sCWNumber | Integer | No | 表示回数（0=無制限） | 0-20 |
| sCWText | String | No | 開示テキスト（HTML） | WYSIWYG入力 |
| sCWContinue | String | No | 続行ボタンテキスト | 最大50文字 |
| sCWError | String | No | エラーメッセージ | 最大250文字 |
| sCWAccept | String | No | 同意テキスト | 最大250文字 |
| sCWBackgroundColor | String | No | 背景色 | 16進カラーコード |
| sCWButtonClass | String | No | ボタンCSSクラス | 最大50文字 |
| sCWTextColor | String | No | テキスト色 | 16進カラーコード |
| sCWLinkColor | String | No | リンク色 | 16進カラーコード |
| bCWUseAsNormalPP | Boolean | No | 同意ブロック非表示 | チェックボックス |
| loaddefault | String | No | デフォルト設定読み込み | "1" |
| loadminimal | String | No | ミニマル設定読み込み | "1" |

### 入力データソース

- 画面入力（フォーム、WYSIWYGエディタ、カラーピッカー）
- 既存設定値はtblCustomerテーブルから取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.bCookieWarning | Boolean | Cookie警告有効/無効 |
| customer.sCWLocation | String | 表示位置 |
| customer.sCWNumber | Integer | 表示回数 |
| customer.sCWText | String | 開示テキスト |
| customer.sCWContinue | String | 続行ボタンテキスト |
| customer.sCWError | String | エラーメッセージ |
| customer.sCWAccept | String | 同意テキスト |
| customer.sCWBackgroundColor | String | 背景色 |
| customer.sCWButtonClass | String | ボタンCSSクラス |
| customer.sCWTextColor | String | テキスト色 |
| customer.sCWLinkColor | String | リンク色 |
| customer.bCWUseAsNormalPP | Boolean | 同意ブロック非表示 |

### 出力先

- tblCustomerテーブル（設定の永続化）
- 画面（設定完了後のリダイレクト）

## 処理フロー

### 処理シーケンス

```
1. ページ読み込み
   └─ 既存のCookie警告設定を読み込み
2. デフォルト設定読み込み（loaddefault=1）
   └─ 言語に応じたデフォルト値を設定（英語/オランダ語）
   └─ customer.save()で保存
   └─ リダイレクト
3. ミニマル設定読み込み（loadminimal=1）
   └─ 言語に応じた最小限の設定値を設定
   └─ customer.save()で保存
   └─ リダイレクト
4. 通常保存（postback）
   └─ フォーム入力値を取得
   └─ customer.save()で保存
   └─ リダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ページ読み込み]
    B --> C{loaddefault=1?}
    C -->|Yes| D{言語判定}
    D -->|オランダ語| E[オランダ語デフォルト設定]
    D -->|その他| F[英語デフォルト設定]
    C -->|No| G{loadminimal=1?}
    E --> H[保存・リダイレクト]
    F --> H
    G -->|Yes| I{言語判定}
    I -->|オランダ語| J[オランダ語ミニマル設定]
    I -->|その他| K[英語ミニマル設定]
    G -->|No| L{postback?}
    J --> H
    K --> H
    L -->|Yes| M[フォーム値保存]
    L -->|No| N[フォーム表示]
    M --> H
    H --> O[終了]
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-034-1 | 多言語デフォルト | language=2（オランダ語）の場合はオランダ語テキスト、それ以外は英語 | プリセット読み込み時 |
| BR-034-2 | 表示回数0 | sCWNumber=0の場合は警告を継続表示 | フロントエンド表示時 |
| BR-034-3 | 同意ブロック非表示 | bCWUseAsNormalPP=trueの場合は同意チェックボックスを非表示 | 目立つ告知として使用 |
| BR-034-4 | デフォルト背景色 | 空の場合は#000000（黒）を使用 | 表示時 |
| BR-034-5 | デフォルトテキスト色 | 空の場合は#FFFFFF（白）を使用 | 表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | tblCustomer | UPDATE | Cookie警告設定の更新 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bCookieWarning | チェックボックス値 | 有効/無効フラグ |
| UPDATE | sCWLocation | "top" or "bottom" | 表示位置 |
| UPDATE | sCWNumber | 0-20の整数 | 表示回数 |
| UPDATE | sCWText | HTML文字列 | 開示テキスト |
| UPDATE | sCWContinue | 文字列 | 続行ボタンテキスト |
| UPDATE | sCWError | 文字列 | エラーメッセージ |
| UPDATE | sCWAccept | 文字列 | 同意テキスト |
| UPDATE | sCWBackgroundColor | 16進カラーコード | 背景色 |
| UPDATE | sCWButtonClass | CSSクラス名 | ボタンスタイル |
| UPDATE | sCWTextColor | 16進カラーコード | テキスト色 |
| UPDATE | sCWLinkColor | 16進カラーコード | リンク色 |
| UPDATE | bCWUseAsNormalPP | Boolean | 同意ブロック非表示フラグ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | ログインしていない場合 | ログイン画面へリダイレクト |
| - | 権限エラー | bCookieWarning権限がない場合 | アクセス拒否 |

### リトライ仕様

特になし

## トランザクション仕様

customer.save()メソッド内でトランザクション管理。

## パフォーマンス要件

- レスポンス時間: 1秒以内
- フロントエンドでのCookie警告表示はJavaScriptで非同期処理

## セキュリティ考慮事項

- bs_security.aspによる管理者認証
- セカンドアドミンのbCookieWarning権限チェック
- HTML入力はWYSIWYGエディタ経由（管理者限定）
- XSS対策としてquotRep関数による出力エスケープ

## 備考

- Cookie警告はGDPR（EU一般データ保護規則）対応のための機能
- 「同意ブロック非表示」オプションで、告知バナーとしても使用可能
- プレビュー機能（QSbcwp=1パラメータ）で事前確認可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | Cookie警告関連プロパティ（17行目） |

**読解のコツ**: bCookieWarning, sCWLocation, sCWNumber, sCWText, sCWAccept, sCWContinue, sCWError, sCWBackgroundColor, sCWButtonClass, sCWTextColor, sCWLinkColor, bCWUseAsNormalPPの各プロパティを確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_cookiewarning.asp | `asp/bs_cookiewarning.asp` | メイン処理ファイル |

**主要処理フロー**:
1. **4行目**: セカンドアドミン権限チェック
2. **6-36行目**: loaddefault処理（言語別デフォルト値設定）
3. **37-67行目**: loadminimal処理（言語別ミニマル値設定）
4. **68-84行目**: 通常保存処理

#### Step 3: フロントエンドでの使用を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | sCookieJS関数（1562-1610行目） |

**主要処理フロー**:
- **1562-1610行目**: Cookie警告用JavaScriptの生成

### プログラム呼び出し階層図

```
bs_cookiewarning.asp
    │
    ├─ begin.asp（共通初期化）
    │      └─ customer.asp（customerオブジェクト定義）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess secondAdmin.bCookieWarning
    │
    ├─ dumpFCKInstance()（WYSIWYGエディタ）
    │
    ├─ JQColorPicker()（カラーピッカー）
    │
    └─ customer.save()（設定保存）
           └─ tblCustomer UPDATE
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ bs_cookiewarning.asp ───▶ tblCustomer
     │                     │
     │                     ▼
     │               sCookieJS()
     │                     │
     └──────────────────────▶ CookieDirective15.js
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_cookiewarning.asp | `asp/bs_cookiewarning.asp` | ソース | Cookie警告設定画面 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客設定クラス・sCookieJS関数 |
| CookieDirective15.js | `js/CookieDirective15.js` | JavaScript | フロントエンドCookie警告表示 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限管理クラス |
| cookiespolicy.html | `cookiepolicy/cookiespolicy.html` | HTML | Cookieポリシーページ（英語） |
| cookiebeleid.html | `cookiepolicy/cookiebeleid.html` | HTML | Cookieポリシーページ（オランダ語） |
