# 機能設計書 35-カスタム404ページ設定

## 概要

本ドキュメントは、QuickerSite CMSにおけるページが見つからない場合のカスタムエラーページ設定機能の設計を記述する。

### 本機能の処理概要

カスタム404ページ設定機能は、サイト訪問者が存在しないページにアクセスした際に表示される「404 Not Found」エラーページをカスタマイズする機能である。

**業務上の目的・背景**：
デフォルトの404エラーページはサーバーが生成する無機質なものであり、ブランドイメージを損なう可能性がある。本機能により、サイトのデザインテーマに沿った404ページを作成でき、ユーザーにとってより親切なエラー体験を提供できる。また、サイト内検索やトップページへのリンクを含めることで、ユーザーの離脱を防ぐことができる。

**機能の利用シーン**：
- サイトのブランドに合わせた404ページを作成したい場合
- 削除されたページへのアクセス時に代替コンテンツを案内したい場合
- 404ページにサイト内検索やナビゲーションを含めたい場合

**主要な処理内容**：
1. カスタム404ページの有効/無効設定
2. ページタイトルの設定
3. メッセージ本文のWYSIWYG編集
4. 適用するテンプレートの選択
5. [404FILENAME]プレースホルダーで見つからないファイル名を表示

**関連システム・外部連携**：
- tblCustomerテーブル（顧客設定情報の永続化）
- テンプレート管理機能（404ページ用テンプレート選択）

**権限による制御**：
- 管理者権限が必要
- セカンドアドミンのbCustom404権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 200 | 404エラー | 主画面 | 404エラーページの表示・設定 |

## 機能種別

設定管理 / CRUD操作（Update）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| postback | String | Yes | ポストバック判定 | "1"固定 |
| bCustom404 | Boolean | No | カスタム404ページ有効/無効 | チェックボックス |
| sCustom404Title | String | No | ページタイトル | 最大250文字 |
| sCustom404Body | String | No | メッセージ本文（HTML） | WYSIWYG入力 |
| i404TemplateID | String(暗号化) | No | 適用テンプレートID | 暗号化された数値 |

### 入力データソース

- 画面入力（フォーム、WYSIWYGエディタ）
- 既存設定値はtblCustomerテーブルから取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.bCustom404 | Boolean | カスタム404ページ有効/無効 |
| customer.sCustom404Title | String | ページタイトル |
| customer.sCustom404Body | String | メッセージ本文 |
| customer.i404TemplateID | Integer | 適用テンプレートID |

### 出力先

- tblCustomerテーブル（設定の永続化）
- 画面（設定完了後のリダイレクト）

## 処理フロー

### 処理シーケンス

```
1. ページ読み込み
   └─ 既存の404ページ設定を読み込み
2. 初期値設定
   └─ タイトルと本文が空の場合はデフォルト値を設定
3. 保存ボタン押下（postback）
   └─ bCustom404, sCustom404Title, sCustom404Body, i404TemplateIDを取得
   └─ customer.save()で保存
   └─ リダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ページ読み込み]
    B --> C{タイトル・本文が空?}
    C -->|Yes| D[デフォルト値設定]
    C -->|No| E{postback?}
    D --> E
    E -->|Yes| F[フォーム値取得]
    E -->|No| G[フォーム表示]
    F --> H[customer.save]
    H --> I[リダイレクト]
    I --> J[終了]
    G --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-035-1 | デフォルトタイトル | 空の場合は"File Not Found"を使用 | 初期表示時 |
| BR-035-2 | デフォルト本文 | 空の場合は"The file "[404FILENAME]" you searched for cannot be found."を使用 | 初期表示時 |
| BR-035-3 | ファイル名プレースホルダー | [404FILENAME]は実際のリクエストファイル名に置換される | 404ページ表示時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | tblCustomer | UPDATE | カスタム404ページ設定の更新 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | bCustom404 | チェックボックス値 | 有効/無効フラグ |
| UPDATE | sCustom404Title | 入力値（最大250文字） | ページタイトル |
| UPDATE | sCustom404Body | HTML文字列 | メッセージ本文 |
| UPDATE | i404TemplateID | 復号化されたテンプレートID | テンプレートID |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | ログインしていない場合 | ログイン画面へリダイレクト |
| - | 権限エラー | bCustom404権限がない場合 | アクセス拒否 |

### リトライ仕様

特になし

## トランザクション仕様

customer.save()メソッド内でトランザクション管理。

## パフォーマンス要件

- レスポンス時間: 1秒以内

## セキュリティ考慮事項

- bs_security.aspによる管理者認証
- セカンドアドミンのbCustom404権限チェック
- テンプレートIDは暗号化して送受信
- HTML入力はWYSIWYGエディタ経由

## 備考

- [404FILENAME]プレースホルダーを使用してリクエストされたファイル名を表示可能
- テンプレートを選択することで、サイト全体のデザインと統一した404ページを作成可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | 404関連プロパティ（18行目、53-56行目） |

**読解のコツ**: bCustom404, sCustom404Title, sCustom404Body, i404TemplateIDの初期値とPick/Save処理を確認する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_404.asp | `asp/bs_404.asp` | メイン処理ファイル |

**主要処理フロー**:
1. **2行目**: セカンドアドミン権限チェック
2. **7-17行目**: 通常保存処理
3. **19-22行目**: デフォルト値設定

#### Step 3: フロントエンドでの使用を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process.asp | `asp/process.asp` | 404エラー発生時の処理 |

### プログラム呼び出し階層図

```
bs_404.asp
    │
    ├─ begin.asp（共通初期化）
    │      └─ customer.asp（customerオブジェクト定義）
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess secondAdmin.bCustom404
    │
    ├─ dumpFCKInstance()（WYSIWYGエディタ）
    │
    ├─ showSelectedtemplate()（テンプレート選択）
    │
    └─ customer.save()（設定保存）
           └─ tblCustomer UPDATE
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ───▶ bs_404.asp ───▶ tblCustomer
     │
     ▼
テンプレート選択
     │
     ▼
[404FILENAME] ───▶ process.asp ───▶ カスタム404ページ
プレースホルダー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_404.asp | `asp/bs_404.asp` | ソース | カスタム404ページ設定画面 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客設定クラス定義 |
| process.asp | `asp/process.asp` | ソース | 404エラー発生時の処理 |
| secondAdmin.asp | `asp/includes/secondAdmin.asp` | ソース | 権限管理クラス |
