# 機能設計書 37-アセットマネージャー

## 概要

本ドキュメントは、QuickerSite CMSにおける画像・ドキュメント等のファイルアップロード・管理機能の設計を記述する。

### 本機能の処理概要

アセットマネージャー機能は、Webサイトで使用する画像、ドキュメント、メディアファイルなどのアセットを一元管理するためのファイルマネージャー機能である。

**業務上の目的・背景**：
CMSでWebサイトを構築する際、画像やPDFなど様々なファイルをアップロード・管理する必要がある。本機能により、フォルダ構造でファイルを整理し、必要なファイルを簡単に見つけてコンテンツに挿入できる。CKEditorと連携してWYSIWYGエディタからも直接アクセス可能。

**機能の利用シーン**：
- ページに挿入する画像をアップロードしたい場合
- ダウンロード用のPDFファイルを管理したい場合
- フォルダを作成してファイルを整理したい場合
- 既存ファイルを編集・削除したい場合

**主要な処理内容**：
1. フォルダ階層のナビゲーション
2. ファイルのアップロード
3. ファイルの表示・プレビュー
4. ファイルの削除
5. フォルダの作成・削除
6. CKEditorへのファイル挿入

**関連システム・外部連携**：
- UserFilesディレクトリ（ファイル格納）
- CKEditor（WYSIWYGエディタ連携）
- FileSystemObject（ファイル操作）

**権限による制御**：
- 管理者権限が必要
- セカンドアドミンのbFiles権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 125 | アセットマネージャー | 主画面 | 画像・ドキュメント等のファイル管理 |
| 126 | アセットマネージャーIF | 主画面 | アセットマネージャーのインターフェース表示 |
| 127 | フォルダ作成 | 主画面 | 新規フォルダの作成 |
| 128 | フォルダ削除 | 主画面 | フォルダの削除処理 |

## 機能種別

ファイル管理 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| selCurrFolder | String | No | 現在のフォルダパス | 物理パス |
| inpCurrFolder | String | No | 選択フォルダパス | 物理パス |
| inpFileToDelete | String | No | 削除対象ファイルパス | 仮想パス |
| File1 | File | No | アップロードファイル | ファイルタイプ制限あり |
| ffilter | String | No | ファイルフィルター | "image", "flash", "media", 空 |
| CKEditorFuncNum | String | No | CKEditorコールバック番号 | 数値 |

### 入力データソース

- 画面入力（フォルダ選択、ファイルアップロード）
- ファイルシステム（既存ファイル・フォルダ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ファイル一覧 | HTML | 選択フォルダ内のファイル一覧 |
| フォルダ一覧 | HTML | 再帰的フォルダ構造のセレクトボックス |
| プレビュー | HTML | 選択ファイルのプレビュー表示 |

### 出力先

- 画面（iframe内表示）
- ファイルシステム（アップロード時）

## 処理フロー

### 処理シーケンス

```
1. ページ読み込み
   └─ セッションから現在フォルダを取得
   └─ ベースフォルダ（最大4つ）を設定
2. フォルダ選択
   └─ recursive関数でフォルダ構造を再帰取得
   └─ セレクトボックスに表示
3. ファイル一覧表示
   └─ 選択フォルダ内のファイルを取得
   └─ ffilterでファイルタイプをフィルタリング
   └─ アイコン付きでファイル一覧を表示
4. ファイルアップロード
   └─ ファイルタイプチェック
   └─ サイズ制限チェック
   └─ 選択フォルダに保存
5. ファイル削除
   └─ 確認ダイアログ表示
   └─ FileSystemObjectで削除
6. CKEditor連携
   └─ ファイル選択時にCKEditorFuncを呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ページ読み込み]
    B --> C[フォルダ構造取得]
    C --> D[ファイル一覧取得]
    D --> E{ファイルフィルター?}
    E -->|image| F[画像のみ表示]
    E -->|flash| G[SWFのみ表示]
    E -->|media| H[メディアのみ表示]
    E -->|なし| I[全ファイル表示]
    F --> J[一覧表示]
    G --> J
    H --> J
    I --> J
    J --> K{操作選択}
    K -->|アップロード| L[ファイルアップロード]
    K -->|削除| M[ファイル削除]
    K -->|選択| N[プレビュー表示]
    K -->|挿入| O[CKEditor連携]
    L --> P[終了]
    M --> P
    N --> P
    O --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-037-1 | ファイルタイプ制限 | allowedFileTypesで許可されたファイルタイプのみアップロード可能 | アップロード時 |
| BR-037-2 | サイズ制限 | 1,324,000バイト以下のファイルのみアップロード可能 | アップロード時 |
| BR-037-3 | ベースフォルダ保護 | アセットベースフォルダは削除不可 | フォルダ削除時 |
| BR-037-4 | 画像フィルター | ffilter=imageの場合、gif/jpg/jpeg/pngのみ表示 | ファイル一覧表示時 |
| BR-037-5 | メディアフィルター | ffilter=mediaの場合、avi/wmv/mpg/mpeg/wav/wma/mid/mp3のみ表示 | ファイル一覧表示時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない（ファイルシステム操作のみ）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | ファイルエラー | アップロードスクリプトが見つからない場合 | エラーメッセージ表示 |
| - | ファイルサイズ | 1MB超過 | "File Size Limit: 1MB!"表示 |
| - | HTTP | HTTPエラー発生時 | エラータイプとステータス表示 |

### リトライ仕様

特になし

## トランザクション仕様

ファイル操作はトランザクション対象外。

## パフォーマンス要件

- ファイル一覧表示: 1秒以内（通常のファイル数）
- アップロード: ファイルサイズに依存

## セキュリティ考慮事項

- bs_security.aspによる管理者認証
- セカンドアドミンのbFiles権限チェック
- ファイルタイプ制限（allowedFileTypes）
- セカンドアドミンはbReadOnly設定で書き込み制限可能
- パス操作はサーバーサイドで検証

## 備考

- iframeで表示される独立したインターフェース
- CKEditorとの連携機能あり
- HTMLファイルはコード編集画面で開くことが可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | settings.asp | `asp/assetmanager/settings.asp` | ベースフォルダ設定、許可ファイルタイプ |

**読解のコツ**: arrBaseFolder配列とarrBaseName配列で最大4つのベースフォルダを設定できる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_assetmanager.asp | `asp/bs_assetmanager.asp` | iframeでassetmanagerIF.aspを読み込み |
| 2-2 | assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` | メインインターフェース |

**主要処理フロー**:
1. **26-30行目**: ベースフォルダオブジェクト作成
2. **56-78行目**: writeFolderSelections() - フォルダセレクトボックス生成
3. **80-99行目**: recursive() - 再帰的フォルダ取得
4. **110-264行目**: writeFileSelections() - ファイル一覧生成

#### Step 3: ファイルアップロード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | i_upload_object_FSO.asp | `asp/assetmanager/i_upload_object_FSO.asp` | アップロード処理 |

### プログラム呼び出し階層図

```
bs_assetmanager.asp
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess secondAdmin.bFiles
    │
    └─ assetmanagerIF.asp（iframe）
           │
           ├─ security.asp（セッション認証）
           │
           ├─ settings.asp（設定読み込み）
           │
           ├─ i_upload_object_FSO.asp（アップロード処理）
           │
           ├─ writeFolderSelections()
           │      └─ recursive()（再帰フォルダ取得）
           │
           ├─ writeFileSelections()
           │      └─ FileSystemObject（ファイル一覧）
           │
           ├─ foldernew.asp（フォルダ作成）
           │
           └─ folderdel.asp（フォルダ削除）
```

### データフロー図

```
[入力]               [処理]                    [出力]

UserFilesディレクトリ ──▶ assetmanagerIF.asp ──▶ ファイル一覧表示
                              │
ファイルアップロード ───────▶│
                              │
                              ▼
                       i_upload_object_FSO.asp
                              │
                              ▼
                       UserFilesディレクトリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_assetmanager.asp | `asp/bs_assetmanager.asp` | ソース | アセットマネージャー呼び出し |
| assetmanagerIF.asp | `asp/assetmanager/assetmanagerIF.asp` | ソース | メインインターフェース |
| security.asp | `asp/assetmanager/security.asp` | ソース | セッション認証 |
| settings.asp | `asp/assetmanager/settings.asp` | ソース | 設定ファイル |
| i_upload_object_FSO.asp | `asp/assetmanager/i_upload_object_FSO.asp` | ソース | アップロード処理 |
| foldernew.asp | `asp/assetmanager/foldernew.asp` | ソース | フォルダ作成ダイアログ |
| folderdel.asp | `asp/assetmanager/folderdel.asp` | ソース | フォルダ削除ダイアログ |
| style.css | `asp/assetmanager/style.css` | CSS | スタイル定義 |
