# 機能設計書 38-マルチファイルアップロード

## 概要

本ドキュメントは、QuickerSite CMSにおける複数ファイルの一括アップロード機能の設計を記述する。

### 本機能の処理概要

マルチファイルアップロード機能は、Uploadifyプラグインを使用して複数のファイルを同時にアップロードする機能である。Flash/jQuery技術を活用し、ドラッグ＆ドロップやプログレスバー表示などの高度なUI機能を提供する。

**業務上の目的・背景**：
大量の画像やドキュメントを一度にアップロードする必要がある場合、1ファイルずつのアップロードは非効率である。本機能により、複数ファイルを選択して一括アップロードでき、作業効率を大幅に向上させることができる。

**機能の利用シーン**：
- 大量の画像を一度にアップロードしたい場合
- ギャラリー用の画像をまとめてアップロードしたい場合
- 複数のドキュメントファイルを同時にアップロードしたい場合

**主要な処理内容**：
1. アップロード先フォルダの選択
2. 複数ファイルの選択（Uploadifyプラグイン）
3. ファイルタイプ・サイズのバリデーション
4. 自動アップロードの実行
5. アップロード完了ファイルの一覧表示

**関連システム・外部連携**：
- Uploadify 2.1.4（Flashベースアップローダー）
- jQuery 1.5
- uploader214.asp（サーバーサイドアップロード処理）
- FileSystemObject（ファイル操作）

**権限による制御**：
- 管理者権限が必要
- セカンドアドミンのbFiles権限が必要

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 129 | ファイルアップロード | 主画面 | ファイルのアップロード処理 |
| 130 | マルチファイルアップロード | 主画面 | 複数ファイルの一括アップロード |
| 131 | アイテムファイルアップロード | 主画面 | アイテム用ファイルのアップロード |

## 機能種別

ファイル管理 / アップロード処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sPath | String | No | アップロード先フォルダパス | 相対パス |
| uploadify | File | Yes | アップロードファイル（複数可） | ファイルタイプ・サイズ制限 |
| sId | String | Yes | セッションID | セッション検証用 |

### 入力データソース

- 画面入力（ファイル選択）
- フォルダセレクトボックス

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| filesUploaded | HTML | アップロード完了ファイル一覧 |

### 出力先

- ファイルシステム（UserFilesディレクトリ）
- 画面（アップロード完了一覧）

## 処理フロー

### 処理シーケンス

```
1. ページ読み込み
   └─ Uploadifyプラグイン初期化
   └─ 許可ファイルタイプ一覧を設定
   └─ フォルダ選択ボックスを生成
2. フォルダ選択
   └─ セレクトボックスでアップロード先を選択
   └─ フォームをサブミットして画面更新
3. ファイル選択
   └─ Uploadifyダイアログでファイル選択（複数可）
   └─ auto: trueにより即座にアップロード開始
4. アップロード処理
   └─ uploader214.aspにファイル送信
   └─ ファイルタイプ・サイズチェック
   └─ 指定フォルダに保存
5. 完了処理
   └─ onCompleteイベントでファイル一覧に追加
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Uploadify初期化]
    B --> C[フォルダ選択]
    C --> D[ファイル選択ダイアログ]
    D --> E{ファイル選択?}
    E -->|Yes| F[自動アップロード開始]
    E -->|No| G[待機]
    F --> H{ファイルチェック}
    H -->|サイズオーバー| I[エラー表示]
    H -->|タイプ不正| I
    H -->|OK| J[uploader214.asp]
    I --> G
    J --> K[ファイル保存]
    K --> L[完了一覧に追加]
    L --> M{次のファイル?}
    M -->|Yes| F
    M -->|No| N[終了]
    G --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-038-1 | サイズ制限 | 1,324,000バイト以下のファイルのみアップロード可能 | アップロード時 |
| BR-038-2 | ファイルタイプ制限 | allowedFileTypesで許可されたタイプのみ | アップロード時 |
| BR-038-3 | 自動アップロード | ファイル選択後に自動的にアップロード開始 | ファイル選択時 |
| BR-038-4 | セッション認証 | アップロードはセッションIDで認証 | uploader214.asp呼び出し時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない（ファイルシステム操作のみ）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | スクリプトエラー | アップロードスクリプトが見つからない場合 | パス確認メッセージ表示 |
| - | File Size | ファイルサイズ超過 | "File Size Limit: 1MB!"表示 |
| - | HTTP | HTTPエラー発生時 | エラータイプとステータス表示 |

### リトライ仕様

アップロード失敗時は手動で再選択・再アップロード。

## トランザクション仕様

ファイル操作はトランザクション対象外。各ファイルは独立してアップロードされる。

## パフォーマンス要件

- 同時アップロード可能
- 各ファイルのプログレス表示

## セキュリティ考慮事項

- bs_security.aspによる管理者認証
- セカンドアドミンのbFiles権限チェック
- セッションIDによるアップロード認証
- ファイルタイプ制限（allowedFileTypes）
- サイズ制限によるDoS対策

## 備考

- Uploadify 2.1.4はFlashベースのため、モダンブラウザでは動作しない可能性あり
- 代替としてHTML5ベースのアップローダーへの移行を検討推奨

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_multifileupload.asp | `asp/bs_multifileupload.asp` | フォルダパス設定、許可ファイルタイプ |

**読解のコツ**: cls_fileexplorerクラスでフォルダ階層を取得し、allowedFileTypesでファイルタイプ制限を設定。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_multifileupload.asp | `asp/bs_multifileupload.asp` | Uploadify設定とフォルダ選択UI |

**主要処理フロー**:
1. **4-8行目**: セキュリティチェック、パス設定
2. **9-12行目**: Uploadify JavaScript関数（Send_document）
3. **13-48行目**: Uploadifyプラグイン初期化
4. **49行目**: フォルダ選択セレクトボックス

#### Step 3: サーバーサイドアップロード処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | uploader214.asp | `asp/uploader214.asp` | ファイル保存処理 |

### プログラム呼び出し階層図

```
bs_multifileupload.asp
    │
    ├─ bs_security.asp（認証チェック）
    │      └─ logon.hasaccess secondAdmin.bFiles
    │
    ├─ cls_fileexplorer（フォルダ階層取得）
    │
    ├─ Uploadifyプラグイン（クライアントサイド）
    │      │
    │      └─ uploadify.swf（Flashアップローダー）
    │
    └─ uploader214.asp（サーバーサイド）
           │
           └─ ファイル保存処理
```

### データフロー図

```
[入力]               [処理]                    [出力]

ファイル選択 ───▶ Uploadify ───▶ uploader214.asp
     │                 │                │
     │                 ▼                ▼
     │           自動アップロード    ファイル保存
     │                 │                │
     └─────────────────┴────────────────┘
                       │
                       ▼
                 filesUploaded表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_multifileupload.asp | `asp/bs_multifileupload.asp` | ソース | マルチファイルアップロード画面 |
| uploader214.asp | `asp/uploader214.asp` | ソース | サーバーサイドアップロード処理 |
| uploadify.swf | `asp/uploadify214/uploadify.swf` | Flash | Flashアップローダー |
| jquery.uploadify.v2.1.4.min.js | `asp/uploadify214/` | JavaScript | Uploadifyプラグイン |
| default.css | `asp/uploadify214/css/default.css` | CSS | デフォルトスタイル |
| uploadify.css | `asp/uploadify214/css/uploadify.css` | CSS | Uploadifyスタイル |
